/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.redis;

import com.jfinal.kit.StrKit;
import com.jfinal.plugin.IPlugin;
import com.jfinal.plugin.redis.Cache;
import com.jfinal.plugin.redis.IKeyNamingPolicy;
import com.jfinal.plugin.redis.Redis;
import com.jfinal.plugin.redis.serializer.FstSerializer;
import com.jfinal.plugin.redis.serializer.ISerializer;
import java.util.function.Consumer;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisPlugin
implements IPlugin {
    protected String cacheName;
    protected String host;
    protected Integer port = null;
    protected Integer timeout = null;
    protected String password = null;
    protected Integer database = null;
    protected String clientName = null;
    protected ISerializer serializer = null;
    protected IKeyNamingPolicy keyNamingPolicy = null;
    protected JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();

    public RedisPlugin(String cacheName, String host) {
        if (StrKit.isBlank(cacheName)) {
            throw new IllegalArgumentException("cacheName can not be blank.");
        }
        if (StrKit.isBlank(host)) {
            throw new IllegalArgumentException("host can not be blank.");
        }
        this.cacheName = cacheName.trim();
        this.host = host;
    }

    public RedisPlugin(String cacheName, String host, int port) {
        this(cacheName, host);
        this.port = port;
    }

    public RedisPlugin(String cacheName, String host, int port, int timeout) {
        this(cacheName, host, port);
        this.timeout = timeout;
    }

    public RedisPlugin(String cacheName, String host, int port, int timeout, String password) {
        this(cacheName, host, port, timeout);
        this.password = password;
    }

    public RedisPlugin(String cacheName, String host, int port, int timeout, String password, int database) {
        this(cacheName, host, port, timeout, password);
        this.database = database;
    }

    public RedisPlugin(String cacheName, String host, int port, int timeout, String password, int database, String clientName) {
        this(cacheName, host, port, timeout, password, database);
        if (StrKit.isBlank(clientName)) {
            throw new IllegalArgumentException("clientName can not be blank.");
        }
        this.clientName = clientName;
    }

    public RedisPlugin(String cacheName, String host, int port, String password) {
        this(cacheName, host, port, 2000, password);
    }

    public RedisPlugin(String cacheName, String host, String password) {
        this(cacheName, host, 6379, 2000, password);
    }

    @Override
    public boolean start() {
        JedisPool jedisPool = this.port != null && this.timeout != null && this.database != null && this.clientName != null ? new JedisPool((GenericObjectPoolConfig)this.jedisPoolConfig, this.host, this.port.intValue(), this.timeout.intValue(), this.password, this.database.intValue(), this.clientName) : (this.port != null && this.timeout != null && this.database != null ? new JedisPool((GenericObjectPoolConfig)this.jedisPoolConfig, this.host, this.port.intValue(), this.timeout.intValue(), this.password, this.database.intValue()) : (this.port != null && this.timeout != null ? new JedisPool((GenericObjectPoolConfig)this.jedisPoolConfig, this.host, this.port.intValue(), this.timeout.intValue(), this.password) : (this.port != null ? new JedisPool((GenericObjectPoolConfig)this.jedisPoolConfig, this.host, this.port.intValue()) : new JedisPool((GenericObjectPoolConfig)this.jedisPoolConfig, this.host))));
        if (this.serializer == null) {
            this.serializer = FstSerializer.me;
        }
        if (this.keyNamingPolicy == null) {
            this.keyNamingPolicy = IKeyNamingPolicy.defaultKeyNamingPolicy;
        }
        Cache cache = new Cache(this.cacheName, jedisPool, this.serializer, this.keyNamingPolicy);
        Redis.addCache(cache);
        return true;
    }

    @Override
    public boolean stop() {
        Cache cache = Redis.removeCache(this.cacheName);
        if (cache == Redis.mainCache) {
            Redis.mainCache = null;
        }
        cache.jedisPool.destroy();
        return true;
    }

    public JedisPoolConfig getJedisPoolConfig() {
        return this.jedisPoolConfig;
    }

    public void config(Consumer<JedisPoolConfig> config) {
        config.accept(this.jedisPoolConfig);
    }

    public void setSerializer(ISerializer serializer) {
        this.serializer = serializer;
    }

    public void setKeyNamingPolicy(IKeyNamingPolicy keyNamingPolicy) {
        this.keyNamingPolicy = keyNamingPolicy;
    }

    public void setTestWhileIdle(boolean testWhileIdle) {
        this.jedisPoolConfig.setTestWhileIdle(testWhileIdle);
    }

    public void setMinEvictableIdleTimeMillis(int minEvictableIdleTimeMillis) {
        this.jedisPoolConfig.setMinEvictableIdleTimeMillis((long)minEvictableIdleTimeMillis);
    }

    public void setTimeBetweenEvictionRunsMillis(int timeBetweenEvictionRunsMillis) {
        this.jedisPoolConfig.setTimeBetweenEvictionRunsMillis((long)timeBetweenEvictionRunsMillis);
    }

    public void setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this.jedisPoolConfig.setNumTestsPerEvictionRun(numTestsPerEvictionRun);
    }
}

