/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.render;

import com.jfinal.render.ContentType;
import com.jfinal.render.Render;
import com.jfinal.render.RenderException;
import java.io.IOException;
import java.io.PrintWriter;

public class TextRender
extends Render {
    protected static final String DEFAULT_CONTENT_TYPE = "text/plain";
    protected String text;
    protected String contentType;

    public TextRender(String text) {
        this.text = text;
        this.contentType = DEFAULT_CONTENT_TYPE;
    }

    public TextRender(String text, String contentType) {
        this.text = text;
        ContentType ct = ContentType.parse(contentType);
        this.contentType = ct != null ? ct.value() : contentType;
    }

    public TextRender(String text, ContentType contentType) {
        this.text = text;
        this.contentType = contentType.value();
    }

    @Override
    public void render() {
        PrintWriter writer = null;
        try {
            String ct = this.getContentType();
            this.response.setContentType(ct);
            if (ct.indexOf("charset") == -1) {
                this.response.setCharacterEncoding(TextRender.getEncoding());
            }
            writer = this.response.getWriter();
            writer.write(this.text);
            writer.flush();
        }
        catch (IOException e) {
            throw new RenderException(e);
        }
    }

    public String getText() {
        return this.text;
    }

    public String getContentType() {
        return this.contentType;
    }
}

