/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator;

import com.google.inject.ProvisionException;
import com.netflix.governator.LifecycleAction;
import com.netflix.governator.LifecycleFeature;
import com.netflix.governator.annotations.Configuration;
import com.netflix.governator.configuration.ConfigurationDocumentation;
import com.netflix.governator.configuration.ConfigurationMapper;
import com.netflix.governator.configuration.ConfigurationProvider;
import com.netflix.governator.lifecycle.LifecycleMethods;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
public class ConfigurationLifecycleFeature
implements LifecycleFeature {
    private volatile Provider<Mapper> mapper;

    @Inject
    public void initialize(Provider<Mapper> state) {
        this.mapper = state;
    }

    public List<LifecycleAction> getActionsForType(final Class<?> type) {
        final LifecycleMethods methods = new LifecycleMethods(type);
        if (methods.annotatedFields(Configuration.class).length > 0) {
            return Arrays.asList(new LifecycleAction(){

                public void call(Object obj) throws Exception {
                    if (ConfigurationLifecycleFeature.this.mapper == null) {
                        throw new ProvisionException("Trying to map fields of type " + type.getName() + " before ConfigurationLifecycleFeature was fully initialized by the injector");
                    }
                    try {
                        ((Mapper)ConfigurationLifecycleFeature.this.mapper.get()).mapConfiguration(obj, methods);
                    }
                    catch (Exception e) {
                        throw new ProvisionException("Failed to map configuration for type " + type.getName(), (Throwable)e);
                    }
                }
            });
        }
        return Collections.emptyList();
    }

    public String toString() {
        return "ConfigurationLifecycleFeature[]";
    }

    private static class Mapper {
        private ConfigurationMapper mapper;
        private ConfigurationProvider configurationProvider;
        private ConfigurationDocumentation configurationDocumentation;

        @Inject
        Mapper(ConfigurationMapper mapper, ConfigurationProvider configurationProvider, ConfigurationDocumentation configurationDocumentation) {
            this.mapper = mapper;
            this.configurationProvider = configurationProvider;
            this.configurationDocumentation = configurationDocumentation;
        }

        private void mapConfiguration(Object obj, LifecycleMethods methods) throws Exception {
            this.mapper.mapConfiguration(this.configurationProvider, this.configurationDocumentation, obj, methods);
        }
    }
}

