/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.configuration;

import com.google.common.collect.Maps;
import com.google.inject.Singleton;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.TreeMap;

@Singleton
public class ConfigurationDocumentation {
    private final Map<String, Entry> entries = Maps.newConcurrentMap();

    public void registerConfiguration(Field field, String configurationName, boolean has, String defaultValue, String value, String documentation) {
        this.entries.put(configurationName, new Entry(field, configurationName, has, defaultValue, value, documentation));
    }

    public Map<String, Entry> getSortedEntries() {
        TreeMap sortedEntries = Maps.newTreeMap();
        sortedEntries.putAll(this.entries);
        return sortedEntries;
    }

    public static class Entry {
        public final Field field;
        public final String configurationName;
        public final boolean has;
        public final String defaultValue;
        public final String value;
        public final String documentation;

        private Entry(Field field, String configurationName, boolean has, String defaultValue, String value, String documentation) {
            this.field = field;
            this.configurationName = configurationName;
            this.has = has;
            this.defaultValue = defaultValue;
            this.value = value;
            this.documentation = documentation;
        }
    }
}

