/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.configuration;

import com.google.common.base.Supplier;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import javax.xml.bind.DatatypeConverter;

public class DateWithDefaultSupplier
implements Supplier<Date> {
    private final Date defaultValue;
    private final Supplier<String> supplier;
    private final DateFormat formatter;

    public DateWithDefaultSupplier(Supplier<String> supplier, Date defaultValue) {
        this.defaultValue = defaultValue;
        this.supplier = supplier;
        this.formatter = DateFormat.getDateInstance(3, Locale.getDefault());
        this.formatter.setLenient(false);
    }

    public Date get() {
        Date newDate;
        String current = (String)this.supplier.get();
        if (current != null && (newDate = this.parseDate(current)) != null) {
            return newDate;
        }
        return this.defaultValue;
    }

    private Date parseDate(String value) {
        if (value == null) {
            return null;
        }
        try {
            return this.formatter.parse(value);
        }
        catch (ParseException parseException) {
            try {
                return DatatypeConverter.parseDateTime((String)value).getTime();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
    }
}

