/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.guice;

import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.grapher.graphviz.GraphvizGrapher;
import com.google.inject.grapher.graphviz.GraphvizModule;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;

public class Grapher {
    private final Injector injector;
    private final Set<Key<?>> roots;

    @Inject
    public Grapher(Injector injector) {
        this.injector = injector;
        this.roots = new HashSet();
    }

    public Grapher(Injector injector, Key<?> ... keys) {
        this.injector = injector;
        this.roots = Sets.newHashSet((Object[])keys);
    }

    public Grapher(Injector injector, Class<?> ... classes) {
        this.injector = injector;
        this.roots = Sets.newHashSetWithExpectedSize((int)classes.length);
        for (Class<?> cls : classes) {
            this.roots.add(Key.get(cls));
        }
    }

    public Grapher(Injector injector, String ... packages) {
        this.injector = injector;
        this.roots = new HashSet();
        block0: for (Key k : injector.getAllBindings().keySet()) {
            Package classPackage = k.getTypeLiteral().getRawType().getPackage();
            if (classPackage == null) continue;
            String packageName = classPackage.getName();
            for (String p : packages) {
                if (!packageName.startsWith(p)) continue;
                this.roots.add(k);
                continue block0;
            }
        }
    }

    public String toFile() throws Exception {
        File file = File.createTempFile("GuiceDependencies_", ".dot");
        this.toFile(file);
        return file.getCanonicalPath();
    }

    public void toFile(File file) throws Exception {
        PrintWriter out = new PrintWriter(file, "UTF-8");
        try {
            out.write(this.graph());
        }
        finally {
            Closeables.close((Closeable)out, (boolean)true);
        }
    }

    public String graph() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter out = new PrintWriter(baos);
        Injector localInjector = Guice.createInjector((Module[])new Module[]{new GraphvizModule()});
        GraphvizGrapher renderer = (GraphvizGrapher)localInjector.getInstance(GraphvizGrapher.class);
        renderer.setOut(out);
        renderer.setRankdir("TB");
        if (!this.roots.isEmpty()) {
            renderer.graph(this.injector, this.roots);
        }
        renderer.graph(this.injector);
        return this.fixupGraph(baos.toString("UTF-8"));
    }

    private String fixupGraph(String s) {
        s = this.fixGrapherBug(s);
        s = this.hideClassPaths(s);
        return s;
    }

    private String hideClassPaths(String s) {
        s = s.replaceAll("\\w[a-z\\d_\\.]+\\.([A-Z][A-Za-z\\d_\\$]*)", "$1");
        s = s.replaceAll("value=[\\w-]+", "random");
        return s;
    }

    private String fixGrapherBug(String s) {
        s = s.replaceAll("style=invis", "style=solid");
        s = s.replaceAll("margin=(\\S+), ", "margin=\"$1\", ");
        return s;
    }
}

