/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.guice;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.ScopeAnnotation;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.ScopedBindingBuilder;
import com.google.inject.internal.MoreTypes;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.util.Types;
import com.netflix.governator.annotations.AutoBind;
import com.netflix.governator.annotations.AutoBindSingleton;
import com.netflix.governator.guice.AutoBindProvider;
import com.netflix.governator.guice.ProviderBinderUtil;
import com.netflix.governator.guice.lazy.LazySingletonScope;
import com.netflix.governator.lifecycle.ClasspathScanner;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Set;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InternalAutoBindModule
extends AbstractModule {
    private static final Logger LOG = LoggerFactory.getLogger(InternalAutoBindModule.class);
    private final Set<Class<?>> ignoreClasses;
    private final Injector injector;
    private final ClasspathScanner classpathScanner;

    InternalAutoBindModule(Injector injector, ClasspathScanner classpathScanner, Collection<Class<?>> ignoreClasses) {
        this.injector = injector;
        this.classpathScanner = classpathScanner;
        Preconditions.checkNotNull(ignoreClasses, (Object)"ignoreClasses cannot be null");
        this.ignoreClasses = ImmutableSet.copyOf(ignoreClasses);
    }

    protected void configure() {
        this.bindAutoBindSingletons();
        this.bindAutoBindConstructors();
        this.bindAutoBindMethods();
        this.bindAutoBindFields();
    }

    private void bindAutoBindFields() {
        for (Field field : this.classpathScanner.getFields()) {
            if (this.ignoreClasses.contains(field.getDeclaringClass())) continue;
            this.bindAnnotations(field.getDeclaredAnnotations());
        }
    }

    private void bindAutoBindMethods() {
        for (Method method : this.classpathScanner.getMethods()) {
            if (this.ignoreClasses.contains(method.getDeclaringClass())) continue;
            this.bindParameterAnnotations(method.getParameterAnnotations());
        }
    }

    private void bindAutoBindConstructors() {
        for (Constructor constructor : this.classpathScanner.getConstructors()) {
            if (this.ignoreClasses.contains(constructor.getDeclaringClass())) continue;
            this.bindParameterAnnotations(constructor.getParameterAnnotations());
        }
    }

    private void bindParameterAnnotations(Annotation[][] parameterAnnotations) {
        for (Annotation[] annotations : parameterAnnotations) {
            this.bindAnnotations(annotations);
        }
    }

    private void bindAnnotations(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            AutoBindProvider autoBindProvider = this.getAutoBindProvider(annotation);
            if (autoBindProvider == null) continue;
            autoBindProvider.configure(this.binder(), annotation);
        }
    }

    private AutoBindProvider getAutoBindProvider(Annotation annotation) {
        AutoBindProvider autoBindProvider = null;
        if (annotation.annotationType().isAnnotationPresent(AutoBind.class)) {
            ParameterizedType parameterizedType = Types.newParameterizedType(AutoBindProvider.class, (Type[])new Type[]{annotation.annotationType()});
            autoBindProvider = (AutoBindProvider)this.injector.getInstance(Key.get((TypeLiteral)TypeLiteral.get((Type)parameterizedType)));
        } else if (annotation.annotationType().isAssignableFrom(AutoBind.class)) {
            autoBindProvider = (AutoBindProvider)this.injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<AutoBindProvider<AutoBind>>(){}));
        }
        return autoBindProvider;
    }

    private void bindAutoBindSingletons() {
        for (Class<?> clazz : this.classpathScanner.getClasses()) {
            if (this.ignoreClasses.contains(clazz) || !clazz.isAnnotationPresent(AutoBindSingleton.class)) continue;
            AutoBindSingleton annotation = clazz.getAnnotation(AutoBindSingleton.class);
            if (Provider.class.isAssignableFrom(clazz)) {
                Preconditions.checkState((annotation.value() == Void.class ? 1 : 0) != 0, (Object)"@AutoBindSingleton value cannot be set for Providers");
                Preconditions.checkState((annotation.baseClass() == Void.class ? 1 : 0) != 0, (Object)"@AutoBindSingleton value cannot be set for Providers");
                Preconditions.checkState((!annotation.multiple() ? 1 : 0) != 0, (Object)"@AutoBindSingleton(multiple=true) value cannot be set for Providers");
                LOG.info("Installing @AutoBindSingleton " + clazz.getName());
                ProviderBinderUtil.bind(this.binder(), clazz, Scopes.SINGLETON);
                continue;
            }
            if (Module.class.isAssignableFrom(clazz)) continue;
            this.bindAutoBindSingleton(annotation, clazz);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void bindAutoBindSingleton(AutoBindSingleton annotation, Class<?> clazz) {
        Class<?> annotationBaseClass;
        LOG.info("Installing @AutoBindSingleton '{}'", (Object)clazz.getName());
        LOG.info("***** @AutoBindSingleton for '{}' is deprecated as of 2015-10-10.\nPlease use a Guice module with bind({}.class).asEagerSingleton() instead.\nSee https://github.com/Netflix/governator/wiki/Auto-Binding", (Object)clazz.getName(), (Object)clazz.getSimpleName());
        Singleton singletonAnnotation = clazz.getAnnotation(Singleton.class);
        if (singletonAnnotation == null) {
            LOG.info("***** {} should also be annotated with @Singleton to ensure singleton behavior", (Object)clazz.getName());
        }
        if ((annotationBaseClass = this.getAnnotationBaseClass(annotation)) != Void.class) {
            Object foundBindingClass = this.searchForBaseClass(clazz, annotationBaseClass, Sets.newHashSet());
            if (foundBindingClass == null) {
                throw new IllegalArgumentException(String.format("AutoBindSingleton class %s does not implement or extend %s", clazz.getName(), annotationBaseClass.getName()));
            }
            if (foundBindingClass instanceof Class) {
                if (annotation.multiple()) {
                    Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), (Class)((Class)foundBindingClass));
                    this.applyScope(multibinder.addBinding().to(clazz), clazz, annotation);
                    return;
                } else {
                    this.applyScope(this.binder().withSource((Object)this.getCurrentStackElement()).bind((Class)foundBindingClass).to(clazz), clazz, annotation);
                }
                return;
            } else {
                if (!(foundBindingClass instanceof Type)) throw new RuntimeException("Unexpected binding class: " + foundBindingClass);
                TypeLiteral typeLiteral = TypeLiteral.get((Type)((Type)foundBindingClass));
                if (annotation.multiple()) {
                    Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), (TypeLiteral)typeLiteral);
                    this.applyScope(multibinder.addBinding().to(clazz), clazz, annotation);
                    return;
                } else {
                    this.applyScope(this.binder().withSource((Object)this.getCurrentStackElement()).bind(typeLiteral).to(clazz), clazz, annotation);
                }
            }
            return;
        } else {
            Preconditions.checkState((!annotation.multiple() ? 1 : 0) != 0, (Object)"@AutoBindSingleton(multiple=true) must have either value or baseClass set");
            this.applyScope((ScopedBindingBuilder)this.binder().withSource((Object)this.getCurrentStackElement()).bind(clazz), clazz, annotation);
        }
    }

    private StackTraceElement getCurrentStackElement() {
        return Thread.currentThread().getStackTrace()[1];
    }

    private void applyScope(ScopedBindingBuilder builder, Class<?> clazz, AutoBindSingleton annotation) {
        if (!this.hasScopeAnnotation(clazz)) {
            if (annotation.eager()) {
                builder.asEagerSingleton();
            } else {
                builder.in(LazySingletonScope.get());
            }
        }
    }

    private boolean hasScopeAnnotation(Class<?> clazz) {
        Annotation scopeAnnotation = null;
        for (Annotation annot : clazz.getAnnotations()) {
            if (!annot.annotationType().isAnnotationPresent(ScopeAnnotation.class)) continue;
            Preconditions.checkState((scopeAnnotation == null ? 1 : 0) != 0, (Object)"Multiple scopes not allowed");
            scopeAnnotation = annot;
        }
        return scopeAnnotation != null;
    }

    private Class<?> getAnnotationBaseClass(AutoBindSingleton annotation) {
        Class annotationValue = annotation.value();
        Class annotationBaseClass = annotation.baseClass();
        Preconditions.checkState((annotationValue == Void.class || annotationBaseClass == Void.class ? 1 : 0) != 0, (Object)"@AutoBindSingleton cannot have both value and baseClass set");
        return annotationBaseClass != Void.class ? annotationBaseClass : annotationValue;
    }

    private Object searchForBaseClass(Class<?> clazz, Class<?> annotationBaseClass, Set<Object> usedSet) {
        if (clazz == null) {
            return null;
        }
        if (clazz.equals(annotationBaseClass)) {
            return clazz;
        }
        if (!usedSet.add(clazz)) {
            return null;
        }
        for (Type type : clazz.getGenericInterfaces()) {
            if (!MoreTypes.getRawType((Type)type).equals(annotationBaseClass)) continue;
            return type;
        }
        if (clazz.getGenericSuperclass() != null && MoreTypes.getRawType((Type)clazz.getGenericSuperclass()).equals(annotationBaseClass)) {
            return clazz.getGenericSuperclass();
        }
        for (Type type : clazz.getInterfaces()) {
            Object foundBindingClass = this.searchForBaseClass((Class<?>)type, annotationBaseClass, usedSet);
            if (foundBindingClass == null) continue;
            return foundBindingClass;
        }
        return this.searchForBaseClass(clazz.getSuperclass(), annotationBaseClass, usedSet);
    }
}

