/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.guice;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import com.netflix.governator.annotations.AutoBindSingleton;
import com.netflix.governator.guice.BootstrapBinder;
import com.netflix.governator.guice.BootstrapModule;
import com.netflix.governator.guice.InternalAutoBindModule;
import com.netflix.governator.lifecycle.ClasspathScanner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class InternalAutoBindModuleBootstrapModule
implements BootstrapModule {
    private static final Logger LOG = LoggerFactory.getLogger(InternalAutoBindModule.class);
    private final List<Class<?>> ignoreClasses;
    private final ClasspathScanner classpathScanner;

    @Inject
    InternalAutoBindModuleBootstrapModule(ClasspathScanner classpathScanner, Collection<Class<?>> ignoreClasses) {
        this.classpathScanner = classpathScanner;
        Preconditions.checkNotNull(ignoreClasses, (Object)"ignoreClasses cannot be null");
        this.ignoreClasses = ImmutableList.copyOf(ignoreClasses);
    }

    @Override
    public void configure(BootstrapBinder binder) {
        this.bindAutoBindSingletons(binder);
    }

    private Module bindAutoBindSingletons(BootstrapBinder binder) {
        ArrayList modules = Lists.newArrayList();
        for (Class<?> clazz : this.classpathScanner.getClasses()) {
            if (this.ignoreClasses.contains(clazz) || !clazz.isAnnotationPresent(AutoBindSingleton.class)) continue;
            AutoBindSingleton annotation = clazz.getAnnotation(AutoBindSingleton.class);
            if (!Module.class.isAssignableFrom(clazz)) continue;
            Preconditions.checkState((annotation.value() == Void.class ? 1 : 0) != 0, (Object)"@AutoBindSingleton value cannot be set for Modules");
            Preconditions.checkState((annotation.baseClass() == Void.class ? 1 : 0) != 0, (Object)"@AutoBindSingleton value cannot be set for Modules");
            Preconditions.checkState((!annotation.multiple() ? 1 : 0) != 0, (Object)"@AutoBindSingleton(multiple=true) value cannot be set for Modules");
            LOG.info("Found @AutoBindSingleton annotated module : {} ", (Object)clazz.getName());
            LOG.info("***** @AutoBindSingleton use for module {} is deprecated as of 2015-10-10.  Modules should be added directly to the injector or via install({}.class). See https://github.com/Netflix/governator/wiki/Auto-Binding", (Object)clazz.getName(), (Object)clazz.getSimpleName());
            binder.include((Class<? extends Module>)clazz);
        }
        return Modules.combine((Iterable)modules);
    }
}

