/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.guice;

import com.google.common.collect.Sets;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.Stage;
import com.netflix.governator.LifecycleManager;
import com.netflix.governator.configuration.ConfigurationDocumentation;
import com.netflix.governator.configuration.ConfigurationProvider;
import com.netflix.governator.guice.BootstrapBinder;
import com.netflix.governator.guice.BootstrapModule;
import com.netflix.governator.guice.LifecycleInjectorMode;
import com.netflix.governator.guice.ModuleListBuilder;
import com.netflix.governator.guice.ModuleTransformer;
import com.netflix.governator.guice.PostInjectorAction;
import com.netflix.governator.guice.lazy.FineGrainedLazySingleton;
import com.netflix.governator.guice.lazy.FineGrainedLazySingletonScope;
import com.netflix.governator.guice.lazy.LazySingleton;
import com.netflix.governator.guice.lazy.LazySingletonScope;
import com.netflix.governator.lifecycle.ClasspathScanner;
import com.netflix.governator.lifecycle.LifecycleConfigurationProviders;
import com.netflix.governator.lifecycle.LifecycleManagerArguments;
import java.util.Collection;
import java.util.Set;

class InternalBootstrapModule
extends AbstractModule {
    private BootstrapBinder bootstrapBinder;
    private ClasspathScanner scanner;
    private Stage stage;
    private LifecycleInjectorMode mode;
    private ModuleListBuilder modules;
    private Collection<PostInjectorAction> actions;
    private Collection<ModuleTransformer> transformers;
    private boolean disableAutoBinding;
    private final Collection<BootstrapModule> bootstrapModules;

    public InternalBootstrapModule(Collection<BootstrapModule> bootstrapModules, ClasspathScanner scanner, Stage stage, LifecycleInjectorMode mode, ModuleListBuilder modules, Collection<PostInjectorAction> actions, Collection<ModuleTransformer> transformers, boolean disableAutoBinding) {
        this.scanner = scanner;
        this.stage = stage;
        this.mode = mode;
        this.modules = modules;
        this.actions = actions;
        this.transformers = transformers;
        this.bootstrapModules = bootstrapModules;
        this.disableAutoBinding = disableAutoBinding;
    }

    BootstrapBinder getBootstrapBinder() {
        return this.bootstrapBinder;
    }

    protected void configure() {
        this.bind(ConfigurationDocumentation.class).in(Scopes.SINGLETON);
        this.bindScope(LazySingleton.class, LazySingletonScope.get());
        this.bindScope(FineGrainedLazySingleton.class, FineGrainedLazySingletonScope.get());
        this.bootstrapBinder = new BootstrapBinder(this.binder(), this.stage, this.mode, this.modules, this.actions, this.transformers, this.disableAutoBinding);
        if (this.bootstrapModules != null) {
            for (BootstrapModule bootstrapModule : this.bootstrapModules) {
                bootstrapModule.configure(this.bootstrapBinder);
            }
        }
        this.bind(LifecycleManager.class).in(Scopes.SINGLETON);
        this.binder().bind(LifecycleManagerArguments.class).in(Scopes.SINGLETON);
        this.binder().bind(com.netflix.governator.lifecycle.LifecycleManager.class).asEagerSingleton();
        this.binder().bind(LifecycleConfigurationProviders.class).toProvider(LifecycleConfigurationProvidersProvider.class).asEagerSingleton();
        this.stage = this.bootstrapBinder.getStage();
        this.mode = this.bootstrapBinder.getMode();
    }

    Stage getStage() {
        return this.stage;
    }

    LifecycleInjectorMode getMode() {
        return this.mode;
    }

    boolean isDisableAutoBinding() {
        return this.disableAutoBinding;
    }

    ModuleListBuilder getModuleListBuilder() {
        return this.modules;
    }

    @Provides
    @Singleton
    public ClasspathScanner getClasspathScanner() {
        return this.scanner;
    }

    private static class LifecycleConfigurationProvidersProvider
    implements Provider<LifecycleConfigurationProviders> {
        @Inject(optional=true)
        private Set<ConfigurationProvider> configurationProviders = Sets.newHashSet();

        private LifecycleConfigurationProvidersProvider() {
        }

        public LifecycleConfigurationProviders get() {
            return new LifecycleConfigurationProviders(this.configurationProviders);
        }
    }
}

