/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.guice;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.inject.AbstractModule;
import com.google.inject.Binding;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.ProvisionListener;
import com.netflix.governator.lifecycle.LifecycleListener;
import com.netflix.governator.lifecycle.LifecycleManager;
import com.netflix.governator.lifecycle.LifecycleMethods;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InternalLifecycleModule
extends AbstractModule
implements ProvisionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(InternalLifecycleModule.class);
    private final LoadingCache<Class<?>, LifecycleMethods> lifecycleMethods = CacheBuilder.newBuilder().initialCapacity(8192).concurrencyLevel(256).softValues().build(new CacheLoader<Class<?>, LifecycleMethods>(){

        public LifecycleMethods load(Class<?> key) throws Exception {
            return new LifecycleMethods(key);
        }
    });
    private final AtomicReference<LifecycleManager> lifecycleManager;

    InternalLifecycleModule(AtomicReference<LifecycleManager> lifecycleManager) {
        this.lifecycleManager = lifecycleManager;
    }

    public void configure() {
        this.bindListener(Matchers.any(), new ProvisionListener[]{this});
    }

    public <T> void onProvision(ProvisionListener.ProvisionInvocation<T> provision) {
        Object instance = provision.provision();
        if (instance != null) {
            Binding binding = provision.getBinding();
            LifecycleManager manager = this.lifecycleManager.get();
            if (manager != null) {
                Key bindingKey = binding.getKey();
                LOGGER.trace("provisioning instance of {}", (Object)bindingKey);
                TypeLiteral bindingType = bindingKey.getTypeLiteral();
                for (LifecycleListener listener : manager.getListeners()) {
                    listener.objectInjected(bindingType, instance);
                }
                try {
                    LifecycleMethods methods = (LifecycleMethods)this.lifecycleMethods.get(instance.getClass());
                    if (methods.hasLifecycleAnnotations()) {
                        manager.add(instance, binding, methods);
                    }
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
                catch (Throwable e) {
                    throw new Error(e);
                }
            }
        }
    }
}

