/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.guice.concurrent;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.BindingTargetVisitor;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.InjectionPoint;
import com.google.inject.spi.ProviderInstanceBinding;
import com.google.inject.spi.ProviderWithExtensionVisitor;
import com.google.inject.spi.Toolable;
import com.netflix.governator.annotations.NonConcurrent;
import com.netflix.governator.lifecycle.LifecycleListener;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class ConcurrentProviders {
    public static <T> Provider<T> of(final Class<? extends T> type) {
        return new ProviderWithExtensionVisitor<T>(){
            private volatile T instance;
            private Injector injector;
            private Set<LifecycleListener> listeners = Collections.emptySet();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public T get() {
                if (this.instance == null) {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.instance == null) {
                            this.instance = this.createAndInjectMember();
                        }
                    }
                }
                return this.instance;
            }

            private T createAndInjectMember() {
                Object instance = this.create();
                this.injector.injectMembers(instance);
                return instance;
            }

            private T create() {
                List deps;
                InjectionPoint injectionPoint = InjectionPoint.forConstructorOf((Class)type);
                long startTime = System.nanoTime();
                for (LifecycleListener listener : this.listeners) {
                    listener.objectInjecting(TypeLiteral.get((Class)type));
                }
                if (injectionPoint != null && (deps = injectionPoint.getDependencies()).size() > 0) {
                    Constructor constructor = (Constructor)injectionPoint.getMember();
                    ExecutorService executor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ConcurrentProviders-" + type.getSimpleName() + "-%d").build());
                    try {
                        Iterator<LifecycleListener> iterator;
                        ArrayList suppliers = Lists.newArrayListWithCapacity((int)deps.size());
                        for (Object dep : deps) {
                            if (!this.isConcurrent(constructor, dep.getParameterIndex())) {
                                suppliers.add(this.getCreator(dep.getKey()));
                                continue;
                            }
                            final Future<Object> future = executor.submit(new Callable<Object>((Dependency)dep){
                                final /* synthetic */ Dependency val$dep;
                                {
                                    this.val$dep = dependency;
                                }

                                @Override
                                public Object call() throws Exception {
                                    return this.getCreator(this.val$dep.getKey()).get();
                                }
                            });
                            suppliers.add(new Supplier(){

                                public Object get() {
                                    try {
                                        return future.get();
                                    }
                                    catch (InterruptedException e) {
                                        Thread.currentThread().interrupt();
                                        throw new ProvisionException("interrupted during provision");
                                    }
                                    catch (ExecutionException e) {
                                        throw new RuntimeException(e.getCause());
                                    }
                                }
                            });
                        }
                        ArrayList params = Lists.newArrayListWithCapacity((int)deps.size());
                        for (Supplier supplier : suppliers) {
                            params.add(supplier.get());
                        }
                        try {
                            Object obj = constructor.newInstance(params.toArray());
                            long duration = System.nanoTime() - startTime;
                            for (LifecycleListener listener : this.listeners) {
                                listener.objectInjected(TypeLiteral.get((Class)type), obj, duration, TimeUnit.NANOSECONDS);
                            }
                            iterator = obj;
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        return iterator;
                    }
                    finally {
                        executor.shutdown();
                    }
                }
                try {
                    Object obj = type.newInstance();
                    long duration = System.nanoTime() - startTime;
                    for (LifecycleListener listener : this.listeners) {
                        listener.objectInjected(TypeLiteral.get((Class)type), obj, duration, TimeUnit.NANOSECONDS);
                    }
                    return obj;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new ProvisionException("Error constructing object of type " + type.getName(), (Throwable)e);
                }
            }

            private boolean isConcurrent(Constructor<?> constructor, int parameterIndex) {
                Annotation[] annots = constructor.getParameterAnnotations()[parameterIndex];
                if (annots != null) {
                    for (Annotation annot : annots) {
                        if (!annot.annotationType().equals(NonConcurrent.class)) continue;
                        return false;
                    }
                }
                return true;
            }

            public <B, V> V acceptExtensionVisitor(BindingTargetVisitor<B, V> visitor, ProviderInstanceBinding<? extends B> binding) {
                return (V)visitor.visit(binding);
            }

            @Inject
            @Toolable
            void initialize(Injector injector) {
                this.injector = injector;
            }

            @Inject(optional=true)
            void setListeners(Set<LifecycleListener> listeners) {
                this.listeners = listeners;
            }

            public <S> Supplier<S> getCreator(final Key<S> key) {
                return new Supplier<S>(){

                    public S get() {
                        long startTime = System.nanoTime();
                        for (LifecycleListener listener : listeners) {
                            listener.objectInjecting(key.getTypeLiteral());
                        }
                        Object obj = injector.getInstance(key);
                        long duration = System.nanoTime() - startTime;
                        for (LifecycleListener listener : listeners) {
                            listener.objectInjected(key.getTypeLiteral(), obj, duration, TimeUnit.NANOSECONDS);
                        }
                        return obj;
                    }
                };
            }
        };
    }
}

