/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.lifecycle;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.netflix.governator.annotations.Configuration;
import com.netflix.governator.configuration.ConfigurationDocumentation;
import com.netflix.governator.configuration.ConfigurationKey;
import com.netflix.governator.configuration.ConfigurationProvider;
import com.netflix.governator.configuration.KeyParser;
import com.netflix.governator.configuration.Property;
import com.netflix.governator.lifecycle.LifecycleMethods;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConfigurationProcessor {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationProcessor.class);
    private final ConfigurationProvider configurationProvider;
    private final ConfigurationDocumentation configurationDocumentation;

    ConfigurationProcessor(ConfigurationProvider configurationProvider, ConfigurationDocumentation configurationDocumentation) {
        this.configurationProvider = configurationProvider;
        this.configurationDocumentation = configurationDocumentation;
    }

    void assignConfiguration(Object obj, Field field, Map<String, String> contextOverrides) throws Exception {
        Configuration configuration = field.getAnnotation(Configuration.class);
        String configurationName = configuration.value();
        ConfigurationKey key = new ConfigurationKey(configurationName, KeyParser.parse(configurationName, contextOverrides));
        Object value = null;
        boolean has = this.configurationProvider.has(key);
        if (has) {
            try {
                Type actualType;
                ParameterizedType type;
                if (Supplier.class.isAssignableFrom(field.getType())) {
                    Class actualClass;
                    type = (ParameterizedType)field.getGenericType();
                    actualType = type.getActualTypeArguments()[0];
                    if (actualType instanceof Class) {
                        actualClass = (Class)actualType;
                    } else if (actualType instanceof ParameterizedType) {
                        actualClass = (Class)((ParameterizedType)actualType).getRawType();
                    } else {
                        throw new UnsupportedOperationException("Supplier parameter type " + actualType + " not supported (" + field.getName() + ")");
                    }
                    Supplier current = (Supplier)LifecycleMethods.fieldGet(field, obj);
                    value = this.getConfigurationSupplier(field, key, actualClass, current);
                    if (value == null) {
                        log.error("Field type not supported: " + actualClass + " (" + field.getName() + ")");
                        field = null;
                    }
                } else if (Property.class.isAssignableFrom(field.getType())) {
                    Class actualClass;
                    type = (ParameterizedType)field.getGenericType();
                    actualType = type.getActualTypeArguments()[0];
                    if (actualType instanceof Class) {
                        actualClass = (Class)actualType;
                    } else if (actualType instanceof ParameterizedType) {
                        actualClass = (Class)((ParameterizedType)actualType).getRawType();
                    } else {
                        throw new UnsupportedOperationException("Supplier parameter type " + actualType + " not supported (" + field.getName() + ")");
                    }
                    Property current = (Property)LifecycleMethods.fieldGet(field, obj);
                    value = this.getConfigurationProperty(field, key, actualClass, current);
                    if (value == null) {
                        log.error("Field type not supported: " + actualClass + " (" + field.getName() + ")");
                        field = null;
                    }
                } else {
                    Supplier<?> supplier = this.getConfigurationSupplier(field, key, field.getType(), Suppliers.ofInstance(LifecycleMethods.fieldGet(field, obj)));
                    if (supplier == null) {
                        log.error("Field type not supported: " + field.getType() + " (" + field.getName() + ")");
                        field = null;
                    } else {
                        value = supplier.get();
                    }
                }
            }
            catch (IllegalArgumentException e) {
                this.ignoreTypeMismtachIfConfigured(configuration, configurationName, e);
                field = null;
            }
        }
        if (field != null) {
            String documentationValue;
            String defaultValue;
            if (Supplier.class.isAssignableFrom(field.getType())) {
                Supplier supplier = (Supplier)LifecycleMethods.fieldGet(field, obj);
                defaultValue = String.valueOf(supplier.get());
            } else {
                defaultValue = String.valueOf(LifecycleMethods.fieldGet(field, obj));
            }
            if (has) {
                LifecycleMethods.fieldSet(field, obj, value);
                documentationValue = String.valueOf(value);
                documentationValue = Supplier.class.isAssignableFrom(field.getType()) ? String.valueOf(((Supplier)value).get()) : String.valueOf(documentationValue);
            } else {
                documentationValue = "";
            }
            this.configurationDocumentation.registerConfiguration(field, configurationName, has, defaultValue, documentationValue, configuration.documentation());
        }
    }

    private Property<?> getConfigurationProperty(Field field, ConfigurationKey key, Class<?> type, Property<?> current) {
        return Property.from(this.getConfigurationSupplier(field, key, type, Property.from(current)));
    }

    private Supplier<?> getConfigurationSupplier(Field field, ConfigurationKey key, Class<?> type, Supplier<?> current) {
        if (String.class.isAssignableFrom(type)) {
            return this.configurationProvider.getStringSupplier(key, (String)current.get());
        }
        if (Boolean.class.isAssignableFrom(type) || Boolean.TYPE.isAssignableFrom(type)) {
            return this.configurationProvider.getBooleanSupplier(key, (Boolean)current.get());
        }
        if (Integer.class.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type)) {
            return this.configurationProvider.getIntegerSupplier(key, (Integer)current.get());
        }
        if (Long.class.isAssignableFrom(type) || Long.TYPE.isAssignableFrom(type)) {
            return this.configurationProvider.getLongSupplier(key, (Long)current.get());
        }
        if (Double.class.isAssignableFrom(type) || Double.TYPE.isAssignableFrom(type)) {
            return this.configurationProvider.getDoubleSupplier(key, (Double)current.get());
        }
        if (Date.class.isAssignableFrom(type)) {
            return this.configurationProvider.getDateSupplier(key, (Date)current.get());
        }
        return this.configurationProvider.getObjectSupplier(key, current.get(), type);
    }

    private void ignoreTypeMismtachIfConfigured(Configuration configuration, String configurationName, Exception e) {
        if (!configuration.ignoreTypeMismatch()) {
            throw Throwables.propagate((Throwable)e);
        }
        log.info(String.format("Type conversion failed for configuration name %s. This error will be ignored and the field will have the default value if specified. Error: %s", configurationName, e));
    }
}

