/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.lifecycle;

import com.google.common.collect.Maps;
import com.netflix.governator.annotations.Configuration;
import com.netflix.governator.annotations.ConfigurationVariable;
import com.netflix.governator.configuration.ConfigurationDocumentation;
import com.netflix.governator.configuration.ConfigurationMapper;
import com.netflix.governator.configuration.ConfigurationProvider;
import com.netflix.governator.lifecycle.ConfigurationProcessor;
import com.netflix.governator.lifecycle.LifecycleMethods;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Map;

public class DefaultConfigurationMapper
implements ConfigurationMapper {
    @Override
    public void mapConfiguration(ConfigurationProvider configurationProvider, ConfigurationDocumentation configurationDocumentation, Object obj, LifecycleMethods methods) throws Exception {
        Field[] configurationFields = methods.annotatedFields(Configuration.class);
        if (configurationFields.length > 0) {
            Map<String, String> overrides;
            Field[] configurationVariableFields = methods.annotatedFields(ConfigurationVariable.class);
            if (configurationVariableFields.length > 0) {
                overrides = Maps.newHashMap();
                for (Field variableField : configurationVariableFields) {
                    ConfigurationVariable annot = variableField.getAnnotation(ConfigurationVariable.class);
                    if (annot == null) continue;
                    overrides.put(annot.name(), LifecycleMethods.fieldGet(variableField, obj).toString());
                }
            } else {
                overrides = Collections.emptyMap();
            }
            ConfigurationProcessor configurationProcessor = new ConfigurationProcessor(configurationProvider, configurationDocumentation);
            for (Field configurationField : configurationFields) {
                try {
                    configurationProcessor.assignConfiguration(obj, configurationField, overrides);
                }
                catch (Exception e) {
                    throw new Exception(String.format("Failed to bind property '%s' for instance of '%s'", configurationField.getName(), obj.getClass().getCanonicalName()), e);
                }
            }
        }
    }
}

