/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.lifecycle;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MapMaker;
import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import com.netflix.governator.LifecycleAction;
import com.netflix.governator.annotations.PreConfiguration;
import com.netflix.governator.annotations.WarmUp;
import com.netflix.governator.configuration.ConfigurationColumnWriter;
import com.netflix.governator.configuration.ConfigurationDocumentation;
import com.netflix.governator.configuration.ConfigurationMapper;
import com.netflix.governator.configuration.ConfigurationProvider;
import com.netflix.governator.guice.PostInjectorAction;
import com.netflix.governator.internal.JSR250LifecycleAction;
import com.netflix.governator.internal.PreDestroyLifecycleFeature;
import com.netflix.governator.internal.PreDestroyMonitor;
import com.netflix.governator.lifecycle.LifecycleListener;
import com.netflix.governator.lifecycle.LifecycleManagerArguments;
import com.netflix.governator.lifecycle.LifecycleMethods;
import com.netflix.governator.lifecycle.LifecycleState;
import com.netflix.governator.lifecycle.ResourceLocator;
import com.netflix.governator.lifecycle.ResourceMapper;
import java.io.Closeable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class LifecycleManager
implements Closeable,
PostInjectorAction {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ConcurrentMap<Object, LifecycleStateWrapper> objectStates = new MapMaker().weakKeys().initialCapacity(65536).concurrencyLevel(1024).makeMap();
    private final PreDestroyLifecycleFeature preDestroyLifecycleFeature = new PreDestroyLifecycleFeature(JSR250LifecycleAction.ValidationMode.LAX);
    private final ConcurrentMap<Class<?>, List<LifecycleAction>> preDestroyActionCache = new ConcurrentHashMap(32768);
    private final AtomicReference<State> state = new AtomicReference<State>(State.LATENT);
    private final ConfigurationDocumentation configurationDocumentation;
    private final ConfigurationProvider configurationProvider;
    private final ConfigurationMapper configurationMapper;
    private final ResourceMapper resourceMapper;
    final LifecycleListener[] listeners;
    private final PreDestroyMonitor preDestroyMonitor;
    private com.netflix.governator.LifecycleManager newLifecycleManager;

    public LifecycleManager() {
        this(new LifecycleManagerArguments(), null);
    }

    public LifecycleManager(LifecycleManagerArguments arguments) {
        this(arguments, null);
    }

    @Inject
    public LifecycleManager(LifecycleManagerArguments arguments, Injector injector) {
        this.preDestroyMonitor = injector != null ? new PreDestroyMonitor(injector.getScopeBindings()) : null;
        this.configurationMapper = arguments.getConfigurationMapper();
        this.newLifecycleManager = arguments.getLifecycleManager();
        this.listeners = arguments.getLifecycleListeners().toArray(new LifecycleListener[0]);
        this.resourceMapper = new ResourceMapper(injector, (Collection<ResourceLocator>)ImmutableSet.copyOf(arguments.getResourceLocators()));
        this.configurationDocumentation = arguments.getConfigurationDocumentation();
        this.configurationProvider = arguments.getConfigurationProvider();
    }

    public Collection<LifecycleListener> getListeners() {
        return Arrays.asList(this.listeners);
    }

    @Deprecated
    public void add(Object ... objects) throws Exception {
        for (Object obj : objects) {
            this.add(obj);
        }
    }

    @Deprecated
    public void add(Object obj) throws Exception {
        this.add(obj, null, new LifecycleMethods(obj.getClass()));
    }

    @Deprecated
    public void add(Object obj, LifecycleMethods methods) throws Exception {
        this.add(obj, null, methods);
    }

    public <T> void add(T obj, Binding<T> binding, LifecycleMethods methods) throws Exception {
        State managerState = this.state.get();
        if (managerState != State.CLOSED) {
            this.startInstance(obj, binding, methods);
            if (managerState == State.STARTED) {
                this.initializeObjectPostStart(obj);
            }
        } else {
            throw new IllegalStateException("LifecycleManager is closed");
        }
    }

    public boolean hasStarted() {
        return this.state.get() == State.STARTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LifecycleState getState(Object obj) {
        LifecycleStateWrapper lifecycleState = (LifecycleStateWrapper)this.objectStates.get(obj);
        if (lifecycleState == null) {
            return this.hasStarted() ? LifecycleState.ACTIVE : LifecycleState.LATENT;
        }
        LifecycleStateWrapper lifecycleStateWrapper = lifecycleState;
        synchronized (lifecycleStateWrapper) {
            return lifecycleState.get();
        }
    }

    public void start() throws Exception {
        Preconditions.checkState((boolean)this.state.compareAndSet(State.LATENT, State.STARTING), (Object)"Already started");
        new ConfigurationColumnWriter(this.configurationDocumentation).output(this.log);
        if (this.newLifecycleManager != null) {
            this.newLifecycleManager.notifyStarted();
        }
        this.state.set(State.STARTED);
    }

    @Deprecated
    public boolean start(long maxWait, TimeUnit unit) throws Exception {
        this.start();
        return true;
    }

    private <T> void startInstance(T obj, Binding<T> binding, LifecycleMethods methods) throws Exception {
        List preDestroyActions;
        Class<?> instanceType = obj.getClass();
        this.log.debug("Starting {}", (Object)instanceType.getName());
        LifecycleStateWrapper lifecycleState = this.initState(obj, LifecycleState.PRE_CONFIGURATION);
        methods.methodInvoke(PreConfiguration.class, obj);
        lifecycleState.set(obj, LifecycleState.SETTING_CONFIGURATION);
        this.configurationMapper.mapConfiguration(this.configurationProvider, this.configurationDocumentation, obj, methods);
        lifecycleState.set(obj, LifecycleState.SETTING_RESOURCES);
        this.resourceMapper.map(obj, methods);
        lifecycleState.set(obj, LifecycleState.POST_CONSTRUCTING);
        methods.methodInvoke(PostConstruct.class, obj);
        Method[] warmUpMethods = methods.annotatedMethods(WarmUp.class);
        if (warmUpMethods.length > 0) {
            Method[] postConstructMethods = methods.annotatedMethods(PostConstruct.class);
            for (Method warmupMethod : warmUpMethods) {
                boolean skipWarmup = false;
                for (Method postConstruct : postConstructMethods) {
                    if (postConstruct != warmupMethod) continue;
                    skipWarmup = true;
                    break;
                }
                if (skipWarmup) continue;
                this.log.debug("\t{}()", (Object)warmupMethod.getName());
                LifecycleMethods.methodInvoke(warmupMethod, obj);
            }
        }
        if (this.preDestroyActionCache.containsKey(instanceType)) {
            preDestroyActions = (List)this.preDestroyActionCache.get(instanceType);
        } else {
            preDestroyActions = this.preDestroyLifecycleFeature.getActionsForType(instanceType);
            this.preDestroyActionCache.put(instanceType, preDestroyActions);
        }
        if (!preDestroyActions.isEmpty()) {
            if (binding != null) {
                this.preDestroyMonitor.register(obj, binding, (Iterable)preDestroyActions);
            } else {
                this.preDestroyMonitor.register(obj, (Object)"legacy", (Iterable)preDestroyActions);
            }
        }
    }

    private LifecycleStateWrapper initState(Object obj, LifecycleState state) {
        LifecycleStateWrapper stateWrapper = new LifecycleStateWrapper();
        this.objectStates.put(obj, stateWrapper);
        stateWrapper.set(obj, state);
        return stateWrapper;
    }

    @Override
    public synchronized void close() {
        if (this.state.compareAndSet(State.STARTING, State.CLOSED) || this.state.compareAndSet(State.STARTED, State.CLOSED)) {
            try {
                if (this.newLifecycleManager != null) {
                    this.newLifecycleManager.notifyShutdown();
                }
                this.preDestroyMonitor.close();
            }
            catch (Exception e) {
                this.log.error("While stopping instances", (Throwable)e);
            }
            finally {
                this.objectStates.clear();
                this.preDestroyActionCache.clear();
            }
        }
    }

    private void initializeObjectPostStart(Object obj) {
    }

    @Override
    public void call(Injector injector) {
        this.resourceMapper.setInjector(injector);
        this.preDestroyMonitor.addScopeBindings(injector.getScopeBindings());
    }

    class LifecycleStateWrapper {
        LifecycleState state;

        LifecycleStateWrapper() {
        }

        public void set(Object managedInstance, LifecycleState state) {
            this.state = state;
            for (LifecycleListener listener : LifecycleManager.this.listeners) {
                listener.stateChanged(managedInstance, state);
            }
        }

        public LifecycleState get() {
            return this.state;
        }
    }

    private static enum State {
        LATENT,
        STARTING,
        STARTED,
        CLOSED;

    }
}

