/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.lifecycle;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.netflix.governator.annotations.Configuration;
import com.netflix.governator.annotations.ConfigurationVariable;
import com.netflix.governator.annotations.PreConfiguration;
import com.netflix.governator.annotations.WarmUp;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.annotation.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifecycleMethods {
    private static final Field[] EMPTY_FIELDS = new Field[0];
    private static final Method[] EMPTY_METHODS = new Method[0];
    private static final MethodHandles.Lookup METHOD_HANDLE_LOOKUP = MethodHandles.lookup();
    private static final Logger log = LoggerFactory.getLogger(LifecycleMethods.class);
    private boolean hasValidations = false;
    private final boolean hasResources;
    static final Map<Method, MethodHandle> methodHandlesMap = new ConcurrentHashMap<Method, MethodHandle>(32768);
    static final Map<Field, MethodHandle[]> fieldHandlesMap = new ConcurrentHashMap<Field, MethodHandle[]>(32768);
    Map<Class<? extends Annotation>, Method[]> methodMap;
    Map<Class<? extends Annotation>, Field[]> fieldMap;
    Map<Class<? extends Annotation>, Annotation[]> classMap;
    private static final MethodHandle[] EMPTY_FIELD_HANDLES = new MethodHandle[0];

    public LifecycleMethods(Class<?> clazz) {
        LifecycleMethodsBuilder builder = new LifecycleMethodsBuilder(clazz, (Multimap<Class<? extends Annotation>, String>)ArrayListMultimap.create());
        this.hasResources = builder.hasResources;
        this.hasValidations = builder.hasValidations;
        this.methodMap = new HashMap<Class<? extends Annotation>, Method[]>();
        for (Map.Entry entry : builder.methodMap.asMap().entrySet()) {
            this.methodMap.put((Class<? extends Annotation>)entry.getKey(), ((Collection)entry.getValue()).toArray(EMPTY_METHODS));
        }
        this.fieldMap = new HashMap<Class<? extends Annotation>, Field[]>();
        for (Map.Entry entry : builder.fieldMap.asMap().entrySet()) {
            this.fieldMap.put((Class<? extends Annotation>)entry.getKey(), ((Collection)entry.getValue()).toArray(EMPTY_FIELDS));
        }
        this.classMap = new HashMap<Class<? extends Annotation>, Annotation[]>();
        for (Class annotationClass : LifecycleMethodsBuilder.classAnnotations) {
            Annotation[] annotationsArray = (Annotation[])Array.newInstance(annotationClass, 0);
            Collection annotations = builder.classMap.get((Object)annotationClass);
            if (annotations != null) {
                annotationsArray = annotations.toArray(annotationsArray);
            }
            this.classMap.put(annotationClass, annotationsArray);
        }
    }

    public boolean hasLifecycleAnnotations() {
        return this.hasValidations;
    }

    public boolean hasResources() {
        return this.hasResources;
    }

    @Deprecated
    public Collection<Method> methodsFor(Class<? extends Annotation> annotation) {
        return Arrays.asList(this.annotatedMethods(annotation));
    }

    @Deprecated
    public Collection<Field> fieldsFor(Class<? extends Annotation> annotation) {
        return Arrays.asList(this.annotatedFields(annotation));
    }

    @Deprecated
    public <T extends Annotation> Collection<T> classAnnotationsFor(Class<T> annotation) {
        return Arrays.asList(this.classAnnotations(annotation));
    }

    public Method[] annotatedMethods(Class<? extends Annotation> annotation) {
        Method[] methods = this.methodMap.get(annotation);
        return methods != null ? methods : EMPTY_METHODS;
    }

    public Field[] annotatedFields(Class<? extends Annotation> annotation) {
        Field[] fields = this.fieldMap.get(annotation);
        return fields != null ? fields : EMPTY_FIELDS;
    }

    public <T extends Annotation> T[] classAnnotations(Class<T> annotation) {
        Annotation[] annotations = this.classMap.get(annotation);
        return annotations != null ? annotations : (Annotation[])Array.newInstance(annotation, 0);
    }

    public void methodInvoke(Class<? extends Annotation> annotation, Object obj) throws Exception {
        if (this.methodMap.containsKey(annotation)) {
            for (Method m : this.methodMap.get(annotation)) {
                LifecycleMethods.methodInvoke(m, obj);
            }
        }
    }

    public static void methodInvoke(Method method, Object target) throws InvocationTargetException, IllegalAccessException {
        MethodHandle handler = methodHandlesMap.get(method);
        if (handler != null) {
            try {
                if (Modifier.isStatic(method.getModifiers())) {
                    log.warn("static lifecycle method: {}, target={}", (Object)method, target);
                    handler.invoke();
                }
                handler.invoke(target);
            }
            catch (Throwable e) {
                throw new InvocationTargetException(e, "invokedynamic: method=" + method + ", target=" + target);
            }
        } else {
            method.invoke(target, new Object[0]);
        }
    }

    public static <T> T fieldGet(Field field, Object obj) throws InvocationTargetException, IllegalAccessException {
        MethodHandle[] fieldHandler = fieldHandlesMap.get(field);
        if (fieldHandler == null) {
            fieldHandler = LifecycleMethods.updateFieldHandles(field);
        }
        if (fieldHandler != EMPTY_FIELD_HANDLES) {
            try {
                return (T)(Modifier.isStatic(field.getModifiers()) ? fieldHandler[0].invoke() : fieldHandler[0].bindTo(obj).invoke());
            }
            catch (Throwable e) {
                throw new InvocationTargetException(e, "invokedynamic: field=" + field + ", object=" + obj);
            }
        }
        return (T)field.get(obj);
    }

    public static void fieldSet(Field field, Object object, Object value) throws InvocationTargetException, IllegalAccessException {
        MethodHandle[] fieldHandler = fieldHandlesMap.get(field);
        if (fieldHandler == null) {
            fieldHandler = LifecycleMethods.updateFieldHandles(field);
        }
        if (fieldHandler != EMPTY_FIELD_HANDLES) {
            try {
                if (Modifier.isStatic(field.getModifiers())) {
                    fieldHandler[1].invoke(value);
                }
                fieldHandler[1].bindTo(object).invoke(value);
            }
            catch (Throwable e) {
                throw new InvocationTargetException(e, "invokedynamic: field=" + field + ", object=" + object);
            }
        } else {
            field.set(object, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MethodHandle[] updateFieldHandles(Field field) {
        Map<Field, MethodHandle[]> map = fieldHandlesMap;
        synchronized (map) {
            MethodHandle[] handles = EMPTY_FIELD_HANDLES;
            try {
                handles = new MethodHandle[]{METHOD_HANDLE_LOOKUP.unreflectGetter(field), METHOD_HANDLE_LOOKUP.unreflectSetter(field)};
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            fieldHandlesMap.put(field, handles);
            return handles;
        }
    }

    static class LifecycleMethodsBuilder {
        private static final Logger log = LoggerFactory.getLogger(LifecycleMethodsBuilder.class);
        private static final Collection<Class<? extends Annotation>> fieldAnnotations;
        private static final Collection<Class<? extends Annotation>> methodAnnotations;
        private static final Collection<Class<? extends Annotation>> classAnnotations;
        private boolean hasValidations = false;
        private boolean hasResources;
        private final Multimap<Class<? extends Annotation>, Field> fieldMap = ArrayListMultimap.create((int)8, (int)32);
        private final Multimap<Class<? extends Annotation>, Method> methodMap = ArrayListMultimap.create((int)16, (int)32);
        private final Multimap<Class<? extends Annotation>, Annotation> classMap = ArrayListMultimap.create((int)4, (int)8);

        public LifecycleMethodsBuilder(Class<?> clazz, Multimap<Class<? extends Annotation>, String> usedNames) {
            this.addLifeCycleMethods(clazz, (Multimap<Class<? extends Annotation>, String>)ArrayListMultimap.create());
            this.hasResources = this.fieldMap.containsKey(Resource.class) || this.fieldMap.containsKey(Resources.class) || this.methodMap.containsKey(Resource.class) || this.methodMap.containsKey(Resources.class) || this.classMap.containsKey(Resource.class) || this.classMap.containsKey(Resources.class);
            this.hasValidations = this.hasValidations || !this.methodMap.isEmpty() || !this.fieldMap.isEmpty();
        }

        void addLifeCycleMethods(Class<?> clazz, Multimap<Class<? extends Annotation>, String> usedNames) {
            if (clazz == null) {
                return;
            }
            for (Class<? extends Annotation> annotationClass : classAnnotations) {
                if (!clazz.isAnnotationPresent(annotationClass)) continue;
                this.classMap.put(annotationClass, (Object)clazz.getAnnotation(annotationClass));
            }
            for (Field field : this.getDeclaredFields(clazz)) {
                if (field.isSynthetic()) continue;
                for (Class<? extends Annotation> annotationClass : fieldAnnotations) {
                    this.processField(field, annotationClass, usedNames);
                }
            }
            for (AccessibleObject accessibleObject : this.getDeclaredMethods(clazz)) {
                if (((Method)accessibleObject).isSynthetic() || ((Method)accessibleObject).isBridge()) continue;
                for (Class<? extends Annotation> annotationClass : methodAnnotations) {
                    this.processMethod((Method)accessibleObject, annotationClass, usedNames);
                }
            }
            this.addLifeCycleMethods(clazz.getSuperclass(), usedNames);
            for (AnnotatedElement annotatedElement : clazz.getInterfaces()) {
                this.addLifeCycleMethods((Class<?>)annotatedElement, usedNames);
            }
        }

        private Method[] getDeclaredMethods(Class<?> clazz) {
            try {
                return clazz.getDeclaredMethods();
            }
            catch (Throwable e) {
                this.handleReflectionError(clazz, e);
                return EMPTY_METHODS;
            }
        }

        private Field[] getDeclaredFields(Class<?> clazz) {
            try {
                return clazz.getDeclaredFields();
            }
            catch (Throwable e) {
                this.handleReflectionError(clazz, e);
                return EMPTY_FIELDS;
            }
        }

        private void handleReflectionError(Class<?> clazz, Throwable e) {
            if (e != null) {
                if (e instanceof NoClassDefFoundError || e instanceof ClassNotFoundException) {
                    log.debug(String.format("Class %s could not be resolved because of a class path error. Governator cannot further process the class.", clazz.getName()), e);
                    return;
                }
                this.handleReflectionError(clazz, e.getCause());
            }
        }

        private void processField(Field field, Class<? extends Annotation> annotationClass, Multimap<Class<? extends Annotation>, String> usedNames) {
            if (field.isAnnotationPresent(annotationClass)) {
                String fieldName = field.getName();
                if (!usedNames.get(annotationClass).contains(fieldName)) {
                    field.setAccessible(true);
                    usedNames.put(annotationClass, (Object)fieldName);
                    this.fieldMap.put(annotationClass, (Object)field);
                    try {
                        fieldHandlesMap.put(field, new MethodHandle[]{METHOD_HANDLE_LOOKUP.unreflectGetter(field), METHOD_HANDLE_LOOKUP.unreflectSetter(field)});
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
            }
        }

        private void processMethod(Method method, Class<? extends Annotation> annotationClass, Multimap<Class<? extends Annotation>, String> usedNames) {
            if (method.isAnnotationPresent(annotationClass)) {
                String methodName = method.getName();
                if (!usedNames.get(annotationClass).contains(methodName)) {
                    method.setAccessible(true);
                    usedNames.put(annotationClass, (Object)methodName);
                    this.methodMap.put(annotationClass, (Object)method);
                    try {
                        methodHandlesMap.put(method, METHOD_HANDLE_LOOKUP.unreflect(method));
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
            }
        }

        static {
            ImmutableSet.Builder methodAnnotationsBuilder = ImmutableSet.builder();
            methodAnnotationsBuilder.add(PreConfiguration.class);
            methodAnnotationsBuilder.add(PostConstruct.class);
            methodAnnotationsBuilder.add(PreDestroy.class);
            methodAnnotationsBuilder.add(Resource.class);
            methodAnnotationsBuilder.add(Resources.class);
            methodAnnotationsBuilder.add(WarmUp.class);
            methodAnnotations = methodAnnotationsBuilder.build();
            ImmutableSet.Builder fieldAnnotationsBuilder = ImmutableSet.builder();
            fieldAnnotationsBuilder.add(Configuration.class);
            fieldAnnotationsBuilder.add(Resource.class);
            fieldAnnotationsBuilder.add(Resources.class);
            fieldAnnotationsBuilder.add(ConfigurationVariable.class);
            fieldAnnotations = fieldAnnotationsBuilder.build();
            ImmutableSet.Builder classAnnotationsBuilder = ImmutableSet.builder();
            classAnnotationsBuilder.add(Resource.class);
            classAnnotationsBuilder.add(Resources.class);
            classAnnotations = classAnnotationsBuilder.build();
        }
    }
}

