/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.lifecycle;

import com.google.inject.Injector;
import com.netflix.governator.lifecycle.LifecycleMethods;
import com.netflix.governator.lifecycle.ResourceLocator;
import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Resource;
import javax.annotation.Resources;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ResourceMapper {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Injector injector;
    private final Collection<ResourceLocator> resourceLocators;

    ResourceMapper(Injector injector, Collection<ResourceLocator> resourceLocators) {
        this.injector = injector;
        this.resourceLocators = resourceLocators;
    }

    public void map(Object obj, LifecycleMethods methods) throws Exception {
        if (methods.hasResources()) {
            Resource resource;
            int n;
            int n2;
            Resource[] resourceArray;
            Resources resources;
            for (Field field : methods.annotatedFields(Resources.class)) {
                resources = field.getAnnotation(Resources.class);
                resourceArray = resources.value();
                n2 = resourceArray.length;
                for (n = 0; n < n2; ++n) {
                    Resource resource2 = resourceArray[n];
                    this.setFieldResource(obj, field, resource2);
                }
            }
            for (Field field : methods.annotatedFields(Resource.class)) {
                resource = field.getAnnotation(Resource.class);
                this.setFieldResource(obj, field, resource);
            }
            for (AccessibleObject accessibleObject : methods.annotatedMethods(Resources.class)) {
                resources = ((Method)accessibleObject).getAnnotation(Resources.class);
                resourceArray = resources.value();
                n2 = resourceArray.length;
                for (n = 0; n < n2; ++n) {
                    Resource resource2 = resourceArray[n];
                    this.setMethodResource(obj, (Method)accessibleObject, resource2);
                }
            }
            for (AccessibleObject accessibleObject : methods.annotatedMethods(Resource.class)) {
                resource = ((Method)accessibleObject).getAnnotation(Resource.class);
                this.setMethodResource(obj, (Method)accessibleObject, resource);
            }
            for (AccessibleObject accessibleObject : (Resources[])methods.classAnnotations(Resources.class)) {
                for (Resource resource3 : accessibleObject.value()) {
                    this.loadClassResource(resource3);
                }
            }
            for (AccessibleObject accessibleObject : (Resource[])methods.classAnnotations(Resource.class)) {
                this.loadClassResource((Resource)accessibleObject);
            }
        }
    }

    private void loadClassResource(Resource resource) throws Exception {
        if (resource.name().isEmpty() || resource.type() == Object.class) {
            throw new Exception("Class resources must have both name() and type(): " + resource);
        }
        this.findResource(resource);
    }

    private void setMethodResource(Object obj, Method method, Resource resource) throws Exception {
        if (method.getParameterTypes().length != 1 || method.getReturnType() != Void.TYPE) {
            throw new Exception(String.format("%s.%s() is not a proper JavaBean setter.", obj.getClass().getName(), method.getName()));
        }
        String beanName = method.getName();
        if (beanName.toLowerCase().startsWith("set")) {
            beanName = beanName.substring("set".length());
        }
        beanName = Introspector.decapitalize(beanName);
        String siteName = obj.getClass().getName() + "/" + beanName;
        resource = this.adjustResource(resource, method.getParameterTypes()[0], siteName);
        Object resourceObj = this.findResource(resource);
        method.setAccessible(true);
        method.invoke(obj, resourceObj);
    }

    private void setFieldResource(Object obj, Field field, Resource resource) throws Exception {
        String siteName = obj.getClass().getName() + "/" + field.getName();
        Object resourceObj = this.findResource(this.adjustResource(resource, field.getType(), siteName));
        field.setAccessible(true);
        field.set(obj, resourceObj);
    }

    private Resource adjustResource(final Resource resource, final Class<?> siteType, final String siteName) {
        return new Resource(){

            public String name() {
                return resource.name().length() == 0 ? siteName : resource.name();
            }

            public String lookup() {
                return this.name();
            }

            public Class<?> type() {
                return resource.type() == Object.class ? siteType : resource.type();
            }

            public Resource.AuthenticationType authenticationType() {
                return resource.authenticationType();
            }

            public boolean shareable() {
                return resource.shareable();
            }

            public String mappedName() {
                return resource.mappedName();
            }

            public String description() {
                return resource.description();
            }

            public Class<? extends Annotation> annotationType() {
                return resource.annotationType();
            }
        };
    }

    private Object findResource(Resource resource) throws Exception {
        if (!this.resourceLocators.isEmpty()) {
            final Iterator<ResourceLocator> iterator = this.resourceLocators.iterator();
            ResourceLocator locator = iterator.next();
            ResourceLocator nextInChain = new ResourceLocator(){

                @Override
                public Object locate(Resource resource, ResourceLocator nextInChain) throws Exception {
                    if (iterator.hasNext()) {
                        return ((ResourceLocator)iterator.next()).locate(resource, this);
                    }
                    return ResourceMapper.this.defaultFindResource(resource);
                }
            };
            return locator.locate(resource, nextInChain);
        }
        return this.defaultFindResource(resource);
    }

    private Object defaultFindResource(Resource resource) throws Exception {
        if (this.injector == null) {
            throw new NamingException("Could not find resource: " + resource);
        }
        this.log.debug("defaultFindResource using injector {}", (Object)System.identityHashCode(this.injector));
        return this.injector.getInstance(resource.type());
    }

    public Injector getInjector() {
        return this.injector;
    }

    public void setInjector(Injector injector) {
        this.injector = injector;
    }
}

