/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator;

import com.netflix.governator.SafeLifecycleListener;
import com.netflix.governator.annotations.SuppressLifecycleUninitialized;
import com.netflix.governator.spi.LifecycleListener;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@SuppressLifecycleUninitialized
public final class LifecycleManager {
    private static final Logger LOG = LoggerFactory.getLogger(LifecycleManager.class);
    private final Set<LifecycleListener> listeners = new HashSet<LifecycleListener>();
    private final AtomicReference<State> state = new AtomicReference<State>(State.Starting);
    private volatile Throwable failureReason;

    public synchronized void addListener(LifecycleListener listener) {
        if (!this.listeners.contains(listener = SafeLifecycleListener.wrap(listener)) && this.listeners.add(listener)) {
            LOG.info("Adding LifecycleListener '{}' {}", (Object)listener, (Object)System.identityHashCode(listener));
            switch (this.state.get()) {
                case Started: {
                    listener.onStarted();
                    break;
                }
                case Stopped: {
                    listener.onStopped(this.failureReason);
                }
            }
        }
    }

    public synchronized void notifyStarted() {
        if (this.state.compareAndSet(State.Starting, State.Started)) {
            for (LifecycleListener listener : this.listeners) {
                listener.onStarted();
            }
        }
    }

    public synchronized void notifyStartFailed(Throwable t) {
        if (this.state.compareAndSet(State.Starting, State.Stopped)) {
            this.failureReason = t;
            for (LifecycleListener listener : this.listeners) {
                listener.onStopped(t);
            }
        }
    }

    public synchronized void notifyShutdown() {
        if (this.state.compareAndSet(State.Started, State.Done)) {
            LOG.info("Shutting down LifecycleManager");
            for (LifecycleListener listener : this.listeners) {
                listener.onStopped(null);
            }
        }
    }

    public State getState() {
        return this.state.get();
    }

    public Throwable getFailureReason() {
        return this.failureReason;
    }

    public static enum State {
        Starting,
        Started,
        Stopped,
        Done;

    }
}

