/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.ProvisionException;
import com.google.inject.matcher.Matchers;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.spi.ProvisionListener;
import com.netflix.governator.AbstractLifecycleListener;
import com.netflix.governator.GovernatorFeatures;
import com.netflix.governator.LifecycleAction;
import com.netflix.governator.LifecycleFeature;
import com.netflix.governator.LifecycleManager;
import com.netflix.governator.annotations.SuppressLifecycleUninitialized;
import com.netflix.governator.internal.GovernatorFeatureSet;
import com.netflix.governator.internal.PostConstructLifecycleActions;
import com.netflix.governator.internal.PreDestroyLifecycleActions;
import com.netflix.governator.spi.LifecycleListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LifecycleModule
extends AbstractModule {
    private static final Logger LOG = LoggerFactory.getLogger(LifecycleModule.class);
    private LifecycleProvisionListener provisionListener = new LifecycleProvisionListener();

    protected void configure() {
        this.requestStaticInjection(new Class[]{LifecycleProvisionListener.class});
        this.bind(LifecycleProvisionListener.class).toInstance((Object)this.provisionListener);
        this.bindListener(Matchers.any(), new ProvisionListener[]{this.provisionListener});
        Multibinder.newSetBinder((Binder)this.binder(), LifecycleFeature.class);
    }

    public boolean equals(Object obj) {
        return ((Object)((Object)this)).getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }

    public String toString() {
        return "LifecycleModule[]";
    }

    @Singleton
    @SuppressLifecycleUninitialized
    static class LifecycleProvisionListener
    extends AbstractLifecycleListener
    implements ProvisionListener {
        private final ConcurrentLinkedDeque<Runnable> shutdownActions = new ConcurrentLinkedDeque();
        private final ConcurrentMap<Class<?>, TypeLifecycleActions> cache = new ConcurrentHashMap();
        private Set<LifecycleFeature> features;
        private final AtomicBoolean isShutdown = new AtomicBoolean();
        private LifecycleManager manager;
        private List<LifecycleListener> pendingLifecycleListeners = new ArrayList<LifecycleListener>();
        private boolean shutdownOnFailure = true;

        LifecycleProvisionListener() {
        }

        @javax.inject.Inject
        public static void initialize(OptionalArgs args, LifecycleManager manager, LifecycleProvisionListener provisionListener, Set<LifecycleFeature> features) {
            provisionListener.manager = manager;
            provisionListener.features = features;
            provisionListener.shutdownOnFailure = args.hasShutdownOnFailure();
            LOG.debug("LifecycleProvisionListener initialized {}", features);
            for (LifecycleListener l : provisionListener.pendingLifecycleListeners) {
                manager.addListener(l);
            }
            provisionListener.pendingLifecycleListeners.clear();
        }

        public TypeLifecycleActions getOrCreateActions(Class<?> type) {
            TypeLifecycleActions actions = (TypeLifecycleActions)this.cache.get(type);
            if (actions == null) {
                actions = new TypeLifecycleActions();
                for (LifecycleFeature feature : this.features) {
                    actions.postConstructActions.addAll(feature.getActionsForType(type));
                }
                actions.postConstructActions.addAll(PostConstructLifecycleActions.INSTANCE.getActionsForType((Class)type));
                actions.preDestroyActions.addAll(PreDestroyLifecycleActions.INSTANCE.getActionsForType((Class)type));
                TypeLifecycleActions existing = this.cache.putIfAbsent(type, actions);
                if (existing != null) {
                    return existing;
                }
            }
            return actions;
        }

        @Override
        public synchronized void onStopped(Throwable optionalFailureReason) {
            if ((this.shutdownOnFailure || optionalFailureReason == null) && this.isShutdown.compareAndSet(false, true)) {
                for (Runnable action : this.shutdownActions) {
                    action.run();
                }
            }
        }

        public String toString() {
            return "LifecycleProvisionListener[]";
        }

        public <T> void onProvision(ProvisionListener.ProvisionInvocation<T> provision) {
            final Object injectee = provision.provision();
            if (this.features == null) {
                if (!injectee.getClass().isAnnotationPresent(SuppressLifecycleUninitialized.class)) {
                    LOG.debug("LifecycleProvisionListener not initialized yet : {}", injectee.getClass());
                }
                if (injectee instanceof LifecycleListener) {
                    this.pendingLifecycleListeners.add((LifecycleListener)injectee);
                }
                return;
            }
            final TypeLifecycleActions actions = this.getOrCreateActions(injectee.getClass());
            for (LifecycleAction action : actions.postConstructActions) {
                try {
                    action.call(injectee);
                }
                catch (Exception e) {
                    throw new ProvisionException("Failed to provision object of type " + injectee.getClass(), (Throwable)e);
                }
            }
            if (injectee instanceof LifecycleListener) {
                this.manager.addListener((LifecycleListener)injectee);
            }
            if (!actions.preDestroyActions.isEmpty()) {
                if (!this.isShutdown.get()) {
                    this.shutdownActions.addFirst(new Runnable(){

                        @Override
                        public void run() {
                            for (LifecycleAction m : actions.preDestroyActions) {
                                try {
                                    m.call(injectee);
                                }
                                catch (Exception e) {
                                    LOG.error("Failed to call @PreDestroy method {} on {}", (Object)new Object[]{m, injectee.getClass().getName()}, (Object)e);
                                }
                            }
                        }
                    });
                } else {
                    LOG.warn("Already shutting down.  Shutdown methods {} on {} will not be invoked", new Object[]{actions.preDestroyActions, injectee.getClass().getName()});
                }
            }
        }

        @SuppressLifecycleUninitialized
        @Singleton
        static class OptionalArgs {
            @Inject(optional=true)
            GovernatorFeatureSet governatorFeatures;

            OptionalArgs() {
            }

            boolean hasShutdownOnFailure() {
                return this.governatorFeatures == null ? true : this.governatorFeatures.get(GovernatorFeatures.SHUTDOWN_ON_ERROR);
            }
        }
    }

    static class TypeLifecycleActions {
        final List<LifecycleAction> postConstructActions = new ArrayList<LifecycleAction>();
        final List<LifecycleAction> preDestroyActions = new ArrayList<LifecycleAction>();

        TypeLifecycleActions() {
        }
    }
}

