/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.internal;

import com.google.inject.Binding;
import com.google.inject.ImplementedBy;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.ProvidedBy;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.BindingTargetVisitor;
import com.google.inject.spi.ConstructorBinding;
import com.google.inject.spi.DefaultBindingTargetVisitor;
import com.google.inject.spi.DefaultElementVisitor;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.Element;
import com.google.inject.spi.ElementSource;
import com.google.inject.spi.ElementVisitor;
import com.google.inject.spi.InjectionPoint;
import com.google.inject.spi.InjectionRequest;
import com.google.inject.spi.LinkedKeyBinding;
import com.google.inject.spi.ProviderBinding;
import com.google.inject.spi.ProviderKeyBinding;
import com.google.inject.spi.ProviderLookup;
import com.google.inject.spi.StaticInjectionRequest;
import com.google.inject.spi.UntargettedBinding;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

final class ElementsEx {
    ElementsEx() {
    }

    public static List<String> getAllSourceModules(List<Element> elements) {
        ArrayList<String> names = new ArrayList<String>();
        for (Element element : elements) {
            if (!element.getSource().getClass().isAssignableFrom(ElementSource.class)) continue;
            ElementSource source = (ElementSource)element.getSource();
            names.addAll(source.getModuleClassNames());
        }
        return names;
    }

    public static Set<Key<?>> getAllUnboundKeys(List<Element> elements) {
        final HashSet boundKeys = new HashSet();
        for (Element element : elements) {
            element.acceptVisitor((ElementVisitor)new DefaultElementVisitor<Void>(){

                public <T> Void visit(Binding<T> binding) {
                    boundKeys.add(binding.getKey());
                    return null;
                }
            });
        }
        final HashSet foundKeys = new HashSet();
        for (Element element : elements) {
            element.acceptVisitor((ElementVisitor)new DefaultElementVisitor<Void>(){

                public <T> Void visit(Binding<T> binding) {
                    binding.acceptTargetVisitor((BindingTargetVisitor)new DefaultBindingTargetVisitor<T, Void>(){

                        public Void visit(ProviderKeyBinding<? extends T> binding) {
                            this.addFoundKeys(ElementsEx.getUnboundDirectDependencies(binding.getProviderKey().getTypeLiteral(), boundKeys));
                            return null;
                        }

                        public Void visit(LinkedKeyBinding<? extends T> binding) {
                            if (!boundKeys.contains(binding.getLinkedKey())) {
                                this.addFoundKeys(ElementsEx.getUnboundDirectDependencies(binding.getLinkedKey().getTypeLiteral(), boundKeys));
                            }
                            return null;
                        }

                        public Void visit(UntargettedBinding<? extends T> binding) {
                            this.addFoundKeys(ElementsEx.getUnboundDirectDependencies(binding.getKey().getTypeLiteral(), boundKeys));
                            return null;
                        }

                        public Void visit(ConstructorBinding<? extends T> binding) {
                            this.addFoundKeys(ElementsEx.getUnboundDirectDependencies(binding.getInjectableMembers(), boundKeys));
                            this.addFoundKeys(ElementsEx.getUnboundDirectDependencies(binding.getDependencies(), boundKeys));
                            return null;
                        }

                        public Void visit(ProviderBinding<? extends T> binding) {
                            this.addFoundKeys(ElementsEx.getUnboundDirectDependencies(binding.getProvidedKey().getTypeLiteral(), boundKeys));
                            return null;
                        }

                        private void addFoundKeys(Set<Key<?>> keys) {
                            foundKeys.addAll(keys);
                        }
                    });
                    return null;
                }

                public Void visit(InjectionRequest<?> request) {
                    for (InjectionPoint ip : request.getInjectionPoints()) {
                        for (Dependency dep : ip.getDependencies()) {
                            foundKeys.addAll(ElementsEx.getUnboundDirectDependencies(dep.getKey().getTypeLiteral(), boundKeys));
                        }
                    }
                    return null;
                }

                public Void visit(StaticInjectionRequest request) {
                    for (InjectionPoint ip : request.getInjectionPoints()) {
                        for (Dependency dep : ip.getDependencies()) {
                            foundKeys.addAll(ElementsEx.getUnboundDirectDependencies(dep.getKey().getTypeLiteral(), boundKeys));
                        }
                    }
                    return null;
                }

                public <T> Void visit(ProviderLookup<T> lookup) {
                    foundKeys.add(lookup.getDependency().getKey());
                    return null;
                }
            });
        }
        for (Key key : foundKeys) {
            ElementsEx.discoverDependencies(key, boundKeys);
        }
        foundKeys.removeAll(boundKeys);
        foundKeys.remove(Key.get(Injector.class));
        return foundKeys;
    }

    static void discoverDependencies(Key<?> key, Set<Key<?>> boundKeys) {
        if (boundKeys.contains(key)) {
            return;
        }
        Class rawType = key.getTypeLiteral().getRawType();
        if (rawType.isInterface() || Modifier.isAbstract(rawType.getModifiers())) {
            ImplementedBy implementedBy = rawType.getAnnotation(ImplementedBy.class);
            if (implementedBy != null) {
                boundKeys.add(key);
                ElementsEx.discoverDependencies(key, boundKeys);
                return;
            }
            ProvidedBy providedBy = rawType.getAnnotation(ProvidedBy.class);
            if (providedBy != null) {
                boundKeys.add(key);
                ElementsEx.discoverDependencies(key, boundKeys);
                return;
            }
        } else {
            boundKeys.add(key);
            for (Key<?> dep : ElementsEx.getUnboundDirectDependencies(key.getTypeLiteral(), boundKeys)) {
                ElementsEx.discoverDependencies(dep, boundKeys);
            }
        }
    }

    static Set<Key<?>> getUnboundDirectDependencies(TypeLiteral<?> type, Set<Key<?>> boundKeys) {
        if (type.getRawType().isInterface()) {
            return Collections.emptySet();
        }
        HashSet keys = new HashSet();
        keys.addAll(ElementsEx.getUnboundDirectDependencies(InjectionPoint.forConstructorOf(type), boundKeys));
        keys.addAll(ElementsEx.getUnboundDirectDependencies(InjectionPoint.forInstanceMethodsAndFields(type), boundKeys));
        return keys;
    }

    static Set<Key<?>> getUnboundDirectDependencies(Set<Dependency<?>> dependencies, Set<Key<?>> boundKeys) {
        HashSet unboundKeys = new HashSet();
        for (Dependency<?> dep : dependencies) {
            for (Dependency dep2 : dep.getInjectionPoint().getDependencies()) {
                if (boundKeys.contains(dep2.getKey())) continue;
                unboundKeys.add(dep2.getKey());
            }
        }
        return unboundKeys;
    }

    static Set<Key<?>> getUnboundDirectDependencies(InjectionPoint ip, Set<Key<?>> boundKeys) {
        HashSet unboundKeys = new HashSet();
        for (Dependency dep : ip.getDependencies()) {
            if (boundKeys.contains(dep.getKey())) continue;
            unboundKeys.add(dep.getKey());
        }
        return unboundKeys;
    }

    static Set<Key<?>> getUnboundDirectDependencies(Collection<InjectionPoint> ips, Set<Key<?>> boundKeys) {
        HashSet unboundKeys = new HashSet();
        for (InjectionPoint ip : ips) {
            for (Dependency dep : ip.getDependencies()) {
                if (boundKeys.contains(dep.getKey())) continue;
                unboundKeys.add(dep.getKey());
            }
        }
        return unboundKeys;
    }
}

