/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.EventListener;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.logging.Logger;
import oracle.jdbc.NotificationRegistration;
import oracle.jdbc.aq.AQNotificationEvent;
import oracle.jdbc.aq.AQNotificationListener;
import oracle.jdbc.dcn.DatabaseChangeListener;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.NTFAQEvent;
import oracle.jdbc.driver.NTFDCNEvent;
import oracle.jdbc.driver.NTFEventListener;
import oracle.jdbc.driver.NTFJMSEvent;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.JMSNotificationListener;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.CHANGE_NOTIFICATION})
abstract class NTFRegistration {
    private final boolean jdbcGetsNotification;
    private final String clientHost;
    private final int clientTCPPort;
    private final Properties options;
    private final boolean isPurgeOnNTF;
    private final String username;
    private final int namespace;
    private final int jdbcRegId;
    private final String dbName;
    private final short databaseVersion;
    private NotificationRegistration.RegistrationState state;
    private NTFEventListener[] listeners = new NTFEventListener[0];
    private NTFEventListener notificationExceptionListener;
    private final Exception[] connectionCreationExceptionArr;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;

    NTFRegistration(int n2, int n3, boolean bl, String string, String string2, int n4, Properties properties, String string3, short s2, Exception[] exceptionArray) {
        this.namespace = n3;
        this.clientHost = string2;
        this.clientTCPPort = n4;
        this.options = properties;
        this.jdbcRegId = n2;
        this.username = string3;
        this.jdbcGetsNotification = bl;
        this.dbName = string;
        this.state = NotificationRegistration.RegistrationState.ACTIVE;
        this.isPurgeOnNTF = this.options != null && this.options.getProperty("NTF_QOS_PURGE_ON_NTFN", "false").compareToIgnoreCase("true") == 0;
        this.databaseVersion = s2;
        this.connectionCreationExceptionArr = exceptionArray;
    }

    short getDatabaseVersion() {
        return this.databaseVersion;
    }

    synchronized void setNotificationExceptionListener(NTFEventListener nTFEventListener) throws SQLException {
        if (this.state == NotificationRegistration.RegistrationState.CLOSED) {
            throw (SQLException)DatabaseError.createSqlException(251).fillInStackTrace();
        }
        this.notificationExceptionListener = nTFEventListener;
    }

    NTFEventListener getNotificationExceptionListener() {
        return this.notificationExceptionListener;
    }

    synchronized void addListener(NTFEventListener nTFEventListener) throws SQLException {
        if (this.state == NotificationRegistration.RegistrationState.CLOSED) {
            throw (SQLException)DatabaseError.createSqlException(251).fillInStackTrace();
        }
        if (!this.jdbcGetsNotification) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 247).fillInStackTrace();
        }
        int n2 = this.listeners.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.listeners[i2].getListener() != nTFEventListener.getListener()) continue;
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 248).fillInStackTrace();
        }
        NTFEventListener[] nTFEventListenerArray = new NTFEventListener[n2 + 1];
        System.arraycopy(this.listeners, 0, nTFEventListenerArray, 0, n2);
        nTFEventListenerArray[n2] = nTFEventListener;
        this.listeners = nTFEventListenerArray;
    }

    synchronized void removeListener(EventListener eventListener) throws SQLException {
        int n2 = 0;
        int n3 = this.listeners.length;
        for (n2 = 0; n2 < n3 && this.listeners[n2].getListener() != eventListener; ++n2) {
        }
        if (n2 == n3) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 249).fillInStackTrace();
        }
        NTFEventListener[] nTFEventListenerArray = new NTFEventListener[n3 - 1];
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            if (this.listeners[n2].getListener() == eventListener) continue;
            nTFEventListenerArray[n4++] = this.listeners[n2];
        }
        this.listeners = nTFEventListenerArray;
    }

    void notify(final NTFDCNEvent nTFDCNEvent) {
        long l2 = 0L;
        NTFEventListener[] nTFEventListenerArray = this.listeners;
        int n2 = nTFEventListenerArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Executor executor = nTFEventListenerArray[i2].getExecutor();
            if (executor != null) {
                final DatabaseChangeListener databaseChangeListener = nTFEventListenerArray[i2].getDCNListener();
                executor.execute(new Runnable(){
                    private static Executable $$$methodRef$$$0;
                    private static Logger $$$loggerRef$$$0;
                    private static Executable $$$methodRef$$$1;
                    private static Logger $$$loggerRef$$$1;

                    @Override
                    public void run() {
                        databaseChangeListener.onDatabaseChangeNotification(nTFDCNEvent);
                    }

                    static {
                        try {
                            $$$methodRef$$$1 = 1.class.getDeclaredConstructor(NTFRegistration.class, DatabaseChangeListener.class, NTFDCNEvent.class);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                        try {
                            $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    }
                });
                continue;
            }
            nTFEventListenerArray[i2].getDCNListener().onDatabaseChangeNotification(nTFDCNEvent);
        }
        if (nTFDCNEvent.isDeregistrationEvent() || this.isPurgeOnNTF) {
            PhysicalConnection.ntfManager.removeRegistration(this);
            PhysicalConnection.ntfManager.freeJdbcRegId(this.getJdbcRegId());
            PhysicalConnection.ntfManager.cleanListenersT4C(this.getClientTCPPort());
            this.state = NotificationRegistration.RegistrationState.CLOSED;
        }
    }

    void notify(final NTFAQEvent nTFAQEvent) {
        long l2 = 0L;
        NTFEventListener[] nTFEventListenerArray = this.listeners;
        int n2 = nTFEventListenerArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Executor executor = nTFEventListenerArray[i2].getExecutor();
            if (executor != null) {
                final AQNotificationListener aQNotificationListener = nTFEventListenerArray[i2].getAQListener();
                executor.execute(new Runnable(){
                    private static Executable $$$methodRef$$$0;
                    private static Logger $$$loggerRef$$$0;
                    private static Executable $$$methodRef$$$1;
                    private static Logger $$$loggerRef$$$1;

                    @Override
                    public void run() {
                        aQNotificationListener.onAQNotification(nTFAQEvent);
                    }

                    static {
                        try {
                            $$$methodRef$$$1 = 2.class.getDeclaredConstructor(NTFRegistration.class, AQNotificationListener.class, NTFAQEvent.class);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                        try {
                            $$$methodRef$$$0 = 2.class.getDeclaredMethod("run", new Class[0]);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    }
                });
                continue;
            }
            nTFEventListenerArray[i2].getAQListener().onAQNotification(nTFAQEvent);
        }
        if (nTFAQEvent.getEventType() == AQNotificationEvent.EventType.DEREG || this.isPurgeOnNTF) {
            PhysicalConnection.ntfManager.removeRegistration(this);
            PhysicalConnection.ntfManager.freeJdbcRegId(this.getJdbcRegId());
            PhysicalConnection.ntfManager.cleanListenersT4C(this.getClientTCPPort());
            this.state = NotificationRegistration.RegistrationState.CLOSED;
        }
    }

    void notify(final NTFJMSEvent nTFJMSEvent) {
        long l2 = 0L;
        NTFEventListener[] nTFEventListenerArray = this.listeners;
        int n2 = nTFEventListenerArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Executor executor = nTFEventListenerArray[i2].getExecutor();
            if (executor != null) {
                final JMSNotificationListener jMSNotificationListener = nTFEventListenerArray[i2].getJMSListener();
                executor.execute(new Runnable(){
                    private static Executable $$$methodRef$$$0;
                    private static Logger $$$loggerRef$$$0;
                    private static Executable $$$methodRef$$$1;
                    private static Logger $$$loggerRef$$$1;

                    @Override
                    public void run() {
                        jMSNotificationListener.onJMSNotification(nTFJMSEvent);
                    }

                    static {
                        try {
                            $$$methodRef$$$1 = 3.class.getDeclaredConstructor(NTFRegistration.class, JMSNotificationListener.class, NTFJMSEvent.class);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                        try {
                            $$$methodRef$$$0 = 3.class.getDeclaredMethod("run", new Class[0]);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    }
                });
                continue;
            }
            nTFEventListenerArray[i2].getJMSListener().onJMSNotification(nTFJMSEvent);
        }
    }

    public Properties getRegistrationOptions() {
        return this.options;
    }

    int getJdbcRegId() {
        return this.jdbcRegId;
    }

    public String getUserName() {
        return this.username;
    }

    String getClientHost() {
        return this.clientHost;
    }

    int getClientTCPPort() {
        return this.clientTCPPort;
    }

    public String getDatabaseName() {
        return this.dbName;
    }

    public NotificationRegistration.RegistrationState getState() {
        return this.state;
    }

    protected void setState(NotificationRegistration.RegistrationState registrationState) {
        this.state = registrationState;
    }

    int getNamespace() {
        return this.namespace;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    public Exception getRegistrationException() {
        if (this.connectionCreationExceptionArr != null && this.connectionCreationExceptionArr.length > 0) {
            return this.connectionCreationExceptionArr[0];
        }
        return null;
    }

    static {
        try {
            $$$methodRef$$$19 = NTFRegistration.class.getDeclaredConstructor(Integer.TYPE, Integer.TYPE, Boolean.TYPE, String.class, String.class, Integer.TYPE, Properties.class, String.class, Short.TYPE, Exception[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = NTFRegistration.class.getDeclaredMethod("getRegistrationException", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = NTFRegistration.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = NTFRegistration.class.getDeclaredMethod("getNamespace", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = NTFRegistration.class.getDeclaredMethod("setState", NotificationRegistration.RegistrationState.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = NTFRegistration.class.getDeclaredMethod("getState", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = NTFRegistration.class.getDeclaredMethod("getDatabaseName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = NTFRegistration.class.getDeclaredMethod("getClientTCPPort", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = NTFRegistration.class.getDeclaredMethod("getClientHost", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = NTFRegistration.class.getDeclaredMethod("getUserName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = NTFRegistration.class.getDeclaredMethod("getJdbcRegId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = NTFRegistration.class.getDeclaredMethod("getRegistrationOptions", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = NTFRegistration.class.getDeclaredMethod("notify", NTFJMSEvent.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = NTFRegistration.class.getDeclaredMethod("notify", NTFAQEvent.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = NTFRegistration.class.getDeclaredMethod("notify", NTFDCNEvent.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = NTFRegistration.class.getDeclaredMethod("removeListener", EventListener.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = NTFRegistration.class.getDeclaredMethod("addListener", NTFEventListener.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = NTFRegistration.class.getDeclaredMethod("getNotificationExceptionListener", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = NTFRegistration.class.getDeclaredMethod("setNotificationExceptionListener", NTFEventListener.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = NTFRegistration.class.getDeclaredMethod("getDatabaseVersion", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

