/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Timestamp;
import java.util.Map;
import java.util.logging.Logger;
import oracle.jdbc.OracleArray;
import oracle.jdbc.OracleBfile;
import oracle.jdbc.OracleBlob;
import oracle.jdbc.OracleClob;
import oracle.jdbc.OracleNClob;
import oracle.jdbc.OracleOpaque;
import oracle.jdbc.OracleRef;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.OracleResultSetMetaData;
import oracle.jdbc.OracleStruct;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.ROWID;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.TypeDescriptor;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.METADATA})
class OracleResultSetMetaData
implements oracle.jdbc.internal.OracleResultSetMetaData {
    PhysicalConnection connection;
    OracleStatement statement;
    int offsetOfFirstUserColumn;
    Object acProxy;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;

    public OracleResultSetMetaData() {
    }

    OracleResultSetMetaData(PhysicalConnection physicalConnection, OracleStatement oracleStatement, int n2) throws SQLException {
        this.connection = physicalConnection;
        this.statement = oracleStatement;
        oracleStatement.describe();
        oracleStatement.computeOffsetOfFirstUserColumn();
        oracleStatement.computeNumberOfUserColumns();
        this.offsetOfFirstUserColumn = n2;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.statement.getNumberOfUserColumns();
    }

    @Override
    public boolean isAutoIncrement(int n2) throws SQLException {
        return false;
    }

    int getValidColumnIndex(int n2) throws SQLException {
        if (n2 <= 0 || n2 > this.statement.getNumberOfUserColumns()) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getValidColumnIndex").fillInStackTrace();
        }
        int n3 = n2 + this.offsetOfFirstUserColumn;
        return n3;
    }

    @Override
    public boolean isCaseSensitive(int n2) throws SQLException {
        int n3 = this.getColumnType(n2);
        return n3 == 1 || n3 == 12 || n3 == -1 || n3 == -15 || n3 == -9 || n3 == 2005 || n3 == 2011 || n3 == 2009;
    }

    @Override
    public boolean isSearchable(int n2) throws SQLException {
        int n3 = this.getColumnType(n2);
        return n3 != -4 && n3 != -1 && n3 != 2004 && n3 != 2005 && n3 != -13 && n3 != 2011 && n3 != 2002 && n3 != 2008 && n3 != 2007 && n3 != 2003 && n3 != 2006 && n3 != -10 && n3 != 2012;
    }

    @Override
    public boolean isCurrency(int n2) throws SQLException {
        int n3 = this.getColumnType(n2);
        return n3 == 2 || n3 == 6;
    }

    @Override
    public int isNullable(int n2) throws SQLException {
        int n3 = this.getValidColumnIndex(n2);
        return this.getDescription()[n3].nullable ? 1 : 0;
    }

    @Override
    public boolean isSigned(int n2) throws SQLException {
        return true;
    }

    @Override
    public int getColumnDisplaySize(int n2) throws SQLException {
        int n3 = this.getValidColumnIndex(n2);
        int n4 = this.getDescription()[n3].describeType;
        switch (n4) {
            case 2: {
                int n5 = this.getPrecision(n2);
                int n6 = this.getDescription()[n3].scale;
                if (n5 != 0 && n6 == -127) {
                    n5 = (int)((double)n5 / 3.32193);
                    n6 = 1;
                } else {
                    if (n5 == 0) {
                        n5 = 38;
                    }
                    if (n6 == -127) {
                        n6 = 0;
                    }
                }
                int n7 = n5 + (n6 != 0 ? 1 : 0) + 1;
                return n7;
            }
            case 1: 
            case 96: {
                Accessor accessor = this.getDescription()[n3];
                if (this.statement.connection.protocolId == 3) {
                    return accessor.describeMaxLengthChars;
                }
                if (accessor.describeMaxLengthChars <= 0) break;
                if (accessor.definedColumnSize > 0) {
                    return Math.min(accessor.describeMaxLengthChars, accessor.definedColumnSize);
                }
                return accessor.describeMaxLengthChars;
            }
        }
        return this.getDescription()[n3].describeMaxLength;
    }

    @Override
    public String getColumnLabel(int n2) throws SQLException {
        return this.getColumnName(n2);
    }

    @Override
    public String getColumnName(int n2) throws SQLException {
        int n3 = this.getValidColumnIndex(n2);
        return this.statement.getDescriptionWithNames()[n3].columnName;
    }

    @Override
    public String getSchemaName(int n2) throws SQLException {
        return "";
    }

    @Override
    public int getPrecision(int n2) throws SQLException {
        int n3 = this.getValidColumnIndex(n2);
        int n4 = this.getDescription()[n3].describeType;
        switch (n4) {
            case 112: 
            case 113: {
                return -1;
            }
            case 8: 
            case 24: {
                return Integer.MAX_VALUE;
            }
            case 1: 
            case 96: {
                Accessor accessor = this.getDescription()[n3];
                if (this.statement.connection.protocolId == 3) {
                    return accessor.describeMaxLengthChars;
                }
                if (accessor.describeMaxLengthChars > 0) {
                    if (accessor.definedColumnSize > 0) {
                        return Math.min(accessor.describeMaxLengthChars, accessor.definedColumnSize);
                    }
                    return accessor.describeMaxLengthChars;
                }
                return accessor.describeMaxLength;
            }
        }
        return this.getDescription()[n3].precision;
    }

    @Override
    public OracleResultSetMetaData.SecurityAttribute getSecurityAttribute(int n2) throws SQLException {
        int n3 = this.getValidColumnIndex(n2);
        return this.getDescription()[n3].securityAttribute;
    }

    @Override
    public int getScale(int n2) throws SQLException {
        int n3 = this.getValidColumnIndex(n2);
        int n4 = this.getDescription()[n3].scale;
        return n4 == -127 && this.statement.connection.j2ee13Compliant ? 0 : n4;
    }

    @Override
    public boolean isVariableScale(int n2) throws SQLException {
        int n3 = this.getValidColumnIndex(n2);
        int n4 = this.getDescription()[n3].scale;
        return n4 == -127;
    }

    @Override
    public String getTableName(int n2) throws SQLException {
        return "";
    }

    @Override
    public String getCatalogName(int n2) throws SQLException {
        return "";
    }

    @Override
    public int getColumnType(int n2) throws SQLException {
        int n3 = this.getValidColumnIndex(n2);
        int n4 = this.getDescription()[n3].describeType;
        switch (n4) {
            case 96: {
                if (this.getDescription()[n3].formOfUse == 2) {
                    return -15;
                }
                return 1;
            }
            case 1: {
                if (this.getDescription()[n3].formOfUse == 2) {
                    return -9;
                }
                return 12;
            }
            case 8: {
                return -1;
            }
            case 2: 
            case 6: {
                if (this.statement.connection.j2ee13Compliant && this.getDescription()[n3].precision != 0 && this.getDescription()[n3].scale == -127) {
                    return 6;
                }
                return 2;
            }
            case 100: {
                return 100;
            }
            case 101: {
                return 101;
            }
            case 23: {
                return -3;
            }
            case 24: {
                return -4;
            }
            case 104: 
            case 208: {
                return -8;
            }
            case 102: {
                return -10;
            }
            case 12: {
                return this.connection.mapDateToTimestamp ? 93 : 91;
            }
            case 180: {
                return 93;
            }
            case 181: {
                return -101;
            }
            case 231: {
                return -102;
            }
            case 113: {
                return 2004;
            }
            case 112: {
                if (this.getDescription()[n3].formOfUse == 2) {
                    return 2011;
                }
                return 2005;
            }
            case 114: {
                return -13;
            }
            case 109: {
                TypeDescriptor typeDescriptor = TypeDescriptor.getTypeDescriptor(this.getDescription()[n3].describeTypeName, this.connection);
                if (typeDescriptor != null) {
                    return typeDescriptor.getTypeCode();
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 60).fillInStackTrace();
            }
            case 111: {
                return 2006;
            }
            case 182: {
                return -103;
            }
            case 183: {
                return -104;
            }
        }
        return 1111;
    }

    @Override
    public String getColumnTypeName(int n2) throws SQLException {
        int n3 = this.getValidColumnIndex(n2);
        int n4 = this.getDescription()[n3].describeType;
        switch (n4) {
            case 96: {
                if (this.getDescription()[n3].formOfUse == 2) {
                    return "NCHAR";
                }
                return "CHAR";
            }
            case 1: {
                if (this.getDescription()[n3].formOfUse == 2) {
                    return "NVARCHAR2";
                }
                return "VARCHAR2";
            }
            case 8: {
                return "LONG";
            }
            case 2: 
            case 6: {
                if (this.statement.connection.j2ee13Compliant && this.getDescription()[n3].precision != 0 && this.getDescription()[n3].scale == -127) {
                    return "FLOAT";
                }
                return "NUMBER";
            }
            case 100: {
                return "BINARY_FLOAT";
            }
            case 101: {
                return "BINARY_DOUBLE";
            }
            case 23: {
                return "RAW";
            }
            case 24: {
                return "LONG RAW";
            }
            case 104: 
            case 208: {
                return "ROWID";
            }
            case 102: {
                return "REFCURSOR";
            }
            case 12: {
                return "DATE";
            }
            case 180: {
                return "TIMESTAMP";
            }
            case 181: {
                return "TIMESTAMP WITH TIME ZONE";
            }
            case 231: {
                return "TIMESTAMP WITH LOCAL TIME ZONE";
            }
            case 113: {
                return "BLOB";
            }
            case 112: {
                if (this.getDescription()[n3].formOfUse == 2) {
                    return "NCLOB";
                }
                return "CLOB";
            }
            case 114: {
                return "BFILE";
            }
            case 109: {
                OracleTypeADT oracleTypeADT = (OracleTypeADT)this.getDescription()[n3].describeOtype;
                return oracleTypeADT.getFullName();
            }
            case 111: {
                OracleTypeADT oracleTypeADT = (OracleTypeADT)this.getDescription()[n3].describeOtype;
                return oracleTypeADT.getFullName();
            }
            case 182: {
                return "INTERVALYM";
            }
            case 183: {
                return "INTERVALDS";
            }
        }
        return null;
    }

    @Override
    public boolean isReadOnly(int n2) throws SQLException {
        return false;
    }

    @Override
    public boolean isWritable(int n2) throws SQLException {
        return true;
    }

    @Override
    public boolean isDefinitelyWritable(int n2) throws SQLException {
        return false;
    }

    @Override
    public String getColumnClassName(int n2) throws SQLException {
        int n3 = this.getValidColumnIndex(n2);
        int n4 = this.getDescription()[n3].describeType;
        switch (n4) {
            case 1: 
            case 8: 
            case 96: 
            case 999: {
                return String.class.getName();
            }
            case 2: 
            case 6: {
                if (this.getDescription()[n3].precision != 0 && this.getDescription()[n3].scale == -127) {
                    return Double.class.getName();
                }
                return BigDecimal.class.getName();
            }
            case 23: 
            case 24: {
                return byte[].class.getName();
            }
            case 12: {
                return Timestamp.class.getName();
            }
            case 180: {
                if (this.statement.connection.j2ee13Compliant) {
                    return Timestamp.class.getName();
                }
                return TIMESTAMP.class.getName();
            }
            case 181: {
                return TIMESTAMPTZ.class.getName();
            }
            case 231: {
                return TIMESTAMPLTZ.class.getName();
            }
            case 182: {
                return INTERVALYM.class.getName();
            }
            case 183: {
                return INTERVALDS.class.getName();
            }
            case 104: 
            case 208: {
                return ROWID.class.getName();
            }
            case 113: {
                return OracleBlob.class.getName();
            }
            case 112: {
                if (this.getDescription()[n3].formOfUse == 2) {
                    return OracleNClob.class.getName();
                }
                return OracleClob.class.getName();
            }
            case 114: {
                return OracleBfile.class.getName();
            }
            case 102: {
                return OracleResultSet.class.getName();
            }
            case 109: {
                switch (this.getColumnType(n2)) {
                    case 2003: {
                        return OracleArray.class.getName();
                    }
                    case 2007: {
                        return OracleOpaque.class.getName();
                    }
                    case 2008: {
                        Class clazz;
                        OracleNamedType oracleNamedType = (OracleNamedType)this.getDescription()[n3].describeOtype;
                        Map map = this.connection.getJavaObjectTypeMap();
                        if (map != null && (clazz = (Class)map.get(oracleNamedType.getFullName())) != null) {
                            return clazz.getName();
                        }
                        return StructDescriptor.getJavaObjectClassName(this.connection, oracleNamedType.getSchemaName(), oracleNamedType.getSimpleName());
                    }
                    case 2002: {
                        Class clazz;
                        Map map = this.connection.getTypeMap();
                        if (map != null && (clazz = (Class)map.get(((OracleNamedType)this.getDescription()[n3].describeOtype).getFullName())) != null) {
                            return clazz.getName();
                        }
                        return OracleStruct.class.getName();
                    }
                    case 2009: {
                        return SQLXML.class.getName();
                    }
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1).fillInStackTrace();
            }
            case 111: {
                return OracleRef.class.getName();
            }
            case 101: {
                return Double.class.getName();
            }
            case 100: {
                return Float.class.getName();
            }
        }
        return null;
    }

    @Override
    public boolean isNCHAR(int n2) throws SQLException {
        int n3 = this.getValidColumnIndex(n2);
        return this.getDescription()[n3].formOfUse == 2;
    }

    @Override
    public boolean isColumnInvisible(int n2) throws SQLException {
        int n3 = this.getValidColumnIndex(n2);
        return this.getDescription()[n3].isColumnInvisible();
    }

    @Override
    public boolean isColumnJSON(int n2) throws SQLException {
        int n3 = this.getValidColumnIndex(n2);
        return this.getDescription()[n3].isColumnJSON();
    }

    Accessor[] getDescription() throws SQLException {
        return this.statement.getDescription();
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        if (clazz.isInterface()) {
            return clazz.isInstance(this);
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177).fillInStackTrace();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (clazz.isInterface() && clazz.isInstance(this)) {
            return (T)this;
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177).fillInStackTrace();
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.connection;
    }

    @Override
    public void setACProxy(Object object) {
        this.acProxy = object;
    }

    @Override
    public Object getACProxy() {
        return this.acProxy;
    }

    static {
        try {
            $$$methodRef$$$34 = OracleResultSetMetaData.class.getDeclaredConstructor(PhysicalConnection.class, OracleStatement.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$33 = OracleResultSetMetaData.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = OracleResultSetMetaData.class.getDeclaredMethod("getACProxy", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = OracleResultSetMetaData.class.getDeclaredMethod("setACProxy", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = OracleResultSetMetaData.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = OracleResultSetMetaData.class.getDeclaredMethod("unwrap", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = OracleResultSetMetaData.class.getDeclaredMethod("isWrapperFor", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = OracleResultSetMetaData.class.getDeclaredMethod("getDescription", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = OracleResultSetMetaData.class.getDeclaredMethod("isColumnJSON", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = OracleResultSetMetaData.class.getDeclaredMethod("isColumnInvisible", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = OracleResultSetMetaData.class.getDeclaredMethod("isNCHAR", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = OracleResultSetMetaData.class.getDeclaredMethod("getColumnClassName", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = OracleResultSetMetaData.class.getDeclaredMethod("isDefinitelyWritable", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = OracleResultSetMetaData.class.getDeclaredMethod("isWritable", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = OracleResultSetMetaData.class.getDeclaredMethod("isReadOnly", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = OracleResultSetMetaData.class.getDeclaredMethod("getColumnTypeName", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = OracleResultSetMetaData.class.getDeclaredMethod("getColumnType", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = OracleResultSetMetaData.class.getDeclaredMethod("getCatalogName", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OracleResultSetMetaData.class.getDeclaredMethod("getTableName", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OracleResultSetMetaData.class.getDeclaredMethod("isVariableScale", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OracleResultSetMetaData.class.getDeclaredMethod("getScale", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OracleResultSetMetaData.class.getDeclaredMethod("getSecurityAttribute", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OracleResultSetMetaData.class.getDeclaredMethod("getPrecision", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleResultSetMetaData.class.getDeclaredMethod("getSchemaName", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleResultSetMetaData.class.getDeclaredMethod("getColumnName", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleResultSetMetaData.class.getDeclaredMethod("getColumnLabel", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleResultSetMetaData.class.getDeclaredMethod("getColumnDisplaySize", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleResultSetMetaData.class.getDeclaredMethod("isSigned", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleResultSetMetaData.class.getDeclaredMethod("isNullable", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleResultSetMetaData.class.getDeclaredMethod("isCurrency", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleResultSetMetaData.class.getDeclaredMethod("isSearchable", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleResultSetMetaData.class.getDeclaredMethod("isCaseSensitive", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleResultSetMetaData.class.getDeclaredMethod("getValidColumnIndex", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleResultSetMetaData.class.getDeclaredMethod("isAutoIncrement", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleResultSetMetaData.class.getDeclaredMethod("getColumnCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

