/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.nio.ByteOrder;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTypeRep;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.net.ns.BreakNetException;
import oracle.net.ns.Communication;
import oracle.net.ns.NIONSDataChannel;
import oracle.net.ns.NetException;
import oracle.net.ns.SessionAtts;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CMAREngineNIO
extends T4CMAREngine {
    private NIONSDataChannel dataChannel;
    SessionAtts sAtts;
    private boolean bytesReadyToGo = false;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;

    T4CMAREngineNIO(Communication communication) throws SQLException, IOException {
        if (communication == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 433).fillInStackTrace();
        }
        this.net = communication;
        this.sAtts = communication.getSessionAttributes();
        this.dataChannel = this.sAtts.dataChannel;
        this.types = new T4CTypeRep(this, true);
        this.types.setRep((byte)1, (byte)2);
        this.sAtts.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        this.sAtts.payloadDataBufferForRead.order(ByteOrder.LITTLE_ENDIAN);
        this.sAtts.payloadDataBufferForWrite.order(ByteOrder.LITTLE_ENDIAN);
    }

    private static void valueToUNV(long l2, byte[] byArray) {
        byArray[0] = 0;
        if (l2 == 0L) {
            return;
        }
        int n2 = 0;
        boolean bl = true;
        boolean bl2 = l2 < 0L;
        long l3 = bl2 ? -l2 : l2;
        for (int i2 = 0; i2 < 8; ++i2) {
            byte by = (byte)(l3 >>> 8 * (7 - i2) & 0xFFL);
            if (bl && by == 0) continue;
            bl = false;
            byArray[++n2] = by;
        }
        byArray[0] = (byte)n2;
        if (bl2) {
            byArray[0] = (byte)(byArray[0] | 0xFFFFFF80);
        }
    }

    @Override
    final void marshalSB1(byte by) throws IOException {
        this.prepareForMarshall(1);
        this.sAtts.payloadDataBufferForWrite.put(by);
        this.bytesReadyToGo = true;
    }

    @Override
    final void marshalUB1(short s2) throws IOException {
        this.marshalSB1((byte)s2);
    }

    @Override
    final void marshalSB2(short s2) throws IOException {
        this.prepareForMarshall(3);
        if (this.types.rep[1] != 1) {
            this.sAtts.payloadDataBufferForWrite.putShort(s2);
        } else if (s2 == 0) {
            this.sAtts.payloadDataBufferForWrite.put((byte)0);
        } else {
            boolean bl = s2 < 0;
            short s3 = bl ? -s2 : s2;
            if (s3 <= 255) {
                if (bl) {
                    this.sAtts.payloadDataBufferForWrite.put((byte)-127);
                } else {
                    this.sAtts.payloadDataBufferForWrite.put((byte)1);
                }
                this.sAtts.payloadDataBufferForWrite.put((byte)s3);
            } else {
                if (bl) {
                    this.sAtts.payloadDataBufferForWrite.put((byte)-126);
                } else {
                    this.sAtts.payloadDataBufferForWrite.put((byte)2);
                }
                this.sAtts.payloadDataBufferForWrite.putShort(s3);
            }
        }
    }

    @Override
    final void marshalUB2(int n2) throws IOException {
        this.prepareForMarshall(3);
        if (this.types.rep[1] != 1) {
            this.sAtts.payloadDataBufferForWrite.putShort((short)n2);
        } else if (n2 == 0) {
            this.sAtts.payloadDataBufferForWrite.put((byte)0);
        } else if (n2 <= 255) {
            this.sAtts.payloadDataBufferForWrite.put((byte)1);
            this.sAtts.payloadDataBufferForWrite.put((byte)n2);
        } else {
            this.sAtts.payloadDataBufferForWrite.put((byte)2);
            this.sAtts.payloadDataBufferForWrite.putShort((short)n2);
        }
        this.bytesReadyToGo = true;
    }

    @Override
    void marshalNativeUB2(short s2, boolean bl) throws IOException {
        try {
            byte by = this.types.getRep((byte)1);
            byte by2 = (byte)(0 | (bl ? 2 : 0));
            this.types.setRep((byte)1, by2);
            this.marshalUB2(s2);
            this.types.setRep((byte)1, by);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    final void marshalSB4(int n2) throws IOException {
        this.prepareForMarshall(5);
        if (this.types.rep[2] != 1) {
            this.sAtts.payloadDataBufferForWrite.putInt(n2);
        } else if (n2 == 0) {
            this.sAtts.payloadDataBufferForWrite.put((byte)0);
        } else {
            int n3;
            boolean bl = n2 < 0;
            int n4 = n3 = bl ? -n2 : n2;
            if (n3 <= 255) {
                if (!bl) {
                    this.sAtts.payloadDataBufferForWrite.put((byte)1);
                } else {
                    this.sAtts.payloadDataBufferForWrite.put((byte)-127);
                }
                this.sAtts.payloadDataBufferForWrite.put((byte)n3);
            } else if (n3 <= 65535) {
                if (!bl) {
                    this.sAtts.payloadDataBufferForWrite.put((byte)2);
                } else {
                    this.sAtts.payloadDataBufferForWrite.put((byte)-126);
                }
                this.sAtts.payloadDataBufferForWrite.putShort((short)n3);
            } else if (n3 < 26) {
                T4CMAREngineNIO.valueToUNV(n2, this.tmpBuffer10);
                this.sAtts.payloadDataBufferForWrite.put(this.tmpBuffer10, 0, this.tmpBuffer10[0] + 1);
            } else {
                if (!bl) {
                    this.sAtts.payloadDataBufferForWrite.put((byte)4);
                } else {
                    this.sAtts.payloadDataBufferForWrite.put((byte)-124);
                }
                this.sAtts.payloadDataBufferForWrite.putInt(n3);
            }
        }
        this.bytesReadyToGo = true;
    }

    @Override
    final void marshalUB4(long l2) throws IOException {
        this.prepareForMarshall(5);
        if (this.types.rep[2] != 1) {
            this.sAtts.payloadDataBufferForWrite.putInt((int)l2);
        } else {
            long l3;
            boolean bl = l2 < 0L;
            long l4 = l3 = bl ? -l2 : l2;
            if (l3 == 0L) {
                this.sAtts.payloadDataBufferForWrite.put((byte)0);
            } else if (l3 <= 255L) {
                this.sAtts.payloadDataBufferForWrite.put((byte)1);
                this.sAtts.payloadDataBufferForWrite.put((byte)l3);
            } else if (l3 <= 65535L) {
                this.sAtts.payloadDataBufferForWrite.put((byte)2);
                this.sAtts.payloadDataBufferForWrite.putShort((short)l3);
            } else if (l3 <= 0xFFFFFFL) {
                T4CMAREngineNIO.valueToUNV(l3, this.tmpBuffer10);
                this.sAtts.payloadDataBufferForWrite.put(this.tmpBuffer10, 0, this.tmpBuffer10[0] + 1);
            } else {
                this.sAtts.payloadDataBufferForWrite.put((byte)4);
                this.sAtts.payloadDataBufferForWrite.putInt((int)l3);
            }
        }
        this.bytesReadyToGo = true;
    }

    @Override
    final void marshalSB8(long l2) throws IOException {
        this.prepareForMarshall(9);
        if (this.types.rep[3] != 1) {
            throw new IOException("TODO: SB8 in UNV representation only");
        }
        T4CMAREngineNIO.valueToUNV(l2, this.tmpBuffer10);
        this.sAtts.payloadDataBufferForWrite.put(this.tmpBuffer10, 0, this.tmpBuffer10[0] + 1);
    }

    final void marshalUB8(long l2) throws IOException {
        this.prepareForMarshall(9);
        if (l2 == 0L) {
            this.sAtts.payloadDataBufferForWrite.put((byte)0);
        }
        if (this.types.rep[3] != 1) {
            throw new IOException("TODO: UB8 in UNV representation only");
        }
        this.tmpBuffer10[0] = 0;
        int n2 = 0;
        for (int i2 = 0; i2 < 8; ++i2) {
            byte by = (byte)(l2 >>> 8 * (7 - i2) & 0xFFL);
            if (by == 0) continue;
            this.tmpBuffer10[++n2] = by;
        }
        this.tmpBuffer10[0] = (byte)n2;
        this.sAtts.payloadDataBufferForWrite.put(this.tmpBuffer10, 0, this.tmpBuffer10[0] + 1);
    }

    @Override
    final void marshalB1Array(byte[] byArray) throws IOException {
        this.marshalB1Array(byArray, 0, byArray.length);
    }

    @Override
    final void marshalB1Array(byte[] byArray, int n2, int n3) throws IOException {
        this.prepareForMarshall(1);
        int n4 = 0;
        for (int i2 = 0; i2 < n3; i2 += n4) {
            this.prepareForMarshall(n3 - i2);
            n4 = Math.min(this.sAtts.payloadDataBufferForWrite.remaining(), n3 - i2);
            this.sAtts.payloadDataBufferForWrite.put(byArray, n2 + i2, n4);
            this.bytesReadyToGo = true;
        }
    }

    @Override
    final byte unmarshalSB1() throws SQLException, IOException {
        byte by = (byte)this.unmarshalSB2();
        return by;
    }

    @Override
    final short unmarshalUB1() throws SQLException, IOException {
        this.prepareForUnmarshall();
        short s2 = (short)(this.sAtts.payloadDataBufferForRead.get() & 0xFF);
        return s2;
    }

    @Override
    final short unmarshalSB2() throws SQLException, IOException {
        this.prepareForUnmarshall();
        if (this.types.rep[1] != 1 && this.sAtts.payloadDataBufferForRead.remaining() >= 2) {
            return this.sAtts.payloadDataBufferForRead.getShort();
        }
        short s2 = (short)this.unmarshalUB2();
        return s2;
    }

    @Override
    final int unmarshalUB2() throws SQLException, IOException {
        int n2 = (int)this.buffer2Value((byte)1);
        return n2 & 0xFFFF;
    }

    @Override
    final int unmarshalSB4() throws SQLException, IOException {
        this.prepareForUnmarshall();
        if (this.types.rep[2] != 1 && this.sAtts.payloadDataBufferForRead.remaining() >= 4) {
            return this.sAtts.payloadDataBufferForRead.getInt();
        }
        return (int)this.buffer2Value((byte)2);
    }

    @Override
    final long unmarshalUB4() throws SQLException, IOException {
        return (long)this.unmarshalSB4() & 0xFFFFFFFFL;
    }

    @Override
    byte[] unmarshalNBytes(int n2) throws SQLException, IOException {
        byte[] byArray = new byte[n2];
        this.getNBytes(byArray, 0, n2);
        return byArray;
    }

    @Override
    int unmarshalNBytes(byte[] byArray, int n2, int n3) throws SQLException, IOException {
        return this.getNBytes(byArray, n2, n3);
    }

    @Override
    int getNBytes(byte[] byArray, int n2, int n3) throws SQLException, IOException {
        int n4;
        int n5;
        if (n2 + n3 > byArray.length) {
            n3 = byArray.length - n2;
        }
        boolean bl = false;
        for (n4 = 0; n4 < n3; n4 += this.sAtts.payloadDataBufferForRead.position() - n5) {
            if (!this.sAtts.payloadDataBufferForRead.hasRemaining()) {
                this.prepareForUnmarshall();
            }
            n5 = this.sAtts.payloadDataBufferForRead.position();
            this.sAtts.payloadDataBufferForRead.get(byArray, n2 + n4, Math.min(n3 - n4, this.sAtts.payloadDataBufferForRead.remaining()));
        }
        return n4;
    }

    @Override
    byte[] getNBytes(int n2) throws SQLException, IOException {
        return this.unmarshalNBytes(n2);
    }

    @Override
    byte[] unmarshalTEXT(int n2) throws SQLException, IOException {
        byte[] byArray;
        int n3 = 0;
        byte[] byArray2 = new byte[n2];
        while (n3 < n2) {
            this.prepareForUnmarshall();
            byArray2[n3] = this.sAtts.payloadDataBufferForRead.get();
            if (byArray2[n3++] != 0) continue;
        }
        if (byArray2.length == --n3) {
            byArray = byArray2;
        } else {
            byArray = new byte[n3];
            System.arraycopy(byArray2, 0, byArray, 0, n3);
        }
        return byArray;
    }

    @Override
    final long buffer2Value(byte by) throws SQLException, IOException {
        long l2 = 0L;
        byte by2 = this.types.rep[by];
        int n2 = 0;
        boolean bl = false;
        if (by2 == 1) {
            this.prepareForUnmarshall();
            n2 = this.sAtts.payloadDataBufferForRead.get();
            if (n2 == 0) {
                return 0L;
            }
            if ((n2 & 0x80) > 0) {
                n2 &= 0x7F;
                bl = true;
            }
        } else {
            switch (by) {
                case 1: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 4;
                    break;
                }
                case 3: {
                    n2 = 8;
                }
            }
        }
        if (this.sAtts.payloadDataBufferForRead.remaining() >= n2 && (n2 == 1 || n2 == 2 || n2 == 4 || n2 == 8)) {
            this.prepareForUnmarshall();
            l2 = n2 == 1 ? (long)this.sAtts.payloadDataBufferForRead.get() & 0xFFL : (n2 == 2 ? (long)this.sAtts.payloadDataBufferForRead.getShort() & 0xFFFFL : (n2 == 4 ? (long)this.sAtts.payloadDataBufferForRead.getInt() & 0xFFFFFFFFL : this.sAtts.payloadDataBufferForRead.getLong()));
        } else {
            this.unmarshalNBytes(this.tmpBuffer8, 0, n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                if (by2 == 1 || by2 != 2) {
                    l2 |= ((long)this.tmpBuffer8[i2] & 0xFFL) << 8 * (n2 - i2 - 1);
                    continue;
                }
                l2 |= ((long)this.tmpBuffer8[i2] & 0xFFL) << 8 * i2;
            }
        }
        if (bl) {
            l2 *= -1L;
        }
        return l2;
    }

    @Override
    void setByteOrder(byte by) {
        if (by == 2) {
            this.sAtts.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        } else {
            this.sAtts.setByteOrder(ByteOrder.BIG_ENDIAN);
        }
        if (this.sAtts.payloadDataBufferForRead != null) {
            this.sAtts.payloadDataBufferForRead.order(this.sAtts.getByteOrder());
        }
        if (this.sAtts.payloadDataBufferForWrite != null) {
            this.sAtts.payloadDataBufferForWrite.order(this.sAtts.getByteOrder());
        }
    }

    @Override
    protected void flush() throws IOException {
        if (this.bytesReadyToGo) {
            this.dataChannel.writeDataToSocketChannel();
        }
        this.bytesReadyToGo = false;
    }

    private void prepareForUnmarshall() throws IOException, SQLException {
        if (this.bytesReadyToGo) {
            this.flush();
        }
        if (this.sAtts.payloadDataBufferForRead.hasRemaining()) {
            return;
        }
        try {
            while (!this.sAtts.payloadDataBufferForRead.hasRemaining()) {
                this.dataChannel.readDataFromSocketChannel();
            }
        }
        catch (BreakNetException breakNetException) {
            this.net.sendReset();
            throw breakNetException;
        }
        catch (NetException netException) {
            if (netException.isNSControlCommandError()) {
                this.clearWriteBuffer();
            }
            switch (netException.getErrorNumber()) {
                case 0: 
                case 202: {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 410).fillInStackTrace();
                }
            }
            throw netException;
        }
    }

    private void prepareForMarshall(int n2) throws IOException {
        if (this.sAtts.payloadDataBufferForWrite.remaining() < n2) {
            if (this.bytesReadyToGo) {
                this.flush();
            }
            this.sAtts.prepareWriteBuffer();
        }
    }

    @Override
    void writeZeroCopyIO(byte[] byArray, int n2, int n3) throws IOException, NetException {
        this.flush();
        this.net.writeZeroCopyIO(byArray, n2, n3);
    }

    @Override
    void clearWriteBuffer() {
        this.sAtts.prepareWriteBuffer();
    }

    @Override
    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }

    static {
        try {
            $$$methodRef$$$30 = T4CMAREngineNIO.class.getDeclaredConstructor(Communication.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = T4CMAREngineNIO.class.getDeclaredMethod("clearWriteBuffer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = T4CMAREngineNIO.class.getDeclaredMethod("writeZeroCopyIO", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = T4CMAREngineNIO.class.getDeclaredMethod("prepareForMarshall", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = T4CMAREngineNIO.class.getDeclaredMethod("prepareForUnmarshall", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = T4CMAREngineNIO.class.getDeclaredMethod("flush", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = T4CMAREngineNIO.class.getDeclaredMethod("setByteOrder", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = T4CMAREngineNIO.class.getDeclaredMethod("buffer2Value", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = T4CMAREngineNIO.class.getDeclaredMethod("unmarshalTEXT", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = T4CMAREngineNIO.class.getDeclaredMethod("getNBytes", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = T4CMAREngineNIO.class.getDeclaredMethod("getNBytes", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = T4CMAREngineNIO.class.getDeclaredMethod("unmarshalNBytes", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = T4CMAREngineNIO.class.getDeclaredMethod("unmarshalNBytes", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = T4CMAREngineNIO.class.getDeclaredMethod("unmarshalUB4", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = T4CMAREngineNIO.class.getDeclaredMethod("unmarshalSB4", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = T4CMAREngineNIO.class.getDeclaredMethod("unmarshalUB2", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = T4CMAREngineNIO.class.getDeclaredMethod("unmarshalSB2", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = T4CMAREngineNIO.class.getDeclaredMethod("unmarshalUB1", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = T4CMAREngineNIO.class.getDeclaredMethod("unmarshalSB1", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = T4CMAREngineNIO.class.getDeclaredMethod("marshalB1Array", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = T4CMAREngineNIO.class.getDeclaredMethod("marshalB1Array", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = T4CMAREngineNIO.class.getDeclaredMethod("marshalUB8", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = T4CMAREngineNIO.class.getDeclaredMethod("marshalSB8", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = T4CMAREngineNIO.class.getDeclaredMethod("marshalUB4", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = T4CMAREngineNIO.class.getDeclaredMethod("marshalSB4", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = T4CMAREngineNIO.class.getDeclaredMethod("marshalNativeUB2", Short.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = T4CMAREngineNIO.class.getDeclaredMethod("marshalUB2", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = T4CMAREngineNIO.class.getDeclaredMethod("marshalSB2", Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T4CMAREngineNIO.class.getDeclaredMethod("marshalUB1", Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T4CMAREngineNIO.class.getDeclaredMethod("marshalSB1", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T4CMAREngineNIO.class.getDeclaredMethod("valueToUNV", Long.TYPE, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

