/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import org.ietf.jgss.GSSCredential;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
abstract class OracleDriverExtension {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;

    OracleDriverExtension() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleDriverExtension.class, $$$methodRef$$$1, null, new Object[0]);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleDriverExtension.class, $$$methodRef$$$1, null);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleDriverExtension.class, $$$methodRef$$$1, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleDriverExtension.class, $$$methodRef$$$1, null, throwable2);
            }
            throw throwable;
        }
    }

    abstract Connection getConnection(String var1, Properties var2) throws SQLException;

    Connection getConnection(String string, Properties properties, GSSCredential gSSCredential) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleDriverExtension.class, $$$methodRef$$$0, this, string, properties, gSSCredential);
            }
            SQLException sQLException = (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, OracleDriverExtension.class, $$$methodRef$$$0, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleDriverExtension.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    abstract OracleStatement allocateStatement(PhysicalConnection var1, Properties var2) throws SQLException;

    abstract OraclePreparedStatement allocatePreparedStatement(PhysicalConnection var1, String var2, Properties var3) throws SQLException;

    abstract OracleCallableStatement allocateCallableStatement(PhysicalConnection var1, String var2, Properties var3) throws SQLException;

    abstract OracleInputStream createInputStream(OracleStatement var1, int var2, Accessor var3) throws SQLException;

    static {
        try {
            $$$methodRef$$$1 = OracleDriverExtension.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleDriverExtension.class.getDeclaredMethod("getConnection", String.class, Properties.class, GSSCredential.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

