/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Executable;
import java.nio.charset.StandardCharsets;
import java.sql.SQLClientInfoException;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLNonTransientException;
import java.sql.SQLRecoverableException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLTimeoutException;
import java.sql.SQLTransactionRollbackException;
import java.sql.SQLTransientConnectionException;
import java.sql.SQLTransientException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DisableTrace;

@DisableTrace
class SQLStateMapping {
    static final SQLStateMapping DEFAULT_SQLSTATE = new SQLStateMapping(Integer.MIN_VALUE, Integer.MAX_VALUE, "99999", SqlExceptionType.SQLEXCEPTION);
    final int low;
    final int high;
    public final String sqlState;
    public final SqlExceptionType exception;
    static final String mappingResource = "errorMap.xml";
    static SQLStateMapping[] all;
    private static final int NUMEBER_OF_MAPPINGS_IN_ERRORMAP_XML = 128;

    public SQLStateMapping(int l2, int h2, String s2, SqlExceptionType ex) {
        this.low = l2;
        this.sqlState = s2;
        this.exception = ex;
        this.high = h2;
    }

    public boolean isIncluded(int value) {
        return this.low <= value && value <= this.high;
    }

    public SQLException newSQLException(String reason, int vendorCode) {
        return this.exception.newInstance(reason, this.sqlState, vendorCode);
    }

    boolean lessThan(SQLStateMapping rhs) {
        if (this.low < rhs.low) {
            return this.high < rhs.high;
        }
        return this.high <= rhs.high;
    }

    @DisableTrace
    public String toString() {
        return super.toString() + "(" + this.low + ", " + this.high + ", " + this.sqlState + ", " + this.exception + ")";
    }

    public static void main(String[] args) throws IOException {
        SQLStateMapping[] a2 = SQLStateMapping.doGetMappings();
        System.out.println("a\t" + a2);
        for (int i2 = 0; i2 < a2.length; ++i2) {
            System.out.println("low:\t" + a2[i2].low + "\thigh:\t" + a2[i2].high + "\tsqlState:\t" + a2[i2].sqlState + "\tsqlException:\t" + a2[i2].exception);
        }
    }

    static SQLStateMapping[] getMappings() {
        if (all == null) {
            try {
                all = SQLStateMapping.doGetMappings();
            }
            catch (Throwable e2) {
                all = new SQLStateMapping[0];
            }
        }
        return all;
    }

    static SQLStateMapping[] doGetMappings() throws IOException {
        InputStream s2 = SQLStateMapping.class.getResourceAsStream(mappingResource);
        ArrayList list = new ArrayList(128);
        SQLStateMapping.load(s2, list);
        return list.toArray(new SQLStateMapping[0]);
    }

    static void load(InputStream is, List list) throws IOException {
        String token;
        BufferedReader r2 = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        Tokenizer st = new Tokenizer(r2);
        int oraErrorFrom = -1;
        int oraErrorTo = -1;
        String sqlState = null;
        SqlExceptionType sqlException = null;
        String comment = null;
        int s2 = 0;
        block39: while ((token = st.next()) != null) {
            switch (s2) {
                case 0: {
                    if (!token.equals("<")) continue block39;
                    s2 = 1;
                    continue block39;
                }
                case 1: {
                    if (token.equals("!")) {
                        s2 = 2;
                        continue block39;
                    }
                    if (token.equals("oraErrorSqlStateSqlExceptionMapping")) {
                        s2 = 6;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected \"oraErrorSqlStateSqlExceptionMapping\".");
                }
                case 2: {
                    if (token.equals("-")) {
                        s2 = 3;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected \"-\".");
                }
                case 3: {
                    if (!token.equals("-")) continue block39;
                    s2 = 4;
                    continue block39;
                }
                case 4: {
                    if (token.equals("-")) {
                        s2 = 5;
                        continue block39;
                    }
                    s2 = 3;
                    continue block39;
                }
                case 5: {
                    if (token.equals(">")) {
                        s2 = 0;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected \">\".");
                }
                case 6: {
                    if (token.equals(">")) {
                        s2 = 7;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected \">\".");
                }
                case 7: {
                    if (token.equals("<")) {
                        s2 = 8;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected \"<\".");
                }
                case 8: {
                    if (token.equals("!")) {
                        s2 = 9;
                        continue block39;
                    }
                    if (token.equals("error")) {
                        s2 = 14;
                        continue block39;
                    }
                    if (token.equals("/")) {
                        s2 = 16;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected one of \"!--\", \"error\", \"/\".");
                }
                case 9: {
                    if (token.equals("-")) {
                        s2 = 10;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected \"-\".");
                }
                case 10: {
                    if (token.equals("-")) {
                        s2 = 11;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected \"-\".");
                }
                case 11: {
                    if (!token.equals("-")) continue block39;
                    s2 = 12;
                    continue block39;
                }
                case 12: {
                    if (token.equals("-")) {
                        s2 = 13;
                        continue block39;
                    }
                    s2 = 11;
                    continue block39;
                }
                case 13: {
                    if (token.equals(">")) {
                        s2 = 7;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected \">\".");
                }
                case 14: {
                    if (token.equals("/")) {
                        s2 = 15;
                        continue block39;
                    }
                    if (token.equals("oraErrorFrom")) {
                        s2 = 19;
                        continue block39;
                    }
                    if (token.equals("oraErrorTo")) {
                        s2 = 21;
                        continue block39;
                    }
                    if (token.equals("sqlState")) {
                        s2 = 23;
                        continue block39;
                    }
                    if (token.equals("sqlException")) {
                        s2 = 25;
                        continue block39;
                    }
                    if (token.equals("comment")) {
                        s2 = 27;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected one of \"oraErrorFrom\", \"oraErrorTo\", \"sqlState\", \"sqlException\", \"comment\", \"/\".");
                }
                case 15: {
                    if (token.equals(">")) {
                        try {
                            SQLStateMapping.createOne(list, oraErrorFrom, oraErrorTo, sqlState, sqlException, comment);
                        }
                        catch (IOException e2) {
                            throw new IOException("Invalid error element at line " + st.lineno + " of errorMap.xml. " + e2.getMessage());
                        }
                        oraErrorFrom = -1;
                        oraErrorTo = -1;
                        sqlState = null;
                        sqlException = null;
                        comment = null;
                        s2 = 7;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected \">\".");
                }
                case 16: {
                    if (token.equals("oraErrorSqlStateSqlExceptionMapping")) {
                        s2 = 17;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected \"oraErrorSqlStateSqlExceptionMapping\".");
                }
                case 17: {
                    if (token.equals(">")) {
                        s2 = 18;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected \">\".");
                }
                case 18: {
                    continue block39;
                }
                case 19: {
                    if (token.equals("=")) {
                        s2 = 20;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected \"=\".");
                }
                case 20: {
                    try {
                        oraErrorFrom = Integer.parseInt(token);
                    }
                    catch (NumberFormatException ex) {
                        throw new IOException("Unexpected value \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected an integer.");
                    }
                    s2 = 14;
                    continue block39;
                }
                case 21: {
                    if (token.equals("=")) {
                        s2 = 22;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected \"=\".");
                }
                case 22: {
                    try {
                        oraErrorTo = Integer.parseInt(token);
                    }
                    catch (NumberFormatException ex) {
                        throw new IOException("Unexpected value \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected an integer.");
                    }
                    s2 = 14;
                    continue block39;
                }
                case 23: {
                    if (token.equals("=")) {
                        s2 = 24;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected \"=\".");
                }
                case 24: {
                    sqlState = token;
                    s2 = 14;
                    continue block39;
                }
                case 25: {
                    if (token.equals("=")) {
                        s2 = 26;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected \"=\".");
                }
                case 26: {
                    try {
                        sqlException = SqlExceptionType.valueOf(token);
                    }
                    catch (Exception e3) {
                        throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected SQLException subclass name.");
                    }
                    s2 = 14;
                    continue block39;
                }
                case 27: {
                    if (token.equals("=")) {
                        s2 = 28;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + token + "\" at line " + st.lineno + " of errorMap.xml. Expected \"=\".");
                }
                case 28: {
                    comment = token;
                    s2 = 14;
                    continue block39;
                }
            }
            throw new IOException("Unknown parser state " + s2 + " at line " + st.lineno + " of errorMap.xml.");
        }
    }

    private static void createOne(List list, int oraErrorFrom, int oraErrorTo, String sqlState, SqlExceptionType sqlException, String comment) throws IOException {
        if (oraErrorFrom == -1) {
            throw new IOException("oraErrorFrom is a required attribute");
        }
        if (oraErrorTo == -1) {
            oraErrorTo = oraErrorFrom;
        }
        if (sqlState == null || sqlState.length() == 0) {
            throw new IOException("sqlState is a required attribute");
        }
        if (sqlException == null) {
            throw new IOException("sqlException is a required attribute");
        }
        if (comment == null || comment.length() < 8) {
            throw new IOException("a lengthy comment in required");
        }
        SQLStateMapping m2 = new SQLStateMapping(oraErrorFrom, oraErrorTo, sqlState, sqlException);
        SQLStateMapping.add(list, m2);
    }

    static void add(List l2, SQLStateMapping a2) {
        int i2;
        for (i2 = l2.size(); i2 > 0 && !((SQLStateMapping)l2.get(i2 - 1)).lessThan(a2); --i2) {
        }
        l2.add(i2, a2);
    }

    private static final class Tokenizer {
        int lineno = 1;
        Reader r;
        int c;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;

        Tokenizer(Reader r2) throws IOException {
            this.r = r2;
            this.c = r2.read();
        }

        String next() throws IOException {
            StringBuffer b2 = new StringBuffer(16);
            boolean skipping = true;
            while (this.c != -1) {
                if (this.c == 10) {
                    ++this.lineno;
                }
                if (this.c <= 32 && skipping) {
                    this.c = this.r.read();
                    continue;
                }
                if (this.c <= 32 && !skipping) {
                    this.c = this.r.read();
                    break;
                }
                if (this.c == 34) {
                    while ((this.c = this.r.read()) != 34) {
                        b2.append((char)this.c);
                    }
                    this.c = this.r.read();
                    break;
                }
                if (48 <= this.c && this.c <= 57 || 65 <= this.c && this.c <= 90 || 97 <= this.c && this.c <= 122 || this.c == 95) {
                    do {
                        b2.append((char)this.c);
                    } while (48 <= (this.c = this.r.read()) && this.c <= 57 || 65 <= this.c && this.c <= 90 || 97 <= this.c && this.c <= 122 || this.c == 95);
                    break;
                }
                b2.append((char)this.c);
                this.c = this.r.read();
                break;
            }
            if (b2.length() > 0) {
                return b2.toString();
            }
            return null;
        }

        static {
            try {
                $$$methodRef$$$1 = Tokenizer.class.getDeclaredConstructor(Reader.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = Tokenizer.class.getDeclaredMethod("next", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    static abstract class SqlExceptionType
    extends Enum<SqlExceptionType> {
        public static final /* enum */ SqlExceptionType SQLEXCEPTION;
        public static final /* enum */ SqlExceptionType SQLNONTRANSIENTEXCEPTION;
        public static final /* enum */ SqlExceptionType SQLTRANSIENTEXCEPTION;
        public static final /* enum */ SqlExceptionType SQLDATAEXCEPTION;
        public static final /* enum */ SqlExceptionType SQLFEATURENOTSUPPORTEDEXCEPTION;
        public static final /* enum */ SqlExceptionType SQLINTEGRITYCONSTRAINTVIOLATIONEXCEPTION;
        public static final /* enum */ SqlExceptionType SQLINVALIDAUTHORIZATIONSPECEXCEPTION;
        public static final /* enum */ SqlExceptionType SQLNONTRANSIENTCONNECTIONEXCEPTION;
        public static final /* enum */ SqlExceptionType SQLSYNTAXERROREXCEPTION;
        public static final /* enum */ SqlExceptionType SQLTIMEOUTEXCEPTION;
        public static final /* enum */ SqlExceptionType SQLTRANSACTIONROLLBACKEXCEPTION;
        public static final /* enum */ SqlExceptionType SQLTRANSIENTCONNECTIONEXCEPTION;
        public static final /* enum */ SqlExceptionType SQLCLIENTINFOEXCEPTION;
        public static final /* enum */ SqlExceptionType SQLRECOVERABLEEXCEPTION;
        private static final /* synthetic */ SqlExceptionType[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;

        public static SqlExceptionType[] values() {
            return (SqlExceptionType[])$VALUES.clone();
        }

        public static SqlExceptionType valueOf(String name) {
            return Enum.valueOf(SqlExceptionType.class, name);
        }

        abstract SQLException newInstance(String var1, String var2, int var3);

        static {
            try {
                $$$methodRef$$$3 = SqlExceptionType.class.getDeclaredConstructor(String.class, Integer.TYPE, oracle.jdbc.driver.SQLStateMapping$1.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = SqlExceptionType.class.getDeclaredConstructor(String.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = SqlExceptionType.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = SqlExceptionType.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            SQLEXCEPTION = new SqlExceptionType(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                SQLException newInstance(String reason, String sqlState, int vendorCode) {
                    return new SQLException(reason, sqlState, vendorCode);
                }

                static {
                    try {
                        $$$methodRef$$$1 = 1.class.getDeclaredConstructor(String.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 1.class.getDeclaredMethod("newInstance", String.class, String.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            };
            SQLNONTRANSIENTEXCEPTION = new SqlExceptionType(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                SQLException newInstance(String reason, String sqlState, int vendorCode) {
                    return new SQLNonTransientException(reason, sqlState, vendorCode);
                }

                static {
                    try {
                        $$$methodRef$$$1 = 2.class.getDeclaredConstructor(String.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 2.class.getDeclaredMethod("newInstance", String.class, String.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            };
            SQLTRANSIENTEXCEPTION = new SqlExceptionType(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                SQLException newInstance(String reason, String sqlState, int vendorCode) {
                    return new SQLTransientException(reason, sqlState, vendorCode);
                }

                static {
                    try {
                        $$$methodRef$$$1 = 3.class.getDeclaredConstructor(String.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 3.class.getDeclaredMethod("newInstance", String.class, String.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            };
            SQLDATAEXCEPTION = new SqlExceptionType(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                SQLException newInstance(String reason, String sqlState, int vendorCode) {
                    return new SQLDataException(reason, sqlState, vendorCode);
                }

                static {
                    try {
                        $$$methodRef$$$1 = 4.class.getDeclaredConstructor(String.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 4.class.getDeclaredMethod("newInstance", String.class, String.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            };
            SQLFEATURENOTSUPPORTEDEXCEPTION = new SqlExceptionType(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                SQLException newInstance(String reason, String sqlState, int vendorCode) {
                    return new SQLFeatureNotSupportedException(reason, sqlState, vendorCode);
                }

                static {
                    try {
                        $$$methodRef$$$1 = 5.class.getDeclaredConstructor(String.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 5.class.getDeclaredMethod("newInstance", String.class, String.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            };
            SQLINTEGRITYCONSTRAINTVIOLATIONEXCEPTION = new SqlExceptionType(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                SQLException newInstance(String reason, String sqlState, int vendorCode) {
                    return new SQLIntegrityConstraintViolationException(reason, sqlState, vendorCode);
                }

                static {
                    try {
                        $$$methodRef$$$1 = 6.class.getDeclaredConstructor(String.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 6.class.getDeclaredMethod("newInstance", String.class, String.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            };
            SQLINVALIDAUTHORIZATIONSPECEXCEPTION = new SqlExceptionType(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                SQLException newInstance(String reason, String sqlState, int vendorCode) {
                    return new SQLInvalidAuthorizationSpecException(reason, sqlState, vendorCode);
                }

                static {
                    try {
                        $$$methodRef$$$1 = 7.class.getDeclaredConstructor(String.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 7.class.getDeclaredMethod("newInstance", String.class, String.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            };
            SQLNONTRANSIENTCONNECTIONEXCEPTION = new SqlExceptionType(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                SQLException newInstance(String reason, String sqlState, int vendorCode) {
                    return new SQLNonTransientConnectionException(reason, sqlState, vendorCode);
                }

                static {
                    try {
                        $$$methodRef$$$1 = 8.class.getDeclaredConstructor(String.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 8.class.getDeclaredMethod("newInstance", String.class, String.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            };
            SQLSYNTAXERROREXCEPTION = new SqlExceptionType(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                SQLException newInstance(String reason, String sqlState, int vendorCode) {
                    return new SQLSyntaxErrorException(reason, sqlState, vendorCode);
                }

                static {
                    try {
                        $$$methodRef$$$1 = 9.class.getDeclaredConstructor(String.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 9.class.getDeclaredMethod("newInstance", String.class, String.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            };
            SQLTIMEOUTEXCEPTION = new SqlExceptionType(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                SQLException newInstance(String reason, String sqlState, int vendorCode) {
                    return new SQLTimeoutException(reason, sqlState, vendorCode);
                }

                static {
                    try {
                        $$$methodRef$$$1 = 10.class.getDeclaredConstructor(String.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 10.class.getDeclaredMethod("newInstance", String.class, String.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            };
            SQLTRANSACTIONROLLBACKEXCEPTION = new SqlExceptionType(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                SQLException newInstance(String reason, String sqlState, int vendorCode) {
                    return new SQLTransactionRollbackException(reason, sqlState, vendorCode);
                }

                static {
                    try {
                        $$$methodRef$$$1 = 11.class.getDeclaredConstructor(String.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 11.class.getDeclaredMethod("newInstance", String.class, String.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            };
            SQLTRANSIENTCONNECTIONEXCEPTION = new SqlExceptionType(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                SQLException newInstance(String reason, String sqlState, int vendorCode) {
                    return new SQLTransientConnectionException(reason, sqlState, vendorCode);
                }

                static {
                    try {
                        $$$methodRef$$$1 = 12.class.getDeclaredConstructor(String.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 12.class.getDeclaredMethod("newInstance", String.class, String.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            };
            SQLCLIENTINFOEXCEPTION = new SqlExceptionType(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                SQLException newInstance(String reason, String sqlState, int vendorCode) {
                    return new SQLClientInfoException(reason, sqlState, vendorCode, null);
                }

                static {
                    try {
                        $$$methodRef$$$1 = 13.class.getDeclaredConstructor(String.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 13.class.getDeclaredMethod("newInstance", String.class, String.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            };
            SQLRECOVERABLEEXCEPTION = new SqlExceptionType(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                SQLException newInstance(String reason, String sqlState, int vendorCode) {
                    return new SQLRecoverableException(reason, sqlState, vendorCode);
                }

                static {
                    try {
                        $$$methodRef$$$1 = 14.class.getDeclaredConstructor(String.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 14.class.getDeclaredMethod("newInstance", String.class, String.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            };
            $VALUES = new SqlExceptionType[]{SQLEXCEPTION, SQLNONTRANSIENTEXCEPTION, SQLTRANSIENTEXCEPTION, SQLDATAEXCEPTION, SQLFEATURENOTSUPPORTEDEXCEPTION, SQLINTEGRITYCONSTRAINTVIOLATIONEXCEPTION, SQLINVALIDAUTHORIZATIONSPECEXCEPTION, SQLNONTRANSIENTCONNECTIONEXCEPTION, SQLSYNTAXERROREXCEPTION, SQLTIMEOUTEXCEPTION, SQLTRANSACTIONROLLBACKEXCEPTION, SQLTRANSIENTCONNECTIONEXCEPTION, SQLCLIENTINFOEXCEPTION, SQLRECOVERABLEEXCEPTION};
        }
    }
}

