/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Executable;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.KeywordValueI;
import oracle.jdbc.driver.NTFDCNRegistration;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PlsqlIbtBindInfo;
import oracle.jdbc.driver.T4C8TTIrxh;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIdcb;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.driver.T4CTTIimplres;
import oracle.jdbc.driver.T4CTTIiov;
import oracle.jdbc.driver.T4CTTIoac;
import oracle.jdbc.driver.T4CTTIrxd;
import oracle.jdbc.driver.TypeAccessor;
import oracle.jdbc.internal.KeywordValue;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.oracore.OracleTypeADT;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
final class T4C8Oall
extends T4CTTIfun {
    Vector<IOException> nonFatalIOExceptions;
    static final byte[] EMPTY_BYTES;
    static final int UOPF_PRS = 1;
    static final int UOPF_BND = 8;
    static final int UOPF_EXE = 32;
    static final int UOPF_FEX = 512;
    static final int UOPF_FCH = 64;
    static final int UOPF_CAN = 128;
    static final int UOPF_COM = 256;
    static final int UOPF_DSY = 131072;
    static final int UOPF_SIO = 1024;
    static final int UOPF_NPL = 32768;
    static final int UOPF_DFN = 16;
    static final int UOPF_NCF = 262144;
    static final int EXE_COMMIT_ON_SUCCESS = 1;
    static final int EXE_LEAVE_CUR_MAPPED = 2;
    static final int EXE_BATCH_DML_ERRORS = 4;
    static final int EXE_SCROL_READ_ONLY = 8;
    static final int EXE_DISABLE_ROWSHIP = 16;
    static final int EXE_RESULT_CACHE = 32;
    static final int EXE_NO_RESULT_CACHE = 64;
    static final int EXE_ACET = 128;
    static final int KPUCXEXE = 32;
    static final int KPUCXFCH = 64;
    static final int KPUCXCAN = 128;
    static final int KPUCXCOM = 256;
    static final int KPUCXFEX = 512;
    static final int KPUCXNCF = 262144;
    static final int AL8EX_GET_PIDMLRC = 16384;
    static final int AL8KW_MAXLANG = 63;
    static final int AL8KW_TIMEZONE = 163;
    static final int AL8KW_ERR_OVLAP = 164;
    static final int AL8KW_SESSION_ID = 165;
    static final int AL8KW_SERIAL_NUM = 166;
    static final int AL8KW_TAG_FOUND = 167;
    static final int AL8KW_SCHEMA_NAME = 168;
    static final int AL8KW_SCHEMA_ID = 169;
    static final int AL8KW_ENABLED_ROLES = 170;
    static final int AL8KW_AUX_SESSSTATE = 171;
    static final int AL8KW_EDITION = 172;
    static final int AL8KW_SQL_TXLP = 173;
    static final int AL8KW_FSQL_SNTX = 174;
    static final String AL8KW_ERR_OVLAP_STR = "AL8KW_ERR_OVLAP";
    static final String AL8KW_SCHEMA_NAME_STR = "AL8KW_SCHEMA_NAME";
    static final String AL8KW_ENABLED_ROLES_STR = "AL8KW_ENABLED_ROLES";
    static final String AL8KW_EDITION_STR = "AL8KW_EDITION";
    static final String AL8KW_AUX_SESSSTATE_STR = "AL8KW_AUX_SESSSTATE";
    static final String AL8KW_SQL_TXLP_STR = "AL8KW_SQL_TXLP";
    static final String AL8KW_FSQL_SNTX_STR = "AL8KW_FSQL_SNTX";
    static final int AL8KW_OPENCURSORS = 175;
    static final String AL8KW_OPENCURSORS_STR = "AL8KW_OPENCURSORS";
    static final int AL8KW_PDBUID = 176;
    static final int AL8KW_DBID = 177;
    static final int AL8KW_GUDBID = 178;
    static final int AL8KW_DBNAME = 179;
    static final int AL8KW_SERVICE_NAME = 183;
    static final int AL8KW_CLIENT_INFO = 186;
    static final String AL8KW_CLIENT_INFO_STR = "AL8KW_CLIENT_INFO";
    static final int AL8KW_ROW_ARCHIVAL = 187;
    static final String AL8KW_ROW_ARCHIVAL_STR = "AL8KW_ROW_ARCHIVAL";
    static final int AL8KW_CONTAINER_NAME = 197;
    static final String AL8KW_CONTAINER_NAME_STR = "CONTAINER_NAME";
    static final int AL8KW_ENABLED_ROLE_NAMES = 199;
    static final String AL8KW_ENABLED_ROLE_NAMES_STR = "AL8KW_ENABLED_ROLE_NAMES";
    static final String[] NLS_KEYS;
    static final int LDIREGIDFLAG = 120;
    static final int LDIREGIDSET = 181;
    static final int LDIMAXTIMEFIELD = 60;
    static final int AL8EX_IMPL_RESULTS_CLIENT = 32768;
    long rowsProcessed;
    int numberOfDefinePositions;
    long options;
    int cursor;
    byte[] sqlStmt;
    final long[] al8i4;
    boolean plsql;
    Accessor[] definesAccessors;
    int definesLength;
    Accessor[] outBindAccessors;
    int numberOfBindPositions;
    InputStream[][] parameterStream;
    short[] bindIndicators;
    byte[] bindBytes;
    char[] bindChars;
    ByteArray bindData;
    boolean bindUseDBA;
    long[] bindDataOffsets;
    int[] bindDataLengths;
    int bindDataIndex;
    int bindIndicatorSubRange;
    byte[] tmpBindsByteArray;
    DBConversion conversion;
    byte[] ibtBindBytes;
    char[] ibtBindChars;
    short[] ibtBindIndicators;
    boolean sendBindsDefinition;
    OracleStatement oracleStatement;
    short dbCharSet;
    short NCharSet;
    T4CTTIrxd rxd;
    T4C8TTIrxh rxh;
    T4CTTIdcb dcb;
    T4CTTIimplres implres;
    OracleStatement.SqlKind typeOfStatement;
    int defCols;
    int rowsToFetch;
    boolean aFetchWasDone;
    T4CTTIoac[] oacdefBindsSent;
    T4CTTIoac[] oacdefDefines;
    int[] definedColumnSize;
    int[] definedColumnType;
    int[] definedColumnFormOfUse;
    NTFDCNRegistration registration;
    static final int AL8TXCUR = 1;
    static final int AL8TXDON = 2;
    static final int AL8TXRON = 4;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;

    T4C8Oall(T4CConnection _connection) {
        super(_connection, (byte)3);
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, T4C8Oall.class, $$$methodRef$$$22, null, _connection);
            }
            this.nonFatalIOExceptions = null;
            this.sqlStmt = new byte[0];
            this.al8i4 = new long[13];
            this.plsql = false;
            this.bindUseDBA = false;
            this.bindDataOffsets = null;
            this.bindDataLengths = null;
            this.sendBindsDefinition = false;
            this.defCols = 0;
            this.aFetchWasDone = false;
            this.registration = null;
            this.setFunCode((short)94);
            this.rxh = new T4C8TTIrxh(_connection);
            this.rxd = new T4CTTIrxd(_connection);
            this.dcb = new T4CTTIdcb(_connection);
            this.implres = new T4CTTIimplres(_connection);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, T4C8Oall.class, $$$methodRef$$$22, null);
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, T4C8Oall.class, $$$methodRef$$$22, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, T4C8Oall.class, $$$methodRef$$$22, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void doOALL(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, OracleStatement.SqlKind sqlKind, int n2, byte[] byArray, int n3, Accessor[] accessorArray, int n4, Accessor[] accessorArray2, int n5, byte[] byArray2, char[] cArray, short[] sArray, int n6, DBConversion dBConversion, byte[] byArray3, InputStream[][] inputStreamArray, OracleStatement oracleStatement, byte[] byArray4, char[] cArray2, short[] sArray2, T4CTTIoac[] t4CTTIoacArray, int[] nArray, int[] nArray2, int[] nArray3, NTFDCNRegistration nTFDCNRegistration, ByteArray byteArray, long[] lArray, int[] nArray4, boolean bl6) throws SQLException, IOException {
        boolean bl7 = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void doDescribe;
            void doFetch;
            void doExecute;
            void doDefine;
            void bindUseDBA;
            void bindDataLengths;
            void bindDataOffsets;
            void bindData;
            void _registration;
            void _definedColumnFormOfUse;
            void _definedColumnSize;
            void _definedColumnType;
            void _oacdefBindsSent;
            void _ibtBindIndicators;
            void _ibtBindChars;
            void _ibtBindBytes;
            void _oracleStatement;
            void _parameterStream;
            void _tmpBindsByteArray;
            void _conversion;
            void _bindIndicatorSubRange;
            void _bindIndicators;
            void _bindChars;
            void _bindBytes;
            void _definesLength;
            void _definesAccessors;
            void _numberOfBindPositions;
            void _outBindAccessors;
            void _rowsToFetch;
            void _sqlStmt;
            void doParse;
            void _cursor;
            void _typeOfStatement;
            if (bl7) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, T4C8Oall.class, $$$methodRef$$$0, this, new Object[]{bl, bl2, bl3, bl4, bl5, sqlKind, n2, byArray, n3, accessorArray, n4, accessorArray2, n5, byArray2, cArray, sArray, n6, dBConversion, byArray3, inputStreamArray, oracleStatement, byArray4, cArray2, sArray2, t4CTTIoacArray, nArray, nArray2, nArray3, nTFDCNRegistration, byteArray, lArray, nArray4, bl6});
            }
            this.typeOfStatement = _typeOfStatement;
            this.cursor = _cursor;
            this.sqlStmt = (byte[])(doParse != false ? _sqlStmt : EMPTY_BYTES);
            this.rowsToFetch = _rowsToFetch;
            this.outBindAccessors = _outBindAccessors;
            this.numberOfBindPositions = _numberOfBindPositions;
            this.definesAccessors = _definesAccessors;
            this.definesLength = _definesLength;
            this.bindBytes = _bindBytes;
            this.bindChars = _bindChars;
            this.bindIndicators = _bindIndicators;
            this.bindIndicatorSubRange = _bindIndicatorSubRange;
            this.conversion = _conversion;
            this.tmpBindsByteArray = _tmpBindsByteArray;
            this.parameterStream = _parameterStream;
            this.oracleStatement = _oracleStatement;
            this.ibtBindBytes = _ibtBindBytes;
            this.ibtBindChars = _ibtBindChars;
            this.ibtBindIndicators = _ibtBindIndicators;
            this.oacdefBindsSent = _oacdefBindsSent;
            this.definedColumnType = _definedColumnType;
            this.definedColumnSize = _definedColumnSize;
            this.definedColumnFormOfUse = _definedColumnFormOfUse;
            this.registration = _registration;
            this.bindData = bindData;
            this.bindDataOffsets = bindDataOffsets;
            this.bindDataLengths = bindDataLengths;
            this.bindUseDBA = bindUseDBA;
            this.dbCharSet = _conversion.getServerCharSetId();
            this.NCharSet = _conversion.getNCharSetId();
            int number_of_bound_rows = 0;
            if (this.bindIndicators != null) {
                number_of_bound_rows = ((this.bindIndicators[this.bindIndicatorSubRange + 3] & 0xFFFF) << 16) + (this.bindIndicators[this.bindIndicatorSubRange + 4] & 0xFFFF);
            }
            if (_sqlStmt == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 431).fillInStackTrace();
                if (bl7) {
                    ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, T4C8Oall.class, $$$methodRef$$$0, this, sQLException);
                }
                throw sQLException;
            }
            if (!this.typeOfStatement.isDML() && number_of_bound_rows > 1) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 433).fillInStackTrace();
                if (bl7) {
                    ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, T4C8Oall.class, $$$methodRef$$$0, this, sQLException);
                }
                throw sQLException;
            }
            this.rowsProcessed = 0L;
            this.options = 0L;
            this.plsql = this.typeOfStatement.isPlsqlOrCall();
            this.sendBindsDefinition = false;
            if (this.receiveState != 0) {
                this.receiveState = 0;
            }
            this.rxh.init();
            this.rxd.init();
            this.oer.init();
            if (doDefine != false && this.typeOfStatement.isSELECT()) {
                this.initDefinesDefinition();
            }
            if (this.numberOfBindPositions > 0 && this.bindIndicators != null) {
                if (this.oacdefBindsSent == null) {
                    this.oacdefBindsSent = new T4CTTIoac[this.numberOfBindPositions];
                }
                this.sendBindsDefinition = this.initBindsDefinition(this.oacdefBindsSent);
            }
            this.options = this.setOptions((boolean)doParse, (boolean)doExecute, (boolean)doFetch, (boolean)doDefine);
            this.al8i4[0] = (this.options & 1L) > 0L ? 1L : 0L;
            this.al8i4[1] = this.plsql || this.typeOfStatement.isOTHER() ? 1L : (doDescribe != false ? (doFetch != false && this.oracleStatement.isFetchStreams ? (long)this.rowsToFetch : 0L) : (this.typeOfStatement.isDML() ? (number_of_bound_rows == 0 ? (long)this.oracleStatement.batch : (long)number_of_bound_rows) : (doFetch != false && doDescribe == false ? (long)this.rowsToFetch : 0L)));
            this.al8i4[7] = this.typeOfStatement.isSELECT() ? 1L : 0L;
            long scn = this.oracleStatement.inScn;
            int leastSignificantHalfScn = (int)scn;
            int mostSignificantHalfScn = (int)(scn >> 32);
            this.al8i4[5] = leastSignificantHalfScn;
            this.al8i4[6] = mostSignificantHalfScn;
            this.al8i4[9] = this.typeOfStatement.isDML() ? this.al8i4[9] | 0x4000L : this.al8i4[9] & 0xFFFFFFFFFFFFBFFFL;
            this.rowsProcessed = 0L;
            this.aFetchWasDone = false;
            this.rxd.setNumberOfColumns(this.definesLength);
            if ((this.options & 0x40L) != 0L && (this.options & 0x20L) == 0L && (this.options & 1L) == 0L && (this.options & 8L) == 0L && (this.options & 0x10L) == 0L && !this.oracleStatement.needToSendOalToFetch) {
                this.setFunCode((short)5);
            } else if (this.oracleStatement.inScn == 0L && (this.options & 0x20L) != 0L && (this.options & 1L) == 0L && (this.options & 0x10L) == 0L && (this.options & 8L) == 0L && (this.options & 0x8000L) != 0L && (this.options & 0x40L) != 0L) {
                this.setFunCode((short)78);
            } else {
                this.setFunCode((short)94);
            }
            this.al8i4[9] = (this.options & 0x20L) != 0L ? this.al8i4[9] | 0x8000L : this.al8i4[9] & 0xFFFFFFFFFFFF7FFFL;
            if (this.getFunCode() == 94 || this.getFunCode() == 78) {
                ((T4CConnection)this.oracleStatement.connection).setExecutingRPCSQL(this.oracleStatement.sqlObject.actualSql);
            }
            this.nonFatalIOExceptions = null;
            this.doRPC();
            if ((this.options & 0x20L) != 0L) {
                this.oracleStatement.inScn = 0L;
            }
            this.ibtBindIndicators = null;
            this.ibtBindChars = null;
            this.ibtBindBytes = null;
            this.tmpBindsByteArray = null;
            this.outBindAccessors = null;
            this.bindBytes = null;
            this.bindChars = null;
            this.bindIndicators = null;
            this.oracleStatement = null;
            this.parameterStream = null;
            if (this.nonFatalIOExceptions != null) {
                IOException firstIOex = this.nonFatalIOExceptions.get(0);
                try {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 266).fillInStackTrace();
                    if (bl7) {
                        ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, T4C8Oall.class, $$$methodRef$$$0, this, sQLException);
                    }
                    throw sQLException;
                }
                catch (SQLException sqlex) {
                    sqlex.initCause(firstIOex);
                    SQLException sQLException = sqlex;
                    if (bl7) {
                        ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, T4C8Oall.class, $$$methodRef$$$0, this, sQLException);
                    }
                    throw sQLException;
                }
            }
            if (bl7) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, T4C8Oall.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4C8Oall.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl7) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4C8Oall.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    void readBVC() throws IOException, SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, T4C8Oall.class, $$$methodRef$$$1, this, new Object[0]);
            }
            int nbOfColumnSent = this.meg.unmarshalUB2();
            this.rxd.unmarshalBVC(nbOfColumnSent);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, T4C8Oall.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4C8Oall.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4C8Oall.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    void readIOV() throws IOException, SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, T4C8Oall.class, $$$methodRef$$$2, this, new Object[0]);
            }
            T4CTTIiov iov = new T4CTTIiov(this.connection, this.rxh, this.rxd);
            iov.init();
            iov.unmarshalV10();
            if (!this.oracleStatement.isDmlReturning && !iov.isIOVectorEmpty()) {
                byte[] ioVector = iov.getIOVector();
                this.outBindAccessors = iov.processRXD(this.outBindAccessors, this.numberOfBindPositions, this.bindBytes, this.bindChars, this.bindIndicators, this.bindIndicatorSubRange, this.conversion, this.tmpBindsByteArray, ioVector, this.parameterStream, this.oracleStatement, null, null, null);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, T4C8Oall.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4C8Oall.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4C8Oall.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    void readRXH() throws IOException, SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, T4C8Oall.class, $$$methodRef$$$3, this, new Object[0]);
            }
            this.rxh.init();
            this.rxh.unmarshalV10(this.rxd);
            if (this.rxh.uacBufLength > 0) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 405).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, T4C8Oall.class, $$$methodRef$$$3, this, sQLException);
                }
                throw sQLException;
            }
            if ((this.rxh.rxhflg & 8) == 8) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 449).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, T4C8Oall.class, $$$methodRef$$$3, this, sQLException);
                }
                throw sQLException;
            }
            if ((this.rxh.rxhflg & 0x10) == 16) {
                for (int i2 = 0; i2 < this.definesAccessors.length; ++i2) {
                    if (this.definesAccessors[i2].udskpos < 0 || this.definesAccessors[i2].udskpos == i2) continue;
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 450).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, T4C8Oall.class, $$$methodRef$$$3, this, sQLException);
                    }
                    throw sQLException;
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, T4C8Oall.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T4C8Oall.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T4C8Oall.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    void processSLG() throws IOException, SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, T4C8Oall.class, $$$methodRef$$$4, this, new Object[0]);
            }
            this.readRXH();
            int[] oacmxlArr = new int[this.numberOfBindPositions];
            for (int i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
                oacmxlArr[i2] = this.oacdefBindsSent[i2].oacmxl;
            }
            this.nonFatalIOExceptions = this.marshalBinds(oacmxlArr, true);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, T4C8Oall.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4C8Oall.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4C8Oall.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    boolean readRXD() throws IOException, SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, T4C8Oall.class, $$$methodRef$$$5, this, new Object[0]);
            }
            this.aFetchWasDone = true;
            if (this.oracleStatement.isDmlReturning && this.numberOfBindPositions > 0) {
                boolean memoryHasBeenAllocated = false;
                for (int col = 0; col < this.oracleStatement.numberOfBindPositions; ++col) {
                    Accessor acc = this.oracleStatement.accessors[col];
                    if (acc == null) continue;
                    int nbOfRowsSent = (int)this.meg.unmarshalUB4();
                    this.oracleStatement.increaseCapacity(nbOfRowsSent);
                    this.oracleStatement.rowsDmlReturned += nbOfRowsSent;
                    for (int row = 0; row < nbOfRowsSent; ++row) {
                        acc.unmarshalOneRow();
                        ++this.oracleStatement.storedRowCount;
                    }
                }
                this.oracleStatement.returnParamsFetched = true;
            } else if (this.iovProcessed || this.outBindAccessors != null && this.definesAccessors == null) {
                if (this.rxd.unmarshal(this.outBindAccessors, this.numberOfBindPositions)) {
                    boolean bl2 = true;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, T4C8Oall.class, $$$methodRef$$$5, this, bl2);
                        ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T4C8Oall.class, $$$methodRef$$$5, this, null);
                    }
                    return true;
                }
            } else if (this.rxd.unmarshal(this.definesAccessors, this.definesLength)) {
                boolean bl3 = true;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, T4C8Oall.class, $$$methodRef$$$5, this, bl3);
                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T4C8Oall.class, $$$methodRef$$$5, this, null);
                }
                return true;
            }
            boolean bl4 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, T4C8Oall.class, $$$methodRef$$$5, this, bl4);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T4C8Oall.class, $$$methodRef$$$5, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T4C8Oall.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    void readRPA() throws IOException, SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, T4C8Oall.class, $$$methodRef$$$6, this, new Object[0]);
            }
            int KSCNFVB = 32768;
            int al8o4l = this.meg.unmarshalUB2();
            int[] al8o4 = new int[al8o4l];
            for (int i2 = 0; i2 < al8o4l; ++i2) {
                al8o4[i2] = (int)this.meg.unmarshalUB4();
            }
            int leastSignificantHalfScn = al8o4[0];
            int mostSignificantHalfScn = al8o4[1] & ~KSCNFVB;
            long scn = (long)leastSignificantHalfScn & 0xFFFFFFFFL | ((long)mostSignificantHalfScn & 0xFFFFFFFFL) << 32;
            if (scn != 0L) {
                this.oracleStatement.connection.outScn = scn;
            }
            this.cursor = al8o4[2];
            int al8txl = this.meg.unmarshalUB2();
            byte[] al8txn = null;
            if (al8txl > 0) {
                al8txn = this.meg.unmarshalNBytes(al8txl);
            }
            int al8kvl = this.meg.unmarshalUB2();
            KeywordValue[] al8kv = new KeywordValue[al8kvl];
            for (int i3 = 0; i3 < al8kvl; ++i3) {
                al8kv[i3] = KeywordValueI.unmarshal(this.meg);
            }
            this.connection.updateSessionProperties(al8kv);
            this.oracleStatement.dcnQueryId = -1L;
            this.oracleStatement.dcnTableName = null;
            if (this.connection.getTTCVersion() >= 4) {
                int registrationFeedbackLength = (int)this.meg.unmarshalUB4();
                byte[] registrationFeedback = this.meg.unmarshalNBytes(registrationFeedbackLength);
                if (registrationFeedbackLength > 0 && this.registration != null) {
                    String qcOption;
                    boolean isQC = false;
                    Properties regOptions = this.registration.getRegistrationOptions();
                    if (regOptions != null && (qcOption = regOptions.getProperty("DCN_QUERY_CHANGE_NOTIFICATION")) != null && qcOption.compareToIgnoreCase("true") == 0) {
                        isQC = true;
                    }
                    int tablesDescriptionLength = registrationFeedbackLength;
                    if (isQC) {
                        tablesDescriptionLength = registrationFeedbackLength - 8;
                    }
                    String tablesAll = new String(registrationFeedback, 0, tablesDescriptionLength, StandardCharsets.US_ASCII);
                    char[] delimitor = new char[]{'\u0000'};
                    String[] tables = tablesAll.split(new String(delimitor));
                    this.registration.addTablesName(tables, tables.length);
                    this.oracleStatement.dcnTableName = tables;
                    if (isQC) {
                        long queryId;
                        int queryId2 = registrationFeedback[registrationFeedbackLength - 1] & 0xFF | (registrationFeedback[registrationFeedbackLength - 2] & 0xFF) << 8 | (registrationFeedback[registrationFeedbackLength - 3] & 0xFF) << 16 | (registrationFeedback[registrationFeedbackLength - 4] & 0xFF) << 24;
                        int queryId1 = registrationFeedback[registrationFeedbackLength - 5] & 0xFF | (registrationFeedback[registrationFeedbackLength - 6] & 0xFF) << 8 | (registrationFeedback[registrationFeedbackLength - 7] & 0xFF) << 16 | (registrationFeedback[registrationFeedbackLength - 8] & 0xFF) << 24;
                        this.oracleStatement.dcnQueryId = queryId = (long)queryId1 & 0xFFFFFFFFL | ((long)queryId2 & 0xFFFFFFFFL) << 32;
                    }
                }
            }
            if (this.connection.getTTCVersion() >= 7 && this.typeOfStatement.isDML()) {
                int al8pidmlrcl = (int)this.meg.unmarshalUB4();
                long[] al8pidmlrc = new long[al8pidmlrcl];
                for (int i4 = 0; i4 < al8pidmlrcl; ++i4) {
                    al8pidmlrc[i4] = this.meg.unmarshalSB8();
                }
                this.oracleStatement.batchRowsUpdatedArray = al8pidmlrc;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, T4C8Oall.class, $$$methodRef$$$6, this);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, T4C8Oall.class, $$$methodRef$$$6, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, T4C8Oall.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    void readDCB() throws IOException, SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, T4C8Oall.class, $$$methodRef$$$7, this, new Object[0]);
            }
            this.dcb.init(this.oracleStatement, 0);
            this.definesAccessors = this.dcb.receive(this.definesAccessors);
            this.definesLength = this.numberOfDefinePositions = this.dcb.numuds;
            this.rxd.setNumberOfColumns(this.numberOfDefinePositions);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, T4C8Oall.class, $$$methodRef$$$7, this);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, T4C8Oall.class, $$$methodRef$$$7, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, T4C8Oall.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    void readRSH() throws IOException, SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, T4C8Oall.class, $$$methodRef$$$8, this, new Object[0]);
            }
            long queryId = this.meg.unmarshalSB8();
            this.connection.kpdqidcscn.unmarshal();
            long executionSCN = this.connection.kpdqidcscn.getSCN();
            this.oracleStatement.setQueryId(queryId);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, T4C8Oall.class, $$$methodRef$$$8, this);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, T4C8Oall.class, $$$methodRef$$$8, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, T4C8Oall.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    void readIMPLRES() throws IOException, SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            int rsCount;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, T4C8Oall.class, $$$methodRef$$$9, this, new Object[0]);
            }
            this.implres.init(this.oracleStatement);
            this.oracleStatement.implicitResultSetStatements = new ArrayDeque(rsCount);
            for (rsCount = (int)this.meg.unmarshalUB4(); rsCount != 0; --rsCount) {
                this.implres.readImplicitResultSet();
            }
            this.oracleStatement.implicitResultSetIterator = this.oracleStatement.implicitResultSetStatements.iterator();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, T4C8Oall.class, $$$methodRef$$$9, this);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, T4C8Oall.class, $$$methodRef$$$9, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, T4C8Oall.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    void processError() throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, T4C8Oall.class, $$$methodRef$$$10, this, new Object[0]);
            }
            this.cursor = this.oer.currCursorID;
            this.rowsProcessed = this.oer.getCurRowNumber();
            this.oracleStatement.isAllFetched = this.oracleStatement.isAllFetched | this.oer.retCode == 1403L;
            if (this.typeOfStatement.isSELECT() && this.oer.retCode == 1403L) {
                this.aFetchWasDone = true;
            }
            if (!this.typeOfStatement.isSELECT() || this.typeOfStatement.isSELECT() && this.oer.retCode != 1403L) {
                if (this.oracleStatement.connection.checksumMode.needToCalculateFetchChecksum() && this.oer.retCode != 0L) {
                    long localCheckSum;
                    this.oracleStatement.checkSum = localCheckSum = this.oer.updateChecksum(this.oracleStatement.checkSum);
                }
                this.oer.processError(this.oracleStatement);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, T4C8Oall.class, $$$methodRef$$$10, this);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T4C8Oall.class, $$$methodRef$$$10, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T4C8Oall.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    int getCursorId() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, T4C8Oall.class, $$$methodRef$$$11, this, new Object[0]);
            }
            int n2 = this.cursor;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, T4C8Oall.class, $$$methodRef$$$11, this, n2);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, T4C8Oall.class, $$$methodRef$$$11, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, T4C8Oall.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void continueReadRow(int n2, OracleStatement oracleStatement) throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            block9: {
                block10: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, T4C8Oall.class, $$$methodRef$$$12, this, n2, oracleStatement);
                    }
                    try {
                        void start;
                        void s2;
                        this.oracleStatement = s2;
                        this.receiveState = 2;
                        if (!this.rxd.unmarshal(this.definesAccessors, (int)start, this.definesLength)) break block9;
                        this.receiveState = 3;
                        this.oracleStatement = null;
                        if (!bl) break block10;
                    }
                    catch (Throwable throwable) {
                        this.oracleStatement = null;
                        Throwable throwable2 = throwable;
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$12, Level.FINEST, T4C8Oall.class, $$$methodRef$$$12, this, throwable2);
                        }
                        throw throwable2;
                    }
                    ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, T4C8Oall.class, $$$methodRef$$$12, this);
                    ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, T4C8Oall.class, $$$methodRef$$$12, this, null);
                }
                return;
            }
            this.resumeReceive();
            this.oracleStatement = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, T4C8Oall.class, $$$methodRef$$$12, this);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, T4C8Oall.class, $$$methodRef$$$12, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, T4C8Oall.class, $$$methodRef$$$12, this, throwable3);
            }
            throw throwable;
        }
    }

    long getNumRows() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, T4C8Oall.class, $$$methodRef$$$13, this, new Object[0]);
            }
            long rows = 0L;
            if (this.typeOfStatement == null) {
                long l2 = rows;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, T4C8Oall.class, $$$methodRef$$$13, this, l2);
                    ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, T4C8Oall.class, $$$methodRef$$$13, this, null);
                }
                return l2;
            }
            if (this.receiveState == 3) {
                rows = -2L;
            } else {
                switch (this.typeOfStatement) {
                    case DELETE: 
                    case INSERT: 
                    case MERGE: 
                    case UPDATE: 
                    case ALTER_SESSION: 
                    case OTHER: 
                    case PLSQL_BLOCK: 
                    case CALL_BLOCK: {
                        rows = this.rowsProcessed;
                        break;
                    }
                    case SELECT_FOR_UPDATE: 
                    case SELECT: {
                        if (!$assertionsDisabled && this.definesAccessors != null && this.definesAccessors[0] == null) {
                            AssertionError assertionError = new AssertionError((Object)"definesAccessors is not null but definesAccessors[0] is null");
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$13, Level.FINEST, T4C8Oall.class, $$$methodRef$$$13, this, (Throwable)((Object)assertionError));
                            }
                            throw assertionError;
                        }
                        rows = this.definesAccessors != null && this.definesLength > 0 && this.definesAccessors[0] != null ? (long)this.definesAccessors[0].lastRowProcessed : 0L;
                    }
                }
            }
            long l3 = rows;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, T4C8Oall.class, $$$methodRef$$$13, this, l3);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, T4C8Oall.class, $$$methodRef$$$13, this, null);
            }
            return l3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, T4C8Oall.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    void marshal() throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, T4C8Oall.class, $$$methodRef$$$14, this, new Object[0]);
            }
            if (this.getFunCode() == 5) {
                this.meg.marshalSWORD(this.cursor);
                this.meg.marshalSWORD((int)this.al8i4[1]);
            } else if (this.getFunCode() == 78) {
                this.meg.marshalSWORD(this.cursor);
                this.meg.marshalSWORD((int)this.al8i4[1]);
                int exerof = 96;
                this.meg.marshalSWORD(exerof);
                int exeflg = 0;
                if ((this.options & 0x100L) == 256L) {
                    exeflg |= 1;
                }
                this.meg.marshalSWORD(exeflg);
                int[] oacmxlArr = new int[this.numberOfBindPositions];
                for (int i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
                    oacmxlArr[i2] = this.oacdefBindsSent[i2].oacmxl;
                }
                if (this.numberOfBindPositions > 0 && this.bindIndicators != null) {
                    this.marshalBinds(oacmxlArr, false);
                }
            } else {
                int i3;
                if (this.oracleStatement.needToSendOalToFetch) {
                    this.oracleStatement.needToSendOalToFetch = false;
                }
                this.marshalPisdef();
                this.meg.marshalCHR(this.sqlStmt);
                this.meg.marshalUB4Array(this.al8i4);
                int[] oacmxlArr = new int[this.numberOfBindPositions];
                for (i3 = 0; i3 < this.numberOfBindPositions; ++i3) {
                    oacmxlArr[i3] = this.oacdefBindsSent[i3].oacmxl;
                }
                if ((this.options & 8L) != 0L && this.numberOfBindPositions > 0 && this.bindIndicators != null && this.sendBindsDefinition) {
                    this.marshalBindsTypes(this.oacdefBindsSent);
                }
                if (this.connection.getTTCVersion() >= 2 && (this.options & 0x10L) != 0L) {
                    for (i3 = 0; i3 < this.defCols; ++i3) {
                        this.oacdefDefines[i3].marshal();
                    }
                }
                if ((this.options & 0x20L) != 0L && this.numberOfBindPositions > 0 && this.bindIndicators != null) {
                    this.nonFatalIOExceptions = this.marshalBinds(oacmxlArr, false);
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, T4C8Oall.class, $$$methodRef$$$14, this);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, T4C8Oall.class, $$$methodRef$$$14, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, T4C8Oall.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    void marshalPisdef() throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, T4C8Oall.class, $$$methodRef$$$15, this, new Object[0]);
            }
            this.meg.marshalUB4(this.options);
            this.meg.marshalSWORD(this.cursor);
            if (this.sqlStmt.length == 0) {
                this.meg.marshalNULLPTR();
            } else {
                this.meg.marshalPTR();
            }
            this.meg.marshalSWORD(this.sqlStmt.length);
            if (this.al8i4.length == 0) {
                this.meg.marshalNULLPTR();
            } else {
                this.meg.marshalPTR();
            }
            this.meg.marshalSWORD(this.al8i4.length);
            this.meg.marshalNULLPTR();
            this.meg.marshalNULLPTR();
            if ((this.options & 0x40L) == 0L && (this.options & 0x20L) != 0L && (this.options & 1L) != 0L && this.typeOfStatement.isSELECT()) {
                this.meg.marshalUB4(Long.MAX_VALUE);
                this.meg.marshalUB4(this.rowsToFetch);
            } else {
                this.meg.marshalUB4(0L);
                this.meg.marshalUB4(0L);
            }
            if (!this.typeOfStatement.isPlsqlOrCall()) {
                this.meg.marshalUB4(Integer.MAX_VALUE);
            } else {
                this.meg.marshalUB4(32760L);
            }
            if ((this.options & 8L) != 0L && this.numberOfBindPositions > 0 && this.sendBindsDefinition) {
                this.meg.marshalPTR();
                this.meg.marshalSWORD(this.numberOfBindPositions);
            } else {
                this.meg.marshalNULLPTR();
                this.meg.marshalSWORD(0);
            }
            this.meg.marshalNULLPTR();
            this.meg.marshalNULLPTR();
            this.meg.marshalNULLPTR();
            this.meg.marshalNULLPTR();
            this.meg.marshalNULLPTR();
            if (this.connection.getTTCVersion() >= 2) {
                if (this.defCols > 0 && (this.options & 0x10L) != 0L) {
                    this.meg.marshalPTR();
                    this.meg.marshalSWORD(this.defCols);
                } else {
                    this.meg.marshalNULLPTR();
                    this.meg.marshalSWORD(0);
                }
            }
            if (this.connection.getTTCVersion() >= 4) {
                int regid_lb = 0;
                int regid_mb = 0;
                if (this.registration != null) {
                    long regid = this.registration.getRegId();
                    regid_lb = (int)(regid & 0xFFFFFFFFFFFFFFFFL);
                    regid_mb = (int)((regid & 0xFFFFFFFF00000000L) >> 32);
                }
                this.meg.marshalUB4(regid_lb);
                this.meg.marshalNULLPTR();
                this.meg.marshalPTR();
                if (this.connection.getTTCVersion() >= 5) {
                    this.meg.marshalNULLPTR();
                    this.meg.marshalUB4(0L);
                    this.meg.marshalNULLPTR();
                    this.meg.marshalUB4(0L);
                    this.meg.marshalUB4(regid_mb);
                    if (this.connection.getTTCVersion() >= 7) {
                        if (this.typeOfStatement.isDML()) {
                            this.meg.marshalPTR();
                            this.meg.marshalUB4(this.oracleStatement.currentRank);
                            this.meg.marshalPTR();
                        } else {
                            this.meg.marshalNULLPTR();
                            this.meg.marshalUB4(0L);
                            this.meg.marshalNULLPTR();
                        }
                        if (this.connection.getTTCVersion() >= 8) {
                            this.meg.marshalNULLPTR();
                            this.meg.marshalUB4(0L);
                            this.meg.marshalNULLPTR();
                            this.meg.marshalUB4(0L);
                            this.meg.marshalNULLPTR();
                            if (this.connection.getTTCVersion() >= 9) {
                                this.meg.marshalNULLPTR();
                                this.meg.marshalUB4(0L);
                            }
                        }
                    }
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, T4C8Oall.class, $$$methodRef$$$15, this);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, T4C8Oall.class, $$$methodRef$$$15, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, T4C8Oall.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    boolean initBindsDefinition(T4CTTIoac[] t4CTTIoacArray) throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            T4CTTIoac[] oacdefArr;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, T4C8Oall.class, $$$methodRef$$$16, this, new Object[]{t4CTTIoacArray});
            }
            boolean needToUpdateDefinition = false;
            if (oacdefArr.length != this.numberOfBindPositions) {
                needToUpdateDefinition = true;
                oacdefArr = new T4CTTIoac[this.numberOfBindPositions];
            }
            short[] l_bindIndicators = this.bindIndicators;
            int _oacmxl = 0;
            int nbOfIbt = 0;
            for (int P = 0; P < this.numberOfBindPositions; ++P) {
                T4CTTIoac oac = new T4CTTIoac(this.connection);
                int subRangeOffset = this.bindIndicatorSubRange + 5 + 10 * P;
                short formOfUse = l_bindIndicators[subRangeOffset + 9];
                int _oactype = l_bindIndicators[subRangeOffset + 0] & 0xFFFF;
                switch (_oactype) {
                    case 8: 
                    case 24: {
                        _oacmxl = this.plsql ? 32760 : Integer.MAX_VALUE;
                        oac.init((short)_oactype, _oacmxl);
                        oac.setFormOfUse(formOfUse);
                        oac.setCharset(formOfUse == 2 ? this.NCharSet : this.dbCharSet);
                        break;
                    }
                    case 998: {
                        if (this.outBindAccessors != null && this.outBindAccessors[P] != null) {
                            PlsqlIbtBindInfo ibtInfo = this.outBindAccessors[P].plsqlIndexTableBindInfo();
                            oac.init((short)ibtInfo.element_internal_type, ibtInfo.elemMaxLen);
                            oac.setMal(ibtInfo.maxLen);
                            oac.addFlg((short)64);
                            ++nbOfIbt;
                            break;
                        }
                        if (this.ibtBindIndicators[6 + nbOfIbt * 8] != 0) {
                            short typeElem = this.ibtBindIndicators[6 + nbOfIbt * 8];
                            int oacmal = (this.ibtBindIndicators[6 + nbOfIbt * 8 + 2] & 0xFFFF) << 16 | this.ibtBindIndicators[6 + nbOfIbt * 8 + 3] & 0xFFFF;
                            _oacmxl = this.ibtBindIndicators[6 + nbOfIbt * 8 + 1] * this.conversion.sMaxCharSize;
                            oac.init(typeElem, _oacmxl);
                            oac.setMal(oacmal);
                            oac.addFlg((short)64);
                            ++nbOfIbt;
                            break;
                        }
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 89, "Binding PLSQL index-by table but no type defined").fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$16, Level.FINEST, T4C8Oall.class, $$$methodRef$$$16, this, sQLException);
                        }
                        throw sQLException;
                    }
                    case 109: 
                    case 111: {
                        if (this.outBindAccessors != null && this.outBindAccessors[P] != null) {
                            if (this.outBindAccessors[P].internalOtype == null) break;
                            oac.init((short)_oactype, _oactype == 109 ? 11 : 4000);
                            oac.setADT((OracleTypeADT)((TypeAccessor)this.outBindAccessors[P]).internalOtype);
                            break;
                        }
                        if (this.oracleStatement instanceof OraclePreparedStatement && ((OraclePreparedStatement)this.oracleStatement).binders != null && ((OraclePreparedStatement)this.oracleStatement).binders[this.oracleStatement.firstRowInBatch] != null) {
                            oac.init((short)_oactype, _oactype == 109 ? 11 : 4000);
                            Binder binder = ((OraclePreparedStatement)this.oracleStatement).binders[this.oracleStatement.firstRowInBatch][P];
                            if (binder == null && ((OraclePreparedStatement)this.oracleStatement).lastBinders != null) {
                                binder = ((OraclePreparedStatement)this.oracleStatement).lastBinders[P];
                            }
                            oac.setADT(((OraclePreparedStatement)this.oracleStatement).getOtype(binder));
                            break;
                        }
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 89, "Binding NAMED_TYPE but no type defined").fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$16, Level.FINEST, T4C8Oall.class, $$$methodRef$$$16, this, sQLException);
                        }
                        throw sQLException;
                    }
                    case 994: {
                        int[] returnParamMetaLocal = this.oracleStatement.returnParamMeta;
                        _oactype = returnParamMetaLocal[3 + P * 4 + 0];
                        _oacmxl = returnParamMetaLocal[3 + P * 4 + 2];
                        formOfUse = (short)returnParamMetaLocal[3 + P * 4 + 3];
                        if (_oactype == 109 || _oactype == 111) {
                            TypeAccessor typeAccessor = (TypeAccessor)this.oracleStatement.accessors[P];
                            oac.init((short)_oactype, _oactype == 109 ? 11 : 4000);
                            oac.setADT((OracleTypeADT)typeAccessor.internalOtype);
                            break;
                        }
                        oac.init((short)_oactype, _oacmxl);
                        oac.setFormOfUse(formOfUse);
                        oac.setCharset(formOfUse == 2 ? this.NCharSet : this.dbCharSet);
                        break;
                    }
                    case 180: {
                        boolean isValueNull;
                        _oacmxl = this.bindUseDBA ? 11 : l_bindIndicators[subRangeOffset + 1] & 0xFFFF;
                        if (bl) {
                            this.debug($$$loggerRef$$$16, Level.FINEST, $$$methodRef$$$16, "T4C8Oall.initBindsDefinition for TIMESTAMP case _oacmxl: " + _oacmxl);
                        }
                        oac.init((short)_oactype, _oacmxl);
                        oac.addFlg2(0x8000000);
                        short scale = -1;
                        Binder binder = ((OraclePreparedStatement)this.oracleStatement).currentRowBinders[P];
                        if (binder == null && (binder = ((OraclePreparedStatement)this.oracleStatement).binders[this.oracleStatement.firstRowInBatch][P]) == null && ((OraclePreparedStatement)this.oracleStatement).lastBinders != null) {
                            binder = ((OraclePreparedStatement)this.oracleStatement).lastBinders[P];
                        }
                        if (binder != null) {
                            scale = ((OraclePreparedStatement)this.oracleStatement).getScale(binder);
                        }
                        if (bl) {
                            this.debug($$$loggerRef$$$16, Level.FINEST, $$$methodRef$$$16, "T4C8Oall.initBindsDefinition for TIMESTAMP case scale: " + scale);
                        }
                        oac.setTimestampFractionalSecondsPrecision(scale == -1 ? (short)9 : scale);
                        int number_of_bound_rows = ((this.bindIndicators[this.bindIndicatorSubRange + 3] & 0xFFFF) << 16) + (this.bindIndicators[this.bindIndicatorSubRange + 4] & 0xFFFF);
                        if (number_of_bound_rows != 1) break;
                        int valueLengthOffset = ((l_bindIndicators[subRangeOffset + 7] & 0xFFFF) << 16) + (l_bindIndicators[subRangeOffset + 8] & 0xFFFF);
                        short valueLength = l_bindIndicators[valueLengthOffset];
                        int nullOffset = ((this.bindIndicators[subRangeOffset + 5] & 0xFFFF) << 16) + (this.bindIndicators[subRangeOffset + 6] & 0xFFFF);
                        boolean bl2 = isValueNull = l_bindIndicators[nullOffset] == -1;
                        if (isValueNull || valueLength == 7 && scale <= 0) {
                            oac.setTimestampFractionalSecondsPrecision((short)0);
                            break;
                        }
                        if (valueLength != 11) break;
                        oac.setTimestampFractionalSecondsPrecision((short)9);
                        break;
                    }
                    case 182: {
                        _oacmxl = l_bindIndicators[subRangeOffset + 1] & 0xFFFF;
                        oac.init((short)_oactype, _oacmxl);
                        oac.setFormOfUse(formOfUse);
                        oac.setCharset(formOfUse == 2 ? this.NCharSet : this.dbCharSet);
                        oac.setPrecision((short)9);
                        oac.addFlg2(0x8000000);
                        break;
                    }
                    case 183: {
                        _oacmxl = l_bindIndicators[subRangeOffset + 1] & 0xFFFF;
                        oac.init((short)_oactype, _oacmxl);
                        oac.setFormOfUse(formOfUse);
                        oac.setCharset(formOfUse == 2 ? this.NCharSet : this.dbCharSet);
                        oac.setPrecision((short)9);
                        oac.addFlg2(0x8000000);
                        oac.setScale((short)9);
                        break;
                    }
                    default: {
                        _oacmxl = l_bindIndicators[subRangeOffset + 1] & 0xFFFF;
                        if (_oacmxl == 0) {
                            _oacmxl = l_bindIndicators[subRangeOffset + 2] & 0xFFFF;
                            if (_oactype == 996) {
                                _oacmxl *= 2;
                            } else if (_oacmxl > 1) {
                                --_oacmxl;
                            }
                            if (formOfUse == 2) {
                                _oacmxl *= this.conversion.maxNCharSize;
                            }
                            if (this.typeOfStatement == OracleStatement.SqlKind.PLSQL_BLOCK || this.connection.versionNumber >= 10200 && this.typeOfStatement == OracleStatement.SqlKind.CALL_BLOCK) {
                                _oacmxl = _oacmxl == 0 ? this.connection.maxVcsBytesPlsql : (_oacmxl *= this.conversion.sMaxCharSize);
                            } else if (this.typeOfStatement == OracleStatement.SqlKind.CALL_BLOCK) {
                                if (_oacmxl < 4001) {
                                    _oacmxl = 4001;
                                }
                            } else if (formOfUse != 2) {
                                int t4MaxLength = this.connection.maxVarcharLength;
                                _oacmxl = ((T4CConnection)this.oracleStatement.connection).retainV9BindBehavior && _oacmxl <= t4MaxLength ? Math.min(_oacmxl * this.conversion.sMaxCharSize, t4MaxLength) : (_oacmxl *= this.conversion.sMaxCharSize);
                            }
                            if (_oacmxl == 0 && this.bindUseDBA && this.bindDataLengths[P] > 0) {
                                _oacmxl = this.bindDataLengths[P];
                            }
                            if (_oacmxl == 0) {
                                _oacmxl = 32;
                            }
                        }
                        oac.init((short)_oactype, _oacmxl);
                        oac.setFormOfUse(formOfUse);
                        oac.setCharset(formOfUse == 2 ? this.NCharSet : this.dbCharSet);
                    }
                }
                if (this.oracleStatement.parameterMaxLength != null && this.oracleStatement.parameterMaxLength[P] > _oacmxl) {
                    oac.init((short)_oactype, this.oracleStatement.parameterMaxLength[P]);
                }
                if (oacdefArr[P] != null && oac.isOldSufficient(oacdefArr[P])) continue;
                oacdefArr[P] = oac;
                needToUpdateDefinition = true;
            }
            if (this.oracleStatement.parameterMaxLength != null) {
                this.oracleStatement.parameterMaxLength = null;
            }
            if (needToUpdateDefinition) {
                this.oracleStatement.nbPostPonedColumns[0] = 0;
            }
            boolean bl3 = needToUpdateDefinition;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, T4C8Oall.class, $$$methodRef$$$16, this, bl3);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, T4C8Oall.class, $$$methodRef$$$16, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, T4C8Oall.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    void initDefinesDefinition() throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, T4C8Oall.class, $$$methodRef$$$17, this, new Object[0]);
            }
            this.defCols = 0;
            for (int i2 = 0; i2 < this.definedColumnType.length && this.definedColumnType[i2] != 0; ++i2) {
                ++this.defCols;
            }
            this.oacdefDefines = new T4CTTIoac[this.defCols];
            int flg2 = 0;
            int maxLength = 0;
            int oacmxlc = 0;
            short internalType = 0;
            for (int i3 = 0; i3 < this.oacdefDefines.length; ++i3) {
                this.oacdefDefines[i3] = new T4CTTIoac(this.connection);
                internalType = (short)this.oracleStatement.getInternalType(this.definedColumnType[i3]);
                maxLength = Integer.MAX_VALUE;
                flg2 = 0;
                oacmxlc = 0;
                short formOfUse = 1;
                if (this.definedColumnFormOfUse != null && this.definedColumnFormOfUse.length > i3 && this.definedColumnFormOfUse[i3] == 2) {
                    formOfUse = 2;
                }
                if (internalType == 8) {
                    internalType = 1;
                } else if (internalType == 24) {
                    internalType = (short)23;
                } else if (internalType == 1 || internalType == 96) {
                    internalType = 1;
                    maxLength = this.connection.maxVarcharLength * this.conversion.sMaxCharSize;
                    if (this.definedColumnSize != null && this.definedColumnSize.length > i3 && this.definedColumnSize[i3] > 0) {
                        maxLength = this.definedColumnSize[i3] * this.conversion.sMaxCharSize;
                    }
                } else if (this.connection.useLobPrefetch && (internalType == 113 || internalType == 112 || internalType == 114)) {
                    maxLength = 0;
                    flg2 = 0x2000000;
                    if (this.definedColumnSize != null && this.definedColumnSize.length > i3 && this.definedColumnSize[i3] > 0) {
                        oacmxlc = this.definedColumnSize[i3];
                    }
                } else if (internalType == 23) {
                    maxLength = this.connection.maxRawLength;
                }
                this.oacdefDefines[i3].init(internalType, maxLength);
                this.oacdefDefines[i3].addFlg2(flg2);
                this.oacdefDefines[i3].setMxlc(oacmxlc);
                this.oacdefDefines[i3].setFormOfUse(formOfUse);
                this.oacdefDefines[i3].setCharset(formOfUse == 2 ? this.NCharSet : this.dbCharSet);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, T4C8Oall.class, $$$methodRef$$$17, this);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, T4C8Oall.class, $$$methodRef$$$17, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, T4C8Oall.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void marshalBindsTypes(T4CTTIoac[] t4CTTIoacArray) throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void oac;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, T4C8Oall.class, $$$methodRef$$$18, this, new Object[]{t4CTTIoacArray});
            }
            if (oac == null) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, T4C8Oall.class, $$$methodRef$$$18, this);
                    ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, T4C8Oall.class, $$$methodRef$$$18, this, null);
                }
                return;
            }
            for (int i2 = 0; i2 < ((void)oac).length; ++i2) {
                oac[i2].marshal();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, T4C8Oall.class, $$$methodRef$$$18, this);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, T4C8Oall.class, $$$methodRef$$$18, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, T4C8Oall.class, $$$methodRef$$$18, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    Vector<IOException> marshalBinds(int[] nArray, boolean bl) throws IOException {
        boolean bl2 = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean sendFirstPostPonedColumnOnly;
            int rowId;
            void processingSLG;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, T4C8Oall.class, $$$methodRef$$$19, this, nArray, bl);
            }
            Vector<IOException> ioExceptionsFromUserStream = null;
            int number_of_bound_rows = ((this.bindIndicators[this.bindIndicatorSubRange + 3] & 0xFFFF) << 16) + (this.bindIndicators[this.bindIndicatorSubRange + 4] & 0xFFFF);
            if (processingSLG != false) {
                rowId = this.rxh.iterNum;
                sendFirstPostPonedColumnOnly = true;
            } else {
                rowId = 0;
                sendFirstPostPonedColumnOnly = false;
            }
            while (rowId < number_of_bound_rows) {
                void oacmxlArr;
                int parameterIndex = this.oracleStatement.firstRowInBatch + rowId;
                InputStream[] streamParameters = null;
                if (this.parameterStream != null) {
                    streamParameters = this.parameterStream[parameterIndex];
                }
                Vector<IOException> ioExceptionsFromUserStreamForThisRow = this.rxd.marshal(this.bindBytes, this.bindChars, this.bindIndicators, this.bindIndicatorSubRange, this.tmpBindsByteArray, this.conversion, streamParameters, this.ibtBindBytes, this.ibtBindChars, this.ibtBindIndicators, null, rowId, (int[])oacmxlArr, this.plsql, this.oracleStatement.returnParamMeta, this.oracleStatement.nbPostPonedColumns, this.oracleStatement.indexOfPostPonedColumn, sendFirstPostPonedColumnOnly, this.bindData, this.bindDataOffsets, this.bindDataLengths, this.bindUseDBA);
                sendFirstPostPonedColumnOnly = false;
                if (ioExceptionsFromUserStreamForThisRow != null) {
                    if (ioExceptionsFromUserStream == null) {
                        ioExceptionsFromUserStream = new Vector<IOException>();
                    }
                    ioExceptionsFromUserStream.addAll(ioExceptionsFromUserStreamForThisRow);
                }
                ++rowId;
            }
            Vector<IOException> vector = ioExceptionsFromUserStream;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, T4C8Oall.class, $$$methodRef$$$19, this, vector);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, T4C8Oall.class, $$$methodRef$$$19, this, null);
            }
            return vector;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, T4C8Oall.class, $$$methodRef$$$19, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    long setOptions(boolean bl, boolean bl2, boolean bl3, boolean bl4) throws SQLException {
        boolean bl5 = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void doFetch;
            void doExecute;
            void doParse;
            block22: {
                long options;
                block24: {
                    block23: {
                        block21: {
                            if (bl5) {
                                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, T4C8Oall.class, $$$methodRef$$$20, this, bl, bl2, bl3, bl4);
                            }
                            options = 0L;
                            if (doParse == false || doExecute != false || doFetch != false) break block21;
                            options |= 1L;
                            break block22;
                        }
                        if (doParse == false || doExecute == false || doFetch != false) break block23;
                        options = 32801L;
                        break block22;
                    }
                    if (doExecute == false || doFetch == false) break block24;
                    if (doParse != false) {
                        options |= 1L;
                    }
                    switch (this.typeOfStatement) {
                        case SELECT_FOR_UPDATE: 
                        case SELECT: {
                            options |= 0x8060L;
                            break block22;
                        }
                        case PLSQL_BLOCK: 
                        case CALL_BLOCK: {
                            if (this.numberOfBindPositions > 0) {
                                options |= 0x420L | (long)(this.oracleStatement.connection.autocommit ? 256 : 0);
                                if (this.sendBindsDefinition) {
                                    options |= 8L;
                                }
                            } else {
                                options |= 0x20L | (long)(this.oracleStatement.connection.autocommit ? 256 : 0);
                            }
                            break block22;
                        }
                        case DELETE: 
                        case INSERT: 
                        case MERGE: 
                        case UPDATE: 
                        case ALTER_SESSION: 
                        case OTHER: {
                            options = this.oracleStatement.isDmlReturning ? (options |= 0x420L | (long)(this.oracleStatement.connection.autocommit ? 256 : 0)) : (options |= 0x8020L | (long)(this.oracleStatement.connection.autocommit ? 256 : 0));
                            break block22;
                        }
                        default: {
                            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 432).fillInStackTrace();
                            if (bl5) {
                                ClioSupport.throwing($$$loggerRef$$$20, Level.FINEST, T4C8Oall.class, $$$methodRef$$$20, this, sQLException);
                            }
                            throw sQLException;
                        }
                    }
                }
                if (doParse == false && doExecute == false && doFetch != false) {
                    options = 32832L;
                } else {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 432).fillInStackTrace();
                    if (bl5) {
                        ClioSupport.throwing($$$loggerRef$$$20, Level.FINEST, T4C8Oall.class, $$$methodRef$$$20, this, sQLException);
                    }
                    throw sQLException;
                }
            }
            if (!this.typeOfStatement.isPlsqlOrCall()) {
                void doDefine;
                if ((doParse != false || doExecute != false || doFetch == false) && this.numberOfBindPositions > 0 && this.sendBindsDefinition) {
                    options |= 8L;
                }
                if (this.connection.versionNumber >= 9000 && doDefine != false && this.typeOfStatement.isSELECT()) {
                    options |= 0x10L;
                }
            }
            long l2 = options &= 0xFFFFFFFFFFFFFFFFL;
            if (bl5) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, T4C8Oall.class, $$$methodRef$$$20, this, l2);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, T4C8Oall.class, $$$methodRef$$$20, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl5) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, T4C8Oall.class, $$$methodRef$$$20, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, T4C8Oall.class, $$$methodRef$$$21, this, new Object[0]);
            }
            T4CConnection t4CConnection = this.connection;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, T4C8Oall.class, $$$methodRef$$$21, this, t4CConnection);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, T4C8Oall.class, $$$methodRef$$$21, this, null);
            }
            return t4CConnection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, T4C8Oall.class, $$$methodRef$$$21, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Log
    protected void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, this.getClass(), method, msg);
    }

    static {
        try {
            $$$methodRef$$$22 = T4C8Oall.class.getDeclaredConstructor(T4CConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = T4C8Oall.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = T4C8Oall.class.getDeclaredMethod("setOptions", Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = T4C8Oall.class.getDeclaredMethod("marshalBinds", int[].class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = T4C8Oall.class.getDeclaredMethod("marshalBindsTypes", T4CTTIoac[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = T4C8Oall.class.getDeclaredMethod("initDefinesDefinition", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = T4C8Oall.class.getDeclaredMethod("initBindsDefinition", T4CTTIoac[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = T4C8Oall.class.getDeclaredMethod("marshalPisdef", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = T4C8Oall.class.getDeclaredMethod("marshal", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = T4C8Oall.class.getDeclaredMethod("getNumRows", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = T4C8Oall.class.getDeclaredMethod("continueReadRow", Integer.TYPE, OracleStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = T4C8Oall.class.getDeclaredMethod("getCursorId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = T4C8Oall.class.getDeclaredMethod("processError", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = T4C8Oall.class.getDeclaredMethod("readIMPLRES", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = T4C8Oall.class.getDeclaredMethod("readRSH", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = T4C8Oall.class.getDeclaredMethod("readDCB", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = T4C8Oall.class.getDeclaredMethod("readRPA", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = T4C8Oall.class.getDeclaredMethod("readRXD", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = T4C8Oall.class.getDeclaredMethod("processSLG", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = T4C8Oall.class.getDeclaredMethod("readRXH", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T4C8Oall.class.getDeclaredMethod("readIOV", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T4C8Oall.class.getDeclaredMethod("readBVC", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T4C8Oall.class.getDeclaredMethod("doOALL", Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, OracleStatement.SqlKind.class, Integer.TYPE, byte[].class, Integer.TYPE, Accessor[].class, Integer.TYPE, Accessor[].class, Integer.TYPE, byte[].class, char[].class, short[].class, Integer.TYPE, DBConversion.class, byte[].class, InputStream[][].class, OracleStatement.class, byte[].class, char[].class, short[].class, T4CTTIoac[].class, int[].class, int[].class, int[].class, NTFDCNRegistration.class, ByteArray.class, long[].class, int[].class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        EMPTY_BYTES = new byte[0];
        NLS_KEYS = new String[]{"AUTH_NLS_LXCCURRENCY", "AUTH_NLS_LXCISOCURR", "AUTH_NLS_LXCNUMERICS", null, null, null, null, "AUTH_NLS_LXCDATEFM", "AUTH_NLS_LXCDATELANG", "AUTH_NLS_LXCTERRITORY", "SESSION_NLS_LXCCHARSET", "AUTH_NLS_LXCSORT", "AUTH_NLS_LXCCALENDAR", null, null, null, "AUTH_NLS_LXLAN", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "AUTH_NLS_LXNLSCOMP", null, "AUTH_NLS_LXCUNIONCUR", null, null, null, null, "AUTH_NLS_LXCTIMEFM", "AUTH_NLS_LXCSTMPFM", "AUTH_NLS_LXCTTZNFM", "AUTH_NLS_LXCSTZNFM", "SESSION_NLS_LXCNLSLENSEM", "SESSION_NLS_LXCNCHAREXCP", "SESSION_NLS_LXCNCHARIMP"};
    }
}

