/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.pool.OracleConnectionPoolDataSource;
import oracle.jdbc.pool.OracleDataSource;
import oracle.jdbc.pool.OracleOCIConnectionPool;
import oracle.jdbc.xa.client.OracleXADataSource;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.CONN_POOL})
public class OracleDataSourceFactory
implements ObjectFactory {
    private static final String CONNECTION_CACHING_ENABLED = "connectionCachingEnabled";
    private static final String CONNECTION_CACHE_NAME = "connectionCacheName";
    private static final String CONNECTION_CACHE_PROPERTIES = "connectionCacheProperties";
    private static final String CONNECTION_PROPERTIES = "connectionProperties";
    private static final String FAST_CONNECTION_FAILOVER_ENABLED = "fastConnectionFailoverEnabled";
    private static final String ONS_CONFIG_STR = "onsConfigStr";
    private static final String ORACLE_CONN_DATA_POOL_SOURCE = "oracle.jdbc.pool.OracleConnectionPoolDataSource";
    private static final String ORACLE_OCI_CONN_POOL = "oracle.jdbc.pool.OracleOCIConnectionPool";
    private static final String ORACLE_DATA_SOURCE = "oracle.jdbc.pool.OracleDataSource";
    private static final String ORACLE_XA_DATA_SOURCE = "oracle.jdbc.xa.client.OracleXADataSource";
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;

    public OracleDataSourceFactory() {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, OracleDataSourceFactory.class, $$$methodRef$$$4, null, new Object[0]);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleDataSourceFactory.class, $$$methodRef$$$4, null);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleDataSourceFactory.class, $$$methodRef$$$4, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleDataSourceFactory.class, $$$methodRef$$$4, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            StringRefAddr st;
            void refObj;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleDataSourceFactory.class, $$$methodRef$$$0, this, object, name, context, hashtable);
            }
            Reference ref = (Reference)refObj;
            OracleDataSource ods = null;
            String cn = ref.getClassName();
            Properties info = new Properties();
            if (cn.equals(ORACLE_DATA_SOURCE) || cn.equals(ORACLE_XA_DATA_SOURCE)) {
                String isFailoverEnabled;
                Properties props;
                String val;
                String isCacheEnabled;
                ods = cn.equals(ORACLE_DATA_SOURCE) ? new OracleDataSource() : new OracleXADataSource();
                st = null;
                st = (StringRefAddr)ref.get(CONNECTION_CACHING_ENABLED);
                if (st != null && (isCacheEnabled = (String)st.getContent()).equals(String.valueOf("true"))) {
                    ods.setConnectionCachingEnabled(true);
                }
                if ((st = (StringRefAddr)ref.get(CONNECTION_CACHE_NAME)) != null) {
                    ods.setConnectionCacheName((String)st.getContent());
                }
                if ((st = (StringRefAddr)ref.get(CONNECTION_CACHE_PROPERTIES)) != null) {
                    val = (String)st.getContent();
                    props = this.extractConnectionCacheProperties(val);
                    ods.setConnectionCacheProperties(props);
                }
                if ((st = (StringRefAddr)ref.get(CONNECTION_PROPERTIES)) != null) {
                    val = (String)st.getContent();
                    props = this.extractConnectionProperties(val);
                    ods.setConnectionProperties(props);
                }
                if ((st = (StringRefAddr)ref.get(FAST_CONNECTION_FAILOVER_ENABLED)) != null && (isFailoverEnabled = (String)st.getContent()).equals(String.valueOf("true"))) {
                    ods.setFastConnectionFailoverEnabled(true);
                }
                if ((st = (StringRefAddr)ref.get(ONS_CONFIG_STR)) != null) {
                    ods.setONSConfiguration((String)st.getContent());
                }
            } else if (cn.equals(ORACLE_CONN_DATA_POOL_SOURCE)) {
                ods = new OracleConnectionPoolDataSource();
            } else if (cn.equals(ORACLE_OCI_CONN_POOL)) {
                ods = new OracleOCIConnectionPool();
                String pn_conn_min_limit = null;
                String pn_conn_max_limit = null;
                String pn_conn_increment = null;
                String pn_conn_active_size = null;
                String pn_conn_pool_size = null;
                String pn_conn_timeout = null;
                String pn_conn_nowait = null;
                StringRefAddr st2 = null;
                Object pn = null;
                String pn_txn_dist = null;
                st2 = (StringRefAddr)ref.get("connpool_min_limit");
                if (st2 != null) {
                    pn_conn_min_limit = (String)st2.getContent();
                }
                if ((st2 = (StringRefAddr)ref.get("connpool_max_limit")) != null) {
                    pn_conn_max_limit = (String)st2.getContent();
                }
                if ((st2 = (StringRefAddr)ref.get("connpool_increment")) != null) {
                    pn_conn_increment = (String)st2.getContent();
                }
                if ((st2 = (StringRefAddr)ref.get("connpool_active_size")) != null) {
                    pn_conn_active_size = (String)st2.getContent();
                }
                if ((st2 = (StringRefAddr)ref.get("connpool_pool_size")) != null) {
                    pn_conn_pool_size = (String)st2.getContent();
                }
                if ((st2 = (StringRefAddr)ref.get("connpool_timeout")) != null) {
                    pn_conn_timeout = (String)st2.getContent();
                }
                if ((st2 = (StringRefAddr)ref.get("connpool_nowait")) != null) {
                    pn_conn_nowait = (String)st2.getContent();
                }
                if ((st2 = (StringRefAddr)ref.get("transactions_distributed")) != null) {
                    pn_txn_dist = (String)st2.getContent();
                }
                info.put("connpool_min_limit", pn_conn_min_limit);
                info.put("connpool_max_limit", pn_conn_max_limit);
                info.put("connpool_increment", pn_conn_increment);
                info.put("connpool_active_size", pn_conn_active_size);
                info.put("connpool_pool_size", pn_conn_pool_size);
                info.put("connpool_timeout", pn_conn_timeout);
                if (pn_conn_nowait == "true") {
                    info.put("connpool_nowait", pn_conn_nowait);
                }
                if (pn_txn_dist == "true") {
                    info.put("transactions_distributed", pn_txn_dist);
                }
            } else {
                Object var20_21 = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleDataSourceFactory.class, $$$methodRef$$$0, this, var20_21);
                    ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleDataSourceFactory.class, $$$methodRef$$$0, this, null);
                }
                return null;
            }
            if (ods != null) {
                st = null;
                st = (StringRefAddr)ref.get("url");
                if (st != null) {
                    ods.setURL((String)st.getContent());
                }
                if ((st = (StringRefAddr)ref.get("userName")) != null || (st = (StringRefAddr)ref.get("u")) != null || (st = (StringRefAddr)ref.get("user")) != null) {
                    ods.setUser((String)st.getContent());
                }
                if ((st = (StringRefAddr)ref.get("passWord")) != null || (st = (StringRefAddr)ref.get("password")) != null) {
                    ods.setPassword((String)st.getContent());
                }
                if ((st = (StringRefAddr)ref.get("description")) != null || (st = (StringRefAddr)ref.get("describe")) != null) {
                    ods.setDescription((String)st.getContent());
                }
                if ((st = (StringRefAddr)ref.get("driverType")) != null || (st = (StringRefAddr)ref.get("driver")) != null) {
                    ods.setDriverType((String)st.getContent());
                }
                if ((st = (StringRefAddr)ref.get("serverName")) != null || (st = (StringRefAddr)ref.get("host")) != null) {
                    ods.setServerName((String)st.getContent());
                }
                if ((st = (StringRefAddr)ref.get("databaseName")) != null || (st = (StringRefAddr)ref.get("sid")) != null) {
                    ods.setDatabaseName((String)st.getContent());
                }
                if ((st = (StringRefAddr)ref.get("serviceName")) != null) {
                    ods.setServiceName((String)st.getContent());
                }
                if ((st = (StringRefAddr)ref.get("networkProtocol")) != null || (st = (StringRefAddr)ref.get("protocol")) != null) {
                    ods.setNetworkProtocol((String)st.getContent());
                }
                if ((st = (StringRefAddr)ref.get("portNumber")) != null || (st = (StringRefAddr)ref.get("port")) != null) {
                    String pn = (String)st.getContent();
                    ods.setPortNumber(Integer.parseInt(pn));
                }
                if ((st = (StringRefAddr)ref.get("tnsentryname")) != null || (st = (StringRefAddr)ref.get("tns")) != null) {
                    ods.setTNSEntryName((String)st.getContent());
                } else if (cn.equals(ORACLE_OCI_CONN_POOL)) {
                    String pn_is_poolCreated = null;
                    st = (StringRefAddr)ref.get("connpool_is_poolcreated");
                    if (st != null) {
                        pn_is_poolCreated = (String)st.getContent();
                    }
                    if ("true".equals(pn_is_poolCreated)) {
                        ((OracleOCIConnectionPool)ods).setPoolConfig(info);
                    }
                }
            }
            OracleDataSource oracleDataSource = ods;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleDataSourceFactory.class, $$$methodRef$$$0, this, oracleDataSource);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleDataSourceFactory.class, $$$methodRef$$$0, this, null);
            }
            return oracleDataSource;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleDataSourceFactory.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties extractConnectionCacheProperties(String string) throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            StringTokenizer strTokens2;
            String val;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleDataSourceFactory.class, $$$methodRef$$$1, this, string);
            }
            Properties cprops = new Properties();
            int awIdx = (val = val.substring(1, val.length() - 1)).indexOf("AttributeWeights", 0);
            if (awIdx >= 0) {
                StringTokenizer strTokens1;
                if (val.charAt(awIdx + 16) != '=' || awIdx > 0 && val.charAt(awIdx - 1) != ' ') {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(139).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, OracleDataSourceFactory.class, $$$methodRef$$$1, this, sQLException);
                    }
                    throw sQLException;
                }
                Properties awProps = new Properties();
                int awLastIdx = val.indexOf("}", awIdx);
                String tmpawStr = val.substring(awIdx, awLastIdx);
                String awStr = tmpawStr.substring(18);
                StringTokenizer stringTokenizer = strTokens1 = new StringTokenizer(awStr, ", ");
                synchronized (stringTokenizer) {
                    try {
                        while (strTokens1.hasMoreTokens()) {
                            String strTkn = strTokens1.nextToken();
                            int len = strTkn.length();
                            int equalsIndex = strTkn.indexOf("=");
                            String key = strTkn.substring(0, equalsIndex);
                            String value = strTkn.substring(equalsIndex + 1, len);
                            awProps.setProperty(key, value);
                        }
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT @DISABLED, blocks:[0, 4, 5, 21] lbl32 : MonitorExitStatement: MONITOREXIT : var9_17
                        Throwable throwable2 = throwable;
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, OracleDataSourceFactory.class, $$$methodRef$$$1, this, throwable2);
                        }
                        throw throwable2;
                    }
                }
                cprops.put("AttributeWeights", awProps);
                if (awIdx > 0 && awLastIdx + 1 == val.length()) {
                    val = val.substring(0, awIdx - 2);
                } else if (awIdx > 0 && awLastIdx + 1 < val.length()) {
                    String valA = val.substring(0, awIdx - 2);
                    String valB = val.substring(awLastIdx + 1, val.length());
                    val = valA.concat(valB);
                } else {
                    val = val.substring(awLastIdx + 2, val.length());
                }
            }
            StringTokenizer stringTokenizer = strTokens2 = new StringTokenizer(val, ", ");
            synchronized (stringTokenizer) {
                try {
                    while (strTokens2.hasMoreTokens()) {
                        String strTkn = strTokens2.nextToken();
                        int len = strTkn.length();
                        int equalsIndex = strTkn.indexOf("=");
                        String key = strTkn.substring(0, equalsIndex);
                        String value = strTkn.substring(equalsIndex + 1, len);
                        cprops.setProperty(key, value);
                    }
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 3, 6] lbl63 : MonitorExitStatement: MONITOREXIT : var5_11
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, OracleDataSourceFactory.class, $$$methodRef$$$1, this, throwable3);
                    }
                    throw throwable3;
                }
            }
            Properties properties = cprops;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleDataSourceFactory.class, $$$methodRef$$$1, this, properties);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleDataSourceFactory.class, $$$methodRef$$$1, this, null);
            }
            return properties;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleDataSourceFactory.class, $$$methodRef$$$1, this, throwable4);
            }
            throw throwable;
        }
    }

    private Properties extractConnectionProperties(String string) throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            String[] tokens;
            String val;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OracleDataSourceFactory.class, $$$methodRef$$$2, this, string);
            }
            Properties cprops = new Properties();
            val = val.substring(1, val.length() - 1);
            for (String strTkn : tokens = val.split(";")) {
                int len = strTkn.length();
                int equalsIndex = strTkn.indexOf("=");
                if (len == 0 || equalsIndex <= 0) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(190).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, OracleDataSourceFactory.class, $$$methodRef$$$2, this, sQLException);
                    }
                    throw sQLException;
                }
                String key = strTkn.substring(0, equalsIndex);
                String value = strTkn.substring(equalsIndex + 1, len);
                cprops.setProperty(key.trim(), value.trim());
            }
            Properties properties = cprops;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleDataSourceFactory.class, $$$methodRef$$$2, this, properties);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleDataSourceFactory.class, $$$methodRef$$$2, this, null);
            }
            return properties;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleDataSourceFactory.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OracleDataSourceFactory.class, $$$methodRef$$$3, this, new Object[0]);
            }
            OracleConnection oracleConnection = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleDataSourceFactory.class, $$$methodRef$$$3, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleDataSourceFactory.class, $$$methodRef$$$3, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleDataSourceFactory.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$4 = OracleDataSourceFactory.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleDataSourceFactory.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleDataSourceFactory.class.getDeclaredMethod("extractConnectionProperties", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleDataSourceFactory.class.getDeclaredMethod("extractConnectionCacheProperties", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleDataSourceFactory.class.getDeclaredMethod("getObjectInstance", Object.class, Name.class, Context.class, Hashtable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

