/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.ACProxyable;
import oracle.jdbc.internal.AdditionalDatabaseMetaData;
import oracle.jdbc.internal.ClientDataSupport;
import oracle.jdbc.internal.OracleConcreteProxy;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleParameterMetaData;
import oracle.jdbc.internal.OracleResultSetMetaData;
import oracle.jdbc.internal.OracleRowId;
import oracle.jdbc.internal.OracleSavepoint;
import oracle.jdbc.internal.OracleTypeMetaData;
import oracle.jdbc.internal.ReplayContext;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyAccess;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.jdbc.replay.ReplayableConnection;
import oracle.jdbc.replay.driver.JDBCReplayable;
import oracle.jdbc.replay.driver.TxnFailoverManagerImpl;

@ProxyFor(value={AdditionalDatabaseMetaData.class, ClientDataSupport.class, OracleParameterMetaData.class, OracleRowId.class, OracleSavepoint.class, OracleTypeMetaData.class, OracleTypeMetaData.Array.class, OracleTypeMetaData.Opaque.class, OracleTypeMetaData.Struct.class, OracleResultSetMetaData.class})
@ProxyAccess(value=ACProxyable.class)
@DefaultLogger(value="oracle.jdbc.internal.replay")
@Supports(value={Feature.APPLICATION_CONTINUITY})
public abstract class TxnReplayableBase
implements JDBCReplayable {
    protected TxnFailoverManagerImpl failoverMngr;
    protected TxnFailoverManagerImpl.CallHistoryEntry headSameProxy;
    protected TxnFailoverManagerImpl.CallHistoryEntry tailSameProxy;
    protected TxnFailoverManagerImpl.CallHistoryEntry replayingCallEntry;
    protected SQLRecoverableException originalError;
    protected static final int SPECIAL_SVR_RECOVERABLE_ERROR = 603;
    protected static final int TXN_IN_READONLY_REPLAY_ERROR = 29791;
    protected static final int SET_CONTAINER_AFTER_PREPARE = 44787;
    protected static final int SVR_NO_REPLAY_ERROR_CODE = 45;
    protected boolean isClosedAndNoReplay;
    protected boolean isLogicallyClosed;
    protected boolean abortCalledBeforeLatestClose;
    protected boolean isCreatingCallReplayable;
    protected boolean isCurrentExecuteReplayable;
    protected boolean isProxyReplayable;
    protected TxnFailoverManagerImpl.CallHistoryEntry creatorCallEntry;
    protected long currentBindChecksum;
    private static final String PROXY_CLASS_SUFFIX = "$$$Proxy";
    protected String thisProxyNameInLog;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;

    protected TxnReplayableBase() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$20, null, new Object[0]);
            }
            this.headSameProxy = null;
            this.tailSameProxy = null;
            this.replayingCallEntry = null;
            this.originalError = null;
            this.isClosedAndNoReplay = false;
            this.isLogicallyClosed = false;
            this.abortCalledBeforeLatestClose = false;
            this.isCreatingCallReplayable = true;
            this.isCurrentExecuteReplayable = true;
            this.isProxyReplayable = true;
            this.creatorCallEntry = null;
            this.currentBindChecksum = 0L;
            this.thisProxyNameInLog = "";
            StringBuffer strBuf = new StringBuffer(this.getClass().getName());
            int idx = strBuf.indexOf(PROXY_CLASS_SUFFIX);
            strBuf.delete(0, idx);
            strBuf.append("@");
            strBuf.append(Integer.toHexString(this.hashCode()));
            this.thisProxyNameInLog = strBuf.toString();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$20, null);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$20, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$20, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Pre
    protected void preForAll(Method method, Object object, Object ... objectArray) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$0, this, method, object, objectArray);
            }
            TxnFailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
            switch (lifecycle) {
                case ENABLED_NOT_REPLAYING: {
                    void args;
                    void m2;
                    this.failoverMngr.acStatistics.incrementTotalCalls();
                    this.failoverMngr.record(this, (Method)m2, (Object[])args, "started");
                    break;
                }
                case INTERNALLY_FAILED: 
                case ALWAYS_DISABLED: 
                case INTERNALLY_DISABLED: 
                case EXTERNALLY_DISABLED: {
                    this.failoverMngr.acStatistics.incrementTotalCalls();
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Post
    protected void postForAll(Method method) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void m2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$1, this, method);
            }
            this.postForAll((Method)m2, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Post
    protected Object postForAll(Method method, Object object) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void result;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$2, this, method, object);
            }
            if (result instanceof TxnReplayableBase) {
                TxnReplayableBase jdbcProxy = (TxnReplayableBase)result;
                jdbcProxy.setFailoverManager(this.getFailoverManager());
            }
            TxnFailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
            switch (lifecycle) {
                case ENABLED_NOT_REPLAYING: 
                case REPLAYING_LASTCALL: {
                    void m2;
                    this.doPostWhenRecording((Method)m2, result, null);
                    break;
                }
                case INTERNALLY_FAILED: 
                case ALWAYS_DISABLED: 
                case INTERNALLY_DISABLED: 
                case EXTERNALLY_DISABLED: 
                case REPLAYING_CALLBACK: {
                    break;
                }
                case REPLAYING: {
                    void m2;
                    this.doPostWhenReplaying((Method)m2, result, null);
                }
            }
            void var5_5 = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$2, this, var5_5);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$2, this, null);
            }
            return var5_5;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void doPostWhenRecording(Method method, Object object, SQLException sQLException) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void sqlexc;
            void result;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$3, this, method, object, sQLException);
            }
            this.failoverMngr.update(this, null, result, "completed", this.currentBindChecksum, (SQLException)sqlexc);
            this.currentBindChecksum = 0L;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    protected void doPostWhenReplaying(Method method, Object object, SQLException sQLException) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$4, this, method, object, sQLException);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method method, SQLException sQLException) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void error;
            void m2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$5, this, method, sQLException);
            }
            this.onErrorForAll((Method)m2, (SQLException)error);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$5, this);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$5, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method method, SQLException sQLException) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            TxnFailoverManagerImpl.ReplayLifecycle lifecycle;
            SQLException error;
            void m2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$6, this, method, sQLException);
            }
            TxnReplayableBase connProxy = (TxnReplayableBase)this.failoverMngr.getConnectionProxy();
            OracleConnection oconn = (OracleConnection)connProxy.getDelegate();
            connProxy.abortCalledBeforeLatestClose = false;
            if (connProxy.isClosedAndNoReplay) {
                if (bl) {
                    OracleLog.log($$$loggerRef$$$6, Level.WARNING, this.getClass(), $$$methodRef$$$6, "On {0}, method {1} hit outage, NO replay because there was a mid-request close() call earlier", new Object[]{connProxy.thisProxyNameInLog, m2.getName()});
                }
                void var8_6 = error;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$6, this, (Throwable)var8_6);
                }
                throw var8_6;
            }
            if (oconn.isClosed() && oconn.isSafelyClosed()) {
                if (bl) {
                    OracleLog.log($$$loggerRef$$$6, Level.WARNING, this.getClass(), $$$methodRef$$$6, "On {0}, method {1} hit outage, NO replay because the connection has been safely closed for RAC planned-maintenance", new Object[]{connProxy.thisProxyNameInLog, m2.getName()});
                }
                void var8_7 = error;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$6, this, (Throwable)var8_7);
                }
                throw var8_7;
            }
            if (error instanceof BatchUpdateException) {
                SQLException nextExc;
                if (bl) {
                    OracleLog.log($$$loggerRef$$$6, Level.FINER, this.getClass(), $$$methodRef$$$6, "On {0}, method {1} hit BatchUpdateException", new Object[]{connProxy.thisProxyNameInLog, m2.getName()});
                }
                if ((nextExc = error.getNextException()) != null && nextExc instanceof SQLRecoverableException) {
                    error = nextExc;
                }
            }
            if (error instanceof SQLRecoverableException && !this.isLogicallyClosed) {
                if (!this.failoverMngr.isSessionStateConsistencyDynamic() && !this.isCreatingCallReplayable) {
                    if (bl) {
                        OracleLog.log($$$loggerRef$$$6, Level.WARNING, this.getClass(), $$$methodRef$$$6, "On {0}, method {1} hit outage, NO replay because this method is not replayable", new Object[]{connProxy.thisProxyNameInLog, m2.getName()});
                    }
                    this.failoverMngr.disableReplayAndThrowOriginalError((Method)m2, 372, "Replay disabled because of nonreplayable call", (SQLRecoverableException)error);
                }
                lifecycle = this.failoverMngr.getReplayLifecycle();
                switch (lifecycle) {
                    case ENABLED_NOT_REPLAYING: {
                        this.failoverMngr.update(this, null, null, "incomplete", this.currentBindChecksum, error);
                        this.currentBindChecksum = 0L;
                    }
                    case ALWAYS_DISABLED: 
                    case INTERNALLY_DISABLED: 
                    case EXTERNALLY_DISABLED: {
                        if (bl) {
                            OracleLog.log($$$loggerRef$$$6, Level.FINE, this.getClass(), $$$methodRef$$$6, "On {0}, method {1} hit outage", new Object[]{connProxy.thisProxyNameInLog, m2.getName()});
                        }
                        Object object = this.failoverMngr.handleOutage((Method)m2, (SQLRecoverableException)error);
                        if (bl) {
                            ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$6, this, object);
                            ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$6, this, null);
                        }
                        return object;
                    }
                    case REPLAYING_LASTCALL: {
                        this.failoverMngr.update(this, null, null, "incomplete", this.currentBindChecksum, error);
                        this.currentBindChecksum = 0L;
                    }
                }
                SQLException sQLException2 = error;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$6, this, sQLException2);
                }
                throw sQLException2;
            }
            if (error instanceof SQLRecoverableException && !this.failoverMngr.isSessionStateConsistencyDynamic() && !this.isCreatingCallReplayable) {
                if (bl) {
                    OracleLog.log($$$loggerRef$$$6, Level.WARNING, this.getClass(), $$$methodRef$$$6, "On {0}, method {1} hit outage, NO replay because this method is not replayable", new Object[]{connProxy.thisProxyNameInLog, m2.getName()});
                }
                this.failoverMngr.disableReplayAndThrowOriginalError((Method)m2, 372, "Replay disabled because of nonreplayable call", (SQLRecoverableException)error);
            }
            if (error instanceof SQLException && error.getErrorCode() == 45) {
                if (bl) {
                    OracleLog.log($$$loggerRef$$$6, Level.WARNING, this.getClass(), $$$methodRef$$$6, "On {0}, method {1} receives ORA-45 and replay is disabled", new Object[]{connProxy.thisProxyNameInLog, m2.getName()});
                }
                this.failoverMngr.disableReplayAndThrowSQLException((Method)m2, 398, "Replay disabled because server killed session with -noreplay option", error);
            }
            lifecycle = this.failoverMngr.getReplayLifecycle();
            switch (lifecycle) {
                case ENABLED_NOT_REPLAYING: 
                case REPLAYING_LASTCALL: {
                    this.doPostWhenRecording((Method)m2, null, error);
                    break;
                }
            }
            SQLException sQLException3 = error;
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$6, this, sQLException3);
            }
            throw sQLException3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="toString", args={})})
    protected void preForToString(Method method, Object object, Object ... objectArray) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$7, this, method, object, objectArray);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$7, this);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$7, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Post
    @Methods(signatures={@Signature(name="toString", args={})})
    protected String postForToString(Method method, String string) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void str;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$8, this, method, string);
            }
            void var4_4 = str;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$8, this, var4_4);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$8, this, null);
            }
            return var4_4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    @GetDelegate
    protected abstract Object getDelegate();

    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @GetCreator
    protected abstract Object getCreator();

    /*
     * WARNING - void declaration
     */
    @Override
    public Object replayOneCall(TxnFailoverManagerImpl.CallHistoryEntry callHistoryEntry, SQLRecoverableException sQLRecoverableException) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void origError;
            void entry;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$9, this, callHistoryEntry, sQLRecoverableException);
            }
            Object result = null;
            String proxyNameInLog = ((TxnReplayableBase)entry.jdbcProxy).thisProxyNameInLog;
            try {
                TxnFailoverManagerImpl.ReplayLifecycle _lifecycle;
                Object newResult;
                ((JDBCReplayable)entry.jdbcProxy).setReplayingCallContext((TxnFailoverManagerImpl.CallHistoryEntry)entry, (SQLRecoverableException)origError);
                if (entry.replayContext != null) {
                    TxnReplayableBase connProxy = (TxnReplayableBase)this.failoverMngr.getConnectionProxy();
                    OracleConnection oconn = (OracleConnection)connProxy.getDelegate();
                    oconn.setReplayContext(entry.replayContext);
                    for (ReplayContext thisReplayContext : entry.replayContext) {
                        if (thisReplayContext == null) {
                            if (!bl) continue;
                            OracleLog.log($$$loggerRef$$$9, Level.FINER, this.getClass(), $$$methodRef$$$9, "On {0}, server replay context set: NULL", proxyNameInLog);
                            continue;
                        }
                        if (!bl) continue;
                        OracleLog.log($$$loggerRef$$$9, Level.FINER, this.getClass(), $$$methodRef$$$9, "On {0}, server replay context set: NOT NULL", proxyNameInLog);
                    }
                }
                result = newResult = entry.method.invoke(entry.jdbcProxy, entry.args);
                if (newResult instanceof TxnReplayableBase) {
                    _lifecycle = this.failoverMngr.getReplayLifecycle();
                    if (_lifecycle == TxnFailoverManagerImpl.ReplayLifecycle.REPLAYING && newResult != null && entry.result != null) {
                        Object newDelegate = ((TxnReplayableBase)newResult).getDelegate();
                        ((TxnReplayableBase)entry.result).setDelegate(newDelegate);
                        result = entry.result;
                    }
                } else if (newResult instanceof OracleConcreteProxy && (_lifecycle = this.failoverMngr.getReplayLifecycle()) == TxnFailoverManagerImpl.ReplayLifecycle.REPLAYING && newResult != null && entry.result != null && entry.result instanceof OracleConcreteProxy) {
                    TxnReplayableBase newConcreteProxy = ((OracleConcreteProxy)newResult).getConcreteProxy();
                    TxnReplayableBase oldConcreteProxy = ((OracleConcreteProxy)entry.result).getConcreteProxy();
                    if (newConcreteProxy != null && oldConcreteProxy != null) {
                        Object newDelegate = newConcreteProxy.getDelegate();
                        oldConcreteProxy.setDelegate(newDelegate);
                        result = entry.result;
                    } else if (newConcreteProxy == null && oldConcreteProxy != null) {
                        oldConcreteProxy.setDelegate(newResult);
                        result = entry.result;
                    }
                }
            }
            catch (InvocationTargetException targetException) {
                SQLException nextExc;
                Throwable throwable = targetException.getCause();
                if (bl) {
                    OracleLog.log($$$loggerRef$$$9, Level.FINER, this.getClass(), $$$methodRef$$$9, "On {0}, replaying {1} got InvocationTargetException with cause: {2}", new Object[]{proxyNameInLog, entry.method.getName(), throwable});
                }
                if (throwable instanceof BatchUpdateException && (nextExc = ((BatchUpdateException)throwable).getNextException()) != null && nextExc instanceof SQLRecoverableException) {
                    throwable = nextExc;
                }
                if (throwable instanceof SQLRecoverableException && !this.isLogicallyClosed) {
                    int errCode;
                    SQLRecoverableException sqlrexc = (SQLRecoverableException)throwable;
                    Throwable t2 = sqlrexc.getCause();
                    if (t2 == null && (errCode = sqlrexc.getErrorCode()) == 603) {
                        if (sqlrexc.getMessage().indexOf("ORA-29791") != -1) {
                            if (bl) {
                                OracleLog.log($$$loggerRef$$$9, Level.WARNING, this.getClass(), $$$methodRef$$$9, "On {0}, replaying {1} receives ORA-603/ORA-29791", new Object[]{proxyNameInLog, entry.method.getName()});
                            }
                            origError.setNextException(sqlrexc);
                            this.failoverMngr.disableReplayAndThrowException(entry.method, 390, "Replay failed because of active transaction during replay", (SQLRecoverableException)origError);
                        } else if (sqlrexc.getMessage().indexOf("ORA-44787") != -1) {
                            if (bl) {
                                OracleLog.log($$$loggerRef$$$9, Level.WARNING, this.getClass(), $$$methodRef$$$9, "On {0}, replaying {1} receives ORA-603/ORA-44787", new Object[]{proxyNameInLog, entry.method.getName()});
                            }
                            origError.setNextException(sqlrexc);
                            this.failoverMngr.disableReplayAndThrowException(entry.method, 366, "Replay failed because of calling set container after PREPARE_REPLAY", (SQLRecoverableException)origError);
                        }
                    }
                    SQLRecoverableException sQLRecoverableException2 = sqlrexc;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$9, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$9, this, sQLRecoverableException2);
                    }
                    throw sQLRecoverableException2;
                }
                if (throwable instanceof SQLRecoverableException && this.isLogicallyClosed || throwable instanceof SQLException) {
                    SQLException sqlexc = (SQLException)throwable;
                    TxnFailoverManagerImpl.ReplayLifecycle _lifecycle = this.failoverMngr.getReplayLifecycle();
                    if (sqlexc.getErrorCode() == 17290) {
                        SQLException sQLException = sqlexc;
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$9, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$9, this, sQLException);
                        }
                        throw sQLException;
                    }
                    if (_lifecycle == TxnFailoverManagerImpl.ReplayLifecycle.INTERNALLY_DISABLED && this.failoverMngr.didReplayingLastCallDisableReplay) {
                        SQLException sQLException = sqlexc;
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$9, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$9, this, sQLException);
                        }
                        throw sQLException;
                    }
                    if (throwable instanceof SQLException && (entry.callException == null || sqlexc.getErrorCode() != entry.callException.getErrorCode())) {
                        origError.setNextException(sqlexc);
                        this.failoverMngr.disableReplayAndThrowException(entry.method, 389, "Replay failed because of error code or message mismatch", (SQLRecoverableException)origError);
                    } else if (_lifecycle == TxnFailoverManagerImpl.ReplayLifecycle.REPLAYING_LASTCALL) {
                        SQLException sQLException = sqlexc;
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$9, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$9, this, sQLException);
                        }
                        throw sQLException;
                    }
                } else {
                    this.failoverMngr.disableReplayAndThrowException(entry.method, 370, "Replay disabled", (SQLRecoverableException)origError);
                }
            }
            catch (Throwable otherThrowable) {
                if (bl) {
                    OracleLog.log($$$loggerRef$$$9, Level.FINER, this.getClass(), $$$methodRef$$$9, "On {0}, replaying {1} caught throwable: {2}", new Object[]{proxyNameInLog, entry.method.getName(), otherThrowable});
                }
                otherThrowable.printStackTrace();
                this.failoverMngr.disableReplayAndThrowException(entry.method, 370, "Replay disabled", (SQLRecoverableException)origError);
            }
            TxnFailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
            switch (lifecycle) {
                case INTERNALLY_FAILED: 
                case INTERNALLY_DISABLED: {
                    this.failoverMngr.throwReplayExceptionInternal(0, null, null);
                }
            }
            Object object = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$9, this, object);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$9, this, null);
            }
            return object;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addToSameProxyList(TxnFailoverManagerImpl.CallHistoryEntry callHistoryEntry) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void entry;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$10, this, callHistoryEntry);
            }
            entry.prevEntrySameProxy = this.tailSameProxy;
            entry.nextEntrySameProxy = null;
            if (this.tailSameProxy != null) {
                this.tailSameProxy.nextEntrySameProxy = entry;
            }
            this.tailSameProxy = entry;
            if (this.headSameProxy == null) {
                this.headSameProxy = entry;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$10, this);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$10, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeFromSameProxyList(TxnFailoverManagerImpl.CallHistoryEntry callHistoryEntry) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void entry;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$11, this, callHistoryEntry);
            }
            if (entry.nextEntrySameProxy != null) {
                entry.nextEntrySameProxy.prevEntrySameProxy = entry.prevEntrySameProxy;
            }
            if (entry.prevEntrySameProxy != null) {
                entry.prevEntrySameProxy.nextEntrySameProxy = entry.nextEntrySameProxy;
            }
            if (this.headSameProxy == entry) {
                this.headSameProxy = entry.nextEntrySameProxy;
            }
            if (this.tailSameProxy == entry) {
                this.tailSameProxy = entry.prevEntrySameProxy;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$11, this);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$11, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void purgeSameProxyList() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$12, this, new Object[0]);
            }
            if (this.failoverMngr != null) {
                HashSet<Object> visitedProxies = new HashSet<Object>();
                for (Object ancestor = this; ancestor != null && ancestor instanceof TxnReplayableBase && !(ancestor instanceof ReplayableConnection); ancestor = ((TxnReplayableBase)ancestor).getCreator()) {
                    visitedProxies.add(ancestor);
                }
                this.failoverMngr.purgeForSameProxy(visitedProxies, this.headSameProxy);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$12, this);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$12, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setReplayingCallContext(TxnFailoverManagerImpl.CallHistoryEntry callHistoryEntry, SQLRecoverableException sQLRecoverableException) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void origError;
            void entry;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$13, this, callHistoryEntry, sQLRecoverableException);
            }
            this.replayingCallEntry = entry;
            this.originalError = origError;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$13, this);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$13, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void setFailoverManager(TxnFailoverManagerImpl txnFailoverManagerImpl) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void mngr;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$14, this, txnFailoverManagerImpl);
            }
            this.failoverMngr = mngr;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$14, this);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$14, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized TxnFailoverManagerImpl getFailoverManager() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$15, this, new Object[0]);
            }
            TxnFailoverManagerImpl txnFailoverManagerImpl = this.failoverMngr;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$15, this, txnFailoverManagerImpl);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$15, this, null);
            }
            return txnFailoverManagerImpl;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    public void disableReplay() throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$16, this, new Object[0]);
            }
            if (this.failoverMngr != null) {
                this.failoverMngr.disableReplay();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$16, this);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$16, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isReplayFailure(Throwable throwable) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            int errCode;
            void t2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$17, this, throwable);
            }
            boolean result = false;
            if (t2 instanceof SQLException && (errCode = ((SQLException)t2).getErrorCode()) >= 370 && errCode < 400) {
                result = true;
            }
            boolean bl2 = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$17, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$17, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$17, this, throwable3);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected boolean assertThrowablesMatch(Throwable throwable, Throwable throwable2) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean doThrowablesMatch;
            void currentT;
            void originalT;
            boolean areSameType;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$18, this, throwable, throwable2);
            }
            boolean bl2 = areSameType = originalT == null ? false : currentT.getClass().getName().equals(originalT.getClass().getName());
            if (bl) {
                OracleLog.log($$$loggerRef$$$18, Level.FINEST, this.getClass(), $$$methodRef$$$18, "Errors at original execution and replay are of same type: {0}", areSameType);
            }
            if (currentT instanceof SQLException && areSameType) {
                boolean bl3 = doThrowablesMatch = ((SQLException)currentT).getErrorCode() == ((SQLException)originalT).getErrorCode();
                if (bl) {
                    OracleLog.log($$$loggerRef$$$18, Level.FINEST, this.getClass(), $$$methodRef$$$18, "Errors at original execution and replay are SQLException, error codes match: {0}", doThrowablesMatch);
                }
            } else if (areSameType) {
                String currentMesg = currentT.getMessage();
                String originalMesg = originalT.getMessage();
                boolean bl4 = doThrowablesMatch = currentMesg == null && originalMesg == null || currentMesg != null && originalMesg != null && currentT.getMessage().equals(originalT.getMessage());
                if (bl) {
                    OracleLog.log($$$loggerRef$$$18, Level.FINEST, this.getClass(), $$$methodRef$$$18, "Errors at original execution and replay are same type but not SQLException, error messages match: {0}", doThrowablesMatch);
                }
            } else {
                doThrowablesMatch = false;
            }
            if (bl) {
                OracleLog.log($$$loggerRef$$$18, Level.FINEST, this.getClass(), $$$methodRef$$$18, "Errors at original execution and replay match: {0}", doThrowablesMatch);
            }
            boolean bl5 = doThrowablesMatch;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$18, this, bl5);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$18, this, null);
            }
            return bl5;
        }
        catch (Throwable throwable3) {
            Throwable throwable4 = throwable3;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$18, this, throwable4);
            }
            throw throwable3;
        }
    }

    @DisableTrace
    public String toString() {
        return this.getDelegate().toString();
    }

    public Object getDelegateObj() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$19, this, new Object[0]);
            }
            Object object = this.getDelegate();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$19, this, object);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$19, this, null);
            }
            return object;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, TxnReplayableBase.class, $$$methodRef$$$19, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$20 = TxnReplayableBase.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$19 = TxnReplayableBase.class.getDeclaredMethod("getDelegateObj", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$18 = TxnReplayableBase.class.getDeclaredMethod("assertThrowablesMatch", Throwable.class, Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$17 = TxnReplayableBase.class.getDeclaredMethod("isReplayFailure", Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$16 = TxnReplayableBase.class.getDeclaredMethod("disableReplay", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$15 = TxnReplayableBase.class.getDeclaredMethod("getFailoverManager", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$14 = TxnReplayableBase.class.getDeclaredMethod("setFailoverManager", TxnFailoverManagerImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$13 = TxnReplayableBase.class.getDeclaredMethod("setReplayingCallContext", TxnFailoverManagerImpl.CallHistoryEntry.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$12 = TxnReplayableBase.class.getDeclaredMethod("purgeSameProxyList", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$11 = TxnReplayableBase.class.getDeclaredMethod("removeFromSameProxyList", TxnFailoverManagerImpl.CallHistoryEntry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$10 = TxnReplayableBase.class.getDeclaredMethod("addToSameProxyList", TxnFailoverManagerImpl.CallHistoryEntry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$9 = TxnReplayableBase.class.getDeclaredMethod("replayOneCall", TxnFailoverManagerImpl.CallHistoryEntry.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$8 = TxnReplayableBase.class.getDeclaredMethod("postForToString", Method.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$7 = TxnReplayableBase.class.getDeclaredMethod("preForToString", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$6 = TxnReplayableBase.class.getDeclaredMethod("onErrorForAll", Method.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$5 = TxnReplayableBase.class.getDeclaredMethod("onErrorVoidForAll", Method.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$4 = TxnReplayableBase.class.getDeclaredMethod("doPostWhenReplaying", Method.class, Object.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$3 = TxnReplayableBase.class.getDeclaredMethod("doPostWhenRecording", Method.class, Object.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$2 = TxnReplayableBase.class.getDeclaredMethod("postForAll", Method.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$1 = TxnReplayableBase.class.getDeclaredMethod("postForAll", Method.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$0 = TxnReplayableBase.class.getDeclaredMethod("preForAll", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
    }
}

