/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.jndi;

import java.lang.reflect.Executable;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Logger;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.net.ssl.SSLException;
import oracle.net.jndi.LDAPSSLSocketFactory;
import oracle.net.ns.NetException;

public class JndiAttrs {
    private Properties env;
    private static final String nFactory = "java.naming.factory.initial";
    private static final String nProvider = "java.naming.provider.url";
    private static final String nProfile = "ora-net-profile";
    private static final String default_nFactory = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final String ldap_read_timeout = "com.sun.jndi.ldap.read.timeout";
    private static final String ldap_connect_timeout = "com.sun.jndi.ldap.connect.timeout";
    DirContext ctx;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JndiAttrs(Properties up) throws NetException {
        Object prop;
        Object providerURL = null;
        this.env = new Properties();
        if (up.containsKey(nFactory)) {
            this.env.put(nFactory, up.getProperty(nFactory));
        } else {
            this.env.put(nFactory, default_nFactory);
        }
        if (up.containsKey(nProvider)) {
            providerURL = up.getProperty(nProvider);
            if (((String)providerURL).startsWith("ldaps")) {
                this.env.put("java.naming.ldap.factory.socket", "oracle.net.jndi.LDAPSSLSocketFactory");
                this.env.put("java.naming.security.protocol", "ssl");
                providerURL = "ldap:" + ((String)providerURL).substring(6);
            }
            this.env.put(nProvider, providerURL);
        }
        if (up.containsKey("oracle.net.profile")) {
            this.env.put(nProfile, up.getProperty("oracle.net.profile"));
        }
        try {
            Class<?> jclass = Class.forName("javax.naming.directory.InitialDirContext");
            if (this.env.get(nFactory) == null) {
                this.env.put(nFactory, default_nFactory);
            }
            if (this.env.get(nProvider) == null) {
                this.env.put(nProvider, providerURL);
            }
        }
        catch (Exception classE) {
            throw new NetException(110, classE.toString());
        }
        if (up.containsKey(ldap_connect_timeout)) {
            this.env.put(ldap_connect_timeout, up.getProperty(ldap_connect_timeout));
        }
        if (up.containsKey(ldap_read_timeout)) {
            this.env.put(ldap_read_timeout, up.getProperty(ldap_read_timeout));
        }
        if ((prop = up.get("java.naming.security.authentication")) != null) {
            this.env.put("java.naming.security.authentication", prop);
        }
        if ((prop = up.get("java.naming.security.principal")) != null) {
            this.env.put("java.naming.security.principal", prop);
        }
        if ((prop = up.get("java.naming.security.credentials")) != null) {
            this.env.put("java.naming.security.credentials", prop);
        }
        LDAPSSLSocketFactory.connectionProperties.set(up);
        try {
            this.initializeLDAPContext(this.env);
        }
        finally {
            LDAPSSLSocketFactory.connectionProperties.remove();
        }
    }

    private void initializeLDAPContext(Properties env) throws NetException {
        for (int i2 = 0; i2 < 3; ++i2) {
            try {
                this.ctx = new InitialDirContext(env);
                break;
            }
            catch (NamingException ne) {
                if (ne.getRootCause() instanceof SSLException && i2 < 3) continue;
                NetException netEx = new NetException(108, ne.toString());
                netEx.initCause(ne);
                throw netEx;
            }
        }
    }

    public Vector getProfileAttrs(String cn) throws NetException {
        String _cn = "cn=";
        Attributes attrs = null;
        try {
            _cn = _cn.concat(cn);
            attrs = this.ctx.getAttributes(_cn);
        }
        catch (NamingException namingE) {
            throw new NetException(108, namingE.toString());
        }
        return this.setAttrs(attrs);
    }

    public Vector getAttrs(String alias, String[] attrname) throws NetException {
        String _cn = "cn=";
        Attributes attrs = null;
        try {
            _cn = !alias.startsWith(_cn) ? _cn.concat(alias) : alias;
            attrs = this.ctx.getAttributes(_cn, attrname);
        }
        catch (NamingException namingE) {
            throw new NetException(108, namingE.toString());
        }
        return this.setAttrs(attrs);
    }

    private Vector setAttrs(Attributes attrs) throws NetException {
        Vector nattr = new Vector(1, 1);
        if (attrs != null) {
            try {
                NamingEnumeration<? extends Attribute> ae2 = attrs.getAll();
                while (ae2 != null && ae2.hasMoreElements()) {
                    Attribute attr = ae2.next();
                    NamingEnumeration<?> e2 = attr.getAll();
                    while (e2.hasMoreElements()) {
                        nattr.addElement(e2.nextElement());
                    }
                }
            }
            catch (NamingException namingE) {
                throw new NetException(108, namingE.toString());
            }
        }
        return nattr;
    }

    public void setEnv(String envP, String envV) {
        this.env.put(envP, envV);
    }

    public void close() throws NetException {
        try {
            if (null != this.ctx) {
                this.ctx.close();
            }
        }
        catch (NamingException namingE) {
            throw new NetException(108, namingE.toString());
        }
    }

    public final String getLdapUrlUsed() throws NetException {
        String url = null;
        try {
            url = (String)this.ctx.getEnvironment().get(nProvider);
        }
        catch (NamingException namingE) {
            throw new NetException(108, namingE.toString());
        }
        return url;
    }

    static {
        try {
            $$$methodRef$$$7 = JndiAttrs.class.getDeclaredConstructor(Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = JndiAttrs.class.getDeclaredMethod("getLdapUrlUsed", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = JndiAttrs.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = JndiAttrs.class.getDeclaredMethod("setEnv", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = JndiAttrs.class.getDeclaredMethod("setAttrs", Attributes.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = JndiAttrs.class.getDeclaredMethod("getAttrs", String.class, String[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = JndiAttrs.class.getDeclaredMethod("getProfileAttrs", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = JndiAttrs.class.getDeclaredMethod("initializeLDAPContext", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

