/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Executable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.net.ns.NetException;
import oracle.net.ns.Packet;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;

@DefaultLogger(value="oracle.net.ns")
@Supports(value={Feature.NET})
public class DataDescriptorPacket
extends Packet
implements SQLnetDef {
    int totalDataLength;
    int descriptorFLaG;
    int[] sdd;
    Packet packet;
    boolean useLongDescriptor;
    private static final byte[] STANDARD_SDD_MAX_DD;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;

    public DataDescriptorPacket(SessionAtts sAtts) {
        super(sAtts, 72, 15, 0);
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, DataDescriptorPacket.class, $$$methodRef$$$4, null, sAtts);
            }
            this.sdd = new int[26];
            this.useLongDescriptor = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, DataDescriptorPacket.class, $$$methodRef$$$4, null);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, DataDescriptorPacket.class, $$$methodRef$$$4, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, DataDescriptorPacket.class, $$$methodRef$$$4, null, throwable2);
            }
            throw throwable;
        }
    }

    public DataDescriptorPacket(Packet _packet, SessionAtts sAtts) {
        super(sAtts);
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, DataDescriptorPacket.class, $$$methodRef$$$5, null, _packet, sAtts);
            }
            this.sdd = new int[26];
            this.useLongDescriptor = false;
            this.type = 15;
            this.packet = _packet;
            this.buffer = this.packet.buffer;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, DataDescriptorPacket.class, $$$methodRef$$$5, null);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, DataDescriptorPacket.class, $$$methodRef$$$5, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, DataDescriptorPacket.class, $$$methodRef$$$5, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected void receive() throws IOException, NetException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, DataDescriptorPacket.class, $$$methodRef$$$0, this, new Object[0]);
            }
            this.packet.receive();
            this.descriptorFLaG = (this.buffer[8] & 0xFF) << 24 | (this.buffer[9] & 0xFF) << 16 | (this.buffer[10] & 0xFF) << 8 | this.buffer[11] & 0xFF;
            this.useLongDescriptor = (this.descriptorFLaG & 2) == 0;
            this.totalDataLength = (this.buffer[12] & 0xFF) << 24 | (this.buffer[13] & 0xFF) << 16 | (this.buffer[14] & 0xFF) << 8 | this.buffer[15] & 0xFF;
            if (bl) {
                this.debug($$$loggerRef$$$0, Level.FINEST, $$$methodRef$$$0, "descriptorFlag=" + this.descriptorFLaG + ", useLongDescriptor=" + this.useLongDescriptor + ", totalDataLength=" + this.totalDataLength + ", sessionTraceId=" + this.sAtts.traceId);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, DataDescriptorPacket.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, DataDescriptorPacket.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, DataDescriptorPacket.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void send(int n2, boolean bl) throws IOException {
        boolean bl2 = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            int i2;
            void marker;
            void totalLength;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, DataDescriptorPacket.class, $$$methodRef$$$1, this, n2, bl);
            }
            if (totalLength == 1703910 && marker == false) {
                OutputStream outputStream = this.sAtts.ntOutputStream;
                synchronized (outputStream) {
                    try {
                        if (bl2) {
                            this.debug($$$loggerRef$$$1, Level.FINEST, $$$methodRef$$$1, "(1):totalLength=" + (int)totalLength + ", marker=" + (boolean)marker + "\n" + this.dumpBytes(STANDARD_SDD_MAX_DD, 0, STANDARD_SDD_MAX_DD.length) + ", sessionTraceId=" + this.sAtts.traceId);
                        }
                        this.sAtts.ntOutputStream.write(STANDARD_SDD_MAX_DD, 0, STANDARD_SDD_MAX_DD.length);
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT @DISABLED, blocks:[0, 3, 19, 5] lbl15 : MonitorExitStatement: MONITOREXIT : var3_4
                        Throwable throwable2 = throwable;
                        if (bl2) {
                            ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, DataDescriptorPacket.class, $$$methodRef$$$1, this, throwable2);
                        }
                        throw throwable2;
                    }
                }
            }
            this.useLongDescriptor = false;
            this.descriptorFLaG = 2;
            if (marker != false) {
                this.descriptorFLaG |= 1;
            }
            int nbOfDD = 0;
            void remainingBytes = totalLength;
            while (remainingBytes > 0) {
                this.sdd[nbOfDD] = remainingBytes > 65535 ? 65535 : remainingBytes;
                remainingBytes -= this.sdd[nbOfDD];
                ++nbOfDD;
            }
            this.writeB4ToBuffer(this.buffer, 8, this.descriptorFLaG);
            this.writeB4ToBuffer(this.buffer, 12, (int)totalLength);
            this.writeB4ToBuffer(this.buffer, 16, nbOfDD);
            for (i2 = 0; i2 < nbOfDD; ++i2) {
                this.writeB2ToBuffer(this.buffer, 20 + i2 * 2, this.sdd[i2]);
            }
            for (i2 = nbOfDD; i2 < 26; ++i2) {
                this.writeB2ToBuffer(this.buffer, 20 + i2 * 2, 0);
            }
            OutputStream outputStream = this.sAtts.ntOutputStream;
            synchronized (outputStream) {
                try {
                    if (bl2) {
                        this.debug($$$loggerRef$$$1, Level.FINEST, $$$methodRef$$$1, "(2): totalLength=" + (int)totalLength + ", marker=" + (boolean)marker + "\n" + this.dumpBytes(this.buffer, 0, 72) + ", sessionTraceId=" + this.sAtts.traceId);
                    }
                    this.sAtts.ntOutputStream.write(this.buffer, 0, 72);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 4, 6] lbl50 : MonitorExitStatement: MONITOREXIT : var5_12
                    Throwable throwable3 = throwable;
                    if (bl2) {
                        ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, DataDescriptorPacket.class, $$$methodRef$$$1, this, throwable3);
                    }
                    throw throwable3;
                }
            }
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, DataDescriptorPacket.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, DataDescriptorPacket.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, DataDescriptorPacket.class, $$$methodRef$$$1, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void writeB4ToBuffer(byte[] byArray, int n2, int n3) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, DataDescriptorPacket.class, $$$methodRef$$$2, this, byArray, n2, n3);
            }
            byte b1 = (byte)((value & 0xFF000000) >>> 24 & 0xFF);
            byte b2 = (byte)((value & 0xFF0000) >>> 16 & 0xFF);
            byte b3 = (byte)((value & 0xFF00) >>> 8 & 0xFF);
            byte b4 = (byte)(value & 0xFF);
            b[off] = b1;
            b[off + true] = b2;
            b[off + 2] = b3;
            b[off + 3] = b4;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, DataDescriptorPacket.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, DataDescriptorPacket.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, DataDescriptorPacket.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void writeB2ToBuffer(byte[] byArray, int n2, int n3) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, DataDescriptorPacket.class, $$$methodRef$$$3, this, byArray, n2, n3);
            }
            byte b3 = (byte)((value & 0xFF00) >>> 8 & 0xFF);
            byte b4 = (byte)(value & 0xFF);
            b[off] = b3;
            b[off + true] = b4;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, DataDescriptorPacket.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, DataDescriptorPacket.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, DataDescriptorPacket.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Log
    protected void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, this.getClass(), method, msg);
    }

    static {
        try {
            $$$methodRef$$$5 = DataDescriptorPacket.class.getDeclaredConstructor(Packet.class, SessionAtts.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$4 = DataDescriptorPacket.class.getDeclaredConstructor(SessionAtts.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$3 = DataDescriptorPacket.class.getDeclaredMethod("writeB2ToBuffer", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$2 = DataDescriptorPacket.class.getDeclaredMethod("writeB4ToBuffer", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$1 = DataDescriptorPacket.class.getDeclaredMethod("send", Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$0 = DataDescriptorPacket.class.getDeclaredMethod("receive", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        STANDARD_SDD_MAX_DD = new byte[]{0, 72, 0, 0, 15, 0, 0, 0, 0, 0, 0, 2, 0, 25, -1, -26, 0, 0, 0, 26, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    }
}

