/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Executable;
import java.net.Socket;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import oracle.dms.instrument.NounIntf;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVNavigator;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NetException;
import oracle.net.nt.MetricsEnabledSSLSocketFactoryWrapper;
import oracle.security.jps.service.keystore.KeyStoreServiceLoadStoreParameter;

public class CustomSSLSocketFactory {
    public static final String DEFAULT_SSO_WALLET_FILE_NAME = "cwallet.sso";
    public static final String DEFAULT_PKCS12_WALLET_FILE_NAME = "ewallet.p12";
    public static final String SSO_WALLET_TYPE = "SSO";
    public static final String PKCS12_WALLET_TYPE = "PKCS12";
    public static final String PKCS11_WALLET_TYPE = "PKCS11";
    public static final String WINDOWS_MY_WALLET_TYPE = "Windows-MY";
    public static final String JKS_TYPE = "JKS";
    public static final String KSS_TYPE = "KSS";
    public static final String SUPPORTED_METHOD_TYPE = "FILE";
    private static final String SSO_FILE_EXTENSION = ".sso";
    private static final String P12_FILE_EXTENSION = ".p12";
    private static final String PFX_FILE_EXTENSION = ".pfx";
    private static final String JKS_FILE_EXTENSION = ".jks";
    private static final String KSS_URI_SCHEME = "kss://";
    private static final String ORACLE_PKI_PROVIDER_CLASS = "oracle.security.pki.OraclePKIProvider";
    private static final String KSS_PROVIDER_CLASS = "oracle.security.jps.internal.keystore.provider.FarmKeyStoreProvider";
    public static SSLSocketFactory defSSLFactory;
    public static SSLContext defSSLContext;
    public static String defPropString;
    public static boolean initDefFactory;
    public static boolean initDefSSLContext;
    NounIntf dmsParent = null;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;

    private CustomSSLSocketFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SSLSocketFactory getSSLSocketFactory(Properties sslSocketProperties, NounIntf dmsParent) throws IOException {
        SSLSocketFactory result = null;
        SSLConfig config = CustomSSLSocketFactory.readSSLConfig(sslSocketProperties);
        if (config.keyStore != null) {
            if (config.keyStore.equalsIgnoreCase("NONE")) return (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
        if (config.trustStore != null && config.trustStore.equalsIgnoreCase("NONE")) {
            return (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
        SSLContext l_context = CustomSSLSocketFactory.getSSLContext(config);
        if (l_context == defSSLContext) {
            if (initDefFactory) return defSSLFactory;
            Class<CustomSSLSocketFactory> clazz = CustomSSLSocketFactory.class;
            synchronized (CustomSSLSocketFactory.class) {
                if (initDefFactory) return defSSLFactory;
                defSSLFactory = l_context.getSocketFactory();
                initDefFactory = true;
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return defSSLFactory;
            }
        }
        result = l_context.getSocketFactory();
        return new MetricsEnabledSSLSocketFactoryWrapper(result, dmsParent);
    }

    public static SSLEngine getSSLSocketEngine(String host, int port, Properties sslSocketProperties) throws IOException {
        SSLConfig config = CustomSSLSocketFactory.readSSLConfig(sslSocketProperties);
        if (config.keyStore != null && config.keyStore.equalsIgnoreCase("NONE") || config.trustStore != null && config.trustStore.equalsIgnoreCase("NONE")) {
            try {
                SSLEngine defSSLEngine = SSLContext.getDefault().createSSLEngine();
                defSSLEngine.setUseClientMode(true);
                return defSSLEngine;
            }
            catch (NoSuchAlgorithmException nae) {
                throw new IOException(nae);
            }
        }
        SSLEngine result = CustomSSLSocketFactory.getSSLContext(config).createSSLEngine(host, port);
        result.setUseClientMode(true);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static SSLContext getSSLContext(SSLConfig config) throws IOException {
        if (!config.propConcatenation.equals(defPropString)) return CustomSSLSocketFactory.createSSLContext(config);
        if (initDefSSLContext) return defSSLContext;
        Class<CustomSSLSocketFactory> clazz = CustomSSLSocketFactory.class;
        synchronized (CustomSSLSocketFactory.class) {
            if (initDefSSLContext) return defSSLContext;
            defSSLContext = CustomSSLSocketFactory.createSSLContext(config);
            initDefSSLContext = true;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return defSSLContext;
        }
    }

    private static SSLContext createSSLContext(SSLConfig sSLConfig) throws NetException {
        boolean bl = (0L & TraceControllerImpl.feature) != 0L;
        try {
            SSLConfig config;
            KeyManager[] keyManagerArray = null;
            TrustManager[] trustManagerArray = null;
            if (config.keyStore != null) {
                keyManagerArray = CustomSSLSocketFactory.getKeyManagerArray(config.keyStore, config.keyStorePassword, config.keyStoreType, config.keyManagerFacAlgo);
            }
            if (config.certificateAlias != null && config.certificateAlias.trim().length() != 0 && keyManagerArray != null) {
                keyManagerArray = CustomSSLSocketFactory.wrapWithAliasKeyManager(keyManagerArray, config.certificateAlias);
            }
            if (config.trustStore != null) {
                trustManagerArray = CustomSSLSocketFactory.getTrustManagerArray(config.trustStore, config.trustStorePassword, config.trustStoreType, config.trustManagerFacAlgo);
            }
            SSLContext l_context = SSLContext.getInstance("SSL");
            l_context.init(keyManagerArray, trustManagerArray, null);
            return l_context;
        }
        catch (Exception ex) {
            if (bl) {
                CustomSSLSocketFactory.debug($$$loggerRef$$$3, Level.FINEST, $$$methodRef$$$3, "Error in initializing ssl context" + ex.toString());
            }
            throw (NetException)new NetException(410).initCause(ex);
        }
    }

    private static X509ExtendedKeyManager[] wrapWithAliasKeyManager(KeyManager[] keyManagers, String alias) {
        X509ExtendedKeyManager[] newKeyManagers = new X509ExtendedKeyManager[keyManagers.length];
        for (int i2 = 0; i2 < keyManagers.length; ++i2) {
            newKeyManagers[i2] = new AliasKeyManager((X509KeyManager)keyManagers[i2], alias);
        }
        return newKeyManagers;
    }

    private static SSLConfig readSSLConfig(Properties sslSocketProperties) throws NetException {
        Object keyStoreType = null;
        Object keyStorePassword = null;
        Object keyStore = null;
        Object trustStoreType = null;
        Object trustStorePassword = null;
        Object trustStore = null;
        Object keyManagerFacAlgo = null;
        Object trustManagerFacAlgo = null;
        Object propConcatenation = null;
        Object walletDirectory = null;
        String walletLocation = null;
        Object walletPassword = null;
        walletLocation = (String)sslSocketProperties.get(5);
        if (walletLocation == null) {
            return CustomSSLSocketFactory.readJavaxNetSSLConfig(sslSocketProperties);
        }
        return CustomSSLSocketFactory.readWalletSSLConfig(sslSocketProperties);
    }

    private static SSLConfig readJavaxNetSSLConfig(Properties sslSocketProperties) {
        SSLConfig config = new SSLConfig();
        config.keyStore = (String)sslSocketProperties.get(8);
        config.certificateAlias = (String)sslSocketProperties.get(29);
        if (config.keyStore != null) {
            config.keyStoreType = (String)sslSocketProperties.get(9);
            if (config.keyStoreType == null) {
                config.keyStoreType = CustomSSLSocketFactory.resolveKeyStoreType(config.keyStore);
            }
            config.keyStorePassword = (String)sslSocketProperties.get(10);
            if (config.keyStorePassword == null) {
                config.keyStorePassword = "";
            }
            config.keyManagerFacAlgo = (String)sslSocketProperties.get(14);
            if (config.keyManagerFacAlgo == null) {
                config.keyManagerFacAlgo = Security.getProperty("ssl.keyManagerFactory.algorithm");
            }
            if (config.keyManagerFacAlgo == null) {
                config.keyManagerFacAlgo = KeyManagerFactory.getDefaultAlgorithm();
            }
        }
        config.trustStore = (String)sslSocketProperties.get(11);
        if (config.trustStore != null) {
            config.trustStoreType = (String)sslSocketProperties.get(12);
            if (config.trustStoreType == null) {
                config.trustStoreType = CustomSSLSocketFactory.resolveKeyStoreType(config.trustStore);
            }
            config.trustStorePassword = (String)sslSocketProperties.get(13);
            if (config.trustStorePassword == null) {
                config.trustStorePassword = "";
            }
            config.trustManagerFacAlgo = (String)sslSocketProperties.get(15);
            if (config.trustManagerFacAlgo == null) {
                config.trustManagerFacAlgo = Security.getProperty("ssl.trustManagerFactory.algorithm");
            }
            if (config.trustManagerFacAlgo == null) {
                config.trustManagerFacAlgo = TrustManagerFactory.getDefaultAlgorithm();
            }
        }
        config.propConcatenation = config.keyStore + "#" + config.keyStoreType + "#" + config.keyStorePassword + "#" + config.trustStore + "#" + config.trustStoreType + "#" + config.trustStorePassword + "#" + config.keyManagerFacAlgo + "#" + config.trustManagerFacAlgo;
        return config;
    }

    private static SSLConfig readWalletSSLConfig(Properties sslSocketProperties) throws NetException {
        String walletDirectory;
        SSLConfig config = new SSLConfig();
        config.certificateAlias = (String)sslSocketProperties.get(29);
        boolean walletFileSpecified = false;
        String walletLocation = (String)sslSocketProperties.get(5);
        if (walletLocation.startsWith("(")) {
            walletDirectory = CustomSSLSocketFactory.processWalletLocation(walletLocation);
        } else {
            walletDirectory = walletLocation.startsWith("file:") ? walletLocation.substring("file:".length()) : walletLocation;
            File walletFile = new File(walletDirectory);
            if (!walletFile.exists()) {
                throw new NetException(407, "Couldn't find file at " + walletDirectory);
            }
            if (!walletFile.isDirectory()) {
                walletFileSpecified = true;
            }
        }
        String walletPassword = (String)sslSocketProperties.get(16);
        if (walletPassword == null) {
            if (!walletFileSpecified) {
                config.keyStore = walletDirectory + System.getProperty("file.separator") + DEFAULT_SSO_WALLET_FILE_NAME;
            } else {
                config.keyStore = walletDirectory;
            }
            config.keyStoreType = SSO_WALLET_TYPE;
            config.keyStorePassword = "";
            config.keyManagerFacAlgo = KeyManagerFactory.getDefaultAlgorithm();
            config.trustStore = config.keyStore;
            config.trustStoreType = SSO_WALLET_TYPE;
            config.trustStorePassword = "";
            config.trustManagerFacAlgo = TrustManagerFactory.getDefaultAlgorithm();
        } else {
            if (!walletFileSpecified) {
                config.keyStore = walletDirectory + System.getProperty("file.separator") + DEFAULT_PKCS12_WALLET_FILE_NAME;
            } else {
                config.keyStore = walletDirectory;
            }
            config.keyStoreType = PKCS12_WALLET_TYPE;
            config.keyStorePassword = walletPassword;
            config.keyManagerFacAlgo = KeyManagerFactory.getDefaultAlgorithm();
            config.trustStore = config.keyStore;
            config.trustStoreType = PKCS12_WALLET_TYPE;
            config.trustStorePassword = walletPassword;
            config.trustManagerFacAlgo = TrustManagerFactory.getDefaultAlgorithm();
        }
        config.propConcatenation = walletLocation + "#" + config.keyManagerFacAlgo + "#" + config.trustManagerFacAlgo;
        return config;
    }

    /*
     * WARNING - void declaration
     */
    public static KeyManager[] getKeyManagerArray(String string, String string2, String string3, String string4) throws IOException {
        void keyManagerFacAlgo;
        void keyStoreType;
        String keyStore;
        boolean bl;
        boolean bl2 = bl = (0L & TraceControllerImpl.feature) != 0L;
        if (bl) {
            CustomSSLSocketFactory.debug($$$loggerRef$$$8, Level.FINEST, $$$methodRef$$$8, "KEY STORE IS" + keyStore);
        }
        if (bl) {
            CustomSSLSocketFactory.debug($$$loggerRef$$$8, Level.FINEST, $$$methodRef$$$8, "KEY STORE TYPE IS" + (String)keyStoreType);
        }
        if (bl) {
            CustomSSLSocketFactory.debug($$$loggerRef$$$8, Level.FINEST, $$$methodRef$$$8, "KEY MANAGER FACTORY ALGORITHM" + (String)keyManagerFacAlgo);
        }
        try {
            void keyStorePassword;
            KeyStore instKeyStore = CustomSSLSocketFactory.loadKeyStore(keyStore, (String)keyStoreType, (String)keyStorePassword);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance((String)keyManagerFacAlgo);
            keyManagerFactory.init(instKeyStore, keyStorePassword.toCharArray());
            return keyManagerFactory.getKeyManagers();
        }
        catch (Exception ex) {
            if (bl) {
                CustomSSLSocketFactory.debug($$$loggerRef$$$8, Level.FINEST, $$$methodRef$$$8, "Error in initializing key store " + ex.toString());
            }
            throw (NetException)new NetException(408).initCause(ex);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static TrustManager[] getTrustManagerArray(String string, String string2, String string3, String string4) throws IOException {
        void trustManagerFacAlgo;
        void trustStoreType;
        String trustStore;
        boolean bl;
        boolean bl2 = bl = (0L & TraceControllerImpl.feature) != 0L;
        if (bl) {
            CustomSSLSocketFactory.debug($$$loggerRef$$$9, Level.FINEST, $$$methodRef$$$9, "TRUST STORE IS" + trustStore);
        }
        if (bl) {
            CustomSSLSocketFactory.debug($$$loggerRef$$$9, Level.FINEST, $$$methodRef$$$9, "TRUST STORE TYPE IS" + (String)trustStoreType);
        }
        if (bl) {
            CustomSSLSocketFactory.debug($$$loggerRef$$$9, Level.FINEST, $$$methodRef$$$9, "TRUST MANAGER FACTORY ALGORITHM" + (String)trustManagerFacAlgo);
        }
        try {
            void trustStorePassword;
            KeyStore instTrustStore = CustomSSLSocketFactory.loadKeyStore(trustStore, (String)trustStoreType, (String)trustStorePassword);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance((String)trustManagerFacAlgo);
            trustManagerFactory.init(instTrustStore);
            return trustManagerFactory.getTrustManagers();
        }
        catch (Exception ex) {
            if (bl) {
                CustomSSLSocketFactory.debug($$$loggerRef$$$9, Level.FINEST, $$$methodRef$$$9, "Error in initializing trust store " + ex.toString());
            }
            throw (NetException)new NetException(409).initCause(ex);
        }
    }

    public static String processWalletLocation(String string) throws NetException {
        boolean bl = (0L & TraceControllerImpl.feature) != 0L;
        String method = null;
        try {
            String walletLocation;
            NVNavigator nav = new NVNavigator();
            NVPair nvpWallet = new NVFactory().createNVPair(walletLocation);
            NVPair nvpMethod = nav.findNVPair(nvpWallet, "METHOD");
            NVPair nvpMethodData = nav.findNVPair(nvpWallet, "METHOD_DATA");
            NVPair nvpDirectory = nav.findNVPair(nvpMethodData, "DIRECTORY");
            method = nvpMethod.getAtom();
            if (bl) {
                CustomSSLSocketFactory.debug($$$loggerRef$$$10, Level.FINEST, $$$methodRef$$$10, "METHOD in wallet " + method);
            }
            if (bl) {
                CustomSSLSocketFactory.debug($$$loggerRef$$$10, Level.FINEST, $$$methodRef$$$10, "Directory in wallet " + nvpDirectory.getAtom());
            }
            if (method.equalsIgnoreCase(SUPPORTED_METHOD_TYPE)) {
                String directoryLoc = nvpDirectory.getAtom();
                return directoryLoc;
            }
            throw new NetException(412, method);
        }
        catch (Exception ex) {
            if (bl) {
                CustomSSLSocketFactory.debug($$$loggerRef$$$10, Level.FINEST, $$$methodRef$$$10, "Error in parsing wallet location " + ex.toString());
            }
            throw (NetException)new NetException(407).initCause(ex);
        }
    }

    public static String getDefaultPropertiesString() {
        Object defaultPropString = null;
        String walletLocation = null;
        Object walletDirectory = null;
        String keyManagerFacAlgo = null;
        String trustManagerFacAlgo = null;
        walletLocation = System.getProperty("oracle.net.wallet_location");
        defaultPropString = walletLocation != null ? walletLocation : System.getProperty("javax.net.ssl.keyStore", "") + "#" + System.getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType()) + "#" + System.getProperty("javax.net.ssl.keyStorePassword", "") + "#" + System.getProperty("javax.net.ssl.trustStore", "") + "#" + System.getProperty("javax.net.ssl.trustStoreType", KeyStore.getDefaultType()) + "#" + System.getProperty("javax.net.ssl.trustStorePassword", "");
        if (keyManagerFacAlgo == null) {
            keyManagerFacAlgo = KeyManagerFactory.getDefaultAlgorithm();
        }
        if (trustManagerFacAlgo == null) {
            trustManagerFacAlgo = TrustManagerFactory.getDefaultAlgorithm();
        }
        return (String)defaultPropString + "#" + keyManagerFacAlgo + "#" + trustManagerFacAlgo;
    }

    private static KeyStore getKeyStoreInstance(String string) throws KeyStoreException {
        String type;
        boolean bl = (0L & TraceControllerImpl.feature) != 0L;
        try {
            return KeyStore.getInstance(type);
        }
        catch (KeyStoreException err) {
            try {
                Provider provider = CustomSSLSocketFactory.loadKnownProvider(type);
                if (provider == null) {
                    throw err;
                }
                return KeyStore.getInstance(type, provider);
            }
            catch (Exception loadProviderError) {
                if (bl) {
                    CustomSSLSocketFactory.debug($$$loggerRef$$$12, Level.FINEST, $$$methodRef$$$12, "Failed to load a known Provider for key store type" + type + " after no registered Provider was found. The exception was: " + loadProviderError.getLocalizedMessage() + ". The origninal exception will be thrown");
                }
                throw err;
            }
        }
    }

    private static Provider loadKnownProvider(String type) throws Exception {
        Class<?> clazz;
        String providerClass;
        Provider providerObject = null;
        switch (type.toUpperCase()) {
            case "SSO": {
                providerClass = ORACLE_PKI_PROVIDER_CLASS;
                break;
            }
            case "KSS": {
                providerClass = KSS_PROVIDER_CLASS;
                break;
            }
            default: {
                providerClass = null;
            }
        }
        if (providerClass != null && (clazz = Class.forName(providerClass)) != null && Provider.class.isAssignableFrom(clazz)) {
            providerObject = AccessController.doPrivileged(() -> (Provider)clazz.newInstance());
        }
        return providerObject;
    }

    private static String resolveKeyStoreType(String keyStorePath) {
        if (keyStorePath == null || keyStorePath.length() == 0) {
            return KeyStore.getDefaultType();
        }
        String lowerCasePath = keyStorePath.toLowerCase();
        if (lowerCasePath.endsWith(SSO_FILE_EXTENSION)) {
            return SSO_WALLET_TYPE;
        }
        if (lowerCasePath.endsWith(P12_FILE_EXTENSION) || lowerCasePath.endsWith(PFX_FILE_EXTENSION)) {
            return PKCS12_WALLET_TYPE;
        }
        if (lowerCasePath.endsWith(JKS_FILE_EXTENSION)) {
            return JKS_TYPE;
        }
        if (lowerCasePath.startsWith(KSS_URI_SCHEME)) {
            return KSS_TYPE;
        }
        return KeyStore.getDefaultType();
    }

    @Log
    protected static void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, CustomSSLSocketFactory.class, method, msg);
    }

    private static KeyStore loadKeyStore(String path, String type, String password) throws IOException, NoSuchAlgorithmException, CertificateException, KeyStoreException {
        KeyStore instKeyStore = CustomSSLSocketFactory.getKeyStoreInstance(type);
        if (KSS_TYPE.equals(type)) {
            CustomSSLSocketFactory.loadKSSKeyStore(instKeyStore, path, password);
        } else {
            CustomSSLSocketFactory.loadFileBasedKeyStore(instKeyStore, path, password);
        }
        return instKeyStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadFileBasedKeyStore(KeyStore keyStore, String path, String password) throws IOException, NoSuchAlgorithmException, CertificateException {
        try (FileInputStream fileStream = new FileInputStream(path);){
            Class<CustomSSLSocketFactory> clazz = CustomSSLSocketFactory.class;
            synchronized (CustomSSLSocketFactory.class) {
                keyStore.load(fileStream, password.toCharArray());
                // ** MonitorExit[var5_5] (shouldn't be in output)
            }
        }
        {
            return;
        }
    }

    private static void loadKSSKeyStore(KeyStore keyStore, String uri, String password) throws IOException, NoSuchAlgorithmException, CertificateException {
        final class KSSLoader {
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            KSSLoader() {
            }

            private final void load(KeyStore ks, String uri, String password) throws IOException, NoSuchAlgorithmException, CertificateException {
                KeyStoreServiceLoadStoreParameter param = new KeyStoreServiceLoadStoreParameter();
                if (password != null) {
                    param.setProtectionParameter((KeyStore.ProtectionParameter)new KeyStore.PasswordProtection(password.toCharArray()));
                }
                param.setKssUri(uri);
                ks.load((KeyStore.LoadStoreParameter)param);
            }

            static {
                try {
                    $$$methodRef$$$2 = KSSLoader.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = KSSLoader.class.getDeclaredMethod("access$1100", KSSLoader.class, KeyStore.class, String.class, String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = KSSLoader.class.getDeclaredMethod("load", KeyStore.class, String.class, String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        }
        new KSSLoader().load(keyStore, uri, password);
    }

    static {
        try {
            $$$methodRef$$$19 = CustomSSLSocketFactory.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = CustomSSLSocketFactory.class.getDeclaredMethod("lambda$loadKnownProvider$0", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = CustomSSLSocketFactory.class.getDeclaredMethod("loadKSSKeyStore", KeyStore.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = CustomSSLSocketFactory.class.getDeclaredMethod("loadFileBasedKeyStore", KeyStore.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = CustomSSLSocketFactory.class.getDeclaredMethod("loadKeyStore", String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = CustomSSLSocketFactory.class.getDeclaredMethod("resolveKeyStoreType", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = CustomSSLSocketFactory.class.getDeclaredMethod("loadKnownProvider", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = CustomSSLSocketFactory.class.getDeclaredMethod("getKeyStoreInstance", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = CustomSSLSocketFactory.class.getDeclaredMethod("getDefaultPropertiesString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = CustomSSLSocketFactory.class.getDeclaredMethod("processWalletLocation", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = CustomSSLSocketFactory.class.getDeclaredMethod("getTrustManagerArray", String.class, String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = CustomSSLSocketFactory.class.getDeclaredMethod("getKeyManagerArray", String.class, String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = CustomSSLSocketFactory.class.getDeclaredMethod("readWalletSSLConfig", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = CustomSSLSocketFactory.class.getDeclaredMethod("readJavaxNetSSLConfig", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = CustomSSLSocketFactory.class.getDeclaredMethod("readSSLConfig", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = CustomSSLSocketFactory.class.getDeclaredMethod("wrapWithAliasKeyManager", KeyManager[].class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = CustomSSLSocketFactory.class.getDeclaredMethod("createSSLContext", SSLConfig.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = CustomSSLSocketFactory.class.getDeclaredMethod("getSSLContext", SSLConfig.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = CustomSSLSocketFactory.class.getDeclaredMethod("getSSLSocketEngine", String.class, Integer.TYPE, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = CustomSSLSocketFactory.class.getDeclaredMethod("getSSLSocketFactory", Properties.class, NounIntf.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        defPropString = CustomSSLSocketFactory.getDefaultPropertiesString();
    }

    static class AliasKeyManager
    extends X509ExtendedKeyManager {
        private final String alias;
        private final X509KeyManager keyManager;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;
        private static Executable $$$methodRef$$$9;
        private static Logger $$$loggerRef$$$9;

        AliasKeyManager(X509KeyManager keyManager, String alias) {
            this.keyManager = keyManager;
            this.alias = alias;
        }

        @Override
        public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
            return this.chooseEngineClientAlias(keyType, issuers, null);
        }

        @Override
        public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
            for (String type : keyType) {
                if (!this.isMatchFound(this.keyManager.getClientAliases(type, issuers), this.alias)) continue;
                return this.alias;
            }
            return null;
        }

        @Override
        public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
            return this.chooseEngineServerAlias(keyType, issuers, null);
        }

        @Override
        public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
            String[] serverAliases = this.keyManager.getServerAliases(keyType, issuers);
            if (this.isMatchFound(serverAliases, this.alias)) {
                return this.alias;
            }
            return null;
        }

        @Override
        public X509Certificate[] getCertificateChain(String alias) {
            return this.keyManager.getCertificateChain(alias);
        }

        @Override
        public String[] getClientAliases(String keyType, Principal[] issuers) {
            return this.keyManager.getClientAliases(keyType, issuers);
        }

        @Override
        public PrivateKey getPrivateKey(String alias) {
            return this.keyManager.getPrivateKey(alias);
        }

        @Override
        public String[] getServerAliases(String keyType, Principal[] issuers) {
            return this.keyManager.getServerAliases(keyType, issuers);
        }

        private boolean isMatchFound(String[] aliases, String alias) {
            if (aliases == null) {
                return false;
            }
            for (String curAlias : aliases) {
                if (!curAlias.equalsIgnoreCase(alias)) continue;
                return true;
            }
            return false;
        }

        static {
            try {
                $$$methodRef$$$9 = AliasKeyManager.class.getDeclaredConstructor(X509KeyManager.class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$8 = AliasKeyManager.class.getDeclaredMethod("isMatchFound", String[].class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$7 = AliasKeyManager.class.getDeclaredMethod("getServerAliases", String.class, Principal[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$6 = AliasKeyManager.class.getDeclaredMethod("getPrivateKey", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$5 = AliasKeyManager.class.getDeclaredMethod("getClientAliases", String.class, Principal[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = AliasKeyManager.class.getDeclaredMethod("getCertificateChain", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = AliasKeyManager.class.getDeclaredMethod("chooseEngineServerAlias", String.class, Principal[].class, SSLEngine.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = AliasKeyManager.class.getDeclaredMethod("chooseServerAlias", String.class, Principal[].class, Socket.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = AliasKeyManager.class.getDeclaredMethod("chooseEngineClientAlias", String[].class, Principal[].class, SSLEngine.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = AliasKeyManager.class.getDeclaredMethod("chooseClientAlias", String[].class, Principal[].class, Socket.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    private static class SSLConfig {
        private String keyStore;
        private String keyStoreType;
        private String keyStorePassword;
        private String certificateAlias;
        private String keyManagerFacAlgo;
        private String trustStore;
        private String trustStoreType;
        private String trustStorePassword;
        private String trustManagerFacAlgo;
        private String propConcatenation;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;
        private static Executable $$$methodRef$$$9;
        private static Logger $$$loggerRef$$$9;
        private static Executable $$$methodRef$$$10;
        private static Logger $$$loggerRef$$$10;
        private static Executable $$$methodRef$$$11;
        private static Logger $$$loggerRef$$$11;
        private static Executable $$$methodRef$$$12;
        private static Logger $$$loggerRef$$$12;
        private static Executable $$$methodRef$$$13;
        private static Logger $$$loggerRef$$$13;
        private static Executable $$$methodRef$$$14;
        private static Logger $$$loggerRef$$$14;
        private static Executable $$$methodRef$$$15;
        private static Logger $$$loggerRef$$$15;
        private static Executable $$$methodRef$$$16;
        private static Logger $$$loggerRef$$$16;
        private static Executable $$$methodRef$$$17;
        private static Logger $$$loggerRef$$$17;
        private static Executable $$$methodRef$$$18;
        private static Logger $$$loggerRef$$$18;
        private static Executable $$$methodRef$$$19;
        private static Logger $$$loggerRef$$$19;
        private static Executable $$$methodRef$$$20;
        private static Logger $$$loggerRef$$$20;
        private static Executable $$$methodRef$$$21;
        private static Logger $$$loggerRef$$$21;

        private SSLConfig() {
        }

        static {
            try {
                $$$methodRef$$$21 = SSLConfig.class.getDeclaredConstructor(1.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$20 = SSLConfig.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$19 = SSLConfig.class.getDeclaredMethod("access$202", SSLConfig.class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$18 = SSLConfig.class.getDeclaredMethod("access$902", SSLConfig.class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$17 = SSLConfig.class.getDeclaredMethod("access$702", SSLConfig.class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$16 = SSLConfig.class.getDeclaredMethod("access$802", SSLConfig.class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$15 = SSLConfig.class.getDeclaredMethod("access$102", SSLConfig.class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$14 = SSLConfig.class.getDeclaredMethod("access$502", SSLConfig.class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$13 = SSLConfig.class.getDeclaredMethod("access$302", SSLConfig.class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$12 = SSLConfig.class.getDeclaredMethod("access$402", SSLConfig.class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$11 = SSLConfig.class.getDeclaredMethod("access$602", SSLConfig.class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$10 = SSLConfig.class.getDeclaredMethod("access$002", SSLConfig.class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$9 = SSLConfig.class.getDeclaredMethod("access$900", SSLConfig.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$8 = SSLConfig.class.getDeclaredMethod("access$800", SSLConfig.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$7 = SSLConfig.class.getDeclaredMethod("access$700", SSLConfig.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$6 = SSLConfig.class.getDeclaredMethod("access$600", SSLConfig.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$5 = SSLConfig.class.getDeclaredMethod("access$500", SSLConfig.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = SSLConfig.class.getDeclaredMethod("access$400", SSLConfig.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = SSLConfig.class.getDeclaredMethod("access$300", SSLConfig.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = SSLConfig.class.getDeclaredMethod("access$200", SSLConfig.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = SSLConfig.class.getDeclaredMethod("access$100", SSLConfig.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = SSLConfig.class.getDeclaredMethod("access$000", SSLConfig.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

