/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.zone.ZoneRules;
import java.util.Calendar;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleTimestampWithTimeZone;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.OffsetDST;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMEZONETAB;
import oracle.sql.ZONEIDMAP;

@DefaultLogger(value="oracle.sql")
@Supports(value={Feature.PRIMITIVE_DATUM})
public class TIMESTAMPTZ
extends Datum
implements OracleTimestampWithTimeZone {
    static final long serialVersionUID = 6708361144588335769L;
    static final Calendar CAL_GMT_US;
    static final TimeZone TIMEZONE_UTC;
    private static int HOUR_MILLISECOND;
    private static int MINUTE_MILLISECOND;
    private static int SECOND_MILLISECOND;
    private static int HOUR_SECOND;
    private static int MINUTE_SECOND;
    private static int OFFSET_HOUR;
    private static int OFFSET_MINUTE;
    private static byte REGIONIDBIT;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;

    public TIMESTAMPTZ() {
        super(TIMESTAMPTZ.initTimestamptz());
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$40, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$40, null, new Object[0]);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$40, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$40, null);
                ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$40, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$40, null, throwable2);
            }
            throw throwable;
        }
    }

    public TIMESTAMPTZ(byte[] timestamptz) {
        super(timestamptz);
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$41, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$41, null, new Object[]{timestamptz});
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$41, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$41, null);
                ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$41, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$41, null, throwable2);
            }
            throw throwable;
        }
    }

    public TIMESTAMPTZ(Connection conn, Date date) throws SQLException {
        super(TIMESTAMPTZ.toBytes(conn, date));
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$42, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$42, null, conn, date);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$42, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$42, null);
                ClioSupport.exiting($$$loggerRef$$$42, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$42, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$42, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$42, null, throwable2);
            }
            throw throwable;
        }
    }

    public TIMESTAMPTZ(Connection conn, Date date, Calendar cal) throws SQLException {
        super(TIMESTAMPTZ.toBytes(conn, date, cal));
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$43, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$43, null, conn, date, cal);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$43, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$43, null);
                ClioSupport.exiting($$$loggerRef$$$43, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$43, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$43, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$43, null, throwable2);
            }
            throw throwable;
        }
    }

    public TIMESTAMPTZ(Connection conn, Time time) throws SQLException {
        super(TIMESTAMPTZ.toBytes(conn, time));
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$44, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$44, null, conn, time);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$44, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$44, null);
                ClioSupport.exiting($$$loggerRef$$$44, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$44, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$44, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$44, null, throwable2);
            }
            throw throwable;
        }
    }

    public TIMESTAMPTZ(Connection conn, Time time, Calendar cal) throws SQLException {
        super(TIMESTAMPTZ.toBytes(conn, time, cal));
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$45, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$45, null, conn, time, cal);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$45, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$45, null);
                ClioSupport.exiting($$$loggerRef$$$45, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$45, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$45, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$45, null, throwable2);
            }
            throw throwable;
        }
    }

    public TIMESTAMPTZ(Connection conn, Timestamp timestamp) throws SQLException {
        super(TIMESTAMPTZ.toBytes(conn, timestamp));
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$46, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$46, null, conn, timestamp);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$46, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$46, null);
                ClioSupport.exiting($$$loggerRef$$$46, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$46, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$46, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$46, null, throwable2);
            }
            throw throwable;
        }
    }

    public TIMESTAMPTZ(Connection conn, Timestamp timestamp, Calendar cal) throws SQLException {
        super(TIMESTAMPTZ.toBytes(conn, timestamp, cal));
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$47, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$47, null, conn, timestamp, cal);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$47, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$47, null);
                ClioSupport.exiting($$$loggerRef$$$47, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$47, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$47, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$47, null, throwable2);
            }
            throw throwable;
        }
    }

    public TIMESTAMPTZ(Connection conn, Timestamp timestamp, ZoneId tzid) throws SQLException {
        super(TIMESTAMPTZ.toBytes(conn, timestamp, tzid));
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$48, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$48, null, conn, timestamp, tzid);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$48, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$48, null);
                ClioSupport.exiting($$$loggerRef$$$48, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$48, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$48, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$48, null, throwable2);
            }
            throw throwable;
        }
    }

    public TIMESTAMPTZ(Connection conn, DATE date) throws SQLException {
        super(TIMESTAMPTZ.toBytes(conn, date));
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$49, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$49, null, conn, date);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$49, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$49, null);
                ClioSupport.exiting($$$loggerRef$$$49, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$49, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$49, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$49, null, throwable2);
            }
            throw throwable;
        }
    }

    public TIMESTAMPTZ(Connection conn, String str) throws SQLException {
        super(TIMESTAMPTZ.toBytes(conn, str));
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$50, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$50, null, conn, str);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$50, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$50, null);
                ClioSupport.exiting($$$loggerRef$$$50, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$50, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$50, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$50, null, throwable2);
            }
            throw throwable;
        }
    }

    public TIMESTAMPTZ(Connection conn, String str, Calendar cal) throws SQLException {
        super(TIMESTAMPTZ.toBytes(conn, str, cal));
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$51, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$51, null, conn, str, cal);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$51, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$51, null);
                ClioSupport.exiting($$$loggerRef$$$51, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$51, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$51, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$51, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Date toDate(Connection connection, byte[] byArray) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            void timestamptz;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$0, null, connection, byArray);
            }
            int[] result = new int[13];
            for (int i2 = 0; i2 < 13; ++i2) {
                result[i2] = timestamptz[i2] & 0xFF;
            }
            int year = TIMESTAMP.getJavaYear(result[0], result[1]);
            Calendar cal = Calendar.getInstance();
            cal.set(1, year);
            cal.set(2, result[2] - 1);
            cal.set(5, result[3]);
            cal.set(11, result[4] - 1);
            cal.set(12, result[5] - 1);
            cal.set(13, result[6] - 1);
            int tsmillis = TIMESTAMP.getNanos((byte[])timestamptz, 7) / 1000000;
            cal.set(14, tsmillis);
            if ((result[11] & REGIONIDBIT) != 0) {
                Connection conn;
                int regionID = TIMESTAMPTZ.getHighOrderbits(result[11]);
                TIMEZONETAB tzTab = TIMESTAMPTZ.getTIMEZONETAB(conn);
                if (tzTab.checkID(regionID += TIMESTAMPTZ.getLowOrderbits(result[12]))) {
                    tzTab.updateTable(conn, regionID);
                }
                int offset = tzTab.getOffset(cal, regionID);
                cal.add(10, offset / HOUR_MILLISECOND);
                cal.add(12, offset % HOUR_MILLISECOND / MINUTE_MILLISECOND);
            } else {
                cal.add(10, result[11] - OFFSET_HOUR);
                cal.add(12, result[12] - OFFSET_MINUTE);
            }
            long millis = cal.getTime().getTime();
            Date date = new Date(millis);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$0, null, date);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$0, null, null);
            }
            return date;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$0, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Date toDate2(Connection connection, byte[] byArray) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            void timestamptz;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$1, null, connection, byArray);
            }
            int[] result = new int[13];
            for (int i2 = 0; i2 < 13; ++i2) {
                result[i2] = timestamptz[i2] & 0xFF;
            }
            int year = TIMESTAMP.getJavaYear(result[0], result[1]);
            Calendar cal = (Calendar)CAL_GMT_US.clone();
            cal.set(1, year);
            cal.set(2, result[2] - 1);
            cal.set(5, result[3]);
            cal.set(11, result[4] - 1);
            cal.set(12, result[5] - 1);
            cal.set(13, result[6] - 1);
            int tsmillis = TIMESTAMP.getNanos((byte[])timestamptz, 7) / 1000000;
            cal.set(14, tsmillis);
            long millis = cal.getTime().getTime();
            Date date = new Date(millis);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$1, null, date);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$1, null, null);
            }
            return date;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$1, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Time toTime(Connection connection, byte[] byArray) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            void timestamptz;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$2, null, connection, byArray);
            }
            int hour = timestamptz[4] & 0xFF;
            int minute = timestamptz[5] & 0xFF;
            int second = timestamptz[6] & 0xFF;
            Calendar cal = (Calendar)CAL_GMT_US.clone();
            cal.set(1, 1970);
            cal.set(2, 0);
            cal.set(5, 1);
            cal.set(11, hour - 1);
            cal.set(12, minute - 1);
            cal.set(13, second - 1);
            cal.set(14, 0);
            Time time = new Time(cal.getTimeInMillis());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$2, null, time);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$2, null, null);
            }
            return time;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$2, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static DATE toDATE(Connection connection, byte[] byArray) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            void timestamptz;
            Connection conn;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$3, null, connection, byArray);
            }
            DATE dATE = new DATE(TIMESTAMPTZ.toTimestampInSessionTimezone(conn, (byte[])timestamptz));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$3, null, dATE);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$3, null, null);
            }
            return dATE;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$3, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static TIMESTAMP toTIMESTAMP(Connection connection, byte[] byArray) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            void timestamptz;
            Connection conn;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$4, null, connection, byArray);
            }
            TIMESTAMP tIMESTAMP = new TIMESTAMP(TIMESTAMPTZ.toTimestampInSessionTimezone(conn, (byte[])timestamptz));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$4, null, tIMESTAMP);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$4, null, null);
            }
            return tIMESTAMP;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$4, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Timestamp toTimestamp(Connection connection, byte[] byArray) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            void timestamptz;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$5, null, connection, byArray);
            }
            int[] result = new int[13];
            for (int i2 = 0; i2 < 13; ++i2) {
                result[i2] = timestamptz[i2] & 0xFF;
            }
            Calendar cal = Calendar.getInstance();
            Calendar gcal = (Calendar)CAL_GMT_US.clone();
            Calendar cal1 = Calendar.getInstance();
            int year = TIMESTAMP.getJavaYear(result[0], result[1]);
            cal.set(1, year);
            cal.set(2, result[2] - 1);
            cal.set(5, result[3]);
            cal.set(11, result[4] - 1);
            cal.set(12, result[5] - 1);
            cal.set(13, result[6] - 1);
            cal.set(14, 0);
            gcal.set(1, year);
            gcal.set(2, result[2] - 1);
            gcal.set(5, result[3]);
            gcal.set(11, result[4] - 1);
            gcal.set(12, result[5] - 1);
            gcal.set(13, result[6] - 1);
            gcal.set(14, 0);
            long timeInMillis = cal.getTime().getTime();
            if ((result[11] & REGIONIDBIT) != 0) {
                Connection conn;
                int regionID = TIMESTAMPTZ.getHighOrderbits(result[11]);
                TIMEZONETAB tzTab = TIMESTAMPTZ.getTIMEZONETAB(conn);
                if (tzTab.checkID(regionID += TIMESTAMPTZ.getLowOrderbits(result[12]))) {
                    tzTab.updateTable(conn, regionID);
                }
                int offset = tzTab.getOffset(gcal, regionID);
                TimeZone calTZ = cal.getTimeZone();
                TimeZone cal1TZ = cal1.getTimeZone();
                if (!calTZ.inDaylightTime(cal.getTime()) && cal1TZ.inDaylightTime(new Timestamp(timeInMillis += (long)offset))) {
                    timeInMillis = cal1TZ instanceof SimpleTimeZone ? (timeInMillis -= (long)((SimpleTimeZone)cal1TZ).getDSTSavings()) : (timeInMillis -= (long)HOUR_MILLISECOND);
                }
                if (calTZ.inDaylightTime(cal.getTime()) && !cal1TZ.inDaylightTime(new Timestamp(timeInMillis))) {
                    timeInMillis = cal1TZ instanceof SimpleTimeZone ? (timeInMillis += (long)((SimpleTimeZone)calTZ).getDSTSavings()) : (timeInMillis += (long)HOUR_MILLISECOND);
                }
            } else {
                cal.add(10, result[11] - OFFSET_HOUR);
                cal.add(12, result[12] - OFFSET_MINUTE);
                timeInMillis = cal.getTime().getTime();
            }
            Timestamp ts = new Timestamp(timeInMillis);
            long milliGMT = gcal.getTime().getTime();
            Calendar tcal = Calendar.getInstance();
            tcal.setTimeInMillis(milliGMT);
            Calendar tcal2 = Calendar.getInstance();
            tcal2.setTime(ts);
            boolean dst1 = tcal.getTimeZone().inDaylightTime(tcal.getTime());
            boolean dst2 = tcal2.getTimeZone().inDaylightTime(tcal2.getTime());
            if (dst1 && !dst2) {
                ts = new Timestamp(timeInMillis - (long)tcal.getTimeZone().getDSTSavings());
            } else if (!dst1 && dst2) {
                ts = new Timestamp(timeInMillis + (long)tcal2.getTimeZone().getDSTSavings());
            }
            int nanos = TIMESTAMP.getNanos((byte[])timestamptz, 7);
            ts.setNanos(nanos);
            Timestamp timestamp = ts;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$5, null, timestamp);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$5, null, null);
            }
            return timestamp;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$5, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Timestamp toTimestamp2(Connection connection, byte[] byArray) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            void timestamptz;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$6, null, connection, byArray);
            }
            int[] result = new int[13];
            for (int i2 = 0; i2 < 13; ++i2) {
                result[i2] = timestamptz[i2] & 0xFF;
            }
            int year = TIMESTAMP.getJavaYear(result[0], result[1]);
            Calendar gmtCal = (Calendar)CAL_GMT_US.clone();
            gmtCal.clear();
            gmtCal.set(1, year);
            gmtCal.set(2, result[2] - 1);
            gmtCal.set(5, result[3]);
            gmtCal.set(11, result[4] - 1);
            gmtCal.set(12, result[5] - 1);
            gmtCal.set(13, result[6] - 1);
            gmtCal.set(14, 0);
            long milliSec = gmtCal.getTime().getTime();
            Timestamp ts = new Timestamp(milliSec);
            int nanos = TIMESTAMP.getNanos((byte[])timestamptz, 7);
            ts.setNanos(nanos);
            Timestamp timestamp = ts;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$6, null, timestamp);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$6, null, null);
            }
            return timestamp;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$6, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    static Timestamp toTimestampInSessionTimezone(Connection connection, byte[] byArray) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            Connection conn;
            void timestamptz;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$7, null, connection, byArray);
            }
            int[] result = new int[13];
            for (int i2 = 0; i2 < 13; ++i2) {
                result[i2] = timestamptz[i2] & 0xFF;
            }
            int year = TIMESTAMP.getJavaYear(result[0], result[1]);
            Calendar gmtCal = (Calendar)CAL_GMT_US.clone();
            gmtCal.clear();
            gmtCal.set(1, year);
            gmtCal.set(2, result[2] - 1);
            gmtCal.set(5, result[3]);
            gmtCal.set(11, result[4] - 1);
            gmtCal.set(12, result[5] - 1);
            gmtCal.set(13, result[6] - 1);
            gmtCal.set(14, 0);
            Calendar sesscal = TIMESTAMPLTZ.getSessCalendar(conn);
            TIMESTAMPLTZ.TimeZoneAdjust(conn, gmtCal, sesscal);
            long milliSec = sesscal.getTime().getTime();
            Timestamp ts = new Timestamp(milliSec);
            int nanos = TIMESTAMP.getNanos((byte[])timestamptz, 7);
            ts.setNanos(nanos);
            Timestamp timestamp = ts;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$7, null, timestamp);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$7, null, null);
            }
            return timestamp;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$7, null, throwable2);
            }
            throw throwable;
        }
    }

    @DisableTrace
    public static String toString(Connection conn, byte[] timestamptz) throws SQLException {
        Object regname;
        int[] result = new int[13];
        for (int i2 = 0; i2 < 13; ++i2) {
            result[i2] = timestamptz[i2] & 0xFF;
        }
        Calendar calUTC = (Calendar)CAL_GMT_US.clone();
        int year = TIMESTAMP.getJavaYear(result[0], result[1]);
        calUTC.set(1, year);
        calUTC.set(2, result[2] - 1);
        calUTC.set(5, result[3]);
        calUTC.set(11, result[4] - 1);
        calUTC.set(12, result[5] - 1);
        calUTC.set(13, result[6] - 1);
        calUTC.set(14, 0);
        if ((result[11] & REGIONIDBIT) != 0) {
            int regionID = TIMESTAMPTZ.getHighOrderbits(result[11]);
            OracleConnection intConn = ((oracle.jdbc.OracleConnection)conn).physicalConnectionWithin();
            TIMEZONETAB tzTab = intConn.getTIMEZONETAB();
            if (tzTab.checkID(regionID += TIMESTAMPTZ.getLowOrderbits(result[12]))) {
                tzTab.updateTable(intConn, regionID);
            }
            regname = ZONEIDMAP.getRegion(regionID);
            int offset_gmt = tzTab.getOffset(calUTC, regionID);
            calUTC.add(14, offset_gmt);
        } else {
            int off_hour = result[11] - OFFSET_HOUR;
            int off_minute = result[12] - OFFSET_MINUTE;
            regname = off_hour + ":";
            regname = off_minute == 0 ? (String)regname + "00" : (String)regname + off_minute;
            calUTC.add(10, off_hour);
            calUTC.add(12, off_minute);
        }
        year = calUTC.get(1);
        if (calUTC.get(0) == 0) {
            year = -(year - 1);
        }
        int month = calUTC.get(2) + 1;
        int date = calUTC.get(5);
        int hour = calUTC.get(11);
        int minute = calUTC.get(12);
        int second = calUTC.get(13);
        int nanos = 0;
        nanos = (result[7] & 0xFF) << 24;
        nanos |= (result[8] & 0xFF) << 16;
        nanos |= (result[9] & 0xFF) << 8;
        return TIMESTAMPTZ.toString(year, month, date, hour, minute, second, nanos |= result[10] & 0xFF & 0xFF, (String)regname);
    }

    /*
     * WARNING - void declaration
     */
    public static OffsetDateTime toOffsetDateTime(Connection connection, byte[] byArray) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$8, null, connection, byArray);
            }
            int[] result = new int[13];
            for (int i2 = 0; i2 < 13; ++i2) {
                void timestamptz;
                result[i2] = timestamptz[i2] & 0xFF;
            }
            Calendar calUTC = (Calendar)CAL_GMT_US.clone();
            int year = TIMESTAMP.getJavaYear(result[0], result[1]);
            calUTC.set(1, year);
            calUTC.set(2, result[2] - 1);
            calUTC.set(5, result[3]);
            calUTC.set(11, result[4] - 1);
            calUTC.set(12, result[5] - 1);
            calUTC.set(13, result[6] - 1);
            calUTC.set(14, 0);
            ZoneOffset zOffset = null;
            if ((result[11] & REGIONIDBIT) != 0) {
                Connection conn;
                int regionID = TIMESTAMPTZ.getHighOrderbits(result[11]);
                OracleConnection intConn = ((oracle.jdbc.OracleConnection)conn).physicalConnectionWithin();
                TIMEZONETAB tzTab = intConn.getTIMEZONETAB();
                if (tzTab.checkID(regionID += TIMESTAMPTZ.getLowOrderbits(result[12]))) {
                    tzTab.updateTable(intConn, regionID);
                }
                int offset_gmt = tzTab.getOffset(calUTC, regionID);
                calUTC.add(14, offset_gmt);
                zOffset = ZoneOffset.ofTotalSeconds(offset_gmt / SECOND_MILLISECOND);
            } else {
                int off_hour = result[11] - OFFSET_HOUR;
                int off_minute = result[12] - OFFSET_MINUTE;
                calUTC.add(10, off_hour);
                calUTC.add(12, off_minute);
                zOffset = ZoneOffset.ofHoursMinutes(off_hour, off_minute);
            }
            year = calUTC.get(1);
            if (calUTC.get(0) == 0) {
                year = -(year - 1);
            }
            int month = calUTC.get(2) + 1;
            int date = calUTC.get(5);
            int hour = calUTC.get(11);
            int minute = calUTC.get(12);
            int second = calUTC.get(13);
            int nanos = 0;
            nanos = (result[7] & 0xFF) << 24;
            nanos |= (result[8] & 0xFF) << 16;
            nanos |= (result[9] & 0xFF) << 8;
            OffsetDateTime offsetDateTime = OffsetDateTime.of(year, month, date, hour, minute, second, nanos |= result[10] & 0xFF & 0xFF, zOffset);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$8, null, offsetDateTime);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$8, null, null);
            }
            return offsetDateTime;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$8, null, throwable2);
            }
            throw throwable;
        }
    }

    @DisableTrace
    public static final String toString(int year, int month, int day, int hours, int minutes, int seconds, int nanos, String regionName) {
        String stringRep = year + "-" + TIMESTAMPTZ.toStr(month) + "-" + TIMESTAMPTZ.toStr(day) + " " + TIMESTAMPTZ.toStr(hours) + ":" + TIMESTAMPTZ.toStr(minutes) + ":" + TIMESTAMPTZ.toStr(seconds);
        if (nanos >= 0) {
            int i2;
            String nanoString = String.format("%09d", nanos);
            char[] nanoChars = nanoString.toCharArray();
            for (i2 = nanoChars.length; i2 > 1 && nanoChars[i2 - 1] == '0'; --i2) {
            }
            nanoString = nanoString.substring(0, i2);
            stringRep = stringRep + "." + nanoString;
        }
        if (regionName != null) {
            stringRep = stringRep + " " + regionName;
        }
        return stringRep;
    }

    private static final String toStr(int n2) {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            int x2;
            Object object;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$9, null, n2);
            }
            Object object2 = object = x2 < 10 ? "0" + x2 : Integer.toString(x2);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$9, null, object);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$9, null, null);
            }
            return object2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$9, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Timestamp timestampValue(Connection connection) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            void conn;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$10, this, connection);
            }
            if (((oracle.jdbc.OracleConnection)conn).physicalConnectionWithin().getTimestamptzInGmt()) {
                Timestamp timestamp = TIMESTAMPTZ.toTimestamp2((Connection)conn, this.getBytes());
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$10, this, timestamp);
                    ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$10, this, null);
                }
                return timestamp;
            }
            Timestamp timestamp = TIMESTAMPTZ.toTimestamp((Connection)conn, this.getBytes());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$10, this, timestamp);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$10, this, null);
            }
            return timestamp;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public byte[] toBytes() {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$11, this, new Object[0]);
            }
            byte[] byArray = this.getBytes();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$11, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$11, this, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] toBytes(Connection connection, Date date) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            void date2;
            Connection conn;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$12, null, connection, date);
            }
            byte[] byArray = TIMESTAMPTZ.toBytes(conn, (Date)date2, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$12, null, byArray);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$12, null, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$12, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] toBytes(Connection connection, Date date, Calendar calendar) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            void cal;
            Connection conn;
            void date2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$13, null, connection, date, calendar);
            }
            if (date2 == null) {
                byte[] byArray = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$13, null, byArray);
                    ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$13, null, null);
                }
                return null;
            }
            byte[] result = new byte[13];
            Calendar cal1 = TIMESTAMPTZ.getWorkCal(conn, (Calendar)cal);
            cal1.setTime((java.util.Date)date2);
            if (OracleDriver.getSystemPropertyDateZeroTime()) {
                cal1.set(11, 0);
                cal1.set(12, 0);
                cal1.set(13, 0);
            }
            Calendar cal2 = TIMESTAMPTZ.doCalWork(conn, cal1, result);
            int year = TIMESTAMP.getOracleYear(cal2);
            result[0] = (byte)(year / 100 + 100);
            result[1] = (byte)(year % 100 + 100);
            result[2] = (byte)(cal2.get(2) + 1);
            result[3] = (byte)cal2.get(5);
            result[4] = (byte)(cal2.get(11) + 1);
            result[5] = (byte)(cal2.get(12) + 1);
            result[6] = (byte)(cal2.get(13) + 1);
            result[7] = 0;
            result[8] = 0;
            result[9] = 0;
            result[10] = 0;
            byte[] byArray = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$13, null, byArray);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$13, null, null);
            }
            return result;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$13, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] toBytes(Connection connection, Time time) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            void time2;
            Connection conn;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$14, null, connection, time);
            }
            byte[] byArray = TIMESTAMPTZ.toBytes(conn, (Time)time2, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$14, null, byArray);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$14, null, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$14, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] toBytes(Connection connection, Time time, Calendar calendar) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            void cal;
            Connection conn;
            void time2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$15, null, connection, time, calendar);
            }
            if (time2 == null) {
                byte[] byArray = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$15, null, byArray);
                    ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$15, null, null);
                }
                return null;
            }
            byte[] result = new byte[13];
            Calendar cal1 = TIMESTAMPTZ.getWorkCal(conn, (Calendar)cal);
            cal1.setTime((java.util.Date)time2);
            int defaultYear = ((oracle.jdbc.OracleConnection)conn).physicalConnectionWithin().getUse1900AsYearForTime() ? 1900 : 1970;
            cal1.set(1, defaultYear);
            cal1.set(2, 0);
            cal1.set(5, 1);
            Calendar cal2 = TIMESTAMPTZ.doCalWork(conn, cal1, result);
            int year = TIMESTAMP.getOracleYear(cal2);
            result[0] = (byte)(year / 100 + 100);
            result[1] = (byte)(year % 100 + 100);
            result[2] = (byte)(cal2.get(2) + 1);
            result[3] = (byte)cal2.get(5);
            result[4] = (byte)(cal2.get(11) + 1);
            result[5] = (byte)(cal2.get(12) + 1);
            result[6] = (byte)(cal2.get(13) + 1);
            result[7] = 0;
            result[8] = 0;
            result[9] = 0;
            result[10] = 0;
            byte[] byArray = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$15, null, byArray);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$15, null, null);
            }
            return result;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$15, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] toBytes(Connection connection, Timestamp timestamp) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            void timestamp2;
            Connection conn;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$16, null, connection, timestamp);
            }
            byte[] byArray = TIMESTAMPTZ.toBytes(conn, (Timestamp)timestamp2, (Calendar)null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$16, null, byArray);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$16, null, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$16, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] toBytes(Connection connection, Timestamp timestamp, Calendar calendar) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            void cal;
            Connection conn;
            void timestamp2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$17, null, connection, timestamp, calendar);
            }
            if (timestamp2 == null) {
                byte[] byArray = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$17, null, byArray);
                    ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$17, null, null);
                }
                return null;
            }
            byte[] result = new byte[13];
            Calendar cal1 = TIMESTAMPTZ.getWorkCal(conn, (Calendar)cal);
            cal1.setTime((java.util.Date)timestamp2);
            Calendar cal2 = TIMESTAMPTZ.doCalWork(conn, cal1, result);
            int year = TIMESTAMP.getOracleYear(cal2);
            result[0] = (byte)(year / 100 + 100);
            result[1] = (byte)(year % 100 + 100);
            result[2] = (byte)(cal2.get(2) + 1);
            result[3] = (byte)cal2.get(5);
            result[4] = (byte)(cal2.get(11) + 1);
            result[5] = (byte)(cal2.get(12) + 1);
            result[6] = (byte)(cal2.get(13) + 1);
            result[7] = (byte)(timestamp2.getNanos() >> 24);
            result[8] = (byte)(timestamp2.getNanos() >> 16 & 0xFF);
            result[9] = (byte)(timestamp2.getNanos() >> 8 & 0xFF);
            result[10] = (byte)(timestamp2.getNanos() & 0xFF);
            byte[] byArray = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$17, null, byArray);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$17, null, null);
            }
            return result;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$17, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] toBytes(Connection connection, Timestamp timestamp, ZoneId zoneId) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            byte[] result;
            block9: {
                void tzid;
                void timestamp2;
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$18, null, connection, timestamp, zoneId);
                }
                result = new byte[13];
                Calendar gmtCal = (Calendar)CAL_GMT_US.clone();
                gmtCal.setTime((java.util.Date)timestamp2);
                int year = TIMESTAMP.getOracleYear(gmtCal);
                result[0] = (byte)(year / 100 + 100);
                result[1] = (byte)(year % 100 + 100);
                result[2] = (byte)(gmtCal.get(2) + 1);
                result[3] = (byte)gmtCal.get(5);
                result[4] = (byte)(gmtCal.get(11) + 1);
                result[5] = (byte)(gmtCal.get(12) + 1);
                result[6] = (byte)(gmtCal.get(13) + 1);
                result[7] = (byte)(timestamp2.getNanos() >> 24);
                result[8] = (byte)(timestamp2.getNanos() >> 16 & 0xFF);
                result[9] = (byte)(timestamp2.getNanos() >> 8 & 0xFF);
                result[10] = (byte)(timestamp2.getNanos() & 0xFF);
                String timeZone = tzid.getId();
                int regionId = ZONEIDMAP.getID(timeZone);
                if (!ZONEIDMAP.isValidID(regionId)) {
                    ZoneRules zRule = tzid.getRules();
                    if (zRule.isFixedOffset()) {
                        ZoneOffset zOff = zRule.getOffset(timestamp2.toInstant());
                        int offset = zOff.getTotalSeconds();
                        result[11] = (byte)(offset / HOUR_SECOND + OFFSET_HOUR);
                        result[12] = (byte)(offset % HOUR_SECOND / MINUTE_SECOND + OFFSET_MINUTE);
                        break block9;
                    } else {
                        SQLException sQLException = new SQLException("Timezone not supported: " + timeZone);
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$18, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$18, null, sQLException);
                        }
                        throw sQLException;
                    }
                }
                result[11] = (byte)TIMESTAMPTZ.setHighOrderbits(regionId);
                result[11] = (byte)(result[11] | REGIONIDBIT);
                result[12] = (byte)TIMESTAMPTZ.setLowOrderbits(regionId);
            }
            byte[] byArray = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$18, null, byArray);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$18, null, null);
            }
            return result;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$18, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] toBytes(Connection connection, DATE dATE) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            Connection conn;
            void date;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$19, null, connection, dATE);
            }
            if (date == null) {
                byte[] byArray = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$19, null, byArray);
                    ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$19, null, null);
                }
                return null;
            }
            byte[] result = new byte[13];
            Calendar cal = TIMESTAMPTZ.getWorkCal(conn, null);
            cal.setTime(DATE.toDate(date.toBytes()));
            Calendar cal1 = TIMESTAMPTZ.doCalWork(conn, cal, result);
            int year = TIMESTAMP.getOracleYear(cal1);
            result[0] = (byte)(year / 100 + 100);
            result[1] = (byte)(year % 100 + 100);
            result[2] = (byte)(cal1.get(2) + 1);
            result[3] = (byte)cal1.get(5);
            result[4] = (byte)(cal1.get(11) + 1);
            result[5] = (byte)(cal1.get(12) + 1);
            result[6] = (byte)(cal1.get(13) + 1);
            result[7] = 0;
            result[8] = 0;
            result[9] = 0;
            result[10] = 0;
            byte[] byArray = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$19, null, byArray);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$19, null, null);
            }
            return result;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$19, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] toBytes(Connection connection, String string) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            byte[] result;
            void str;
            Connection conn;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$20, null, connection, string);
            }
            try {
                result = TIMESTAMPTZ.toBytes(conn, Timestamp.valueOf((String)str));
            }
            catch (IllegalArgumentException ia) {
                result = TIMESTAMPTZ.parseTimestampTz(conn, (String)str);
            }
            byte[] byArray = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$20, null, byArray);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$20, null, null);
            }
            return result;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$20, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] toBytes(Connection connection, String string, Calendar calendar) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            Connection conn;
            void cal;
            void str;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$21, null, connection, string, calendar);
            }
            Calendar local = (Calendar)CAL_GMT_US.clone();
            Timestamp ts = TIMESTAMPTZ.parseTimestamp((String)str);
            local.setTime(ts);
            Calendar cal1 = cal == null ? Calendar.getInstance() : Calendar.getInstance(cal.getTimeZone());
            cal1.set(1, local.get(1));
            cal1.set(2, local.get(2));
            cal1.set(5, local.get(5));
            cal1.set(11, local.get(11));
            cal1.set(12, local.get(12));
            cal1.set(13, local.get(13));
            cal1.set(14, local.get(14));
            int nano = ts.getNanos();
            ts = new Timestamp(cal1.getTime().getTime());
            ts.setNanos(nano);
            byte[] byArray = TIMESTAMPTZ.toBytes(conn, ts, (Calendar)cal);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$21, null, byArray);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$21, null, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$21, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String stringValue(Connection connection) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            void conn;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$22, this, connection);
            }
            String string = TIMESTAMPTZ.toString((Connection)conn, this.getBytes());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$22, this, string);
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$22, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$22, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public OffsetDateTime offsetDateTimeValue(Connection connection) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            void conn;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$23, this, connection);
            }
            OffsetDateTime offsetDateTime = TIMESTAMPTZ.toOffsetDateTime((Connection)conn, this.getBytes());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$23, this, offsetDateTime);
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$23, this, null);
            }
            return offsetDateTime;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$23, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Date dateValue(Connection connection) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            void conn;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$24, this, connection);
            }
            if (((oracle.jdbc.OracleConnection)conn).physicalConnectionWithin().getTimestamptzInGmt()) {
                Date date = TIMESTAMPTZ.toDate2((Connection)conn, this.getBytes());
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$24, this, date);
                    ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$24, this, null);
                }
                return date;
            }
            Date date = TIMESTAMPTZ.toDate((Connection)conn, this.getBytes());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$24, this, date);
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$24, this, null);
            }
            return date;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$24, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Time timeValue(Connection connection) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            void conn;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$25, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$25, this, connection);
            }
            Time time = TIMESTAMPTZ.toTime((Connection)conn, this.getBytes());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$25, this, time);
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$25, this, null);
            }
            return time;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$25, this, throwable2);
            }
            throw throwable;
        }
    }

    public TimeZone getTimeZone() throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            Object tzname;
            byte[] bits;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$26, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$26, this, new Object[0]);
            }
            if (((bits = this.shareBytes())[11] & REGIONIDBIT) != 0) {
                int regionID = TIMESTAMPTZ.getHighOrderbits(bits[11]);
                tzname = ZONEIDMAP.getRegion(regionID += TIMESTAMPTZ.getLowOrderbits(bits[12]));
            } else {
                int off_hour = bits[11] - OFFSET_HOUR;
                int off_minute = bits[12] - OFFSET_MINUTE;
                String regname = off_hour + ":";
                regname = off_minute == 0 ? regname + "00" : regname + off_minute;
                tzname = "GMT" + (off_hour >= 0 ? "+" : "") + regname;
            }
            TimeZone timeZone = TimeZone.getTimeZone((String)tzname);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$26, this, timeZone);
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$26, this, null);
            }
            return timeZone;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$26, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Calendar getWorkCal(Connection connection, Calendar calendar) {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            Connection conn;
            String locTimeZone;
            void cal;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$27, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$27, null, connection, calendar);
            }
            Calendar cal1 = cal == null ? ((locTimeZone = ((oracle.jdbc.OracleConnection)conn).getSessionTimeZone()) != null ? Calendar.getInstance(TimeZone.getTimeZone(locTimeZone)) : Calendar.getInstance()) : Calendar.getInstance(cal.getTimeZone());
            Calendar calendar2 = cal1;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$27, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$27, null, calendar2);
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$27, null, null);
            }
            return calendar2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$27, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Calendar doCalWork(Connection connection, Calendar calendar, byte[] byArray) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            int offset;
            void cal;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$28, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$28, null, connection, calendar, byArray);
            }
            if (cal.getTimeZone().getID() == "Custom") {
                offset = cal.getTimeZone().getRawOffset();
                result[11] = (byte)(offset / HOUR_MILLISECOND + OFFSET_HOUR);
                result[12] = (byte)(offset % HOUR_MILLISECOND / MINUTE_MILLISECOND + OFFSET_MINUTE);
            } else {
                String timeZone = cal.getTimeZone().getID();
                int regionId = ZONEIDMAP.getID(timeZone);
                if (!ZONEIDMAP.isValidID(regionId)) {
                    if (cal.getTimeZone().useDaylightTime()) {
                        SQLException sQLException = new SQLException("Timezone not supported: " + timeZone);
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$28, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$28, null, sQLException);
                        }
                        throw sQLException;
                    }
                    offset = cal.getTimeZone().getRawOffset();
                    result[11] = (byte)(offset / HOUR_MILLISECOND + OFFSET_HOUR);
                    result[12] = (byte)(offset % HOUR_MILLISECOND / MINUTE_MILLISECOND + OFFSET_MINUTE);
                } else {
                    void result;
                    Connection conn;
                    TIMEZONETAB tzTab = TIMESTAMPTZ.getTIMEZONETAB(conn);
                    if (tzTab.checkID(regionId)) {
                        tzTab.updateTable(conn, regionId);
                    }
                    OffsetDST trans_data = new OffsetDST();
                    byte olap = tzTab.getLocalOffset((Calendar)cal, regionId, trans_data);
                    offset = trans_data.getOFFSET();
                    boolean overlap = cal.getTimeZone().inDaylightTime(cal.getTime());
                    if (overlap && olap == 1) {
                        if (trans_data.getDSTFLAG() == 0) {
                            offset += HOUR_MILLISECOND;
                        } else {
                            SQLException sQLException = new SQLException();
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$28, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$28, null, sQLException);
                            }
                            throw sQLException;
                        }
                    }
                    result[11] = (byte)TIMESTAMPTZ.setHighOrderbits(regionId);
                    void v0 = result;
                    v0[11] = (byte)(v0[11] | REGIONIDBIT);
                    result[12] = (byte)TIMESTAMPTZ.setLowOrderbits(regionId);
                }
            }
            Calendar gmtCal = (Calendar)CAL_GMT_US.clone();
            gmtCal.set(0, cal.get(0));
            gmtCal.set(1, cal.get(1));
            gmtCal.set(2, cal.get(2));
            gmtCal.set(5, cal.get(5));
            gmtCal.set(11, cal.get(11));
            gmtCal.set(12, cal.get(12));
            gmtCal.set(13, cal.get(13));
            gmtCal.add(14, -1 * offset);
            Calendar calendar2 = gmtCal;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$28, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$28, null, calendar2);
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$28, null, null);
            }
            return calendar2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$28, null, throwable2);
            }
            throw throwable;
        }
    }

    private static byte[] initTimestamptz() {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$29, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$29, null, new Object[0]);
            }
            byte[] tmp = new byte[13];
            Calendar cal = Calendar.getInstance();
            tmp[0] = 119;
            tmp[1] = -86;
            tmp[2] = 1;
            tmp[3] = 1;
            tmp[4] = 1;
            tmp[5] = 1;
            tmp[6] = 1;
            tmp[7] = 0;
            tmp[8] = 0;
            tmp[9] = 0;
            tmp[10] = 0;
            String timeZone = cal.getTimeZone().getID();
            tmp[11] = (byte)TIMESTAMPTZ.setHighOrderbits(ZONEIDMAP.getID(timeZone));
            tmp[11] = (byte)(tmp[11] | REGIONIDBIT);
            tmp[12] = (byte)TIMESTAMPTZ.setLowOrderbits(ZONEIDMAP.getID(timeZone));
            byte[] byArray = tmp;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$29, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$29, null, byArray);
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$29, null, null);
            }
            return tmp;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$29, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Object toJdbc() throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$30, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$30, this, new Object[0]);
            }
            TIMESTAMPTZ tIMESTAMPTZ = this;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$30, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$30, this, tIMESTAMPTZ);
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$30, this, null);
            }
            return tIMESTAMPTZ;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$30, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object makeJdbcArray(int n2) {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            void arraySize;
            Timestamp[] ts;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$31, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$31, this, n2);
            }
            Timestamp[] timestampArray = ts = new Timestamp[arraySize];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$31, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$31, this, timestampArray);
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$31, this, null);
            }
            return ts;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$31, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isConvertibleTo(Class clazz) {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            void cls;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$32, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$32, this, clazz);
            }
            if (cls.getName().compareTo("java.sql.Date") == 0 || cls.getName().compareTo("java.sql.Time") == 0 || cls.getName().compareTo("java.sql.Timestamp") == 0 || cls.getName().compareTo("java.lang.String") == 0) {
                boolean bl2 = true;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$32, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$32, this, bl2);
                    ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$32, this, null);
                }
                return true;
            }
            boolean bl3 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$32, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$32, this, bl3);
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$32, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$32, this, throwable2);
            }
            throw throwable;
        }
    }

    private static Timestamp parseTimestamp(String string) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            int second;
            String sTime;
            String timeStr;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$33, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$33, null, string);
            }
            if (timeStr == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$33, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$33, null, sQLException);
                }
                throw sQLException;
            }
            String sTemp = timeStr.trim();
            int spacePos = sTemp.indexOf(32);
            if (spacePos == -1) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$33, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$33, null, sQLException);
                }
                throw sQLException;
            }
            String sDate = sTemp.substring(0, spacePos).trim();
            if (sDate == null | (sTime = sTemp.substring(spacePos + 1).trim()) == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$33, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$33, null, sQLException);
                }
                throw sQLException;
            }
            int posH1 = sDate.indexOf(45);
            int posH2 = sDate.indexOf(45, posH1 + 1);
            if (posH1 < 1 || posH2 < 1 || posH2 == sDate.length()) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$33, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$33, null, sQLException);
                }
                throw sQLException;
            }
            String sYear = sDate.substring(0, posH1);
            String sMonth = sDate.substring(posH1 + 1, posH2);
            String sDay = sDate.substring(posH2 + 1);
            if (sYear.length() != 4 || sMonth.length() != 2 || sDay.length() != 2) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$33, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$33, null, sQLException);
                }
                throw sQLException;
            }
            int year = Integer.parseInt(sYear);
            int month = Integer.parseInt(sMonth) - 1;
            int day = Integer.parseInt(sDay);
            int posC1 = sTime.indexOf(58);
            int posC2 = sTime.indexOf(58, posC1 + 1);
            if (posC1 < 1 || posC2 < 1 || posC2 == sTime.length()) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$33, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$33, null, sQLException);
                }
                throw sQLException;
            }
            String sHour = sTime.substring(0, posC1);
            String sMinute = sTime.substring(posC1 + 1, posC2);
            if (sHour.length() != 2 || sMinute.length() != 2) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$33, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$33, null, sQLException);
                }
                throw sQLException;
            }
            int hour = Integer.parseInt(sHour);
            int minute = Integer.parseInt(sMinute);
            int nanos = 0;
            int posDot = sTime.indexOf(46, posC2 + 1);
            if (posDot == -1) {
                second = Integer.parseInt(sTime.substring(posC2 + 1));
            } else if (posDot > 0 && posDot < sTime.length() - 1) {
                second = Integer.parseInt(sTime.substring(posC2 + 1, posDot));
                Object sNanos = sTime.substring(posDot + 1);
                String zeroes = "000000000";
                if (((String)sNanos).length() > zeroes.length() || !Character.isDigit(((String)sNanos).charAt(0))) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$33, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$33, null, sQLException);
                    }
                    throw sQLException;
                }
                sNanos = (String)sNanos + zeroes.substring(0, zeroes.length() - ((String)sNanos).length());
                nanos = Integer.parseInt((String)sNanos);
            } else {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$33, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$33, null, sQLException);
                }
                throw sQLException;
            }
            Calendar cal = (Calendar)CAL_GMT_US.clone();
            cal.set(1, year);
            cal.set(2, month);
            cal.set(5, day);
            cal.set(11, hour);
            cal.set(12, minute);
            cal.set(13, second);
            cal.set(14, 0);
            Timestamp result = new Timestamp(cal.getTime().getTime());
            result.setNanos(nanos);
            Timestamp timestamp = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$33, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$33, null, timestamp);
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$33, null, null);
            }
            return timestamp;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$33, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] parseTimestampTz(Connection connection, String string) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            Connection conn;
            int second;
            Object sTz;
            String sTime;
            void timeStr;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$34, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$34, null, connection, string);
            }
            if (timeStr == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$34, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$34, null, sQLException);
                }
                throw sQLException;
            }
            String sTemp = timeStr.trim();
            int spacePos = sTemp.indexOf(32);
            if (spacePos == -1) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$34, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$34, null, sQLException);
                }
                throw sQLException;
            }
            String sDate = sTemp.substring(0, spacePos).trim();
            if (sDate == null | (sTime = sTemp.substring(spacePos + 1).trim()) == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$34, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$34, null, sQLException);
                }
                throw sQLException;
            }
            boolean nYear = false;
            if (sDate.charAt(0) == '-') {
                nYear = true;
                if (sDate.length() > 1) {
                    sDate = sDate.substring(1);
                } else {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$34, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$34, null, sQLException);
                    }
                    throw sQLException;
                }
            }
            int posH1 = sDate.indexOf(45);
            int posH2 = sDate.indexOf(45, posH1 + 1);
            if (posH1 < 1 || posH2 < 1 || posH2 == sDate.length()) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$34, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$34, null, sQLException);
                }
                throw sQLException;
            }
            String sYear = sDate.substring(0, posH1);
            String sMonth = sDate.substring(posH1 + 1, posH2);
            String sDay = sDate.substring(posH2 + 1);
            if (sYear.length() != 4 || sMonth.length() != 2 || sDay.length() != 2) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$34, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$34, null, sQLException);
                }
                throw sQLException;
            }
            int year = Integer.parseInt(sYear);
            int month = Integer.parseInt(sMonth) - 1;
            int day = Integer.parseInt(sDay);
            if (nYear) {
                year = -year;
            }
            int posC1 = sTime.indexOf(58);
            int posC2 = sTime.indexOf(58, posC1 + 1);
            spacePos = sTime.indexOf(32);
            if (spacePos != -1) {
                sTz = sTime.substring(spacePos + 1).trim();
                sTime = sTime.substring(0, spacePos).trim();
            } else {
                sTz = null;
            }
            if (posC1 < 1 || posC2 < 1 || posC2 == sTime.length()) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$34, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$34, null, sQLException);
                }
                throw sQLException;
            }
            String sHour = sTime.substring(0, posC1);
            String sMinute = sTime.substring(posC1 + 1, posC2);
            if (sHour.length() != 2 || sMinute.length() != 2) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$34, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$34, null, sQLException);
                }
                throw sQLException;
            }
            int hour = Integer.parseInt(sHour);
            int minute = Integer.parseInt(sMinute);
            int nanos = 0;
            int posDot = sTime.indexOf(46, posC2 + 1);
            if (posDot == -1) {
                second = Integer.parseInt(sTime.substring(posC2 + 1));
            } else if (posDot > 0 && posDot < sTime.length() - 1) {
                second = Integer.parseInt(sTime.substring(posC2 + 1, posDot));
                Object sNanos = sTime.substring(posDot + 1);
                String zeroes = "000000000";
                if (((String)sNanos).length() > zeroes.length() || !Character.isDigit(((String)sNanos).charAt(0))) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$34, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$34, null, sQLException);
                    }
                    throw sQLException;
                }
                sNanos = (String)sNanos + zeroes.substring(0, zeroes.length() - ((String)sNanos).length());
                nanos = Integer.parseInt((String)sNanos);
            } else {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$34, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$34, null, sQLException);
                }
                throw sQLException;
            }
            Calendar cal2 = null;
            if (sTz != null) {
                char cTz = ((String)sTz).charAt(0);
                if (cTz == '-') {
                    sTz = "GMT" + (String)sTz;
                } else if (Character.isDigit(cTz)) {
                    sTz = "GMT+" + (String)sTz;
                }
                cal2 = Calendar.getInstance(TimeZone.getTimeZone((String)sTz));
            }
            Calendar cal = cal2 == null ? (Calendar)CAL_GMT_US.clone() : cal2;
            cal.set(1, year);
            cal.set(2, month);
            cal.set(5, day);
            cal.set(11, hour);
            cal.set(12, minute);
            cal.set(13, second);
            cal.set(14, 0);
            Timestamp result = new Timestamp(cal.getTime().getTime());
            result.setNanos(nanos);
            byte[] byArray = TIMESTAMPTZ.toBytes(conn, result, cal2);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$34, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$34, null, byArray);
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$34, null, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$34, null, throwable2);
            }
            throw throwable;
        }
    }

    private static int setHighOrderbits(int n2) {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            int ID;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$35, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$35, null, n2);
            }
            int n3 = (ID & 0x1FC0) >> 6;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$35, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$35, null, n3);
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$35, null, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$35, null, throwable2);
            }
            throw throwable;
        }
    }

    private static int setLowOrderbits(int n2) {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            int ID;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$36, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$36, null, n2);
            }
            int n3 = (ID & 0x3F) << 2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$36, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$36, null, n3);
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$36, null, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$36, null, throwable2);
            }
            throw throwable;
        }
    }

    private static int getHighOrderbits(int n2) {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            int hour;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$37, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$37, null, n2);
            }
            int n3 = (hour & 0x7F) << 6;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$37, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$37, null, n3);
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$37, null, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$37, null, throwable2);
            }
            throw throwable;
        }
    }

    private static int getLowOrderbits(int n2) {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            int minute;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$38, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$38, null, n2);
            }
            int n3 = (minute & 0xFC) >> 2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$38, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$38, null, n3);
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$38, null, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$38, null, throwable2);
            }
            throw throwable;
        }
    }

    static TIMEZONETAB getTIMEZONETAB(Connection connection) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            Connection conn;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$39, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$39, null, connection);
            }
            OracleConnection oconn = ((oracle.jdbc.OracleConnection)conn).physicalConnectionWithin();
            TIMEZONETAB tIMEZONETAB = oconn.getTIMEZONETAB();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$39, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$39, null, tIMEZONETAB);
                ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$39, null, null);
            }
            return tIMEZONETAB;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, TIMESTAMPTZ.class, $$$methodRef$$$39, null, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$51 = TIMESTAMPTZ.class.getDeclaredConstructor(Connection.class, String.class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$50 = TIMESTAMPTZ.class.getDeclaredConstructor(Connection.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$49 = TIMESTAMPTZ.class.getDeclaredConstructor(Connection.class, DATE.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$48 = TIMESTAMPTZ.class.getDeclaredConstructor(Connection.class, Timestamp.class, ZoneId.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$47 = TIMESTAMPTZ.class.getDeclaredConstructor(Connection.class, Timestamp.class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$46 = TIMESTAMPTZ.class.getDeclaredConstructor(Connection.class, Timestamp.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$45 = TIMESTAMPTZ.class.getDeclaredConstructor(Connection.class, Time.class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$44 = TIMESTAMPTZ.class.getDeclaredConstructor(Connection.class, Time.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$43 = TIMESTAMPTZ.class.getDeclaredConstructor(Connection.class, Date.class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$42 = TIMESTAMPTZ.class.getDeclaredConstructor(Connection.class, Date.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$41 = TIMESTAMPTZ.class.getDeclaredConstructor(byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$40 = TIMESTAMPTZ.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$39 = TIMESTAMPTZ.class.getDeclaredMethod("getTIMEZONETAB", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$38 = TIMESTAMPTZ.class.getDeclaredMethod("getLowOrderbits", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$37 = TIMESTAMPTZ.class.getDeclaredMethod("getHighOrderbits", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$36 = TIMESTAMPTZ.class.getDeclaredMethod("setLowOrderbits", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$35 = TIMESTAMPTZ.class.getDeclaredMethod("setHighOrderbits", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$34 = TIMESTAMPTZ.class.getDeclaredMethod("parseTimestampTz", Connection.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$33 = TIMESTAMPTZ.class.getDeclaredMethod("parseTimestamp", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$32 = TIMESTAMPTZ.class.getDeclaredMethod("isConvertibleTo", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$31 = TIMESTAMPTZ.class.getDeclaredMethod("makeJdbcArray", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$30 = TIMESTAMPTZ.class.getDeclaredMethod("toJdbc", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$29 = TIMESTAMPTZ.class.getDeclaredMethod("initTimestamptz", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$28 = TIMESTAMPTZ.class.getDeclaredMethod("doCalWork", Connection.class, Calendar.class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$27 = TIMESTAMPTZ.class.getDeclaredMethod("getWorkCal", Connection.class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$26 = TIMESTAMPTZ.class.getDeclaredMethod("getTimeZone", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$25 = TIMESTAMPTZ.class.getDeclaredMethod("timeValue", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$24 = TIMESTAMPTZ.class.getDeclaredMethod("dateValue", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$23 = TIMESTAMPTZ.class.getDeclaredMethod("offsetDateTimeValue", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$22 = TIMESTAMPTZ.class.getDeclaredMethod("stringValue", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$21 = TIMESTAMPTZ.class.getDeclaredMethod("toBytes", Connection.class, String.class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$20 = TIMESTAMPTZ.class.getDeclaredMethod("toBytes", Connection.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$19 = TIMESTAMPTZ.class.getDeclaredMethod("toBytes", Connection.class, DATE.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$18 = TIMESTAMPTZ.class.getDeclaredMethod("toBytes", Connection.class, Timestamp.class, ZoneId.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$17 = TIMESTAMPTZ.class.getDeclaredMethod("toBytes", Connection.class, Timestamp.class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$16 = TIMESTAMPTZ.class.getDeclaredMethod("toBytes", Connection.class, Timestamp.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$15 = TIMESTAMPTZ.class.getDeclaredMethod("toBytes", Connection.class, Time.class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$14 = TIMESTAMPTZ.class.getDeclaredMethod("toBytes", Connection.class, Time.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$13 = TIMESTAMPTZ.class.getDeclaredMethod("toBytes", Connection.class, Date.class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$12 = TIMESTAMPTZ.class.getDeclaredMethod("toBytes", Connection.class, Date.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$11 = TIMESTAMPTZ.class.getDeclaredMethod("toBytes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$10 = TIMESTAMPTZ.class.getDeclaredMethod("timestampValue", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$9 = TIMESTAMPTZ.class.getDeclaredMethod("toStr", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$8 = TIMESTAMPTZ.class.getDeclaredMethod("toOffsetDateTime", Connection.class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$7 = TIMESTAMPTZ.class.getDeclaredMethod("toTimestampInSessionTimezone", Connection.class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$6 = TIMESTAMPTZ.class.getDeclaredMethod("toTimestamp2", Connection.class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$5 = TIMESTAMPTZ.class.getDeclaredMethod("toTimestamp", Connection.class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$4 = TIMESTAMPTZ.class.getDeclaredMethod("toTIMESTAMP", Connection.class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$3 = TIMESTAMPTZ.class.getDeclaredMethod("toDATE", Connection.class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$2 = TIMESTAMPTZ.class.getDeclaredMethod("toTime", Connection.class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$1 = TIMESTAMPTZ.class.getDeclaredMethod("toDate2", Connection.class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$0 = TIMESTAMPTZ.class.getDeclaredMethod("toDate", Connection.class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        CAL_GMT_US = Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.US);
        TIMEZONE_UTC = TimeZone.getTimeZone("UTC");
        HOUR_MILLISECOND = 3600000;
        MINUTE_MILLISECOND = 60000;
        SECOND_MILLISECOND = 1000;
        HOUR_SECOND = 3600;
        MINUTE_SECOND = 60;
        OFFSET_HOUR = 20;
        OFFSET_MINUTE = 60;
        REGIONIDBIT = (byte)-128;
    }
}

