/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.differ;

import de.danielbechler.diff.access.Instances;
import de.danielbechler.diff.access.MapEntryAccessor;
import de.danielbechler.diff.comparison.ComparisonStrategyResolver;
import de.danielbechler.diff.differ.Differ;
import de.danielbechler.diff.differ.DifferDispatcher;
import de.danielbechler.diff.node.DiffNode;
import de.danielbechler.util.Assert;
import de.danielbechler.util.Collections;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MapDiffer
implements Differ {
    private final ComparisonStrategyResolver comparisonStrategyResolver;
    private final DifferDispatcher differDispatcher;

    public MapDiffer(DifferDispatcher differDispatcher, ComparisonStrategyResolver comparisonStrategyResolver) {
        Assert.notNull(differDispatcher, "differDispatcher");
        this.differDispatcher = differDispatcher;
        this.comparisonStrategyResolver = comparisonStrategyResolver;
    }

    private static Collection<?> findAddedKeys(Instances instances) {
        Set source = instances.getWorking(Map.class).keySet();
        Set filter = instances.getBase(Map.class).keySet();
        return Collections.filteredCopyOf(source, filter);
    }

    private static Collection<?> findRemovedKeys(Instances instances) {
        Set source = instances.getBase(Map.class).keySet();
        Set filter = instances.getWorking(Map.class).keySet();
        return Collections.filteredCopyOf(source, filter);
    }

    private static Iterable<?> findKnownKeys(Instances instances) {
        Set keys = instances.getWorking(Map.class).keySet();
        Set changed = Collections.setOf(keys);
        changed.removeAll(MapDiffer.findAddedKeys(instances));
        changed.removeAll(MapDiffer.findRemovedKeys(instances));
        return changed;
    }

    @Override
    public boolean accepts(Class<?> type) {
        if (type != null) {
            return Map.class.isAssignableFrom(type);
        }
        return false;
    }

    @Override
    public final DiffNode compare(DiffNode parentNode, Instances instances) {
        DiffNode mapNode = new DiffNode(parentNode, instances.getSourceAccessor(), instances.getType());
        if (instances.hasBeenAdded()) {
            this.compareEntries(mapNode, instances, instances.getWorking(Map.class).keySet());
            mapNode.setState(DiffNode.State.ADDED);
        } else if (instances.hasBeenRemoved()) {
            this.compareEntries(mapNode, instances, instances.getBase(Map.class).keySet());
            mapNode.setState(DiffNode.State.REMOVED);
        } else if (instances.areSame()) {
            mapNode.setState(DiffNode.State.UNTOUCHED);
        } else if (this.comparisonStrategyResolver.resolveComparisonStrategy(mapNode) != null) {
            this.comparisonStrategyResolver.resolveComparisonStrategy(mapNode).compare(mapNode, instances.getType(), instances.getWorking(Map.class), instances.getBase(Map.class));
        } else {
            this.compareEntries(mapNode, instances, MapDiffer.findAddedKeys(instances));
            this.compareEntries(mapNode, instances, MapDiffer.findRemovedKeys(instances));
            this.compareEntries(mapNode, instances, MapDiffer.findKnownKeys(instances));
        }
        return mapNode;
    }

    private void compareEntries(DiffNode mapNode, Instances mapInstances, Iterable<?> keys) {
        for (Object key : keys) {
            this.differDispatcher.dispatch(mapNode, mapInstances, new MapEntryAccessor(key));
        }
    }
}

