/*
 * Decompiled with CFR 0.152.
 */
package io.goeasy;

import io.goeasy.otp.OtpGenerator;
import io.goeasy.publish.PublishListener;
import io.goeasy.publish.Publisher;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoEasy {
    private static Logger log = LoggerFactory.getLogger(Publisher.class);
    public static String artifactVersion = "0.0";
    private Publisher publisher;

    public GoEasy(String regionHost, String appkey) {
        this.publisher = new Publisher(regionHost, appkey);
    }

    public void publish(String channel, String content) {
        this.publish(channel, content, new PublishListener());
    }

    public void publish(String messageId, String channel, String content) {
        this.publish(messageId, channel, content, new PublishListener());
    }

    public void publish(String channel, String content, PublishListener publishListener) {
        this.publish(null, channel, content, false, publishListener);
    }

    public void publish(String messageId, String channel, String content, PublishListener publishListener) {
        this.publish(messageId, channel, content, false, publishListener);
    }

    public void publish(String channel, String content, boolean retained) {
        this.publish(null, channel, content, retained, new PublishListener());
    }

    public void publish(String messageId, String channel, String content, boolean retained) {
        this.publish(messageId, channel, content, retained, new PublishListener());
    }

    public void publish(String messgageId, String channel, String content, boolean retained, PublishListener publishListener) {
        this.publisher.publish(messgageId, channel, content, retained, publishListener);
    }

    public void publish(String channel, String content, String notificationTitle, String notificationBody) {
        this.publish(null, channel, content, notificationTitle, notificationBody);
    }

    public void publish(String channel, String content, String notificationTitle, String notificationBody, PublishListener publishListener) {
        this.publish(null, channel, content, notificationTitle, notificationBody, publishListener);
    }

    public void publish(String messageId, String channel, String content, String notificationTitle, String notificationBody) {
        this.publish(messageId, channel, content, notificationTitle, notificationBody, new PublishListener());
    }

    public void publish(String messageId, String channel, String content, String notificationTitle, String notificationBody, PublishListener publishListener) {
        this.publisher.publish(messageId, channel, content, notificationTitle, notificationBody, publishListener);
    }

    public void setHttps(boolean https) {
        this.publisher.setHttps(https);
    }

    public void setHost(String host) {
        this.publisher.setPublisUrl(host + "/goeasy/publish");
    }

    public static String otp(String secretKey) {
        return OtpGenerator.generate(secretKey);
    }

    static {
        try {
            String manifestPath;
            Manifest manifest;
            Attributes attr;
            String goeasyVersion;
            Class<Publisher> clazz = Publisher.class;
            String className = clazz.getSimpleName() + ".class";
            String classPath = clazz.getResource(className).toString();
            if (classPath.startsWith("jar") && (goeasyVersion = (attr = (manifest = new Manifest(new URL(manifestPath = classPath.substring(0, classPath.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF").openStream())).getMainAttributes()).getValue("goeasy-sdk-artifact-version")) != null) {
                artifactVersion = goeasyVersion;
            }
        }
        catch (Exception e) {
            log.error("load artifact version failed.", (Throwable)e);
        }
    }
}

