/*
 * Decompiled with CFR 0.152.
 */
package io.goeasy.publish;

import com.google.gson.Gson;
import io.goeasy.GoEasy;
import io.goeasy.publish.GoEasyError;
import io.goeasy.publish.GoEasyErrorCode;
import io.goeasy.publish.PublishListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.UUID;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Publisher {
    private static Logger log = LoggerFactory.getLogger(Publisher.class);
    private String appkey;
    private String PUBLISH_URL;
    private static final int CONNECT_TIMEOUT = 3000;
    private static final int READ_TIMEOUT = 3000;
    private int maxRetries = 5;
    private Gson gson = new Gson();

    public Publisher(String regionHost, String appkey) {
        this.appkey = appkey;
        boolean hasProtocol = regionHost.startsWith("http");
        if (!hasProtocol) {
            regionHost = "http://" + regionHost;
        }
        this.PUBLISH_URL = regionHost + "/publish";
    }

    public void publish(String messageId, String channel, String content, String notificationTitle, String notificationBody, PublishListener publishListener) {
        if (this.isEmpty(channel)) {
            publishListener.onFailed(new GoEasyError(GoEasyErrorCode.PARAMETER_ERROR.code(), "Channel is required"));
            return;
        }
        if (this.isEmpty(content)) {
            publishListener.onFailed(new GoEasyError(GoEasyErrorCode.PARAMETER_ERROR.code(), "Content is required"));
            return;
        }
        if (this.isEmpty(notificationTitle)) {
            publishListener.onFailed(new GoEasyError(GoEasyErrorCode.PARAMETER_ERROR.code(), "Notification title is required"));
            return;
        }
        if (notificationTitle.length() > 32) {
            publishListener.onFailed(new GoEasyError(GoEasyErrorCode.PARAMETER_ERROR.code(), "Notification title is over max length 32"));
            return;
        }
        if (this.isEmpty(notificationBody)) {
            publishListener.onFailed(new GoEasyError(GoEasyErrorCode.PARAMETER_ERROR.code(), "Notification body is required"));
            return;
        }
        if (notificationBody.length() > 50) {
            publishListener.onFailed(new GoEasyError(GoEasyErrorCode.PARAMETER_ERROR.code(), "Notification body is over max length 100"));
            return;
        }
        this.doPublish(messageId, channel, content, false, notificationTitle, notificationBody, publishListener);
    }

    public void publish(String messageId, String channel, String content, boolean retained, PublishListener publishListener) {
        if (this.isEmpty(channel)) {
            publishListener.onFailed(new GoEasyError(GoEasyErrorCode.PARAMETER_ERROR.code(), "Channel is required"));
            return;
        }
        if (this.isEmpty(content)) {
            publishListener.onFailed(new GoEasyError(GoEasyErrorCode.PARAMETER_ERROR.code(), "Content is required"));
            return;
        }
        this.doPublish(messageId, channel, content, retained, null, null, publishListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPublish(String messageId, String channel, String content, boolean retained, String notificationTitle, String notificationBody, PublishListener publishListener) {
        int retried = 0;
        int responseCode = GoEasyErrorCode.UNKNOWN_ERROR.code();
        boolean success = false;
        String guid = messageId;
        if (guid == null || guid.trim().length() == 0) {
            guid = UUID.randomUUID().toString();
        }
        while (!success && retried <= this.maxRetries) {
            String string = guid;
            synchronized (string) {
                try {
                    if (retried > 0) {
                        log.debug("retring {} times", (Object)retried);
                        guid.wait(70L);
                    }
                }
                catch (InterruptedException e) {
                    log.error("Delay publish[{}] error.", (Object)guid);
                }
            }
            try {
                URL url = new URL(this.PUBLISH_URL);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setDoInput(true);
                conn.setDoOutput(true);
                conn.setUseCaches(false);
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Accept-Charset", "utf-8");
                conn.setRequestProperty("contentType", "utf-8");
                conn.setConnectTimeout(3000);
                conn.setReadTimeout(3000);
                if (this.PUBLISH_URL.startsWith("https://")) {
                    System.setProperty("https.protocols", "TLSv1");
                    TrustManager[] tm = new TrustManager[]{new PubSubX509TrustManager()};
                    SSLContext sslContext = SSLContext.getInstance("SSL", "SunJSSE");
                    sslContext.init(null, tm, new SecureRandom());
                    SSLSocketFactory ssf = sslContext.getSocketFactory();
                    HttpsURLConnection httpsConn = (HttpsURLConnection)conn;
                    httpsConn.setSSLSocketFactory(ssf);
                }
                String encodedChannel = URLEncoder.encode(channel, "utf-8");
                String encodedContent = URLEncoder.encode(content, "utf-8");
                String input = "channel=" + encodedChannel + "&content=" + encodedContent + "&retained=" + retained + "&appkey=" + this.appkey + "&guid=" + guid + "&retried=" + retried + "&artifactVersion=" + GoEasy.artifactVersion;
                if (!this.isEmpty(notificationTitle)) {
                    String encodedTitle = URLEncoder.encode(notificationTitle, "utf-8");
                    String encodedBody = URLEncoder.encode(notificationBody, "utf-8");
                    input = input + "&notification_title=" + encodedTitle + "&notification_body=" + encodedBody;
                }
                OutputStream os = conn.getOutputStream();
                os.write(input.getBytes("utf-8"));
                os.flush();
                responseCode = conn.getResponseCode();
                this.showResult(conn, responseCode, publishListener);
                conn.disconnect();
                success = true;
            }
            catch (ConnectException e) {
                this.onFailed(retried, publishListener, GoEasyErrorCode.UNREACHABLE_TIMEOUT, e);
            }
            catch (SocketException e) {
                this.onFailed(retried, publishListener, GoEasyErrorCode.UNREACHABLE_TIMEOUT, e);
            }
            catch (SocketTimeoutException e) {
                this.onFailed(retried, publishListener, GoEasyErrorCode.UNREACHABLE_TIMEOUT, e);
            }
            catch (UnknownHostException e) {
                this.onFailed(retried, publishListener, 408, "java.net.UnknownHostException: " + this.PUBLISH_URL, e);
            }
            catch (IOException e) {
                this.onFailed(retried, publishListener, responseCode, "java.io.IOException", e);
            }
            catch (Exception e) {
                this.onFailed(retried, publishListener, responseCode, e.getMessage(), e);
            }
            finally {
                ++retried;
            }
        }
    }

    private void onFailed(int retried, PublishListener publishListener, GoEasyErrorCode errorCode, Exception e) {
        if (retried == this.maxRetries) {
            log.error("Publish finally still failed code[{}] with message[{}] after tried {} times", new Object[]{errorCode.code(), errorCode.content(), this.maxRetries + 1, e});
            publishListener.onFailed(new GoEasyError(errorCode.code(), errorCode.content()));
        } else {
            log.debug("Publish failed code[{}] with message[{}] after tried {} times", new Object[]{errorCode.code(), errorCode.content(), retried + 1, e});
        }
    }

    private void onFailed(int retried, PublishListener publishListener, int customCode, String customMessage, Exception e) {
        if (retried == this.maxRetries) {
            log.error("Publish finally still failed code[{}] with message[{}] after tried {} times", new Object[]{customCode, customMessage, this.maxRetries + 1, e});
            publishListener.onFailed(new GoEasyError(customCode, customMessage));
        } else {
            log.debug("Publish failed code[{}] with message[{}] after tried {} times", new Object[]{customCode, customMessage, retried + 1, e});
        }
    }

    private void showResult(HttpURLConnection conn, int responseCode, PublishListener publishListener) throws IOException {
        if (responseCode == 200) {
            publishListener.onSuccess();
        } else {
            String result = null;
            InputStream errorStream = conn.getErrorStream();
            if (errorStream != null) {
                BufferedReader in = new BufferedReader(new InputStreamReader(errorStream));
                String temp = in.readLine();
                while (temp != null) {
                    result = result != null ? result + temp : temp;
                    temp = in.readLine();
                }
            } else {
                InputStream inputStream = conn.getInputStream();
                if (inputStream != null) {
                    BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));
                    String temp = in.readLine();
                    while (temp != null) {
                        result = result != null ? result + temp : temp;
                        temp = in.readLine();
                    }
                } else {
                    publishListener.onFailed(new GoEasyError(responseCode, "Input stream and error stream are both null"));
                    return;
                }
            }
            GoEasyError goEasyError = (GoEasyError)this.gson.fromJson(result, GoEasyError.class);
            publishListener.onFailed(goEasyError);
        }
    }

    private boolean isEmpty(String text) {
        return text == null || text.trim().length() == 0;
    }

    public void setHttps(boolean https) {
        if (https) {
            this.PUBLISH_URL = this.PUBLISH_URL.replace("http://", "https://");
        }
    }

    public void setPublisUrl(String url) {
        this.PUBLISH_URL = url;
    }

    class PubSubX509TrustManager
    implements X509TrustManager {
        PubSubX509TrustManager() {
        }

        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

