/*
 * Decompiled with CFR 0.152.
 */
package javaslang;

import java.util.Objects;
import java.util.function.Predicate;
import javaslang.collection.List;

public final class Predicates {
    private Predicates() {
    }

    public static <T> Predicate<T> instanceOf(Class<? extends T> type) {
        Objects.requireNonNull(type, "type is null");
        return obj -> obj != null && type.isAssignableFrom(obj.getClass());
    }

    public static <T> Predicate<T> is(T value) {
        return obj -> Objects.equals(obj, value);
    }

    @SafeVarargs
    public static <T> Predicate<T> isIn(T ... values) {
        Objects.requireNonNull(values, "values is null");
        return obj -> List.of(values).find(value -> Objects.equals(value, obj)).isDefined();
    }

    @SafeVarargs
    public static <T> Predicate<T> allOf(Predicate<? super T> ... predicates) {
        Objects.requireNonNull(predicates, "predicates is null");
        return t -> List.of(predicates).foldLeft(true, (bool, pred) -> bool != false && pred.test(t));
    }

    @SafeVarargs
    public static <T> Predicate<T> anyOf(Predicate<? super T> ... predicates) {
        Objects.requireNonNull(predicates, "predicates is null");
        return t -> List.of(predicates).find(pred -> pred.test(t)).isDefined();
    }

    @SafeVarargs
    public static <T> Predicate<T> noneOf(Predicate<? super T> ... predicates) {
        Objects.requireNonNull(predicates, "predicates is null");
        return Predicates.anyOf(predicates).negate();
    }
}

