/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import zipkin.Annotation;
import zipkin.BinaryAnnotation;
import zipkin.Codec;
import zipkin.DependencyLink;
import zipkin.Endpoint;
import zipkin.Span;
import zipkin.internal.Base64;
import zipkin.internal.Util;
import zipkin.internal.V2SpanConverter;
import zipkin.internal.gson.stream.JsonReader;
import zipkin.internal.gson.stream.JsonToken;
import zipkin.internal.gson.stream.MalformedJsonException;
import zipkin2.codec.DependencyLinkBytesEncoder;
import zipkin2.internal.Buffer;
import zipkin2.internal.JsonEscaper;

public final class JsonCodec
implements Codec {
    static final long MAX_SAFE_INTEGER = 0x1FFFFFFFFFFFFFL;
    static final String ENDPOINT_HEADER = ",\"endpoint\":";
    static final JsonReaderAdapter<Endpoint> ENDPOINT_READER = new JsonReaderAdapter<Endpoint>(){

        @Override
        public Endpoint fromJson(JsonReader reader) throws IOException {
            Endpoint.Builder result = Endpoint.builder();
            reader.beginObject();
            while (reader.hasNext()) {
                String nextName = reader.nextName();
                if (nextName.equals("serviceName")) {
                    result.serviceName(reader.nextString());
                    continue;
                }
                if (nextName.equals("ipv4") || nextName.equals("ipv6")) {
                    result.parseIp(reader.nextString());
                    continue;
                }
                if (nextName.equals("port")) {
                    result.port(reader.nextInt());
                    continue;
                }
                reader.skipValue();
            }
            reader.endObject();
            return result.build();
        }
    };
    static final Buffer.Writer<Endpoint> ENDPOINT_WRITER = new Buffer.Writer<Endpoint>(){

        public int sizeInBytes(Endpoint v) {
            int port;
            zipkin2.Endpoint value = v.toV2();
            int sizeInBytes = 17;
            if (value.serviceName() != null) {
                sizeInBytes += JsonEscaper.jsonEscapedSizeInBytes((String)value.serviceName());
            }
            if (value.ipv4() != null) {
                if (sizeInBytes != 1) {
                    ++sizeInBytes;
                }
                sizeInBytes += 9;
                sizeInBytes += value.ipv4().length();
            }
            if (value.ipv6() != null) {
                if (sizeInBytes != 1) {
                    ++sizeInBytes;
                }
                sizeInBytes += 9;
                sizeInBytes += value.ipv6().length();
            }
            if ((port = value.portAsInt()) != 0) {
                if (sizeInBytes != 1) {
                    ++sizeInBytes;
                }
                sizeInBytes += 7;
                sizeInBytes += Buffer.asciiSizeInBytes((long)port);
            }
            return ++sizeInBytes;
        }

        public void write(Endpoint v, Buffer b) {
            int port;
            zipkin2.Endpoint value = v.toV2();
            b.writeAscii("{\"serviceName\":\"");
            if (value.serviceName() != null) {
                b.writeUtf8(JsonEscaper.jsonEscape((String)value.serviceName()));
            }
            b.writeByte(34);
            if (value.ipv4() != null) {
                b.writeAscii(",\"ipv4\":\"");
                b.writeAscii(value.ipv4()).writeByte(34);
            }
            if (value.ipv6() != null) {
                b.writeAscii(",\"ipv6\":\"");
                b.writeAscii(value.ipv6()).writeByte(34);
            }
            if ((port = value.portAsInt()) != 0) {
                b.writeAscii(",\"port\":").writeAscii((long)port);
            }
            b.writeByte(125);
        }
    };
    static final JsonReaderAdapter<Annotation> ANNOTATION_READER = new JsonReaderAdapter<Annotation>(){

        @Override
        public Annotation fromJson(JsonReader reader) throws IOException {
            Annotation.Builder result = Annotation.builder();
            reader.beginObject();
            while (reader.hasNext()) {
                String nextName = reader.nextName();
                if (nextName.equals("timestamp")) {
                    result.timestamp(reader.nextLong());
                    continue;
                }
                if (nextName.equals("value")) {
                    result.value(reader.nextString());
                    continue;
                }
                if (nextName.equals("endpoint") && reader.peek() != JsonToken.NULL) {
                    result.endpoint(ENDPOINT_READER.fromJson(reader));
                    continue;
                }
                reader.skipValue();
            }
            reader.endObject();
            return result.build();
        }
    };
    static final Buffer.Writer<Annotation> ANNOTATION_WRITER = new Buffer.Writer<Annotation>(){

        public int sizeInBytes(Annotation value) {
            int sizeInBytes = 0;
            sizeInBytes += "{\"timestamp\":".length() + Buffer.asciiSizeInBytes((long)value.timestamp);
            sizeInBytes += ",\"value\":\"".length() + JsonEscaper.jsonEscapedSizeInBytes((String)value.value) + 1;
            if (value.endpoint != null) {
                sizeInBytes += JsonCodec.ENDPOINT_HEADER.length() + ENDPOINT_WRITER.sizeInBytes((Object)value.endpoint);
            }
            return ++sizeInBytes;
        }

        public void write(Annotation value, Buffer b) {
            b.writeAscii("{\"timestamp\":").writeAscii(value.timestamp);
            b.writeAscii(",\"value\":\"").writeUtf8(JsonEscaper.jsonEscape((String)value.value)).writeByte(34);
            if (value.endpoint != null) {
                b.writeAscii(JsonCodec.ENDPOINT_HEADER);
                ENDPOINT_WRITER.write((Object)value.endpoint, b);
            }
            b.writeByte(125);
        }
    };
    static final JsonReaderAdapter<BinaryAnnotation> BINARY_ANNOTATION_READER = new JsonReaderAdapter<BinaryAnnotation>(){

        @Override
        public BinaryAnnotation fromJson(JsonReader reader) throws IOException {
            byte[] value;
            BinaryAnnotation.Builder result = BinaryAnnotation.builder();
            String key = null;
            BinaryAnnotation.Type type = BinaryAnnotation.Type.STRING;
            boolean valueSet = false;
            String number = null;
            String string = null;
            reader.beginObject();
            block10: while (reader.hasNext()) {
                String nextName = reader.nextName();
                if (nextName.equals("key")) {
                    key = reader.nextString();
                    result.key(key);
                    continue;
                }
                if (nextName.equals("value")) {
                    valueSet = true;
                    switch (reader.peek()) {
                        case BOOLEAN: {
                            byte[] byArray;
                            type = BinaryAnnotation.Type.BOOL;
                            if (reader.nextBoolean()) {
                                byte[] byArray2 = new byte[1];
                                byArray = byArray2;
                                byArray2[0] = 1;
                            } else {
                                byte[] byArray3 = new byte[1];
                                byArray = byArray3;
                                byArray3[0] = 0;
                            }
                            result.value(byArray);
                            continue block10;
                        }
                        case STRING: {
                            string = reader.nextString();
                            continue block10;
                        }
                        case NUMBER: {
                            number = reader.nextString();
                            continue block10;
                        }
                    }
                    throw new MalformedJsonException("Expected value to be a boolean, string or number but was " + (Object)((Object)reader.peek()) + " at path " + reader.getPath());
                }
                if (nextName.equals("type")) {
                    type = BinaryAnnotation.Type.valueOf(reader.nextString());
                    continue;
                }
                if (nextName.equals("endpoint") && reader.peek() != JsonToken.NULL) {
                    result.endpoint(ENDPOINT_READER.fromJson(reader));
                    continue;
                }
                reader.skipValue();
            }
            if (key == null) {
                throw new MalformedJsonException("No key at " + reader.getPath());
            }
            if (!valueSet) {
                throw new MalformedJsonException("No value for key " + key + " at " + reader.getPath());
            }
            reader.endObject();
            result.type(type);
            switch (type) {
                case BOOL: {
                    return result.build();
                }
                case STRING: {
                    return result.value(string.getBytes(Util.UTF_8)).build();
                }
                case BYTES: {
                    return result.value(Base64.decode(string)).build();
                }
            }
            if (type == BinaryAnnotation.Type.I16) {
                short v = Short.parseShort(number);
                value = ByteBuffer.allocate(2).putShort(0, v).array();
            } else if (type == BinaryAnnotation.Type.I32) {
                int v = Integer.parseInt(number);
                value = ByteBuffer.allocate(4).putInt(0, v).array();
            } else if (type == BinaryAnnotation.Type.I64 || type == BinaryAnnotation.Type.DOUBLE) {
                if (number == null) {
                    number = string;
                }
                long v = type == BinaryAnnotation.Type.I64 ? Long.parseLong(number) : Double.doubleToRawLongBits(Double.parseDouble(number));
                value = ByteBuffer.allocate(8).putLong(0, v).array();
            } else {
                throw new AssertionError((Object)("BinaryAnnotationType " + (Object)((Object)type) + " was added, but not handled"));
            }
            return result.value(value).build();
        }
    };
    static final Buffer.Writer<BinaryAnnotation> BINARY_ANNOTATION_WRITER = new Buffer.Writer<BinaryAnnotation>(){

        public int sizeInBytes(BinaryAnnotation value) {
            int sizeInBytes = 0;
            sizeInBytes += "{\"key\":\"".length() + JsonEscaper.jsonEscapedSizeInBytes((String)value.key);
            sizeInBytes += "\",\"value\":".length();
            switch (value.type) {
                case BOOL: {
                    sizeInBytes += value.value[0] == 1 ? 4 : 5;
                    break;
                }
                case STRING: {
                    int escapedSize = JsonEscaper.needsJsonEscaping((byte[])value.value) ? JsonEscaper.jsonEscapedSizeInBytes((String)new String(value.value, Util.UTF_8)) : value.value.length;
                    sizeInBytes += escapedSize + 2;
                    break;
                }
                case BYTES: {
                    sizeInBytes += (value.value.length + 2) / 3 * 4 + 2;
                    break;
                }
                case I16: {
                    sizeInBytes += Buffer.asciiSizeInBytes((long)ByteBuffer.wrap(value.value).getShort());
                    break;
                }
                case I32: {
                    sizeInBytes += Buffer.asciiSizeInBytes((long)ByteBuffer.wrap(value.value).getInt());
                    break;
                }
                case I64: {
                    long number = ByteBuffer.wrap(value.value).getLong();
                    sizeInBytes += Buffer.asciiSizeInBytes((long)number);
                    if (number <= 0x1FFFFFFFFFFFFFL) break;
                    sizeInBytes += 2;
                    break;
                }
                case DOUBLE: {
                    double wrapped = Double.longBitsToDouble(ByteBuffer.wrap(value.value).getLong());
                    sizeInBytes += Double.toString(wrapped).length();
                    break;
                }
            }
            if (value.type != BinaryAnnotation.Type.STRING && value.type != BinaryAnnotation.Type.BOOL) {
                sizeInBytes += ",\"type\":\"".length() + value.type.name().length() + 1;
            }
            if (value.endpoint != null) {
                sizeInBytes += JsonCodec.ENDPOINT_HEADER.length() + ENDPOINT_WRITER.sizeInBytes((Object)value.endpoint);
            }
            return ++sizeInBytes;
        }

        public void write(BinaryAnnotation value, Buffer b) {
            b.writeAscii("{\"key\":\"").writeUtf8(JsonEscaper.jsonEscape((String)value.key));
            b.writeAscii("\",\"value\":");
            switch (value.type) {
                case BOOL: {
                    b.writeAscii(value.value[0] == 1 ? "true" : "false");
                    break;
                }
                case STRING: {
                    b.writeByte(34).writeUtf8(JsonEscaper.jsonEscape((String)new String(value.value, Util.UTF_8))).writeByte(34);
                    break;
                }
                case BYTES: {
                    b.writeByte(34).writeAscii(Util.writeBase64Url(value.value)).writeByte(34);
                    break;
                }
                case I16: {
                    b.writeAscii((long)ByteBuffer.wrap(value.value).getShort());
                    break;
                }
                case I32: {
                    b.writeAscii((long)ByteBuffer.wrap(value.value).getInt());
                    break;
                }
                case I64: {
                    long number = ByteBuffer.wrap(value.value).getLong();
                    if (number > 0x1FFFFFFFFFFFFFL) {
                        b.writeByte(34);
                    }
                    b.writeAscii(number);
                    if (number <= 0x1FFFFFFFFFFFFFL) break;
                    b.writeByte(34);
                    break;
                }
                case DOUBLE: {
                    double wrapped = Double.longBitsToDouble(ByteBuffer.wrap(value.value).getLong());
                    b.writeAscii(Double.toString(wrapped));
                    break;
                }
            }
            if (value.type != BinaryAnnotation.Type.STRING && value.type != BinaryAnnotation.Type.BOOL) {
                b.writeAscii(",\"type\":\"").writeAscii(value.type.name()).writeByte(34);
            }
            if (value.endpoint != null) {
                b.writeAscii(JsonCodec.ENDPOINT_HEADER);
                ENDPOINT_WRITER.write((Object)value.endpoint, b);
            }
            b.writeByte(125);
        }
    };
    static final Buffer.Writer<Span> SPAN_WRITER = new Buffer.Writer<Span>(){

        public int sizeInBytes(Span value) {
            int i;
            int length;
            int sizeInBytes = 0;
            if (value.traceIdHigh != 0L) {
                sizeInBytes += 16;
            }
            sizeInBytes += "{\"traceId\":\"".length() + 16;
            sizeInBytes += "\",\"id\":\"".length() + 16;
            sizeInBytes += "\",\"name\":\"".length() + JsonEscaper.jsonEscapedSizeInBytes((String)value.name) + 1;
            if (value.parentId != null) {
                sizeInBytes += ",\"parentId\":\"".length() + 16 + 1;
            }
            if (value.timestamp != null) {
                sizeInBytes += ",\"timestamp\":".length() + Buffer.asciiSizeInBytes((long)value.timestamp);
            }
            if (value.duration != null) {
                sizeInBytes += ",\"duration\":".length() + Buffer.asciiSizeInBytes((long)value.duration);
            }
            if (!value.annotations.isEmpty()) {
                sizeInBytes += 17;
                length = value.annotations.size();
                if (length > 1) {
                    sizeInBytes += length - 1;
                }
                for (i = 0; i < length; ++i) {
                    sizeInBytes += ANNOTATION_WRITER.sizeInBytes((Object)value.annotations.get(i));
                }
            }
            if (!value.binaryAnnotations.isEmpty()) {
                sizeInBytes += 23;
                length = value.binaryAnnotations.size();
                if (length > 1) {
                    sizeInBytes += length - 1;
                }
                for (i = 0; i < length; ++i) {
                    sizeInBytes += BINARY_ANNOTATION_WRITER.sizeInBytes((Object)value.binaryAnnotations.get(i));
                }
            }
            if (value.debug != null && value.debug.booleanValue()) {
                sizeInBytes += ",\"debug\":true".length();
            }
            return ++sizeInBytes;
        }

        public void write(Span value, Buffer b) {
            b.writeAscii("{\"traceId\":\"");
            if (value.traceIdHigh != 0L) {
                JsonCodec.writeLowerHex(b, value.traceIdHigh);
            }
            JsonCodec.writeLowerHex(b, value.traceId);
            b.writeAscii("\",\"id\":\"");
            JsonCodec.writeLowerHex(b, value.id);
            b.writeAscii("\",\"name\":\"").writeUtf8(JsonEscaper.jsonEscape((String)value.name)).writeByte(34);
            if (value.parentId != null) {
                b.writeAscii(",\"parentId\":\"");
                JsonCodec.writeLowerHex(b, value.parentId);
                b.writeByte(34);
            }
            if (value.timestamp != null) {
                b.writeAscii(",\"timestamp\":").writeAscii(value.timestamp.longValue());
            }
            if (value.duration != null) {
                b.writeAscii(",\"duration\":").writeAscii(value.duration.longValue());
            }
            if (!value.annotations.isEmpty()) {
                b.writeAscii(",\"annotations\":");
                zipkin2.internal.JsonCodec.writeList(ANNOTATION_WRITER, value.annotations, (Buffer)b);
            }
            if (!value.binaryAnnotations.isEmpty()) {
                b.writeAscii(",\"binaryAnnotations\":");
                zipkin2.internal.JsonCodec.writeList(BINARY_ANNOTATION_WRITER, value.binaryAnnotations, (Buffer)b);
            }
            if (value.debug != null && value.debug.booleanValue()) {
                b.writeAscii(",\"debug\":true");
            }
            b.writeByte(125);
        }

        public String toString() {
            return "Span";
        }
    };
    static final JsonReaderAdapter<DependencyLink> DEPENDENCY_LINK_READER = new JsonReaderAdapter<DependencyLink>(){

        @Override
        public DependencyLink fromJson(JsonReader reader) throws IOException {
            DependencyLink.Builder result = DependencyLink.builder();
            reader.beginObject();
            while (reader.hasNext()) {
                String nextName = reader.nextName();
                if (nextName.equals("parent")) {
                    result.parent(reader.nextString());
                    continue;
                }
                if (nextName.equals("child")) {
                    result.child(reader.nextString());
                    continue;
                }
                if (nextName.equals("callCount")) {
                    result.callCount(reader.nextLong());
                    continue;
                }
                if (nextName.equals("errorCount")) {
                    result.errorCount(reader.nextLong());
                    continue;
                }
                reader.skipValue();
            }
            reader.endObject();
            return result.build();
        }

        public String toString() {
            return "DependencyLink";
        }
    };
    static final Buffer.Writer<DependencyLink> DEPENDENCY_LINK_WRITER = new Buffer.Writer<DependencyLink>(){

        public int sizeInBytes(DependencyLink v) {
            zipkin2.DependencyLink value = V2SpanConverter.fromLink(v);
            return DependencyLinkBytesEncoder.JSON_V1.sizeInBytes((Object)value);
        }

        public void write(DependencyLink v, Buffer b) {
            zipkin2.DependencyLink value = V2SpanConverter.fromLink(v);
            b.write(DependencyLinkBytesEncoder.JSON_V1.encode((Object)value));
        }

        public String toString() {
            return "DependencyLink";
        }
    };
    static final JsonReaderAdapter<String> STRING_READER = new JsonReaderAdapter<String>(){

        @Override
        public String fromJson(JsonReader reader) throws IOException {
            return reader.nextString();
        }

        public String toString() {
            return "String";
        }
    };
    static final Buffer.Writer<String> STRING_WRITER = new Buffer.Writer<String>(){

        public int sizeInBytes(String value) {
            return JsonEscaper.jsonEscapedSizeInBytes((String)value) + 2;
        }

        public void write(String value, Buffer buffer) {
            buffer.writeByte(34).writeUtf8(JsonEscaper.jsonEscape((String)value)).writeByte(34);
        }

        public String toString() {
            return "String";
        }
    };
    static final byte[] HEX_DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    @Override
    public Span readSpan(byte[] bytes) {
        return JsonCodec.read(new SpanReader(), bytes);
    }

    @Override
    public int sizeInBytes(Span value) {
        return SPAN_WRITER.sizeInBytes((Object)value);
    }

    @Override
    public byte[] writeSpan(Span value) {
        return zipkin2.internal.JsonCodec.write(SPAN_WRITER, (Object)value);
    }

    public static byte[] writeEndpoint(Endpoint value) {
        return zipkin2.internal.JsonCodec.write(ENDPOINT_WRITER, (Object)value);
    }

    public static byte[] writeAnnotation(Annotation value) {
        return zipkin2.internal.JsonCodec.write(ANNOTATION_WRITER, (Object)value);
    }

    public static byte[] writeBinaryAnnotation(BinaryAnnotation value) {
        return zipkin2.internal.JsonCodec.write(BINARY_ANNOTATION_WRITER, (Object)value);
    }

    @Override
    public List<Span> readSpans(byte[] bytes) {
        return JsonCodec.readList(new SpanReader(), bytes);
    }

    @Override
    public byte[] writeSpans(List<Span> value) {
        return zipkin2.internal.JsonCodec.writeList(SPAN_WRITER, value);
    }

    @Override
    public byte[] writeTraces(List<List<Span>> traces) {
        int length = traces.size();
        int sizeInBytes = 2;
        if (length > 1) {
            sizeInBytes += length - 1;
        }
        for (int i = 0; i < length; ++i) {
            List<Span> spans = traces.get(i);
            int jLength = spans.size();
            sizeInBytes += 2;
            if (jLength > 1) {
                sizeInBytes += jLength - 1;
            }
            for (int j = 0; j < jLength; ++j) {
                sizeInBytes += this.sizeInBytes(spans.get(j));
            }
        }
        byte[] out = new byte[sizeInBytes];
        int pos = 0;
        out[pos++] = 91;
        for (int i = 0; i < length; ++i) {
            pos += zipkin2.internal.JsonCodec.writeList(SPAN_WRITER, traces.get(i), (byte[])out, (int)pos);
            if (i + 1 >= length) continue;
            out[pos++] = 44;
        }
        out[pos] = 93;
        return out;
    }

    public List<List<Span>> readTraces(byte[] bytes) {
        return JsonCodec.readList(new SpanListReader(), bytes);
    }

    @Override
    public DependencyLink readDependencyLink(byte[] bytes) {
        return JsonCodec.read(DEPENDENCY_LINK_READER, bytes);
    }

    @Override
    public byte[] writeDependencyLink(DependencyLink value) {
        return zipkin2.internal.JsonCodec.write(DEPENDENCY_LINK_WRITER, (Object)value);
    }

    @Override
    public List<DependencyLink> readDependencyLinks(byte[] bytes) {
        return JsonCodec.readList(DEPENDENCY_LINK_READER, bytes);
    }

    @Override
    public byte[] writeDependencyLinks(List<DependencyLink> value) {
        return zipkin2.internal.JsonCodec.writeList(DEPENDENCY_LINK_WRITER, value);
    }

    public List<String> readStrings(byte[] bytes) {
        return JsonCodec.readList(STRING_READER, bytes);
    }

    public byte[] writeStrings(List<String> value) {
        return zipkin2.internal.JsonCodec.writeList(STRING_WRITER, value);
    }

    public static <T> T read(JsonReaderAdapter<T> adapter, byte[] bytes) {
        if (bytes.length == 0) {
            throw new IllegalArgumentException("Empty input reading " + adapter);
        }
        try {
            return adapter.fromJson(JsonCodec.jsonReader(bytes));
        }
        catch (Exception e) {
            throw JsonCodec.exceptionReading(adapter.toString(), e);
        }
    }

    public static <T> List<T> readList(JsonReaderAdapter<T> adapter, byte[] bytes) {
        if (bytes.length == 0) {
            throw new IllegalArgumentException("Empty input reading List<" + adapter + ">");
        }
        JsonReader reader = JsonCodec.jsonReader(bytes);
        try {
            ArrayList<T> result;
            reader.beginArray();
            ArrayList<T> arrayList = result = reader.hasNext() ? new ArrayList<T>() : Collections.emptyList();
            while (reader.hasNext()) {
                result.add(adapter.fromJson(reader));
            }
            reader.endArray();
            return result;
        }
        catch (Exception e) {
            throw JsonCodec.exceptionReading("List<" + adapter + ">", e);
        }
    }

    static JsonReader jsonReader(byte[] bytes) {
        return new JsonReader(new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), Util.UTF_8));
    }

    static void writeHexByte(Buffer buffer, byte b) {
        buffer.writeByte((int)HEX_DIGITS[b >> 4 & 0xF]);
        buffer.writeByte((int)HEX_DIGITS[b & 0xF]);
    }

    static void writeLowerHex(Buffer b, long v) {
        JsonCodec.writeHexByte(b, (byte)(v >>> 56 & 0xFFL));
        JsonCodec.writeHexByte(b, (byte)(v >>> 48 & 0xFFL));
        JsonCodec.writeHexByte(b, (byte)(v >>> 40 & 0xFFL));
        JsonCodec.writeHexByte(b, (byte)(v >>> 32 & 0xFFL));
        JsonCodec.writeHexByte(b, (byte)(v >>> 24 & 0xFFL));
        JsonCodec.writeHexByte(b, (byte)(v >>> 16 & 0xFFL));
        JsonCodec.writeHexByte(b, (byte)(v >>> 8 & 0xFFL));
        JsonCodec.writeHexByte(b, (byte)(v & 0xFFL));
    }

    static IllegalArgumentException exceptionReading(String type, Exception e) {
        String cause;
        String string = cause = e.getMessage() == null ? "Error" : e.getMessage();
        if (cause.indexOf("malformed") != -1) {
            cause = "Malformed";
        }
        String message = String.format("%s reading %s from json", cause, type);
        throw new IllegalArgumentException(message, e);
    }

    public static interface JsonReaderAdapter<T> {
        public T fromJson(JsonReader var1) throws IOException;
    }

    static final class SpanListReader
    implements JsonReaderAdapter<List<Span>> {
        SpanReader spanReader;

        SpanListReader() {
        }

        @Override
        public List<Span> fromJson(JsonReader reader) throws IOException {
            reader.beginArray();
            if (!reader.hasNext()) {
                reader.endArray();
                return Collections.emptyList();
            }
            ArrayList<Span> result = new ArrayList<Span>();
            if (this.spanReader == null) {
                this.spanReader = new SpanReader();
            }
            while (reader.hasNext()) {
                result.add(this.spanReader.fromJson(reader));
            }
            reader.endArray();
            return result;
        }

        public String toString() {
            return "List<Span>";
        }
    }

    static final class SpanReader
    implements JsonReaderAdapter<Span> {
        Span.Builder builder;

        SpanReader() {
        }

        @Override
        public Span fromJson(JsonReader reader) throws IOException {
            if (this.builder == null) {
                this.builder = Span.builder();
            } else {
                this.builder.clear();
            }
            reader.beginObject();
            while (reader.hasNext()) {
                String nextName = reader.nextName();
                if (nextName.equals("traceId")) {
                    String traceId = reader.nextString();
                    if (traceId.length() == 32) {
                        this.builder.traceIdHigh(Util.lowerHexToUnsignedLong(traceId, 0));
                    }
                    this.builder.traceId(Util.lowerHexToUnsignedLong(traceId));
                    continue;
                }
                if (nextName.equals("name")) {
                    this.builder.name(reader.nextString());
                    continue;
                }
                if (nextName.equals("id")) {
                    this.builder.id(Util.lowerHexToUnsignedLong(reader.nextString()));
                    continue;
                }
                if (nextName.equals("parentId") && reader.peek() != JsonToken.NULL) {
                    this.builder.parentId(Util.lowerHexToUnsignedLong(reader.nextString()));
                    continue;
                }
                if (nextName.equals("timestamp") && reader.peek() != JsonToken.NULL) {
                    this.builder.timestamp(reader.nextLong());
                    continue;
                }
                if (nextName.equals("duration") && reader.peek() != JsonToken.NULL) {
                    this.builder.duration(reader.nextLong());
                    continue;
                }
                if (nextName.equals("annotations")) {
                    reader.beginArray();
                    while (reader.hasNext()) {
                        this.builder.addAnnotation(ANNOTATION_READER.fromJson(reader));
                    }
                    reader.endArray();
                    continue;
                }
                if (nextName.equals("binaryAnnotations")) {
                    reader.beginArray();
                    while (reader.hasNext()) {
                        this.builder.addBinaryAnnotation(BINARY_ANNOTATION_READER.fromJson(reader));
                    }
                    reader.endArray();
                    continue;
                }
                if (nextName.equals("debug") && reader.peek() != JsonToken.NULL) {
                    if (!reader.nextBoolean()) continue;
                    this.builder.debug(true);
                    continue;
                }
                reader.skipValue();
            }
            reader.endObject();
            return this.builder.build();
        }

        public String toString() {
            return "Span";
        }
    }
}

