/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage;

import java.util.concurrent.Executor;
import zipkin.Component;
import zipkin.internal.Util;
import zipkin.storage.AsyncSpanConsumer;
import zipkin.storage.AsyncSpanStore;
import zipkin.storage.InMemorySpanStore;
import zipkin.storage.StorageAdapters;
import zipkin.storage.StorageComponent;

public final class InMemoryStorage
implements StorageComponent {
    final InMemorySpanStore spanStore;
    final AsyncSpanStore asyncSpanStore;
    final AsyncSpanConsumer asyncConsumer;

    public static Builder builder() {
        return new Builder();
    }

    public InMemoryStorage() {
        this(new Builder());
    }

    InMemoryStorage(Builder builder) {
        this.spanStore = new InMemorySpanStore(builder);
        this.asyncSpanStore = StorageAdapters.blockingToAsync(this.spanStore, (Executor)DirectExecutor.INSTANCE);
        this.asyncConsumer = StorageAdapters.blockingToAsync(this.spanStore.spanConsumer, (Executor)DirectExecutor.INSTANCE);
    }

    @Override
    public InMemorySpanStore spanStore() {
        return this.spanStore;
    }

    @Override
    public AsyncSpanStore asyncSpanStore() {
        return this.asyncSpanStore;
    }

    public StorageAdapters.SpanConsumer spanConsumer() {
        return this.spanStore.spanConsumer;
    }

    @Override
    public AsyncSpanConsumer asyncSpanConsumer() {
        return this.asyncConsumer;
    }

    public void clear() {
        this.spanStore.clear();
    }

    public int acceptedSpanCount() {
        return this.spanStore.acceptedSpanCount;
    }

    @Override
    public Component.CheckResult check() {
        return Component.CheckResult.OK;
    }

    @Override
    public void close() {
    }

    static enum DirectExecutor implements Executor
    {
        INSTANCE;


        @Override
        public void execute(Runnable command) {
            command.run();
        }

        public String toString() {
            return "DirectExecutor";
        }
    }

    public static final class Builder
    implements StorageComponent.Builder {
        boolean strictTraceId = true;
        int maxSpanCount = 500000;

        @Override
        public Builder strictTraceId(boolean strictTraceId) {
            this.strictTraceId = strictTraceId;
            return this;
        }

        public Builder maxSpanCount(int maxSpanCount) {
            Util.checkArgument(maxSpanCount > 0, "maxSpanCount <= 0", new Object[0]);
            this.maxSpanCount = maxSpanCount;
            return this;
        }

        @Override
        public InMemoryStorage build() {
            return new InMemoryStorage(this);
        }
    }
}

