/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncBufferedMutator;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class AsyncBufferedMutatorImpl
implements AsyncBufferedMutator {
    private final AsyncTable<?> table;
    private final long writeBufferSize;
    private List<Mutation> mutations = new ArrayList<Mutation>();
    private List<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
    private long bufferedSize;
    private boolean closed;

    AsyncBufferedMutatorImpl(AsyncTable<?> table, long writeBufferSize) {
        this.table = table;
        this.writeBufferSize = writeBufferSize;
    }

    @Override
    public TableName getName() {
        return this.table.getName();
    }

    @Override
    public Configuration getConfiguration() {
        return this.table.getConfiguration();
    }

    private void internalFlush() {
        List<Mutation> toSend = this.mutations;
        if (toSend.isEmpty()) {
            return;
        }
        List<CompletableFuture<Void>> toComplete = this.futures;
        assert (toSend.size() == toComplete.size());
        this.mutations = new ArrayList<Mutation>();
        this.futures = new ArrayList<CompletableFuture<Void>>();
        this.bufferedSize = 0L;
        Iterator<CompletableFuture<Void>> toCompleteIter = toComplete.iterator();
        for (CompletableFuture future : this.table.batch(toSend)) {
            CompletableFuture<Void> toCompleteFuture = toCompleteIter.next();
            future.whenComplete((r, e) -> {
                if (e != null) {
                    toCompleteFuture.completeExceptionally((Throwable)e);
                } else {
                    toCompleteFuture.complete(null);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> mutate(Mutation mutation) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        long heapSize = mutation.heapSize();
        AsyncBufferedMutatorImpl asyncBufferedMutatorImpl = this;
        synchronized (asyncBufferedMutatorImpl) {
            if (this.closed) {
                future.completeExceptionally(new IOException("Already closed"));
                return future;
            }
            this.mutations.add(mutation);
            this.futures.add(future);
            this.bufferedSize += heapSize;
            if (this.bufferedSize >= this.writeBufferSize) {
                this.internalFlush();
            }
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CompletableFuture<Void>> mutate(List<? extends Mutation> mutations) {
        List<CompletableFuture<Void>> futures = Stream.generate(CompletableFuture::new).limit(mutations.size()).collect(Collectors.toList());
        long heapSize = mutations.stream().mapToLong(m -> m.heapSize()).sum();
        AsyncBufferedMutatorImpl asyncBufferedMutatorImpl = this;
        synchronized (asyncBufferedMutatorImpl) {
            if (this.closed) {
                IOException ioe = new IOException("Already closed");
                futures.forEach(f -> f.completeExceptionally(ioe));
                return futures;
            }
            this.mutations.addAll(mutations);
            this.futures.addAll(futures);
            this.bufferedSize += heapSize;
            if (this.bufferedSize >= this.writeBufferSize) {
                this.internalFlush();
            }
        }
        return futures;
    }

    @Override
    public synchronized void flush() {
        this.internalFlush();
    }

    @Override
    public synchronized void close() {
        this.internalFlush();
        this.closed = true;
    }

    @Override
    public long getWriteBufferSize() {
        return this.writeBufferSize;
    }
}

