/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.WorkBench;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apiguardian.api.API;

public class NamePanel
extends JPanel
implements JMeterGUIComponent {
    private static final long serialVersionUID = 240L;
    private static final String LABEL_RESOURCE = "root";
    private final JTextField nameField = new JTextField(15);

    public NamePanel() {
        this._setName(JMeterUtils.getResString(LABEL_RESOURCE));
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout(5, 0));
        JLabel nameLabel = new JLabel(JMeterUtils.getResString("name"));
        nameLabel.setName("name");
        nameLabel.setLabelFor(this.nameField);
        this.add((Component)nameLabel, "West");
        this.add((Component)this.nameField, "Center");
    }

    @API(status=API.Status.INTERNAL, since="5.2.0")
    public JTextField getNameField() {
        return this.nameField;
    }

    @Override
    public void clearGui() {
        this.setName(this.getStaticLabel());
    }

    @Override
    public String getName() {
        if (this.nameField != null) {
            return this.nameField.getText();
        }
        return "";
    }

    @Override
    public void setName(String name) {
        this._setName(name);
    }

    private void _setName(String name) {
        super.setName(name);
        this.nameField.setText(name);
    }

    @Override
    public void configure(TestElement testElement) {
        this.setName(testElement.getName());
    }

    @Override
    public JPopupMenu createPopupMenu() {
        return null;
    }

    @Override
    public String getStaticLabel() {
        return JMeterUtils.getResString(this.getLabelResource());
    }

    @Override
    public String getLabelResource() {
        return LABEL_RESOURCE;
    }

    @Override
    public Collection<String> getMenuCategories() {
        return null;
    }

    @Override
    public TestElement createTestElement() {
        WorkBench wb = new WorkBench();
        this.modifyTestElement(wb);
        return wb;
    }

    @Override
    public void modifyTestElement(TestElement wb) {
        wb.setName(this.getName());
        wb.setProperty(new StringProperty("TestElement.gui_class", this.getClass().getName()));
        wb.setProperty(new StringProperty("TestElement.test_class", WorkBench.class.getName()));
    }

    @Override
    public String getDocAnchor() {
        return null;
    }
}

