/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.MenuElement;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.AbstractAction;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.plugin.MenuCreator;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.testbeans.TestBeanHelper;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.JSR223TestElement;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.HashTreeTraverser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompileJSR223TestElements
extends AbstractAction
implements MenuCreator {
    private static final Logger log = LoggerFactory.getLogger(CompileJSR223TestElements.class);
    private static final MessageFormat MESSAGE_FORMAT = new MessageFormat(JMeterUtils.getResString("compilation_errors"));
    private static final Set<String> commands = new HashSet<String>();

    @Override
    public void doAction(ActionEvent e) {
        HashTree wholeTree = GuiPackage.getInstance().getTreeModel().getTestPlan();
        JSR223TestElementCompilerVisitor visitor = new JSR223TestElementCompilerVisitor();
        wholeTree.traverse((HashTreeTraverser)visitor);
        GuiPackage.getInstance().getMainFrame().repaint();
        if (visitor.getElementsWithCompilationErrors() > 0) {
            JMeterUtils.reportErrorToUser(MESSAGE_FORMAT.format(new Object[]{visitor.getElementsWithCompilationErrors()}));
        }
    }

    @Override
    public Set<String> getActionNames() {
        return commands;
    }

    @Override
    public JMenuItem[] getMenuItemsAtLocation(MenuCreator.MENU_LOCATION location) {
        if (location == MenuCreator.MENU_LOCATION.TOOLS) {
            JMenuItem menuItemIC = new JMenuItem(JMeterUtils.getResString("compile_menu"), 0);
            menuItemIC.setName("compile_jsr223");
            menuItemIC.setActionCommand("compile_jsr223");
            menuItemIC.setAccelerator(null);
            menuItemIC.addActionListener(ActionRouter.getInstance());
            return new JMenuItem[]{menuItemIC};
        }
        return new JMenuItem[0];
    }

    @Override
    public JMenu[] getTopLevelMenus() {
        return new JMenu[0];
    }

    @Override
    public boolean localeChanged(MenuElement menu) {
        return false;
    }

    @Override
    public void localeChanged() {
    }

    static {
        commands.add("compile_jsr223");
    }

    private static class JSR223TestElementCompilerVisitor
    implements HashTreeTraverser {
        private int elementsWithCompilationErrors = 0;

        public void addNode(Object object, HashTree subTree) {
            JMeterTreeNode treeNode = (JMeterTreeNode)object;
            Object userObject = treeNode.getUserObject();
            treeNode.setMarkedBySearch(false);
            if (treeNode.isEnabled() && userObject instanceof JSR223TestElement) {
                JSR223TestElement element = (JSR223TestElement)userObject;
                TestBeanHelper.prepare(element);
                try {
                    log.info("Compiling {}", (Object)element.getName());
                    if (!element.compile()) {
                        ++this.elementsWithCompilationErrors;
                        treeNode.setMarkedBySearch(true);
                    } else {
                        log.info("Compilation succeeded for {}", (Object)element.getName());
                    }
                }
                catch (Exception e) {
                    treeNode.setMarkedBySearch(true);
                    log.error("Error compiling test element {}", (Object)element.getName(), (Object)e);
                }
            }
        }

        public void subtractNode() {
        }

        public void processPath() {
        }

        public int getElementsWithCompilationErrors() {
            return this.elementsWithCompilationErrors;
        }
    }
}

