/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.util;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.apache.jmeter.gui.util.JSyntaxTextArea;
import org.apache.jmeter.gui.util.JTextScrollPane;

public class TextAreaCellRenderer
implements TableCellRenderer {
    private JSyntaxTextArea rend = this.createRenderer("");

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.rend = value != null ? this.createRenderer((String)value) : this.createRenderer("");
        if (hasFocus || isSelected) {
            this.rend.setBackground(Color.blue);
            this.rend.setForeground(Color.white);
        }
        if (table.getRowHeight(row) < this.getPreferredHeight()) {
            table.setRowHeight(row, this.getPreferredHeight());
        }
        return JTextScrollPane.getInstance(this.rend);
    }

    private JSyntaxTextArea createRenderer(String value) {
        JSyntaxTextArea textArea = JSyntaxTextArea.getInstance(2, 50);
        textArea.setLanguage("text");
        textArea.setInitialText(value);
        return textArea;
    }

    public int getPreferredHeight() {
        if ("true".equals(System.getProperty("java.awt.headless"))) {
            return 10;
        }
        return this.rend.getPreferredSize().height + 5;
    }
}

