/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public final class TemplateUtil {
    private static Configuration templateConfiguration = TemplateUtil.init();

    private TemplateUtil() {
    }

    private static Configuration init() {
        Configuration templateConfiguration = new Configuration(Configuration.getVersion());
        templateConfiguration.setDefaultEncoding(StandardCharsets.UTF_8.name());
        templateConfiguration.setInterpolationSyntax(22);
        templateConfiguration.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        return templateConfiguration;
    }

    public static Configuration getTemplateConfig() {
        return templateConfiguration;
    }

    public static void processTemplate(File template, File outputFile, Configuration templateConfig, Map<String, String> data) throws IOException, TemplateException {
        templateConfig.setDirectoryForTemplateLoading(template.getParentFile());
        Template temp = templateConfig.getTemplate(template.getName());
        try (FileOutputStream stream = new FileOutputStream(outputFile);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8);
             BufferedWriter bufferedWriter = new BufferedWriter(writer);){
            temp.process(data, (Writer)bufferedWriter);
        }
    }
}

