/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.codehaus.plexus.component.discovery.ComponentDiscoveryEvent;
import org.codehaus.plexus.component.discovery.ComponentDiscoveryListener;
import org.codehaus.plexus.component.repository.ComponentSetDescriptor;

public class MavenPluginValidator
implements ComponentDiscoveryListener {
    private final Artifact pluginArtifact;
    private List errors = new ArrayList();

    public MavenPluginValidator(Artifact pluginArtifact) {
        this.pluginArtifact = pluginArtifact;
    }

    public void componentDiscovered(ComponentDiscoveryEvent event) {
        ComponentSetDescriptor componentSetDescriptor = event.getComponentSetDescriptor();
        if (componentSetDescriptor instanceof PluginDescriptor) {
            PluginDescriptor pluginDescriptor = (PluginDescriptor)componentSetDescriptor;
            if (!this.pluginArtifact.getGroupId().equals(pluginDescriptor.getGroupId())) {
                this.errors.add("Plugin's descriptor contains the wrong group ID: " + pluginDescriptor.getGroupId());
            }
            if (!this.pluginArtifact.getArtifactId().equals(pluginDescriptor.getArtifactId())) {
                this.errors.add("Plugin's descriptor contains the wrong artifact ID: " + pluginDescriptor.getArtifactId());
            }
            if (!this.pluginArtifact.getBaseVersion().equals(pluginDescriptor.getVersion())) {
                this.errors.add("Plugin's descriptor contains the wrong version: " + pluginDescriptor.getVersion());
            }
        }
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public List getErrors() {
        return this.errors;
    }
}

