/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.usability;

import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.usability.diagnostics.DiagnosisUtils;
import org.apache.maven.usability.diagnostics.ErrorDiagnoser;

public class MojoFailureExceptionDiagnoser
implements ErrorDiagnoser {
    public boolean canDiagnose(Throwable error) {
        return DiagnosisUtils.containsInCausality((Throwable)error, MojoFailureException.class);
    }

    public String diagnose(Throwable error) {
        String longMessage;
        String shortMessage;
        MojoFailureException mfe = (MojoFailureException)DiagnosisUtils.getFromCausality((Throwable)error, MojoFailureException.class);
        StringBuffer message = new StringBuffer();
        Object source = mfe.getSource();
        if (source != null) {
            message.append(": ").append(mfe.getSource()).append("\n");
        }
        if ((shortMessage = mfe.getMessage()) != null) {
            message.append(shortMessage);
        }
        if ((longMessage = mfe.getLongMessage()) != null && !longMessage.equals(shortMessage) && shortMessage.indexOf(longMessage) < 0) {
            message.append("\n\n").append(longMessage);
        }
        return message.toString();
    }
}

