/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.settings;

import java.util.List;
import org.apache.maven.settings.Activation;
import org.apache.maven.settings.ActivationFile;
import org.apache.maven.settings.ActivationOS;
import org.apache.maven.settings.ActivationProperty;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.RepositoryPolicy;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.merge.MavenSettingsMerger;

public final class SettingsUtils {
    private SettingsUtils() {
    }

    public static void merge(Settings dominant, Settings recessive, String recessiveSourceLevel) {
        new MavenSettingsMerger().merge(dominant, recessive, recessiveSourceLevel);
    }

    public static Profile convertToSettingsProfile(org.apache.maven.model.Profile modelProfile) {
        List pluginRepos;
        Profile profile = new Profile();
        profile.setId(modelProfile.getId());
        org.apache.maven.model.Activation modelActivation = modelProfile.getActivation();
        if (modelActivation != null) {
            org.apache.maven.model.ActivationFile modelFile;
            org.apache.maven.model.ActivationOS modelOs;
            Activation activation = new Activation();
            activation.setActiveByDefault(modelActivation.isActiveByDefault());
            activation.setJdk(modelActivation.getJdk());
            org.apache.maven.model.ActivationProperty modelProp = modelActivation.getProperty();
            if (modelProp != null) {
                ActivationProperty prop = new ActivationProperty();
                prop.setName(modelProp.getName());
                prop.setValue(modelProp.getValue());
                activation.setProperty(prop);
            }
            if ((modelOs = modelActivation.getOs()) != null) {
                ActivationOS os = new ActivationOS();
                os.setArch(modelOs.getArch());
                os.setFamily(modelOs.getFamily());
                os.setName(modelOs.getName());
                os.setVersion(modelOs.getVersion());
                activation.setOs(os);
            }
            if ((modelFile = modelActivation.getFile()) != null) {
                ActivationFile file = new ActivationFile();
                file.setExists(modelFile.getExists());
                file.setMissing(modelFile.getMissing());
                activation.setFile(file);
            }
            profile.setActivation(activation);
        }
        profile.setProperties(modelProfile.getProperties());
        List repos = modelProfile.getRepositories();
        if (repos != null) {
            for (org.apache.maven.model.Repository repo : repos) {
                profile.addRepository(SettingsUtils.convertToSettingsRepository(repo));
            }
        }
        if ((pluginRepos = modelProfile.getPluginRepositories()) != null) {
            for (org.apache.maven.model.Repository pluginRepo : pluginRepos) {
                profile.addPluginRepository(SettingsUtils.convertToSettingsRepository(pluginRepo));
            }
        }
        return profile;
    }

    public static org.apache.maven.model.Profile convertFromSettingsProfile(Profile settingsProfile) {
        List pluginRepos;
        org.apache.maven.model.Profile profile = new org.apache.maven.model.Profile();
        profile.setId(settingsProfile.getId());
        profile.setSource("settings.xml");
        Activation settingsActivation = settingsProfile.getActivation();
        if (settingsActivation != null) {
            ActivationFile settingsFile;
            ActivationOS settingsOs;
            org.apache.maven.model.Activation activation = new org.apache.maven.model.Activation();
            activation.setActiveByDefault(settingsActivation.isActiveByDefault());
            activation.setJdk(settingsActivation.getJdk());
            ActivationProperty settingsProp = settingsActivation.getProperty();
            if (settingsProp != null) {
                org.apache.maven.model.ActivationProperty prop = new org.apache.maven.model.ActivationProperty();
                prop.setName(settingsProp.getName());
                prop.setValue(settingsProp.getValue());
                activation.setProperty(prop);
            }
            if ((settingsOs = settingsActivation.getOs()) != null) {
                org.apache.maven.model.ActivationOS os = new org.apache.maven.model.ActivationOS();
                os.setArch(settingsOs.getArch());
                os.setFamily(settingsOs.getFamily());
                os.setName(settingsOs.getName());
                os.setVersion(settingsOs.getVersion());
                activation.setOs(os);
            }
            if ((settingsFile = settingsActivation.getFile()) != null) {
                org.apache.maven.model.ActivationFile file = new org.apache.maven.model.ActivationFile();
                file.setExists(settingsFile.getExists());
                file.setMissing(settingsFile.getMissing());
                activation.setFile(file);
            }
            profile.setActivation(activation);
        }
        profile.setProperties(settingsProfile.getProperties());
        List repos = settingsProfile.getRepositories();
        if (repos != null) {
            for (Repository repo : repos) {
                profile.addRepository(SettingsUtils.convertFromSettingsRepository(repo));
            }
        }
        if ((pluginRepos = settingsProfile.getPluginRepositories()) != null) {
            for (Repository pluginRepo : pluginRepos) {
                profile.addPluginRepository(SettingsUtils.convertFromSettingsRepository(pluginRepo));
            }
        }
        return profile;
    }

    private static org.apache.maven.model.Repository convertFromSettingsRepository(Repository settingsRepo) {
        org.apache.maven.model.Repository repo = new org.apache.maven.model.Repository();
        repo.setId(settingsRepo.getId());
        repo.setLayout(settingsRepo.getLayout());
        repo.setName(settingsRepo.getName());
        repo.setUrl(settingsRepo.getUrl());
        if (settingsRepo.getSnapshots() != null) {
            repo.setSnapshots(SettingsUtils.convertRepositoryPolicy(settingsRepo.getSnapshots()));
        }
        if (settingsRepo.getReleases() != null) {
            repo.setReleases(SettingsUtils.convertRepositoryPolicy(settingsRepo.getReleases()));
        }
        return repo;
    }

    private static org.apache.maven.model.RepositoryPolicy convertRepositoryPolicy(RepositoryPolicy settingsPolicy) {
        org.apache.maven.model.RepositoryPolicy policy = new org.apache.maven.model.RepositoryPolicy();
        policy.setEnabled(settingsPolicy.isEnabled());
        policy.setUpdatePolicy(settingsPolicy.getUpdatePolicy());
        policy.setChecksumPolicy(settingsPolicy.getChecksumPolicy());
        return policy;
    }

    private static Repository convertToSettingsRepository(org.apache.maven.model.Repository modelRepo) {
        Repository repo = new Repository();
        repo.setId(modelRepo.getId());
        repo.setLayout(modelRepo.getLayout());
        repo.setName(modelRepo.getName());
        repo.setUrl(modelRepo.getUrl());
        if (modelRepo.getSnapshots() != null) {
            repo.setSnapshots(SettingsUtils.convertRepositoryPolicy(modelRepo.getSnapshots()));
        }
        if (modelRepo.getReleases() != null) {
            repo.setReleases(SettingsUtils.convertRepositoryPolicy(modelRepo.getReleases()));
        }
        return repo;
    }

    private static RepositoryPolicy convertRepositoryPolicy(org.apache.maven.model.RepositoryPolicy modelPolicy) {
        RepositoryPolicy policy = new RepositoryPolicy();
        policy.setEnabled(modelPolicy.isEnabled());
        policy.setUpdatePolicy(modelPolicy.getUpdatePolicy());
        policy.setChecksumPolicy(modelPolicy.getChecksumPolicy());
        return policy;
    }

    public static Settings copySettings(Settings settings) {
        if (settings == null) {
            return null;
        }
        Settings clone = new Settings();
        clone.setActiveProfiles(settings.getActiveProfiles());
        clone.setInteractiveMode(settings.isInteractiveMode());
        clone.setLocalRepository(settings.getLocalRepository());
        clone.setMirrors(settings.getMirrors());
        clone.setModelEncoding(settings.getModelEncoding());
        clone.setOffline(settings.isOffline());
        clone.setPluginGroups(settings.getPluginGroups());
        clone.setProfiles(settings.getProfiles());
        clone.setProxies(settings.getProxies());
        clone.setServers(settings.getServers());
        clone.setSourceLevel(settings.getSourceLevel());
        clone.setUsePluginRegistry(settings.isUsePluginRegistry());
        return clone;
    }
}

