/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.maven.project.builder.ProjectUri;
import org.apache.maven.shared.model.ModelContainer;
import org.apache.maven.shared.model.ModelContainerAction;
import org.apache.maven.shared.model.ModelContainerFactory;
import org.apache.maven.shared.model.ModelProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArtifactModelContainerFactory
implements ModelContainerFactory {
    private static final Collection<String> uris = Collections.unmodifiableList(Arrays.asList(ProjectUri.DependencyManagement.Dependencies.Dependency.xUri, ProjectUri.Dependencies.Dependency.xUri, ProjectUri.Reporting.Plugins.Plugin.xUri, ProjectUri.Build.PluginManagement.Plugins.Plugin.xUri, ProjectUri.Build.Plugins.Plugin.xUri, ProjectUri.Build.Extensions.Extension.xUri));
    private final Collection<String> u;

    public Collection<String> getUris() {
        return this.u;
    }

    public ArtifactModelContainerFactory() {
        this.u = uris;
    }

    public ArtifactModelContainerFactory(String uri) {
        this.u = Collections.unmodifiableList(Arrays.asList(uri));
    }

    public ModelContainer create(List<ModelProperty> modelProperties) {
        if (modelProperties == null || modelProperties.size() == 0) {
            throw new IllegalArgumentException("modelProperties: null or empty");
        }
        return new ArtifactModelContainer(modelProperties);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArtifactModelContainer
    implements ModelContainer {
        private String groupId;
        private String artifactId;
        private String version;
        private String type;
        private String scope;
        private String classifier;
        private String uri;
        private List<ModelProperty> properties;

        private static String findBaseUriFrom(List<ModelProperty> modelProperties) {
            String baseUri = null;
            for (ModelProperty mp : modelProperties) {
                if (baseUri != null && mp.getUri().length() >= baseUri.length()) continue;
                baseUri = mp.getUri();
            }
            return baseUri;
        }

        private ArtifactModelContainer(List<ModelProperty> properties) {
            this.properties = new ArrayList<ModelProperty>(properties);
            this.properties = Collections.unmodifiableList(this.properties);
            this.uri = ArtifactModelContainer.findBaseUriFrom(this.properties);
            for (ModelProperty mp : this.properties) {
                if (this.version == null && mp.getUri().equals(this.uri + "/version")) {
                    this.version = mp.getResolvedValue();
                    continue;
                }
                if (this.artifactId == null && mp.getUri().equals(this.uri + "/artifactId")) {
                    this.artifactId = mp.getResolvedValue();
                    continue;
                }
                if (this.groupId == null && mp.getUri().equals(this.uri + "/groupId")) {
                    this.groupId = mp.getResolvedValue();
                    continue;
                }
                if (this.scope == null && mp.getUri().equals(this.uri + "/scope")) {
                    this.scope = mp.getResolvedValue();
                    continue;
                }
                if (this.classifier == null && mp.getUri().equals(this.uri + "/classifier")) {
                    this.classifier = mp.getResolvedValue();
                    continue;
                }
                if ((this.type != null || !mp.getUri().equals(ProjectUri.Dependencies.Dependency.type)) && !mp.getUri().equals(ProjectUri.DependencyManagement.Dependencies.Dependency.type) && !mp.getUri().equals(ProjectUri.Build.PluginManagement.Plugins.Plugin.Dependencies.Dependency.type) && !mp.getUri().equals(ProjectUri.Build.Plugins.Plugin.Dependencies.Dependency.type)) continue;
                this.type = mp.getResolvedValue();
            }
            if (this.groupId == null) {
                if (ProjectUri.Build.Plugins.Plugin.xUri.equals(this.uri) || ProjectUri.Profiles.Profile.Build.Plugins.Plugin.xUri.equals(this.uri) || ProjectUri.Build.PluginManagement.Plugins.Plugin.xUri.equals(this.uri) || ProjectUri.Profiles.Profile.Build.PluginManagement.Plugins.Plugin.xUri.equals(this.uri) || ProjectUri.Reporting.Plugins.Plugin.xUri.equals(this.uri) || ProjectUri.Profiles.Profile.Reporting.Plugins.Plugin.xUri.equals(this.uri)) {
                    this.groupId = "org.apache.maven.plugins";
                } else {
                    throw new IllegalArgumentException("Properties do not contain group id. Artifact ID = " + this.artifactId + ", Version = " + this.version);
                }
            }
            if (this.artifactId == null) {
                StringBuffer sb = new StringBuffer();
                for (ModelProperty mp : properties) {
                    sb.append(mp).append("\r\n");
                }
                throw new IllegalArgumentException("Properties does not contain artifact id. Group ID = " + this.groupId + ", Version = " + this.version + ", Base = " + this.uri + ":\r\n" + sb);
            }
            if (this.version == null) {
                this.version = "";
            }
            if (this.type == null) {
                this.type = "jar";
            }
            if (this.classifier == null) {
                this.classifier = "";
            }
            if (this.scope == null || this.scope.equals("provided")) {
                this.scope = "compile";
            }
        }

        public ModelContainerAction containerAction(ModelContainer modelContainer) {
            if (modelContainer == null) {
                throw new IllegalArgumentException("modelContainer: null");
            }
            if (!(modelContainer instanceof ArtifactModelContainer)) {
                throw new IllegalArgumentException("modelContainer: wrong type");
            }
            ArtifactModelContainer c = (ArtifactModelContainer)modelContainer;
            if (c.groupId.equals(this.groupId) && c.artifactId.equals(this.artifactId) && c.type.equals(this.type) && c.classifier.equals(this.classifier)) {
                if (this.uri.startsWith(ProjectUri.Build.Plugins.xUri) || c.version.equals(this.version) || this.version.equals("") || c.version.equals("")) {
                    return ModelContainerAction.JOIN;
                }
                return ModelContainerAction.DELETE;
            }
            return ModelContainerAction.NOP;
        }

        public ModelContainer createNewInstance(List<ModelProperty> modelProperties) {
            return new ArtifactModelContainer(modelProperties);
        }

        public List<ModelProperty> getProperties() {
            return this.properties;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("Group ID = ").append(this.groupId).append(", Artifact ID = ").append(this.artifactId).append(", Version").append(this.version).append("\r\n");
            for (ModelProperty mp : this.properties) {
                sb.append(mp).append("\r\n");
            }
            return sb.toString();
        }
    }
}

