/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.distsql.parser.core;

import java.util.Properties;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.distsql.parser.autogen.ScalingStatementBaseVisitor;
import org.apache.shardingsphere.distsql.parser.autogen.ScalingStatementParser;
import org.apache.shardingsphere.distsql.parser.segment.AlgorithmSegment;
import org.apache.shardingsphere.scaling.distsql.statement.ApplyScalingStatement;
import org.apache.shardingsphere.scaling.distsql.statement.CheckScalingStatement;
import org.apache.shardingsphere.scaling.distsql.statement.CreateShardingScalingRuleStatement;
import org.apache.shardingsphere.scaling.distsql.statement.DisableShardingScalingRuleStatement;
import org.apache.shardingsphere.scaling.distsql.statement.DropScalingStatement;
import org.apache.shardingsphere.scaling.distsql.statement.DropShardingScalingRuleStatement;
import org.apache.shardingsphere.scaling.distsql.statement.EnableShardingScalingRuleStatement;
import org.apache.shardingsphere.scaling.distsql.statement.ResetScalingStatement;
import org.apache.shardingsphere.scaling.distsql.statement.ShowScalingCheckAlgorithmsStatement;
import org.apache.shardingsphere.scaling.distsql.statement.ShowScalingListStatement;
import org.apache.shardingsphere.scaling.distsql.statement.ShowScalingStatusStatement;
import org.apache.shardingsphere.scaling.distsql.statement.ShowShardingScalingRulesStatement;
import org.apache.shardingsphere.scaling.distsql.statement.StartScalingStatement;
import org.apache.shardingsphere.scaling.distsql.statement.StopScalingSourceWritingStatement;
import org.apache.shardingsphere.scaling.distsql.statement.StopScalingStatement;
import org.apache.shardingsphere.scaling.distsql.statement.segment.InputOrOutputSegment;
import org.apache.shardingsphere.scaling.distsql.statement.segment.ShardingScalingRuleConfigurationSegment;
import org.apache.shardingsphere.sql.parser.api.visitor.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.SQLVisitor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.SchemaSegment;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class ScalingSQLStatementVisitor
extends ScalingStatementBaseVisitor<ASTNode>
implements SQLVisitor {
    @Override
    public ASTNode visitShowScalingList(ScalingStatementParser.ShowScalingListContext ctx) {
        return new ShowScalingListStatement();
    }

    @Override
    public ASTNode visitShowScalingStatus(ScalingStatementParser.ShowScalingStatusContext ctx) {
        return new ShowScalingStatusStatement(ctx.jobId().getText());
    }

    @Override
    public ASTNode visitStartScaling(ScalingStatementParser.StartScalingContext ctx) {
        return new StartScalingStatement(ctx.jobId().getText());
    }

    @Override
    public ASTNode visitStopScaling(ScalingStatementParser.StopScalingContext ctx) {
        return new StopScalingStatement(ctx.jobId().getText());
    }

    @Override
    public ASTNode visitDropScaling(ScalingStatementParser.DropScalingContext ctx) {
        return new DropScalingStatement(ctx.jobId().getText());
    }

    @Override
    public ASTNode visitResetScaling(ScalingStatementParser.ResetScalingContext ctx) {
        return new ResetScalingStatement(ctx.jobId().getText());
    }

    @Override
    public ASTNode visitCheckScaling(ScalingStatementParser.CheckScalingContext ctx) {
        AlgorithmSegment typeStrategy = null;
        if (null != ctx.algorithmDefinition()) {
            typeStrategy = (AlgorithmSegment)this.visit((ParseTree)ctx.algorithmDefinition());
        }
        return new CheckScalingStatement(ctx.jobId().getText(), typeStrategy);
    }

    @Override
    public ASTNode visitShowScalingCheckAlgorithms(ScalingStatementParser.ShowScalingCheckAlgorithmsContext ctx) {
        return new ShowScalingCheckAlgorithmsStatement();
    }

    @Override
    public ASTNode visitStopScalingSourceWriting(ScalingStatementParser.StopScalingSourceWritingContext ctx) {
        return new StopScalingSourceWritingStatement(ctx.jobId().getText());
    }

    @Override
    public ASTNode visitApplyScaling(ScalingStatementParser.ApplyScalingContext ctx) {
        return new ApplyScalingStatement(ctx.jobId().getText());
    }

    @Override
    public ASTNode visitCreateShardingScalingRule(ScalingStatementParser.CreateShardingScalingRuleContext ctx) {
        CreateShardingScalingRuleStatement result = new CreateShardingScalingRuleStatement(new IdentifierValue(ctx.scalingName().getText()).getValue());
        if (null != ctx.scalingRuleDefinition()) {
            result.setConfigurationSegment((ShardingScalingRuleConfigurationSegment)this.visit((ParseTree)ctx.scalingRuleDefinition()));
        }
        return result;
    }

    @Override
    public ASTNode visitScalingRuleDefinition(ScalingStatementParser.ScalingRuleDefinitionContext ctx) {
        ShardingScalingRuleConfigurationSegment result = new ShardingScalingRuleConfigurationSegment();
        if (null != ctx.inputDefinition()) {
            result.setInputSegment((InputOrOutputSegment)this.visit((ParseTree)ctx.inputDefinition()));
        }
        if (null != ctx.outputDefinition()) {
            result.setOutputSegment((InputOrOutputSegment)this.visit((ParseTree)ctx.outputDefinition()));
        }
        if (null != ctx.streamChannel()) {
            result.setStreamChannel((AlgorithmSegment)this.visit((ParseTree)ctx.streamChannel()));
        }
        if (null != ctx.completionDetector()) {
            result.setCompletionDetector((AlgorithmSegment)this.visit((ParseTree)ctx.completionDetector()));
        }
        if (null != ctx.dataConsistencyChecker()) {
            result.setDataConsistencyChecker((AlgorithmSegment)this.visit((ParseTree)ctx.dataConsistencyChecker()));
        }
        return result;
    }

    @Override
    public ASTNode visitInputDefinition(ScalingStatementParser.InputDefinitionContext ctx) {
        int workerThread = Integer.parseInt(ctx.workerThread().intValue().getText());
        int batchSize = Integer.parseInt(ctx.batchSize().intValue().getText());
        AlgorithmSegment rateLimiter = (AlgorithmSegment)this.visit((ParseTree)ctx.rateLimiter());
        return new InputOrOutputSegment(workerThread, batchSize, rateLimiter);
    }

    @Override
    public ASTNode visitOutputDefinition(ScalingStatementParser.OutputDefinitionContext ctx) {
        int workerThread = Integer.parseInt(ctx.workerThread().intValue().getText());
        int batchSize = Integer.parseInt(ctx.batchSize().intValue().getText());
        AlgorithmSegment rateLimiter = (AlgorithmSegment)this.visit((ParseTree)ctx.rateLimiter());
        return new InputOrOutputSegment(workerThread, batchSize, rateLimiter);
    }

    @Override
    public ASTNode visitRateLimiter(ScalingStatementParser.RateLimiterContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.algorithmDefinition());
    }

    @Override
    public ASTNode visitStreamChannel(ScalingStatementParser.StreamChannelContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.algorithmDefinition());
    }

    @Override
    public ASTNode visitCompletionDetector(ScalingStatementParser.CompletionDetectorContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.algorithmDefinition());
    }

    @Override
    public ASTNode visitDataConsistencyChecker(ScalingStatementParser.DataConsistencyCheckerContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.algorithmDefinition());
    }

    @Override
    public ASTNode visitDropShardingScalingRule(ScalingStatementParser.DropShardingScalingRuleContext ctx) {
        return new DropShardingScalingRuleStatement(new IdentifierValue(ctx.scalingName().getText()).getValue());
    }

    @Override
    public ASTNode visitEnableShardingScalingRule(ScalingStatementParser.EnableShardingScalingRuleContext ctx) {
        return new EnableShardingScalingRuleStatement(new IdentifierValue(ctx.scalingName().getText()).getValue());
    }

    @Override
    public ASTNode visitDisableShardingScalingRule(ScalingStatementParser.DisableShardingScalingRuleContext ctx) {
        return new DisableShardingScalingRuleStatement(new IdentifierValue(ctx.scalingName().getText()).getValue());
    }

    @Override
    public ASTNode visitShowShardingScalingRules(ScalingStatementParser.ShowShardingScalingRulesContext ctx) {
        return new ShowShardingScalingRulesStatement(null == ctx.schemaName() ? null : (SchemaSegment)this.visit((ParseTree)ctx.schemaName()));
    }

    @Override
    public ASTNode visitAlgorithmDefinition(ScalingStatementParser.AlgorithmDefinitionContext ctx) {
        return new AlgorithmSegment(ctx.algorithmName().getText(), this.getAlgorithmProperties(ctx));
    }

    private Properties getAlgorithmProperties(ScalingStatementParser.AlgorithmDefinitionContext ctx) {
        Properties result = new Properties();
        if (null == ctx.algorithmProperties()) {
            return result;
        }
        for (ScalingStatementParser.AlgorithmPropertyContext each : ctx.algorithmProperties().algorithmProperty()) {
            result.setProperty(new IdentifierValue(each.key.getText()).getValue(), new IdentifierValue(each.value.getText()).getValue());
        }
        return result;
    }

    @Override
    public ASTNode visitSchemaName(ScalingStatementParser.SchemaNameContext ctx) {
        return new SchemaSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), new IdentifierValue(ctx.getText()));
    }
}

