/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.xml.namespace.NamespaceContext;
import org.apache.sis.xml.TransformVersion;

class TransformingNamespaces
implements NamespaceContext {
    final NamespaceContext context;
    final TransformVersion version;

    static NamespaceContext asXML(NamespaceContext namespaceContext, TransformVersion transformVersion) {
        if (namespaceContext != null) {
            namespaceContext = namespaceContext instanceof Inverse && ((Inverse)namespaceContext).version == transformVersion ? ((Inverse)namespaceContext).context : new TransformingNamespaces(namespaceContext, transformVersion);
        }
        return namespaceContext;
    }

    static NamespaceContext asJAXB(NamespaceContext namespaceContext, TransformVersion transformVersion) {
        if (namespaceContext != null) {
            namespaceContext = namespaceContext.getClass() == TransformingNamespaces.class && ((TransformingNamespaces)namespaceContext).version == transformVersion ? ((TransformingNamespaces)namespaceContext).context : new Inverse(namespaceContext, transformVersion);
        }
        return namespaceContext;
    }

    private TransformingNamespaces(NamespaceContext namespaceContext, TransformVersion transformVersion) {
        this.context = namespaceContext;
        this.version = transformVersion;
    }

    @Override
    public String getNamespaceURI(String string) {
        return this.version.exportNS(this.context.getNamespaceURI(string));
    }

    @Override
    public String getPrefix(String string) {
        String string2 = this.context.getPrefix(this.version.importNS(string));
        if (string2 != null) {
            return string2;
        }
        Iterator<Map.Entry<String, String>> iterator = this.version.exports();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            if (!string.equals(entry.getValue()) || (string2 = this.context.getPrefix(entry.getKey())) == null) continue;
            return string2;
        }
        return this.context.getPrefix(string);
    }

    @Override
    public Iterator<String> getPrefixes(String string) {
        return new Prefixes(this.context, this.version.exports(), string);
    }

    private static final class Prefixes
    implements Iterator<String> {
        private final String namespaceURI;
        private final NamespaceContext context;
        private final Iterator<Map.Entry<String, String>> exports;
        private Iterator<String> prefixes;
        private String next;

        Prefixes(NamespaceContext namespaceContext, Iterator<Map.Entry<String, String>> iterator, String string) {
            this.context = namespaceContext;
            this.exports = iterator;
            this.namespaceURI = string;
        }

        @Override
        public boolean hasNext() {
            while (this.next == null) {
                while (this.prefixes == null) {
                    if (!this.exports.hasNext()) {
                        return false;
                    }
                    Map.Entry<String, String> entry = this.exports.next();
                    if (!this.namespaceURI.equals(entry.getValue())) continue;
                    this.prefixes = this.context.getPrefixes(entry.getKey());
                }
                if (this.prefixes.hasNext()) {
                    this.next = this.prefixes.next();
                    continue;
                }
                this.prefixes = null;
            }
            return true;
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String string = this.next;
            this.next = null;
            return string;
        }
    }

    private static final class Inverse
    extends TransformingNamespaces {
        Inverse(NamespaceContext namespaceContext, TransformVersion transformVersion) {
            super(namespaceContext, transformVersion);
        }

        @Override
        public String getNamespaceURI(String string) {
            return this.version.importNS(this.context.getNamespaceURI(string));
        }

        @Override
        public String getPrefix(String string) {
            return this.context.getPrefix(this.version.exportNS(string));
        }

        @Override
        public Iterator<String> getPrefixes(String string) {
            return this.context.getPrefixes(this.version.exportNS(string));
        }
    }
}

