/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http2;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.coyote.http2.ConnectionException;
import org.apache.coyote.http2.Http2Error;
import org.apache.coyote.http2.Http2Exception;
import org.apache.coyote.http2.Stream;
import org.apache.coyote.http2.StreamException;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

abstract class AbstractStream {
    private static final Log log = LogFactory.getLog(AbstractStream.class);
    private static final StringManager sm = StringManager.getManager(AbstractStream.class);
    private final Integer identifier;
    private volatile AbstractStream parentStream = null;
    private final Set<Stream> childStreams = Collections.newSetFromMap(new ConcurrentHashMap());
    private long windowSize = 65535L;

    AbstractStream(Integer identifier) {
        this.identifier = identifier;
    }

    final Integer getIdentifier() {
        return this.identifier;
    }

    final int getIdAsInt() {
        return this.identifier;
    }

    final void detachFromParent() {
        if (this.parentStream != null) {
            this.parentStream.getChildStreams().remove(this);
            this.parentStream = null;
        }
    }

    final void addChild(Stream child) {
        child.setParentStream(this);
        this.childStreams.add(child);
    }

    final boolean isDescendant(AbstractStream stream) {
        if (this.childStreams.contains(stream)) {
            return true;
        }
        for (AbstractStream abstractStream : this.childStreams) {
            if (!abstractStream.isDescendant(stream)) continue;
            return true;
        }
        return false;
    }

    final AbstractStream getParentStream() {
        return this.parentStream;
    }

    final void setParentStream(AbstractStream parentStream) {
        this.parentStream = parentStream;
    }

    final Set<Stream> getChildStreams() {
        return this.childStreams;
    }

    final synchronized void setWindowSize(long windowSize) {
        this.windowSize = windowSize;
    }

    final synchronized long getWindowSize() {
        return this.windowSize;
    }

    synchronized void incrementWindowSize(int increment) throws Http2Exception {
        this.windowSize += (long)increment;
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("abstractStream.windowSizeInc", this.getConnectionId(), this.getIdentifier(), Integer.toString(increment), Long.toString(this.windowSize)));
        }
        if (this.windowSize > Integer.MAX_VALUE) {
            String msg = sm.getString("abstractStream.windowSizeTooBig", this.getConnectionId(), this.identifier, Integer.toString(increment), Long.toString(this.windowSize));
            if (this.identifier == 0) {
                throw new ConnectionException(msg, Http2Error.FLOW_CONTROL_ERROR);
            }
            throw new StreamException(msg, Http2Error.FLOW_CONTROL_ERROR, this.identifier);
        }
    }

    final synchronized void decrementWindowSize(int decrement) {
        this.windowSize -= (long)decrement;
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("abstractStream.windowSizeDec", this.getConnectionId(), this.getIdentifier(), Integer.toString(decrement), Long.toString(this.windowSize)));
        }
    }

    abstract String getConnectionId();

    abstract int getWeight();
}

