/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal;

import com.google.common.base.Charsets;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.twill.api.LocalFile;
import org.apache.twill.api.RunId;
import org.apache.twill.api.RuntimeSpecification;
import org.apache.twill.filesystem.Location;
import org.apache.twill.internal.AbstractZKServiceController;
import org.apache.twill.internal.ContainerInfo;
import org.apache.twill.internal.ContainerLiveNodeData;
import org.apache.twill.internal.DefaultLocalFile;
import org.apache.twill.internal.JvmOptions;
import org.apache.twill.internal.ProcessController;
import org.apache.twill.internal.ProcessLauncher;
import org.apache.twill.internal.TwillContainerController;
import org.apache.twill.internal.state.Message;
import org.apache.twill.internal.utils.Resources;
import org.apache.twill.launcher.FindFreePort;
import org.apache.twill.launcher.TwillLauncher;
import org.apache.twill.zookeeper.NodeData;
import org.apache.twill.zookeeper.OperationFuture;
import org.apache.twill.zookeeper.ZKClient;
import org.apache.twill.zookeeper.ZKOperations;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TwillContainerLauncher {
    private static final Logger LOG = LoggerFactory.getLogger(TwillContainerLauncher.class);
    private final RuntimeSpecification runtimeSpec;
    private final ContainerInfo containerInfo;
    private final ProcessLauncher.PrepareLaunchContext launchContext;
    private final ZKClient zkClient;
    private final int instanceCount;
    private final JvmOptions jvmOpts;
    private final int reservedMemory;
    private final Location secureStoreLocation;

    public TwillContainerLauncher(RuntimeSpecification runtimeSpec, ContainerInfo containerInfo, ProcessLauncher.PrepareLaunchContext launchContext, ZKClient zkClient, int instanceCount, JvmOptions jvmOpts, int reservedMemory, Location secureStoreLocation) {
        this.runtimeSpec = runtimeSpec;
        this.containerInfo = containerInfo;
        this.launchContext = launchContext;
        this.zkClient = zkClient;
        this.instanceCount = instanceCount;
        this.jvmOpts = jvmOpts;
        this.reservedMemory = reservedMemory;
        this.secureStoreLocation = secureStoreLocation;
    }

    public TwillContainerController start(RunId runId, int instanceId, Class<?> mainClass, String classPath) {
        String firstCommand;
        Futures.getUnchecked((Future)ZKOperations.ignoreError((OperationFuture)ZKOperations.recursiveDelete((ZKClient)this.zkClient, (String)("/" + runId)), KeeperException.NoNodeException.class, null));
        this.launchContext.addResources(this.runtimeSpec.getLocalFiles());
        try {
            if (this.secureStoreLocation != null && this.secureStoreLocation.exists()) {
                this.launchContext.addResources(new LocalFile[]{new DefaultLocalFile("credentials.store", this.secureStoreLocation.toURI(), this.secureStoreLocation.lastModified(), this.secureStoreLocation.length(), false, null)});
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to launch container with secure store {}.", (Object)this.secureStoreLocation);
        }
        this.launchContext.addEnvironment("TWILL_RUN_ID", runId.getId()).addEnvironment("TWILL_RUNNABLE_NAME", this.runtimeSpec.getName()).addEnvironment("TWILL_INSTANCE_ID", Integer.toString(instanceId)).addEnvironment("TWILL_INSTANCE_COUNT", Integer.toString(this.instanceCount));
        ImmutableList.Builder commandBuilder = ImmutableList.builder();
        if (this.jvmOpts.getDebugOptions().doDebug(this.runtimeSpec.getName())) {
            String suspend = this.jvmOpts.getDebugOptions().doSuspend() ? "y" : "n";
            firstCommand = "TWILL_DEBUG_PORT=$($JAVA_HOME/bin/java";
            commandBuilder.add((Object[])new String[]{"-cp", "launcher.jar", FindFreePort.class.getName() + ")", "&&", "$JAVA_HOME/bin/java", "-agentlib:jdwp=transport=dt_socket,server=y,suspend=" + suspend + "," + "address=\\$TWILL_DEBUG_PORT", "-Dtwill.debug.port=\\$TWILL_DEBUG_PORT"});
        } else {
            firstCommand = "$JAVA_HOME/bin/java";
        }
        int memory = Resources.computeMaxHeapSize(this.containerInfo.getMemoryMB(), this.reservedMemory, 0.7);
        commandBuilder.add((Object[])new String[]{"-Djava.io.tmpdir=tmp", "-Dyarn.container=$YARN_CONTAINER_ID", "-Dtwill.runnable=$TWILL_APP_NAME.$TWILL_RUNNABLE_NAME", "-cp", "launcher.jar:" + classPath, "-Xmx" + memory + "m"});
        if (this.jvmOpts.getExtraOptions() != null) {
            commandBuilder.add((Object)this.jvmOpts.getExtraOptions());
        }
        commandBuilder.add((Object[])new String[]{TwillLauncher.class.getName(), "container.jar", mainClass.getName(), Boolean.TRUE.toString()});
        ImmutableList command = commandBuilder.build();
        ProcessController<Void> processController = this.launchContext.addCommand(firstCommand, command.toArray(new String[command.size()])).launch();
        TwillContainerControllerImpl controller = new TwillContainerControllerImpl(this.zkClient, runId, this.runtimeSpec.getName(), instanceId, processController);
        controller.start();
        return controller;
    }

    private static final class TwillContainerControllerImpl
    extends AbstractZKServiceController
    implements TwillContainerController {
        private final String runnable;
        private final int instanceId;
        private final ProcessController<Void> processController;
        private final CountDownLatch shutdownLatch;
        private volatile ContainerLiveNodeData liveData;

        protected TwillContainerControllerImpl(ZKClient zkClient, RunId runId, String runnable, int instanceId, ProcessController<Void> processController) {
            super(runId, zkClient);
            this.runnable = runnable;
            this.instanceId = instanceId;
            this.processController = processController;
            this.shutdownLatch = new CountDownLatch(1);
        }

        @Override
        protected void doStartUp() {
        }

        @Override
        protected void doShutDown() {
            int maxWaitSecs = 30;
            maxWaitSecs = maxWaitSecs < 15 ? 15 : maxWaitSecs;
            try {
                if (Uninterruptibles.awaitUninterruptibly((CountDownLatch)this.shutdownLatch, (long)maxWaitSecs, (TimeUnit)TimeUnit.SECONDS)) {
                    return;
                }
            }
            catch (Exception e) {
                LOG.error("Got exception while trying to stop runnable {}, instance {}", new Object[]{this.runnable, this.instanceId, e});
            }
            LOG.warn("Killing runnable {}, instance {} after waiting {} secs", new Object[]{this.runnable, this.instanceId, maxWaitSecs});
            this.killAndWait(maxWaitSecs);
        }

        @Override
        protected void instanceNodeUpdated(NodeData nodeData) {
            if (nodeData == null || nodeData.getData() == null) {
                LOG.warn("Instance node was updated but data is null.");
                return;
            }
            try {
                JsonElement data;
                Gson gson = new Gson();
                JsonElement json = (JsonElement)gson.fromJson(new String(nodeData.getData(), Charsets.UTF_8), JsonElement.class);
                if (json.isJsonObject() && (data = json.getAsJsonObject().get("data")) != null) {
                    this.liveData = (ContainerLiveNodeData)gson.fromJson(data, ContainerLiveNodeData.class);
                    LOG.info("Container LiveNodeData updated: " + new String(nodeData.getData(), Charsets.UTF_8));
                }
            }
            catch (Throwable t) {
                LOG.warn("Error deserializing updated instance node data", t);
            }
        }

        @Override
        protected void instanceNodeFailed(Throwable cause) {
        }

        @Override
        public ListenableFuture<Message> sendMessage(Message message) {
            return this.sendMessage(message, message);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void completed(int exitStatus) {
            this.shutdownLatch.countDown();
            TwillContainerControllerImpl twillContainerControllerImpl = this;
            synchronized (twillContainerControllerImpl) {
                this.forceShutDown();
            }
        }

        @Override
        public ContainerLiveNodeData getLiveNodeData() {
            return this.liveData;
        }

        public void kill() {
            this.processController.cancel();
        }

        private void killAndWait(int maxWaitSecs) {
            Stopwatch watch = new Stopwatch();
            watch.start();
            while (watch.elapsedTime(TimeUnit.SECONDS) < (long)maxWaitSecs) {
                try {
                    this.kill();
                }
                catch (Exception e) {
                    LOG.error("Exception while killing runnable {}, instance {}", new Object[]{this.runnable, this.instanceId, e});
                }
                if (!Uninterruptibles.awaitUninterruptibly((CountDownLatch)this.shutdownLatch, (long)10L, (TimeUnit)TimeUnit.SECONDS)) continue;
                return;
            }
            LOG.error("Failed to kill runnable {}, instance {} after {} seconds", new Object[]{this.runnable, this.instanceId, watch.elapsedTime(TimeUnit.SECONDS)});
        }
    }
}

